<?php
/**
 * Shortcode For Site URL
 *
 */
?>
<?php
if ( ! function_exists( 'hcode_option' ) ) {
	function hcode_option( $option ){
		global $hcode_theme_settings, $post;
		$hcode_single = false;
		if(is_singular()){
			$value = get_post_meta( $post->ID, $option.'_single', true);
			$hcode_single = true;
		}

		if($hcode_single == true){
			if (is_string($value) && (strlen($value) > 0 || is_array($value)) && ($value != 'default' && $value != 'Select Sidebar')  ) {
				return $value;
			}
		}
		if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
			$option_value = $hcode_theme_settings[$option];
			return $option_value;
		}
		return false;
	}
}

if ( ! function_exists( 'hcode_site_url_shortcode' ) ) {
	function hcode_site_url_shortcode( $atts, $content = null ) { 
		return home_url( '/' );
	}
}
add_shortcode( 'hcode_site_url', 'hcode_site_url_shortcode' );

if ( ! function_exists( 'hcode_current_year_shortcode' ) ) {
	function hcode_current_year_shortcode() { 
		return date_i18n( 'Y' );
	}
}
add_shortcode( 'hcode_current_year', 'hcode_current_year_shortcode' );

if ( ! function_exists( 'hcode_site_title_shortcode' ) ) {
	function hcode_site_title_shortcode() { 
		return get_bloginfo( 'name' );
	}
}
add_shortcode( 'hcode_site_title', 'hcode_site_title_shortcode' );

//load button setting css other css 
if( ! function_exists( 'hcode_addons_generate_custom_css' ) ) {
	function hcode_addons_generate_custom_css() {
		global $hcode_featured_array, $style_array,$responsive_style, $hcode_featured_mini_desktop_array, $hcode_featured_ipad_array, $hcode_featured_mobile_array;

		$output_css = '';
		if( !empty($hcode_featured_array) || !empty($hcode_featured_ipad_array) || !empty($hcode_featured_mobile_array) ) {
			ob_start();
				echo '<style id="hcode-addon-custom-css" type="text/css">';
					if( !empty($hcode_featured_array) ){
						foreach ($hcode_featured_array as $key => $value) {
							echo $value;
						}
					}

					if( !empty($hcode_featured_ipad_array) ){
						echo '@media (max-width: 991px) {';
							foreach ($hcode_featured_ipad_array as $key => $value) {
								echo $value;
							}
						echo '}';
					}
					if( !empty($hcode_featured_mobile_array) ){
						echo '@media (max-width: 767px) {';
							foreach ($hcode_featured_mobile_array as $key => $value) {
								echo $value;
							}
						echo '}';
					}    
				echo '</style>';
			$output_css = ob_get_contents();
			ob_end_clean();

			// 1. Remove comments.
			// 2. Remove whitespace.
			// 3. Remove starting whitespace.
			$output_css = preg_replace( '#/\*.*?\*/#s', '', $output_css );
			$output_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_css );
			$output_css = preg_replace( '/\s\s+(.*)/', '$1', $output_css );

			?>
				<script type="text/javascript"> (function($) { $('head').append('<?php print $output_css; ?>'); })(jQuery); </script>
			<?php   
		}
	   
	}
}
add_action( 'wp_footer', 'hcode_addons_generate_custom_css', 998 );

//load dyamic css for font settings
if( ! function_exists( 'hcode_addons_text_align_css' ) ) {
	function hcode_addons_text_align_css() {
		global $font_settings_array;

		$output_css = '';
		if( !empty($font_settings_array)) {
			ob_start();
				echo '<style id="hcode-addon-font-custom-css" type="text/css">';
					foreach ($font_settings_array as $key => $value) {
						echo $value;
					}    
				echo '</style>';
			$output_css = ob_get_contents();
			ob_end_clean();

			// 1. Remove comments.
			// 2. Remove whitespace.
			// 3. Remove starting whitespace.
			$output_css = preg_replace( '#/\*.*?\*/#s', '', $output_css );
			$output_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_css );
			$output_css = preg_replace( '/\s\s+(.*)/', '$1', $output_css );

			?>
				<script type="text/javascript"> (function($) { $('head').append('<?php print $output_css; ?>'); })(jQuery); </script>
			<?php   
		}
	}
}
add_action( 'wp_footer', 'hcode_addons_text_align_css', 998 );

if( ! function_exists( 'hcode_portfolio_dropdown_categories' ) ) {
	function hcode_portfolio_dropdown_categories( $args = array() ) {
		global $wp_query;

		$args = wp_parse_args( $args, array(
			'pad_counts'         => 1,
			'show_count'         => 1,
			'hierarchical'       => 1,
			'hide_empty'         => 1,
			'show_uncategorized' => 1,
			'orderby'            => 'name',
			'selected'           => isset( $wp_query->query_vars['portfolio_cat'] ) ? $wp_query->query_vars['portfolio_cat']: '',
			'menu_order'         => false,
			'show_option_none'   => __( 'Select a category', 'hcode-addons' ),
			'option_none_value'  => '',
			'value_field'        => 'slug',
			'taxonomy'           => 'portfolio-category',
			'name'               => 'portfolio_cat',
			'class'              => 'portfolio_categories',
		) );

		if ( 'order' === $args['orderby'] ) {
			$args['menu_order'] = 'asc';
			$args['orderby']    = 'name';
		}

		wp_dropdown_categories( $args );
	}
}

if ( ! function_exists( 'hcode_slider_pagination' ) ) {
	function hcode_slider_pagination( $pagination , $slider_id = ''){
		$output  = '';

		ob_start();

		if($pagination){
			$pagination_count = substr_count($pagination, '[hcode_slide_content ');
			for ($count=0; $count <= $pagination_count-1; $count++){
				echo '<li data-target="#'.$slider_id.'" data-slide-to="'.$count.'"></li>';
			}
		}

		$result = ob_get_contents();
		ob_end_clean();
		$output .= $result;

		return $output;
	}
}
/* For content bootstrap slider pagination */
if ( ! function_exists( 'hcode_bootstrap_content_slider_pagination' ) ) {
	function hcode_bootstrap_content_slider_pagination( $pagination , $slider_id = ''){
		$output  = '';

		ob_start();

		if($pagination){
			$pagination_count = substr_count($pagination, '[hcode_special_slide_content ');
			for ($count=0; $count <= $pagination_count-1; $count++){
				echo '<li data-target="#'.$slider_id.'" data-slide-to="'.$count.'"></li>';
			}
		}

		$result = ob_get_contents();
		ob_end_clean();
		$output .= $result;

		return $output;
	}
}

if ( ! function_exists( 'hcode_owl_pagination_color_classes' ) ) {
	function hcode_owl_pagination_color_classes( $pagination ){
		$class_list = '';

		switch($pagination)
		{
			case 0:
				$class_list .= ' dark-pagination';
				break;

			case 1:
				$class_list .= ' light-pagination';
				break;

			default:
				$class_list .= ' dark-pagination';
				break;
		}
		return $class_list;
	}
}

if ( ! function_exists( 'hcode_owl_pagination_slider_classes' ) ) {
	function hcode_owl_pagination_slider_classes( $pagination_color ){
		$class_list = '';

		switch($pagination_color)
		{
			case 0:
				$class_list .= ' dot-pagination';
				break;

			case 1:
				$class_list .= ' square-pagination';
				break;

					case 2:
						$class_list .= ' round-pagination';
						break;

			default:
				$class_list .= ' dot-pagination';
				break;
		}

		return $class_list;
	}
}

if ( ! function_exists( 'hcode_owl_navigation_slider_classes' ) ) {
	function hcode_owl_navigation_slider_classes ($navigation){
		$class_list = '';

		switch($navigation)
		{
			case 0:
				$class_list .= ' dark-navigation';
				break;

			case 1:
				$class_list .= ' light-navigation';
				break;

			default:
				$class_list .= ' dark-navigation';
				break;
		}

		return $class_list;
	}
}

add_filter( 'hcode_portfolio_title', 'hcode_portfolio_title_filter' );

if ( ! function_exists( 'hcode_portfolio_title_filter' ) ) {
	function hcode_portfolio_title_filter( $value ) {   

		if( is_admin() ) {
			return $value;
		}

		$hcode_options = get_option( 'hcode_theme_setting' );
		if( !empty( $hcode_options['hcode_portfolio_cat_title'] ) ) {
			$value = trim( $hcode_options['hcode_portfolio_cat_title'] );
		} elseif( !empty( $hcode_options['hcode_portfolio_url_slug'] ) ) {
			$value = trim( $hcode_options['hcode_portfolio_url_slug'] );
		}

		return $value;
	}
}

if ( ! function_exists( 'hcode_fontawesome_solid' ) ) :
    function hcode_fontawesome_solid() {
        $fa_icons_solid = array( "fa-0", "fa-1", "fa-2", "fa-3", "fa-4", "fa-5", "fa-6", "fa-7", "fa-8", "fa-9", "fa-fill-drip", "fa-arrows-to-circle", "fa-circle-chevron-right", "fa-at", "fa-trash-can", "fa-text-height", "fa-user-xmark", "fa-stethoscope", "fa-message", "fa-info", "fa-down-left-and-up-right-to-center", "fa-explosion", "fa-file-lines", "fa-wave-square", "fa-ring", "fa-building-un", "fa-dice-three", "fa-calendar-days", "fa-anchor-circle-check", "fa-building-circle-arrow-right", "fa-volleyball", "fa-arrows-up-to-line", "fa-sort-down", "fa-circle-minus", "fa-door-open", "fa-right-from-bracket", "fa-atom", "fa-soap", "fa-icons", "fa-microphone-lines-slash", "fa-bridge-circle-check", "fa-pump-medical", "fa-fingerprint", "fa-hand-point-right", "fa-magnifying-glass-location", "fa-forward-step", "fa-face-smile-beam", "fa-flag-checkered", "fa-football", "fa-school-circle-exclamation", "fa-crop", "fa-angles-down", "fa-users-rectangle", "fa-people-roof", "fa-people-line", "fa-beer-mug-empty", "fa-diagram-predecessor", "fa-arrow-up-long", "fa-fire-flame-simple", "fa-person", "fa-laptop", "fa-file-csv", "fa-menorah", "fa-truck-plane", "fa-record-vinyl", "fa-face-grin-stars", "fa-bong", "fa-spaghetti-monster-flying", "fa-arrow-down-up-across-line", "fa-spoon", "fa-jar-wheat", "fa-envelopes-bulk", "fa-file-circle-exclamation", "fa-circle-h", "fa-pager", "fa-address-book", "fa-strikethrough", "fa-k", "fa-landmark-flag", "fa-pencil", "fa-backward", "fa-caret-right", "fa-comments", "fa-paste", "fa-code-pull-request", "fa-clipboard-list", "fa-truck-ramp-box", "fa-user-check", "fa-vial-virus", "fa-sheet-plastic", "fa-blog", "fa-user-ninja", "fa-person-arrow-up-from-line", "fa-scroll-torah", "fa-broom-ball", "fa-toggle-off", "fa-box-archive", "fa-person-drowning", "fa-arrow-down-9-1", "fa-face-grin-tongue-squint", "fa-spray-can", "fa-truck-monster", "fa-w", "fa-earth-africa", "fa-rainbow", "fa-circle-notch", "fa-tablet-screen-button", "fa-paw", "fa-cloud", "fa-trowel-bricks", "fa-face-flushed", "fa-hospital-user", "fa-tent-arrow-left-right", "fa-gavel", "fa-binoculars", "fa-microphone-slash", "fa-box-tissue", "fa-motorcycle", "fa-bell-concierge", "fa-pen-ruler", "fa-people-arrows", "fa-mars-and-venus-burst", "fa-square-caret-right", "fa-scissors", "fa-sun-plant-wilt", "fa-toilets-portable", "fa-hockey-puck", "fa-table", "fa-magnifying-glass-arrow-right", "fa-tachograph-digital", "fa-users-slash", "fa-clover", "fa-reply", "fa-star-and-crescent", "fa-house-fire", "fa-square-minus", "fa-helicopter", "fa-compass", "fa-square-caret-down", "fa-file-circle-question", "fa-laptop-code", "fa-swatchbook", "fa-prescription-bottle", "fa-bars", "fa-people-group", "fa-hourglass-end", "fa-heart-crack", "fa-square-up-right", "fa-face-kiss-beam", "fa-film", "fa-ruler-horizontal", "fa-people-robbery", "fa-lightbulb", "fa-caret-left", "fa-circle-exclamation", "fa-school-circle-xmark", "fa-arrow-right-from-bracket", "fa-circle-chevron-down", "fa-unlock-keyhole", "fa-cloud-showers-heavy", "fa-headphones-simple", "fa-sitemap", "fa-circle-dollar-to-slot", "fa-memory", "fa-road-spikes", "fa-fire-burner", "fa-flag", "fa-hanukiah", "fa-feather", "fa-volume-low", "fa-comment-slash", "fa-cloud-sun-rain", "fa-compress", "fa-wheat-awn", "fa-ankh", "fa-hands-holding-child", "fa-asterisk", "fa-square-check", "fa-peseta-sign", "fa-heading", "fa-ghost", "fa-list", "fa-square-phone-flip", "fa-cart-plus", "fa-gamepad", "fa-circle-dot", "fa-face-dizzy", "fa-egg", "fa-house-medical-circle-xmark", "fa-campground", "fa-folder-plus", "fa-futbol", "fa-paintbrush", "fa-lock", "fa-gas-pump", "fa-hot-tub-person", "fa-map-location", "fa-house-flood-water", "fa-tree", "fa-bridge-lock", "fa-sack-dollar", "fa-pen-to-square", "fa-car-side", "fa-share-nodes", "fa-heart-circle-minus", "fa-hourglass-half", "fa-microscope", "fa-sink", "fa-bag-shopping", "fa-arrow-down-z-a", "fa-mitten", "fa-person-rays", "fa-users", "fa-eye-slash", "fa-flask-vial", "fa-hand", "fa-om", "fa-worm", "fa-house-circle-xmark", "fa-plug", "fa-chevron-up", "fa-hand-spock", "fa-stopwatch", "fa-face-kiss", "fa-bridge-circle-xmark", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-ear-deaf", "fa-road-circle-check", "fa-dice-five", "fa-square-rss", "fa-land-mine-on", "fa-i-cursor", "fa-stamp", "fa-stairs", "fa-i", "fa-hryvnia-sign", "fa-pills", "fa-face-grin-wide", "fa-tooth", "fa-v", "fa-bangladeshi-taka-sign", "fa-bicycle", "fa-staff-snake", "fa-head-side-cough-slash", "fa-truck-medical", "fa-wheat-awn-circle-exclamation", "fa-snowman", "fa-mortar-pestle", "fa-road-barrier", "fa-school", "fa-igloo", "fa-joint", "fa-angle-right", "fa-horse", "fa-q", "fa-g", "fa-notes-medical", "fa-temperature-half", "fa-dong-sign", "fa-capsules", "fa-poo-storm", "fa-face-frown-open", "fa-hand-point-up", "fa-money-bill", "fa-bookmark", "fa-align-justify", "fa-umbrella-beach", "fa-helmet-un", "fa-bullseye", "fa-bacon", "fa-hand-point-down", "fa-arrow-up-from-bracket", "fa-folder", "fa-file-waveform", "fa-radiation", "fa-chart-simple", "fa-mars-stroke", "fa-vial", "fa-gauge", "fa-wand-magic-sparkles", "fa-e", "fa-pen-clip", "fa-bridge-circle-exclamation", "fa-user", "fa-school-circle-check", "fa-dumpster", "fa-van-shuttle", "fa-building-user", "fa-square-caret-left", "fa-highlighter", "fa-key", "fa-bullhorn", "fa-globe", "fa-synagogue", "fa-person-half-dress", "fa-road-bridge", "fa-location-arrow", "fa-c", "fa-tablet-button", "fa-building-lock", "fa-pizza-slice", "fa-money-bill-wave", "fa-chart-area", "fa-house-flag", "fa-person-circle-minus", "fa-ban", "fa-camera-rotate", "fa-spray-can-sparkles", "fa-star", "fa-repeat", "fa-cross", "fa-box", "fa-venus-mars", "fa-arrow-pointer", "fa-maximize", "fa-charging-station", "fa-shapes", "fa-shuffle", "fa-person-running", "fa-mobile-retro", "fa-grip-lines-vertical", "fa-spider", "fa-hands-bound", "fa-file-invoice-dollar", "fa-plane-circle-exclamation", "fa-x-ray", "fa-spell-check", "fa-slash", "fa-computer-mouse", "fa-arrow-right-to-bracket", "fa-shop-slash", "fa-server", "fa-virus-covid-slash", "fa-shop-lock", "fa-hourglass-start", "fa-blender-phone", "fa-building-wheat", "fa-person-breastfeeding", "fa-right-to-bracket", "fa-venus", "fa-passport", "fa-heart-pulse", "fa-people-carry-box", "fa-temperature-high", "fa-microchip", "fa-crown", "fa-weight-hanging", "fa-xmarks-lines", "fa-file-prescription", "fa-weight-scale", "fa-user-group", "fa-arrow-up-a-z", "fa-chess-knight", "fa-face-laugh-squint", "fa-wheelchair", "fa-circle-arrow-up", "fa-toggle-on", "fa-person-walking", "fa-l", "fa-fire", "fa-bed-pulse", "fa-shuttle-space", "fa-face-laugh", "fa-folder-open", "fa-heart-circle-plus", "fa-code-fork", "fa-city", "fa-microphone-lines", "fa-pepper-hot", "fa-unlock", "fa-colon-sign", "fa-headset", "fa-store-slash", "fa-road-circle-xmark", "fa-user-minus", "fa-mars-stroke-up", "fa-champagne-glasses", "fa-clipboard", "fa-house-circle-exclamation", "fa-file-arrow-up", "fa-wifi", "fa-bath", "fa-underline", "fa-user-pen", "fa-signature", "fa-stroopwafel", "fa-bold", "fa-anchor-lock", "fa-building-ngo", "fa-manat-sign", "fa-not-equal", "fa-border-top-left", "fa-map-location-dot", "fa-jedi", "fa-square-poll-vertical", "fa-mug-hot", "fa-car-battery", "fa-gift", "fa-dice-two", "fa-chess-queen", "fa-glasses", "fa-chess-board", "fa-building-circle-check", "fa-person-chalkboard", "fa-mars-stroke-right", "fa-hand-back-fist", "fa-square-caret-up", "fa-cloud-showers-water", "fa-chart-bar", "fa-hands-bubbles", "fa-less-than-equal", "fa-train", "fa-eye-low-vision", "fa-crow", "fa-sailboat", "fa-window-restore", "fa-square-plus", "fa-torii-gate", "fa-frog", "fa-bucket", "fa-image", "fa-microphone", "fa-cow", "fa-caret-up", "fa-screwdriver", "fa-folder-closed", "fa-house-tsunami", "fa-square-nfi", "fa-arrow-up-from-ground-water", "fa-martini-glass", "fa-rotate-left", "fa-table-columns", "fa-lemon", "fa-head-side-mask", "fa-handshake", "fa-gem", "fa-dolly", "fa-smoking", "fa-minimize", "fa-monument", "fa-snowplow", "fa-angles-right", "fa-cannabis", "fa-circle-play", "fa-tablets", "fa-ethernet", "fa-euro-sign", "fa-chair", "fa-circle-check", "fa-circle-stop", "fa-compass-drafting", "fa-plate-wheat", "fa-icicles", "fa-person-shelter", "fa-neuter", "fa-id-badge", "fa-marker", "fa-face-laugh-beam", "fa-helicopter-symbol", "fa-universal-access", "fa-circle-chevron-up", "fa-lari-sign", "fa-volcano", "fa-person-walking-dashed-line-arrow-right", "fa-sterling-sign", "fa-viruses", "fa-square-person-confined", "fa-user-tie", "fa-arrow-down-long", "fa-tent-arrow-down-to-line", "fa-certificate", "fa-reply-all", "fa-suitcase", "fa-person-skating", "fa-filter-circle-dollar", "fa-camera-retro", "fa-circle-arrow-down", "fa-file-import", "fa-square-arrow-up-right", "fa-box-open", "fa-scroll", "fa-spa", "fa-location-pin-lock", "fa-pause", "fa-hill-avalanche", "fa-temperature-empty", "fa-bomb", "fa-registered", "fa-address-card", "fa-scale-unbalanced-flip", "fa-subscript", "fa-diamond-turn-right", "fa-burst", "fa-house-laptop", "fa-face-tired", "fa-money-bills", "fa-smog", "fa-crutch", "fa-font-awesome", "fa-cloud-arrow-up", "fa-palette", "fa-arrows-turn-right", "fa-vest", "fa-ferry", "fa-arrows-down-to-people", "fa-seedling", "fa-left-right", "fa-boxes-packing", "fa-circle-arrow-left", "fa-group-arrows-rotate", "fa-bowl-food", "fa-candy-cane", "fa-arrow-down-wide-short", "fa-cloud-bolt", "fa-text-slash", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-arrows-left-right", "fa-house-lock", "fa-cloud-arrow-down", "fa-children", "fa-chalkboard", "fa-user-large-slash", "fa-envelope-open", "fa-handshake-simple-slash", "fa-mattress-pillow", "fa-guarani-sign", "fa-arrows-rotate", "fa-fire-extinguisher", "fa-cruzeiro-sign", "fa-greater-than-equal", "fa-shield-halved", "fa-book-atlas", "fa-virus", "fa-envelope-circle-check", "fa-layer-group", "fa-arrows-to-dot", "fa-archway", "fa-heart-circle-check", "fa-house-chimney-crack", "fa-file-zipper", "fa-square", "fa-martini-glass-empty", "fa-couch", "fa-cedi-sign", "fa-italic", "fa-church", "fa-comments-dollar", "fa-democrat", "fa-z", "fa-person-skiing", "fa-road-lock", "fa-a", "fa-temperature-arrow-down", "fa-feather-pointed", "fa-p", "fa-snowflake", "fa-newspaper", "fa-rectangle-ad", "fa-circle-arrow-right", "fa-filter-circle-xmark", "fa-locust", "fa-sort", "fa-list-ol", "fa-person-dress-burst", "fa-money-check-dollar", "fa-vector-square", "fa-bread-slice", "fa-language", "fa-face-kiss-wink-heart", "fa-filter", "fa-question", "fa-file-signature", "fa-up-down-left-right", "fa-house-chimney-user", "fa-hand-holding-heart", "fa-puzzle-piece", "fa-money-check", "fa-star-half-stroke", "fa-code", "fa-whiskey-glass", "fa-building-circle-exclamation", "fa-magnifying-glass-chart", "fa-arrow-up-right-from-square", "fa-cubes-stacked", "fa-won-sign", "fa-virus-covid", "fa-austral-sign", "fa-f", "fa-leaf", "fa-road", "fa-taxi", "fa-person-circle-plus", "fa-chart-pie", "fa-bolt-lightning", "fa-sack-xmark", "fa-file-excel", "fa-file-contract", "fa-fish-fins", "fa-building-flag", "fa-face-grin-beam", "fa-object-ungroup", "fa-poop", "fa-location-pin", "fa-kaaba", "fa-toilet-paper", "fa-helmet-safety", "fa-eject", "fa-circle-right", "fa-plane-circle-check", "fa-face-rolling-eyes", "fa-object-group", "fa-chart-line", "fa-mask-ventilator", "fa-arrow-right", "fa-signs-post", "fa-cash-register", "fa-person-circle-question", "fa-h", "fa-tarp", "fa-screwdriver-wrench", "fa-arrows-to-eye", "fa-plug-circle-bolt", "fa-heart", "fa-mars-and-venus", "fa-house-user", "fa-dumpster-fire", "fa-house-crack", "fa-martini-glass-citrus", "fa-face-surprise", "fa-bottle-water", "fa-circle-pause", "fa-toilet-paper-slash", "fa-apple-whole", "fa-kitchen-set", "fa-r", "fa-temperature-quarter", "fa-cube", "fa-bitcoin-sign", "fa-shield-dog", "fa-solar-panel", "fa-lock-open", "fa-elevator", "fa-money-bill-transfer", "fa-money-bill-trend-up", "fa-house-flood-water-circle-arrow-right", "fa-square-poll-horizontal", "fa-circle", "fa-backward-fast", "fa-recycle", "fa-user-astronaut", "fa-plane-slash", "fa-trademark", "fa-basketball", "fa-satellite-dish", "fa-circle-up", "fa-mobile-screen-button", "fa-volume-high", "fa-users-rays", "fa-wallet", "fa-clipboard-check", "fa-file-audio", "fa-burger", "fa-wrench", "fa-bugs", "fa-rupee-sign", "fa-file-image", "fa-circle-question", "fa-plane-departure", "fa-handshake-slash", "fa-book-bookmark", "fa-code-branch", "fa-hat-cowboy", "fa-bridge", "fa-phone-flip", "fa-truck-front", "fa-cat", "fa-anchor-circle-exclamation", "fa-truck-field", "fa-route", "fa-clipboard-question", "fa-panorama", "fa-comment-medical", "fa-teeth-open", "fa-file-circle-minus", "fa-tags", "fa-wine-glass", "fa-forward-fast", "fa-face-meh-blank", "fa-square-parking", "fa-house-signal", "fa-bars-progress", "fa-faucet-drip", "fa-cart-flatbed", "fa-ban-smoking", "fa-terminal", "fa-mobile-button", "fa-house-medical-flag", "fa-basket-shopping", "fa-tape", "fa-bus-simple", "fa-eye", "fa-face-sad-cry", "fa-audio-description", "fa-person-military-to-person", "fa-file-shield", "fa-user-slash", "fa-pen", "fa-tower-observation", "fa-file-code", "fa-signal", "fa-bus", "fa-heart-circle-xmark", "fa-house-chimney", "fa-window-maximize", "fa-face-frown", "fa-prescription", "fa-shop", "fa-floppy-disk", "fa-vihara", "fa-scale-unbalanced", "fa-sort-up", "fa-comment-dots", "fa-plant-wilt", "fa-diamond", "fa-face-grin-squint", "fa-hand-holding-dollar", "fa-bacterium", "fa-hand-pointer", "fa-drum-steelpan", "fa-hand-scissors", "fa-hands-praying", "fa-arrow-rotate-right", "fa-biohazard", "fa-location-crosshairs", "fa-mars-double", "fa-child-dress", "fa-users-between-lines", "fa-lungs-virus", "fa-face-grin-tears", "fa-phone", "fa-calendar-xmark", "fa-child-reaching", "fa-head-side-virus", "fa-user-gear", "fa-arrow-up-1-9", "fa-door-closed", "fa-shield-virus", "fa-dice-six", "fa-mosquito-net", "fa-bridge-water", "fa-person-booth", "fa-text-width", "fa-hat-wizard", "fa-pen-fancy", "fa-person-digging", "fa-trash", "fa-gauge-simple", "fa-book-medical", "fa-poo", "fa-quote-right", "fa-shirt", "fa-cubes", "fa-divide", "fa-tenge-sign", "fa-headphones", "fa-hands-holding", "fa-hands-clapping", "fa-republican", "fa-arrow-left", "fa-person-circle-xmark", "fa-ruler", "fa-align-left", "fa-dice-d6", "fa-restroom", "fa-j", "fa-users-viewfinder", "fa-file-video", "fa-up-right-from-square", "fa-table-cells", "fa-file-pdf", "fa-book-bible", "fa-o", "fa-suitcase-medical", "fa-user-secret", "fa-otter", "fa-person-dress", "fa-comment-dollar", "fa-business-time", "fa-table-cells-large", "fa-book-tanakh", "fa-phone-volume", "fa-hat-cowboy-side", "fa-clipboard-user", "fa-child", "fa-lira-sign", "fa-satellite", "fa-plane-lock", "fa-tag", "fa-comment", "fa-cake-candles", "fa-envelope", "fa-angles-up", "fa-paperclip", "fa-arrow-right-to-city", "fa-ribbon", "fa-lungs", "fa-arrow-up-9-1", "fa-litecoin-sign", "fa-border-none", "fa-circle-nodes", "fa-parachute-box", "fa-indent", "fa-truck-field-un", "fa-hourglass", "fa-mountain", "fa-user-doctor", "fa-circle-info", "fa-cloud-meatball", "fa-camera", "fa-square-virus", "fa-meteor", "fa-car-on", "fa-sleigh", "fa-arrow-down-1-9", "fa-hand-holding-droplet", "fa-water", "fa-calendar-check", "fa-braille", "fa-prescription-bottle-medical", "fa-landmark", "fa-truck", "fa-crosshairs", "fa-person-cane", "fa-tent", "fa-vest-patches", "fa-check-double", "fa-arrow-down-a-z", "fa-money-bill-wheat", "fa-cookie", "fa-arrow-rotate-left", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-dumbbell", "fa-rectangle-list", "fa-tarp-droplet", "fa-house-medical-circle-check", "fa-person-skiing-nordic", "fa-calendar-plus", "fa-plane-arrival", "fa-circle-left", "fa-train-subway", "fa-chart-gantt", "fa-indian-rupee-sign", "fa-crop-simple", "fa-money-bill-1", "fa-left-long", "fa-dna", "fa-virus-slash", "fa-minus", "fa-chess", "fa-arrow-left-long", "fa-plug-circle-check", "fa-street-view", "fa-franc-sign", "fa-volume-off", "fa-hands-asl-interpreting", "fa-gear", "fa-droplet-slash", "fa-mosque", "fa-mosquito", "fa-star-of-david", "fa-person-military-rifle", "fa-cart-shopping", "fa-vials", "fa-plug-circle-plus", "fa-place-of-worship", "fa-grip-vertical", "fa-arrow-turn-up", "fa-u", "fa-square-root-variable", "fa-clock", "fa-backward-step", "fa-pallet", "fa-faucet", "fa-baseball-bat-ball", "fa-s", "fa-timeline", "fa-keyboard", "fa-caret-down", "fa-house-chimney-medical", "fa-temperature-three-quarters", "fa-mobile-screen", "fa-plane-up", "fa-piggy-bank", "fa-battery-half", "fa-mountain-city", "fa-coins", "fa-khanda", "fa-sliders", "fa-folder-tree", "fa-network-wired", "fa-map-pin", "fa-hamsa", "fa-cent-sign", "fa-flask", "fa-person-pregnant", "fa-wand-sparkles", "fa-ellipsis-vertical", "fa-ticket", "fa-power-off", "fa-right-long", "fa-flag-usa", "fa-laptop-file", "fa-tty", "fa-diagram-next", "fa-person-rifle", "fa-house-medical-circle-exclamation", "fa-closed-captioning", "fa-person-hiking", "fa-venus-double", "fa-images", "fa-calculator", "fa-people-pulling", "fa-n", "fa-cable-car", "fa-cloud-rain", "fa-building-circle-xmark", "fa-ship", "fa-arrows-down-to-line", "fa-download", "fa-face-grin", "fa-delete-left", "fa-eye-dropper", "fa-file-circle-check", "fa-forward", "fa-mobile", "fa-face-meh", "fa-align-center", "fa-book-skull", "fa-id-card", "fa-outdent", "fa-heart-circle-exclamation", "fa-house", "fa-calendar-week", "fa-laptop-medical", "fa-b", "fa-file-medical", "fa-dice-one", "fa-kiwi-bird", "fa-arrow-right-arrow-left", "fa-rotate-right", "fa-utensils", "fa-arrow-up-wide-short", "fa-mill-sign", "fa-bowl-rice", "fa-skull", "fa-tower-broadcast", "fa-truck-pickup", "fa-up-long", "fa-stop", "fa-code-merge", "fa-upload", "fa-hurricane", "fa-mound", "fa-toilet-portable", "fa-compact-disc", "fa-file-arrow-down", "fa-caravan", "fa-shield-cat", "fa-bolt", "fa-glass-water", "fa-oil-well", "fa-vault", "fa-mars", "fa-toilet", "fa-plane-circle-xmark", "fa-yen-sign", "fa-ruble-sign", "fa-sun", "fa-guitar", "fa-face-laugh-wink", "fa-horse-head", "fa-bore-hole", "fa-industry", "fa-circle-down", "fa-arrows-turn-to-dots", "fa-florin-sign", "fa-arrow-down-short-wide", "fa-less-than", "fa-angle-down", "fa-car-tunnel", "fa-head-side-cough", "fa-grip-lines", "fa-thumbs-down", "fa-user-lock", "fa-arrow-right-long", "fa-anchor-circle-xmark", "fa-ellipsis", "fa-chess-pawn", "fa-kit-medical", "fa-person-through-window", "fa-toolbox", "fa-hands-holding-circle", "fa-bug", "fa-credit-card", "fa-car", "fa-hand-holding-hand", "fa-book-open-reader", "fa-mountain-sun", "fa-arrows-left-right-to-line", "fa-dice-d20", "fa-truck-droplet", "fa-file-circle-xmark", "fa-temperature-arrow-up", "fa-medal", "fa-bed", "fa-square-h", "fa-podcast", "fa-temperature-full", "fa-bell", "fa-superscript", "fa-plug-circle-xmark", "fa-star-of-life", "fa-phone-slash", "fa-paint-roller", "fa-handshake-angle", "fa-location-dot", "fa-file", "fa-greater-than", "fa-person-swimming", "fa-arrow-down", "fa-droplet", "fa-eraser", "fa-earth-americas", "fa-person-burst", "fa-dove", "fa-battery-empty", "fa-socks", "fa-inbox", "fa-section", "fa-gauge-high", "fa-envelope-open-text", "fa-hospital", "fa-wine-bottle", "fa-chess-rook", "fa-bars-staggered", "fa-dharmachakra", "fa-hotdog", "fa-person-walking-with-cane", "fa-drum", "fa-ice-cream", "fa-heart-circle-bolt", "fa-fax", "fa-paragraph", "fa-check-to-slot", "fa-star-half", "fa-boxes-stacked", "fa-link", "fa-ear-listen", "fa-tree-city", "fa-play", "fa-font", "fa-rupiah-sign", "fa-magnifying-glass", "fa-table-tennis-paddle-ball", "fa-person-dots-from-line", "fa-trash-can-arrow-up", "fa-naira-sign", "fa-cart-arrow-down", "fa-walkie-talkie", "fa-file-pen", "fa-receipt", "fa-square-pen", "fa-suitcase-rolling", "fa-person-circle-exclamation", "fa-chevron-down", "fa-battery-full", "fa-skull-crossbones", "fa-code-compare", "fa-list-ul", "fa-school-lock", "fa-tower-cell", "fa-down-long", "fa-ranking-star", "fa-chess-king", "fa-person-harassing", "fa-brazilian-real-sign", "fa-landmark-dome", "fa-arrow-up", "fa-tv", "fa-shrimp", "fa-list-check", "fa-jug-detergent", "fa-circle-user", "fa-user-shield", "fa-wind", "fa-car-burst", "fa-y", "fa-person-snowboarding", "fa-truck-fast", "fa-fish", "fa-user-graduate", "fa-circle-half-stroke", "fa-clapperboard", "fa-circle-radiation", "fa-baseball", "fa-jet-fighter-up", "fa-diagram-project", "fa-copy", "fa-volume-xmark", "fa-hand-sparkles", "fa-grip", "fa-share-from-square", "fa-child-combatant", "fa-gun", "fa-square-phone", "fa-plus", "fa-expand", "fa-computer", "fa-xmark", "fa-arrows-up-down-left-right", "fa-chalkboard-user", "fa-peso-sign", "fa-building-shield", "fa-baby", "fa-users-line", "fa-quote-left", "fa-tractor", "fa-trash-arrow-up", "fa-arrow-down-up-lock", "fa-lines-leaning", "fa-ruler-combined", "fa-copyright", "fa-equals", "fa-blender", "fa-teeth", "fa-shekel-sign", "fa-map", "fa-rocket", "fa-photo-film", "fa-folder-minus", "fa-store", "fa-arrow-trend-up", "fa-plug-circle-minus", "fa-sign-hanging", "fa-bezier-curve", "fa-bell-slash", "fa-tablet", "fa-school-flag", "fa-fill", "fa-angle-up", "fa-drumstick-bite", "fa-holly-berry", "fa-chevron-left", "fa-bacteria", "fa-hand-lizard", "fa-notdef", "fa-disease", "fa-briefcase-medical", "fa-genderless", "fa-chevron-right", "fa-retweet", "fa-car-rear", "fa-pump-soap", "fa-video-slash", "fa-battery-quarter", "fa-radio", "fa-baby-carriage", "fa-traffic-light", "fa-thermometer", "fa-vr-cardboard", "fa-hand-middle-finger", "fa-percent", "fa-truck-moving", "fa-glass-water-droplet", "fa-display", "fa-face-smile", "fa-thumbtack", "fa-trophy", "fa-person-praying", "fa-hammer", "fa-hand-peace", "fa-rotate", "fa-spinner", "fa-robot", "fa-peace", "fa-gears", "fa-warehouse", "fa-arrow-up-right-dots", "fa-splotch", "fa-face-grin-hearts", "fa-dice-four", "fa-sim-card", "fa-transgender", "fa-mercury", "fa-arrow-turn-down", "fa-person-falling-burst", "fa-award", "fa-ticket-simple", "fa-building", "fa-angles-left", "fa-qrcode", "fa-clock-rotate-left", "fa-face-grin-beam-sweat", "fa-file-export", "fa-shield", "fa-arrow-up-short-wide", "fa-house-medical", "fa-golf-ball-tee", "fa-circle-chevron-left", "fa-house-chimney-window", "fa-pen-nib", "fa-tent-arrow-turn-left", "fa-tents", "fa-wand-magic", "fa-dog", "fa-carrot", "fa-moon", "fa-wine-glass-empty", "fa-cheese", "fa-yin-yang", "fa-music", "fa-code-commit", "fa-temperature-low", "fa-person-biking", "fa-broom", "fa-shield-heart", "fa-gopuram", "fa-earth-oceania", "fa-square-xmark", "fa-hashtag", "fa-up-right-and-down-left-from-center", "fa-oil-can", "fa-t", "fa-hippo", "fa-chart-column", "fa-infinity", "fa-vial-circle-check", "fa-person-arrow-down-to-line", "fa-voicemail", "fa-fan", "fa-person-walking-luggage", "fa-up-down", "fa-cloud-moon-rain", "fa-calendar", "fa-trailer", "fa-bahai", "fa-sd-card", "fa-dragon", "fa-shoe-prints", "fa-circle-plus", "fa-face-grin-tongue-wink", "fa-hand-holding", "fa-plug-circle-exclamation", "fa-link-slash", "fa-clone", "fa-person-walking-arrow-loop-left", "fa-arrow-up-z-a", "fa-fire-flame-curved", "fa-tornado", "fa-file-circle-plus", "fa-book-quran", "fa-anchor", "fa-border-all", "fa-face-angry", "fa-cookie-bite", "fa-arrow-trend-down", "fa-rss", "fa-draw-polygon", "fa-scale-balanced", "fa-gauge-simple-high", "fa-shower", "fa-desktop", "fa-m", "fa-table-list", "fa-comment-sms", "fa-book", "fa-user-plus", "fa-check", "fa-battery-three-quarters", "fa-house-circle-check", "fa-angle-left", "fa-diagram-successor", "fa-truck-arrow-right", "fa-arrows-split-up-and-left", "fa-hand-fist", "fa-cloud-moon", "fa-briefcase", "fa-person-falling", "fa-image-portrait", "fa-user-tag", "fa-rug", "fa-earth-europe", "fa-cart-flatbed-suitcase", "fa-rectangle-xmark", "fa-baht-sign", "fa-book-open", "fa-book-journal-whills", "fa-handcuffs", "fa-triangle-exclamation", "fa-database", "fa-share", "fa-bottle-droplet", "fa-mask-face", "fa-hill-rockslide", "fa-right-left", "fa-paper-plane", "fa-road-circle-exclamation", "fa-dungeon", "fa-align-right", "fa-money-bill-1-wave", "fa-life-ring", "fa-hands", "fa-calendar-day", "fa-water-ladder", "fa-arrows-up-down", "fa-face-grimace", "fa-wheelchair-move", "fa-turn-down", "fa-person-walking-arrow-right", "fa-square-envelope", "fa-dice", "fa-bowling-ball", "fa-brain", "fa-bandage", "fa-calendar-minus", "fa-circle-xmark", "fa-gifts", "fa-hotel", "fa-earth-asia", "fa-id-card-clip", "fa-magnifying-glass-plus", "fa-thumbs-up", "fa-user-clock", "fa-hand-dots", "fa-file-invoice", "fa-window-minimize", "fa-mug-saucer", "fa-brush", "fa-mask", "fa-magnifying-glass-minus", "fa-ruler-vertical", "fa-user-large", "fa-train-tram", "fa-user-nurse", "fa-syringe", "fa-cloud-sun", "fa-stopwatch-20", "fa-square-full", "fa-magnet", "fa-jar", "fa-note-sticky", "fa-bug-slash", "fa-arrow-up-from-water-pump", "fa-bone", "fa-user-injured", "fa-face-sad-tear", "fa-plane", "fa-tent-arrows-down", "fa-exclamation", "fa-arrows-spin", "fa-print", "fa-turkish-lira-sign", "fa-dollar-sign", "fa-x", "fa-magnifying-glass-dollar", "fa-users-gear", "fa-person-military-pointing", "fa-building-columns", "fa-umbrella", "fa-trowel", "fa-d", "fa-stapler", "fa-masks-theater", "fa-kip-sign", "fa-hand-point-left", "fa-handshake-simple", "fa-jet-fighter", "fa-square-share-nodes", "fa-barcode", "fa-plus-minus", "fa-video", "fa-graduation-cap", "fa-hand-holding-medical", "fa-person-circle-check", "fa-turn-up" );
        return $fa_icons_solid;
    }
endif;


if ( ! function_exists( 'hcode_fontawesome_reg' ) ) :
	function hcode_fontawesome_reg() {
		$fa_icons_reg = array( "fa-trash-can", "fa-message", "fa-file-lines", "fa-calendar-days", "fa-hand-point-right", "fa-face-smile-beam", "fa-face-grin-stars", "fa-address-book", "fa-comments", "fa-paste", "fa-face-grin-tongue-squint", "fa-face-flushed", "fa-square-caret-right", "fa-square-minus", "fa-compass", "fa-square-caret-down", "fa-face-kiss-beam", "fa-lightbulb", "fa-flag", "fa-square-check", "fa-circle-dot", "fa-face-dizzy", "fa-futbol", "fa-pen-to-square", "fa-hourglass-half", "fa-eye-slash", "fa-hand", "fa-hand-spock", "fa-face-kiss", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-face-grin-wide", "fa-face-frown-open", "fa-hand-point-up", "fa-bookmark", "fa-hand-point-down", "fa-folder", "fa-user", "fa-square-caret-left", "fa-star", "fa-chess-knight", "fa-face-laugh-squint", "fa-face-laugh", "fa-folder-open", "fa-clipboard", "fa-chess-queen", "fa-hand-back-fist", "fa-square-caret-up", "fa-chart-bar", "fa-window-restore", "fa-square-plus", "fa-image", "fa-folder-closed", "fa-lemon", "fa-handshake", "fa-gem", "fa-circle-play", "fa-circle-check", "fa-circle-stop", "fa-id-badge", "fa-face-laugh-beam", "fa-registered", "fa-address-card", "fa-face-tired", "fa-font-awesome", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-envelope-open", "fa-file-zipper", "fa-square", "fa-snowflake", "fa-newspaper", "fa-face-kiss-wink-heart", "fa-star-half-stroke", "fa-file-excel", "fa-face-grin-beam", "fa-object-ungroup", "fa-circle-right", "fa-face-rolling-eyes", "fa-object-group", "fa-heart", "fa-face-surprise", "fa-circle-pause", "fa-circle", "fa-circle-up", "fa-file-audio", "fa-file-image", "fa-circle-question", "fa-face-meh-blank", "fa-eye", "fa-face-sad-cry", "fa-file-code", "fa-window-maximize", "fa-face-frown", "fa-floppy-disk", "fa-comment-dots", "fa-face-grin-squint", "fa-hand-pointer", "fa-hand-scissors", "fa-face-grin-tears", "fa-calendar-xmark", "fa-file-video", "fa-file-pdf", "fa-comment", "fa-envelope", "fa-hourglass", "fa-calendar-check", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-rectangle-list", "fa-calendar-plus", "fa-circle-left", "fa-money-bill-1", "fa-clock", "fa-keyboard", "fa-closed-captioning", "fa-images", "fa-face-grin", "fa-face-meh", "fa-id-card", "fa-sun", "fa-face-laugh-wink", "fa-circle-down", "fa-thumbs-down", "fa-chess-pawn", "fa-credit-card", "fa-bell", "fa-file", "fa-hospital", "fa-chess-rook", "fa-star-half", "fa-chess-king", "fa-circle-user", "fa-copy", "fa-share-from-square", "fa-copyright", "fa-map", "fa-bell-slash", "fa-hand-lizard", "fa-face-smile", "fa-hand-peace", "fa-face-grin-hearts", "fa-building", "fa-face-grin-beam-sweat", "fa-moon", "fa-calendar", "fa-face-grin-tongue-wink", "fa-clone", "fa-face-angry", "fa-rectangle-xmark", "fa-paper-plane", "fa-life-ring", "fa-face-grimace", "fa-calendar-minus", "fa-circle-xmark", "fa-thumbs-up", "fa-window-minimize", "fa-square-full", "fa-note-sticky", "fa-face-sad-tear", "fa-hand-point-left" );
		return $fa_icons_reg;
	}
endif;

if ( ! function_exists( 'hcode_fontawesome_brand' ) ) :
	function hcode_fontawesome_brand() {
		$fa_icons_brand = array( "fa-monero", "fa-hooli", "fa-yelp", "fa-cc-visa", "fa-lastfm", "fa-shopware", "fa-creative-commons-nc", "fa-aws", "fa-redhat", "fa-yoast", "fa-cloudflare", "fa-ups", "fa-wpexplorer", "fa-dyalog", "fa-bity", "fa-stackpath", "fa-buysellads", "fa-first-order", "fa-modx", "fa-guilded", "fa-vnv", "fa-square-js", "fa-microsoft", "fa-qq", "fa-orcid", "fa-java", "fa-invision", "fa-creative-commons-pd-alt", "fa-centercode", "fa-glide-g", "fa-drupal", "fa-hire-a-helper", "fa-creative-commons-by", "fa-unity", "fa-whmcs", "fa-rocketchat", "fa-vk", "fa-untappd", "fa-mailchimp", "fa-css3-alt", "fa-square-reddit", "fa-vimeo-v", "fa-contao", "fa-square-font-awesome", "fa-deskpro", "fa-sistrix", "fa-square-instagram", "fa-battle-net", "fa-the-red-yeti", "fa-square-hacker-news", "fa-edge", "fa-threads", "fa-napster", "fa-square-snapchat", "fa-google-plus-g", "fa-artstation", "fa-markdown", "fa-sourcetree", "fa-google-plus", "fa-diaspora", "fa-foursquare", "fa-stack-overflow", "fa-github-alt", "fa-phoenix-squadron", "fa-pagelines", "fa-algolia", "fa-red-river", "fa-creative-commons-sa", "fa-safari", "fa-google", "fa-square-font-awesome-stroke", "fa-atlassian", "fa-linkedin-in", "fa-digital-ocean", "fa-nimblr", "fa-chromecast", "fa-evernote", "fa-hacker-news", "fa-creative-commons-sampling", "fa-adversal", "fa-creative-commons", "fa-watchman-monitoring", "fa-fonticons", "fa-weixin", "fa-shirtsinbulk", "fa-codepen", "fa-git-alt", "fa-lyft", "fa-rev", "fa-windows", "fa-wizards-of-the-coast", "fa-square-viadeo", "fa-meetup", "fa-centos", "fa-adn", "fa-cloudsmith", "fa-pied-piper-alt", "fa-square-dribbble", "fa-codiepie", "fa-node", "fa-mix", "fa-steam", "fa-cc-apple-pay", "fa-scribd", "fa-debian", "fa-openid", "fa-instalod", "fa-expeditedssl", "fa-sellcast", "fa-square-twitter", "fa-r-project", "fa-delicious", "fa-freebsd", "fa-vuejs", "fa-accusoft", "fa-ioxhost", "fa-fonticons-fi", "fa-app-store", "fa-cc-mastercard", "fa-itunes-note", "fa-golang", "fa-kickstarter", "fa-grav", "fa-weibo", "fa-uncharted", "fa-firstdraft", "fa-square-youtube", "fa-wikipedia-w", "fa-wpressr", "fa-angellist", "fa-galactic-republic", "fa-nfc-directional", "fa-skype", "fa-joget", "fa-fedora", "fa-stripe-s", "fa-meta", "fa-laravel", "fa-hotjar", "fa-bluetooth-b", "fa-sticker-mule", "fa-creative-commons-zero", "fa-hips", "fa-behance", "fa-reddit", "fa-discord", "fa-chrome", "fa-app-store-ios", "fa-cc-discover", "fa-wpbeginner", "fa-confluence", "fa-mdb", "fa-dochub", "fa-accessible-icon", "fa-ebay", "fa-amazon", "fa-unsplash", "fa-yarn", "fa-square-steam", "fa-500px", "fa-square-vimeo", "fa-asymmetrik", "fa-font-awesome", "fa-gratipay", "fa-apple", "fa-hive", "fa-gitkraken", "fa-keybase", "fa-apple-pay", "fa-padlet", "fa-amazon-pay", "fa-square-github", "fa-stumbleupon", "fa-fedex", "fa-phoenix-framework", "fa-shopify", "fa-neos", "fa-square-threads", "fa-hackerrank", "fa-researchgate", "fa-swift", "fa-angular", "fa-speakap", "fa-angrycreative", "fa-y-combinator", "fa-empire", "fa-envira", "fa-square-gitlab", "fa-studiovinari", "fa-pied-piper", "fa-wordpress", "fa-product-hunt", "fa-firefox", "fa-linode", "fa-goodreads", "fa-square-odnoklassniki", "fa-jsfiddle", "fa-sith", "fa-themeisle", "fa-page4", "fa-hashnode", "fa-react", "fa-cc-paypal", "fa-squarespace", "fa-cc-stripe", "fa-creative-commons-share", "fa-bitcoin", "fa-keycdn", "fa-opera", "fa-itch-io", "fa-umbraco", "fa-galactic-senate", "fa-ubuntu", "fa-draft2digital", "fa-stripe", "fa-houzz", "fa-gg", "fa-dhl", "fa-square-pinterest", "fa-xing", "fa-blackberry", "fa-creative-commons-pd", "fa-playstation", "fa-quinscape", "fa-less", "fa-blogger-b", "fa-opencart", "fa-vine", "fa-paypal", "fa-gitlab", "fa-typo3", "fa-reddit-alien", "fa-yahoo", "fa-dailymotion", "fa-affiliatetheme", "fa-pied-piper-pp", "fa-bootstrap", "fa-odnoklassniki", "fa-nfc-symbol", "fa-ethereum", "fa-speaker-deck", "fa-creative-commons-nc-eu", "fa-patreon", "fa-avianex", "fa-ello", "fa-gofore", "fa-bimobject", "fa-facebook-f", "fa-square-google-plus", "fa-mandalorian", "fa-first-order-alt", "fa-osi", "fa-google-wallet", "fa-d-and-d-beyond", "fa-periscope", "fa-fulcrum", "fa-cloudscale", "fa-forumbee", "fa-mizuni", "fa-schlix", "fa-square-xing", "fa-bandcamp", "fa-wpforms", "fa-cloudversify", "fa-usps", "fa-megaport", "fa-magento", "fa-spotify", "fa-optin-monster", "fa-fly", "fa-aviato", "fa-itunes", "fa-cuttlefish", "fa-blogger", "fa-flickr", "fa-viber", "fa-soundcloud", "fa-digg", "fa-tencent-weibo", "fa-symfony", "fa-maxcdn", "fa-etsy", "fa-facebook-messenger", "fa-audible", "fa-think-peaks", "fa-bilibili", "fa-erlang", "fa-x-twitter", "fa-cotton-bureau", "fa-dashcube", "fa-42-group", "fa-stack-exchange", "fa-elementor", "fa-square-pied-piper", "fa-creative-commons-nd", "fa-palfed", "fa-superpowers", "fa-resolving", "fa-xbox", "fa-searchengin", "fa-tiktok", "fa-square-facebook", "fa-renren", "fa-linux", "fa-glide", "fa-linkedin", "fa-hubspot", "fa-deploydog", "fa-twitch", "fa-ravelry", "fa-mixer", "fa-square-lastfm", "fa-vimeo", "fa-mendeley", "fa-uniregistry", "fa-figma", "fa-creative-commons-remix", "fa-cc-amazon-pay", "fa-dropbox", "fa-instagram", "fa-cmplid", "fa-facebook", "fa-gripfire", "fa-jedi-order", "fa-uikit", "fa-fort-awesome-alt", "fa-phabricator", "fa-ussunnah", "fa-earlybirds", "fa-trade-federation", "fa-autoprefixer", "fa-whatsapp", "fa-slideshare", "fa-google-play", "fa-viadeo", "fa-line", "fa-google-drive", "fa-servicestack", "fa-simplybuilt", "fa-bitbucket", "fa-imdb", "fa-deezer", "fa-raspberry-pi", "fa-jira", "fa-docker", "fa-screenpal", "fa-bluetooth", "fa-gitter", "fa-d-and-d", "fa-microblog", "fa-cc-diners-club", "fa-gg-circle", "fa-pied-piper-hat", "fa-kickstarter-k", "fa-yandex", "fa-readme", "fa-html5", "fa-sellsy", "fa-sass", "fa-wirsindhandwerk", "fa-buromobelexperte", "fa-salesforce", "fa-octopus-deploy", "fa-medapps", "fa-ns8", "fa-pinterest-p", "fa-apper", "fa-fort-awesome", "fa-waze", "fa-cc-jcb", "fa-snapchat", "fa-fantasy-flight-games", "fa-rust", "fa-wix", "fa-square-behance", "fa-supple", "fa-rebel", "fa-css3", "fa-staylinked", "fa-kaggle", "fa-space-awesome", "fa-deviantart", "fa-cpanel", "fa-goodreads-g", "fa-square-git", "fa-square-tumblr", "fa-trello", "fa-creative-commons-nc-jp", "fa-get-pocket", "fa-perbyte", "fa-grunt", "fa-weebly", "fa-connectdevelop", "fa-leanpub", "fa-black-tie", "fa-themeco", "fa-python", "fa-android", "fa-bots", "fa-free-code-camp", "fa-hornbill", "fa-js", "fa-ideal", "fa-git", "fa-dev", "fa-sketch", "fa-yandex-international", "fa-cc-amex", "fa-uber", "fa-github", "fa-php", "fa-alipay", "fa-youtube", "fa-skyatlas", "fa-firefox-browser", "fa-replyd", "fa-suse", "fa-jenkins", "fa-twitter", "fa-rockrms", "fa-pinterest", "fa-buffer", "fa-npm", "fa-yammer", "fa-btc", "fa-dribbble", "fa-stumbleupon-circle", "fa-internet-explorer", "fa-stubber", "fa-telegram", "fa-old-republic", "fa-odysee", "fa-square-whatsapp", "fa-node-js", "fa-edge-legacy", "fa-slack", "fa-medrt", "fa-usb", "fa-tumblr", "fa-vaadin", "fa-quora", "fa-square-x-twitter", "fa-reacteurope", "fa-medium", "fa-amilia", "fa-mixcloud", "fa-flipboard", "fa-viacoin", "fa-critical-role", "fa-sitrox", "fa-discourse", "fa-joomla", "fa-mastodon", "fa-airbnb", "fa-wolf-pack-battalion", "fa-buy-n-large", "fa-gulp", "fa-creative-commons-sampling-plus", "fa-strava", "fa-ember", "fa-canadian-maple-leaf", "fa-teamspeak", "fa-pushed", "fa-wordpress-simple", "fa-nutritionix", "fa-wodu", "fa-google-pay", "fa-intercom", "fa-zhihu", "fa-korvue", "fa-pix", "fa-steam-symbol" );

		return $fa_icons_brand;
	}
endif;

if ( ! function_exists( 'hcode_fontawesome_old' ) ) {
	function hcode_fontawesome_old() {
		$fa_icon_old = array( 'fa-500px' => 'fab fa-500px','fa-address-book-o' => 'far fa-address-book','fa-address-card-o' => 'far fa-address-card','fa-adn' => 'fab fa-adn','fa-amazon' => 'fab fa-amazon','fa-android' => 'fab fa-android','fa-angellist' => 'fab fa-angellist','fa-apple' => 'fab fa-apple','fa-area-chart' => 'fas fa-chart-area','fa-arrow-circle-o-down' => 'far fa-arrow-alt-circle-down','fa-arrow-circle-o-left' => 'far fa-arrow-alt-circle-left','fa-arrow-circle-o-right' => 'far fa-arrow-alt-circle-right','fa-arrow-circle-o-up' => 'far fa-arrow-alt-circle-up','fa-arrows' => 'fas fa-arrows-alt','fa-arrows-alt' => 'fas fa-expand-arrows-alt','fa-arrows-h' => 'fas fa-arrows-alt-h','fa-arrows-v' => 'fas fa-arrows-alt-v','fa-asl-interpreting' => 'fas fa-american-sign-language-interpreting','fa-automobile' => 'fas fa-car','fa-bandcamp' => 'fab fa-bandcamp','fa-bank' => 'fas fa-university','fa-bar-chart' => 'far fa-chart-bar','fa-bar-chart-o' => 'far fa-chart-bar','fa-bathtub' => 'fas fa-bath','fa-battery' => 'fas fa-battery-full','fa-battery-0' => 'fas fa-battery-empty','fa-battery-1' => 'fas fa-battery-quarter','fa-battery-2' => 'fas fa-battery-half','fa-battery-3' => 'fas fa-battery-three-quarters','fa-battery-4' => 'fas fa-battery-full','fa-behance' => 'fab fa-behance','fa-behance-square' => 'fab fa-behance-square','fa-bell-o' => 'far fa-bell','fa-bell-slash-o' => 'far fa-bell-slash','fa-bitbucket' => 'fab fa-bitbucket','fa-bitbucket-square' => 'fab fa-bitbucket','fa-bitcoin' => 'fab fa-btc','fa-black-tie' => 'fab fa-black-tie','fa-bluetooth' => 'fab fa-bluetooth','fa-bluetooth-b' => 'fab fa-bluetooth-b','fa-bookmark-o' => 'far fa-bookmark','fa-btc' => 'fab fa-btc','fa-building-o' => 'far fa-building','fa-buysellads' => 'fab fa-buysellads','fa-cab' => 'fas fa-taxi','fa-calendar' => 'fas fa-calendar-alt','fa-calendar-check-o' => 'far fa-calendar-check','fa-calendar-minus-o' => 'far fa-calendar-minus','fa-calendar-o' => 'far fa-calendar','fa-calendar-plus-o' => 'far fa-calendar-plus','fa-calendar-times-o' => 'far fa-calendar-times','fa-caret-square-o-down' => 'far fa-caret-square-down','fa-caret-square-o-left' => 'far fa-caret-square-left','fa-caret-square-o-right' => 'far fa-caret-square-right','fa-caret-square-o-up' => 'far fa-caret-square-up','fa-cc' => 'far fa-closed-captioning','fa-cc-amex' => 'fab fa-cc-amex','fa-cc-diners-club' => 'fab fa-cc-diners-club','fa-cc-discover' => 'fab fa-cc-discover','fa-cc-jcb' => 'fab fa-cc-jcb','fa-cc-mastercard' => 'fab fa-cc-mastercard','fa-cc-paypal' => 'fab fa-cc-paypal','fa-cc-stripe' => 'fab fa-cc-stripe','fa-cc-visa' => 'fab fa-cc-visa','fa-chain' => 'fas fa-link','fa-chain-broken' => 'fas fa-unlink','fa-check-circle-o' => 'far fa-check-circle','fa-check-square-o' => 'far fa-check-square','fa-chrome' => 'fab fa-chrome','fa-circle-o' => 'far fa-circle','fa-circle-o-notch' => 'fas fa-circle-notch','fa-circle-thin' => 'far fa-circle','fa-clipboard' => 'far fa-clipboard','fa-clock-o' => 'far fa-clock','fa-clone' => 'far fa-clone','fa-close' => 'fas fa-times','fa-cloud-download' => 'fas fa-cloud-download-alt','fa-cloud-upload' => 'fas fa-cloud-upload-alt','fa-cny' => 'fas fa-yen-sign','fa-code-fork' => 'fas fa-code-branch','fa-codepen' => 'fab fa-codepen','fa-codiepie' => 'fab fa-codiepie','fa-comment-o' => 'far fa-comment','fa-commenting' => 'far fa-comment-dots','fa-commenting-o' => 'far fa-comment-dots','fa-comments-o' => 'far fa-comments','fa-compass' => 'far fa-compass','fa-connectdevelop' => 'fab fa-connectdevelop','fa-contao' => 'fab fa-contao','fa-copyright' => 'far fa-copyright','fa-creative-commons' => 'fab fa-creative-commons','fa-credit-card' => 'far fa-credit-card','fa-credit-card-alt' => 'fas fa-credit-card','fa-css3' => 'fab fa-css3','fa-cutlery' => 'fas fa-utensils','fa-dashboard' => 'fas fa-tachometer-alt','fa-dashcube' => 'fab fa-dashcube','fa-deafness' => 'fas fa-deaf','fa-dedent' => 'fas fa-outdent','fa-delicious' => 'fab fa-delicious','fa-deviantart' => 'fab fa-deviantart','fa-diamond' => 'far fa-gem','fa-digg' => 'fab fa-digg','fa-dollar' => 'fas fa-dollar-sign','fa-dot-circle-o' => 'far fa-dot-circle','fa-dribbble' => 'fab fa-dribbble','fa-drivers-license' => 'fas fa-id-card','fa-drivers-license-o' => 'far fa-id-card','fa-dropbox' => 'fab fa-dropbox','fa-drupal' => 'fab fa-drupal','fa-edge' => 'fab fa-edge','fa-eercast' => 'fab fa-sellcast','fa-empire' => 'fab fa-empire','fa-envelope-o' => 'far fa-envelope','fa-envelope-open-o' => 'far fa-envelope-open','fa-envira' => 'fab fa-envira','fa-etsy' => 'fab fa-etsy','fa-eur' => 'fas fa-euro-sign','fa-euro' => 'fas fa-euro-sign','fa-exchange' => 'fas fa-exchange-alt','fa-expeditedssl' => 'fab fa-expeditedssl','fa-external-link' => 'fas fa-external-link-alt','fa-external-link-square' => 'fas fa-external-link-square-alt','fa-eye' => 'far fa-eye','fa-eye-slash' => 'far fa-eye-slash','fa-eyedropper' => 'fas fa-eye-dropper','fa-fa' => 'fab fa-font-awesome','fa-facebook' => 'fab fa-facebook-f','fa-facebook-f' => 'fab fa-facebook-f','fa-facebook-official' => 'fab fa-facebook','fa-facebook-square' => 'fab fa-facebook-square','fa-feed' => 'fas fa-rss','fa-file-archive-o' => 'far fa-file-archive','fa-file-audio-o' => 'far fa-file-audio','fa-file-code-o' => 'far fa-file-code','fa-file-excel-o' => 'far fa-file-excel','fa-file-image-o' => 'far fa-file-image','fa-file-movie-o' => 'far fa-file-video','fa-file-o' => 'far fa-file','fa-file-pdf-o' => 'far fa-file-pdf','fa-file-photo-o' => 'far fa-file-image','fa-file-picture-o' => 'far fa-file-image','fa-file-powerpoint-o' => 'far fa-file-powerpoint','fa-file-sound-o' => 'far fa-file-audio','fa-file-text' => 'fas fa-file-alt','fa-file-text-o' => 'far fa-file-alt','fa-file-video-o' => 'far fa-file-video','fa-file-word-o' => 'far fa-file-word','fa-file-zip-o' => 'far fa-file-archive','fa-files-o' => 'far fa-copy','fa-firefox' => 'fab fa-firefox','fa-first-order' => 'fab fa-first-order','fa-flag-o' => 'far fa-flag','fa-flash' => 'fas fa-bolt','fa-flickr' => 'fab fa-flickr','fa-floppy-o' => 'far fa-save','fa-folder-o' => 'far fa-folder','fa-folder-open-o' => 'far fa-folder-open','fa-font-awesome' => 'fab fa-font-awesome','fa-fonticons' => 'fab fa-fonticons','fa-fort-awesome' => 'fab fa-fort-awesome','fa-forumbee' => 'fab fa-forumbee','fa-foursquare' => 'fab fa-foursquare','fa-free-code-camp' => 'fab fa-free-code-camp','fa-frown-o' => 'far fa-frown','fa-futbol-o' => 'far fa-futbol','fa-gbp' => 'fas fa-pound-sign','fa-ge' => 'fab fa-empire','fa-gear' => 'fas fa-cog','fa-gears' => 'fas fa-cogs','fa-get-pocket' => 'fab fa-get-pocket','fa-gg' => 'fab fa-gg','fa-gg-circle' => 'fab fa-gg-circle','fa-git' => 'fab fa-git','fa-git-square' => 'fab fa-git-square','fa-github' => 'fab fa-github','fa-github-alt' => 'fab fa-github-alt','fa-github-square' => 'fab fa-github-square','fa-gitlab' => 'fab fa-gitlab','fa-gittip' => 'fab fa-gratipay','fa-glass' => 'fas fa-glass-martini','fa-glide' => 'fab fa-glide','fa-glide-g' => 'fab fa-glide-g','fa-google' => 'fab fa-google','fa-google-plus' => 'fab fa-google-plus-g','fa-google-plus-circle' => 'fab fa-google-plus','fa-google-plus-official' => 'fab fa-google-plus','fa-google-plus-square' => 'fab fa-google-plus-square','fa-google-wallet' => 'fab fa-google-wallet','fa-gratipay' => 'fab fa-gratipay','fa-grav' => 'fab fa-grav','fa-group' => 'fas fa-users','fa-hacker-news' => 'fab fa-hacker-news','fa-hand-grab-o' => 'far fa-hand-rock','fa-hand-lizard-o' => 'far fa-hand-lizard','fa-hand-o-down' => 'far fa-hand-point-down','fa-hand-o-left' => 'far fa-hand-point-left','fa-hand-o-right' => 'far fa-hand-point-right','fa-hand-o-up' => 'far fa-hand-point-up','fa-hand-paper-o' => 'far fa-hand-paper','fa-hand-peace-o' => 'far fa-hand-peace','fa-hand-pointer-o' => 'far fa-hand-pointer','fa-hand-rock-o' => 'far fa-hand-rock','fa-hand-scissors-o' => 'far fa-hand-scissors','fa-hand-spock-o' => 'far fa-hand-spock','fa-hand-stop-o' => 'far fa-hand-paper','fa-handshake-o' => 'far fa-handshake','fa-hard-of-hearing' => 'fas fa-deaf','fa-hdd-o' => 'far fa-hdd','fa-header' => 'fas fa-heading','fa-heart-o' => 'far fa-heart','fa-hospital-o' => 'far fa-hospital','fa-hotel' => 'fas fa-bed','fa-hourglass-1' => 'fas fa-hourglass-start','fa-hourglass-2' => 'fas fa-hourglass-half','fa-hourglass-3' => 'fas fa-hourglass-end','fa-hourglass-o' => 'far fa-hourglass','fa-houzz' => 'fab fa-houzz','fa-html5' => 'fab fa-html5','fa-id-badge' => 'far fa-id-badge','fa-id-card-o' => 'far fa-id-card','fa-ils' => 'fas fa-shekel-sign','fa-image' => 'far fa-image','fa-imdb' => 'fab fa-imdb','fa-inr' => 'fas fa-rupee-sign','fa-instagram' => 'fab fa-instagram','fa-institution' => 'fas fa-university','fa-internet-explorer' => 'fab fa-internet-explorer','fa-intersex' => 'fas fa-transgender','fa-ioxhost' => 'fab fa-ioxhost','fa-joomla' => 'fab fa-joomla','fa-jpy' => 'fas fa-yen-sign','fa-jsfiddle' => 'fab fa-jsfiddle','fa-keyboard-o' => 'far fa-keyboard','fa-krw' => 'fas fa-won-sign','fa-lastfm' => 'fab fa-lastfm','fa-lastfm-square' => 'fab fa-lastfm-square','fa-leanpub' => 'fab fa-leanpub','fa-legal' => 'fas fa-gavel','fa-lemon-o' => 'far fa-lemon','fa-level-down' => 'fas fa-level-down-alt','fa-level-up' => 'fas fa-level-up-alt','fa-life-bouy' => 'far fa-life-ring','fa-life-buoy' => 'far fa-life-ring','fa-life-ring' => 'far fa-life-ring','fa-life-saver' => 'far fa-life-ring','fa-lightbulb-o' => 'far fa-lightbulb','fa-line-chart' => 'fas fa-chart-line','fa-linkedin' => 'fab fa-linkedin-in','fa-linkedin-square' => 'fab fa-linkedin','fa-linode' => 'fab fa-linode','fa-linux' => 'fab fa-linux','fa-list-alt' => 'far fa-list-alt','fa-long-arrow-down' => 'fas fa-long-arrow-alt-down','fa-long-arrow-left' => 'fas fa-long-arrow-alt-left','fa-long-arrow-right' => 'fas fa-long-arrow-alt-right','fa-long-arrow-up' => 'fas fa-long-arrow-alt-up','fa-mail-forward' => 'fas fa-share','fa-mail-reply' => 'fas fa-reply','fa-mail-reply-all' => 'fas fa-reply-all','fa-map-marker' => 'fas fa-map-marker-alt','fa-map-o' => 'far fa-map','fa-maxcdn' => 'fab fa-maxcdn','fa-meanpath' => 'fab fa-font-awesome','fa-medium' => 'fab fa-medium','fa-meetup' => 'fab fa-meetup','fa-meh-o' => 'far fa-meh','fa-minus-square-o' => 'far fa-minus-square','fa-mixcloud' => 'fab fa-mixcloud','fa-mobile' => 'fas fa-mobile-alt','fa-mobile-phone' => 'fas fa-mobile-alt','fa-modx' => 'fab fa-modx','fa-money' => 'far fa-money-bill-alt','fa-moon-o' => 'far fa-moon','fa-mortar-board' => 'fas fa-graduation-cap','fa-navicon' => 'fas fa-bars','fa-newspaper-o' => 'far fa-newspaper','fa-object-group' => 'far fa-object-group','fa-object-ungroup' => 'far fa-object-ungroup','fa-odnoklassniki' => 'fab fa-odnoklassniki','fa-odnoklassniki-square' => 'fab fa-odnoklassniki-square','fa-opencart' => 'fab fa-opencart','fa-openid' => 'fab fa-openid','fa-opera' => 'fab fa-opera','fa-optin-monster' => 'fab fa-optin-monster','fa-pagelines' => 'fab fa-pagelines','fa-paper-plane-o' => 'far fa-paper-plane','fa-paste' => 'far fa-clipboard','fa-pause-circle-o' => 'far fa-pause-circle','fa-paypal' => 'fab fa-paypal','fa-pencil' => 'fas fa-pencil-alt','fa-pencil-square' => 'fas fa-pen-square','fa-pencil-square-o' => 'far fa-edit','fa-photo' => 'far fa-image','fa-picture-o' => 'far fa-image','fa-pie-chart' => 'fas fa-chart-pie','fa-pied-piper' => 'fab fa-pied-piper','fa-pied-piper-alt' => 'fab fa-pied-piper-alt','fa-pied-piper-pp' => 'fab fa-pied-piper-pp','fa-pinterest' => 'fab fa-pinterest','fa-pinterest-p' => 'fab fa-pinterest-p','fa-pinterest-square' => 'fab fa-pinterest-square','fa-play-circle-o' => 'far fa-play-circle','fa-plus-square-o' => 'far fa-plus-square','fa-product-hunt' => 'fab fa-product-hunt','fa-qq' => 'fab fa-qq','fa-question-circle-o' => 'far fa-question-circle','fa-quora' => 'fab fa-quora','fa-ra' => 'fab fa-rebel','fa-ravelry' => 'fab fa-ravelry','fa-rebel' => 'fab fa-rebel','fa-reddit' => 'fab fa-reddit','fa-reddit-alien' => 'fab fa-reddit-alien','fa-reddit-square' => 'fab fa-reddit-square','fa-refresh' => 'fas fa-sync','fa-registered' => 'far fa-registered','fa-remove' => 'fas fa-times','fa-renren' => 'fab fa-renren','fa-reorder' => 'fas fa-bars','fa-repeat' => 'fas fa-redo','fa-resistance' => 'fab fa-rebel','fa-rmb' => 'fas fa-yen-sign','fa-rotate-left' => 'fas fa-undo','fa-rotate-right' => 'fas fa-redo','fa-rouble' => 'fas fa-ruble-sign','fa-rub' => 'fas fa-ruble-sign','fa-ruble' => 'fas fa-ruble-sign','fa-rupee' => 'fas fa-rupee-sign','fa-s15' => 'fas fa-bath','fa-safari' => 'fab fa-safari','fa-scissors' => 'fas fa-cut','fa-scribd' => 'fab fa-scribd','fa-sellsy' => 'fab fa-sellsy','fa-send' => 'fas fa-paper-plane','fa-send-o' => 'far fa-paper-plane','fa-share-square-o' => 'far fa-share-square','fa-shekel' => 'fas fa-shekel-sign','fa-sheqel' => 'fas fa-shekel-sign','fa-shield' => 'fas fa-shield-alt','fa-shirtsinbulk' => 'fab fa-shirtsinbulk','fa-sign-in' => 'fas fa-sign-in-alt','fa-sign-out' => 'fas fa-sign-out-alt','fa-signing' => 'fas fa-sign-language','fa-simplybuilt' => 'fab fa-simplybuilt','fa-skyatlas' => 'fab fa-skyatlas','fa-skype' => 'fab fa-skype','fa-slack' => 'fab fa-slack','fa-sliders' => 'fas fa-sliders-h','fa-slideshare' => 'fab fa-slideshare','fa-smile-o' => 'far fa-smile','fa-snapchat' => 'fab fa-snapchat','fa-snapchat-ghost' => 'fab fa-snapchat-ghost','fa-snapchat-square' => 'fab fa-snapchat-square','fa-snowflake-o' => 'far fa-snowflake','fa-soccer-ball-o' => 'far fa-futbol','fa-sort-alpha-asc' => 'fas fa-sort-alpha-down','fa-sort-alpha-desc' => 'fas fa-sort-alpha-up','fa-sort-amount-asc' => 'fas fa-sort-amount-down','fa-sort-amount-desc' => 'fas fa-sort-amount-up','fa-sort-asc' => 'fas fa-sort-up','fa-sort-desc' => 'fas fa-sort-down','fa-sort-numeric-asc' => 'fas fa-sort-numeric-down','fa-sort-numeric-desc' => 'fas fa-sort-numeric-up','fa-soundcloud' => 'fab fa-soundcloud','fa-spoon' => 'fas fa-utensil-spoon','fa-spotify' => 'fab fa-spotify','fa-square-o' => 'far fa-square','fa-stack-exchange' => 'fab fa-stack-exchange','fa-stack-overflow' => 'fab fa-stack-overflow','fa-star-half-empty' => 'far fa-star-half','fa-star-half-full' => 'far fa-star-half','fa-star-half-o' => 'far fa-star-half','fa-star-o' => 'far fa-star','fa-steam' => 'fab fa-steam','fa-steam-square' => 'fab fa-steam-square','fa-sticky-note-o' => 'far fa-sticky-note','fa-stop-circle-o' => 'far fa-stop-circle','fa-stumbleupon' => 'fab fa-stumbleupon','fa-stumbleupon-circle' => 'fab fa-stumbleupon-circle','fa-sun-o' => 'far fa-sun','fa-superpowers' => 'fab fa-superpowers','fa-support' => 'far fa-life-ring','fa-tablet' => 'fas fa-tablet-alt','fa-tachometer' => 'fas fa-tachometer-alt','fa-telegram' => 'fab fa-telegram','fa-television' => 'fas fa-tv','fa-tencent-weibo' => 'fab fa-tencent-weibo','fa-themeisle' => 'fab fa-themeisle','fa-thermometer' => 'fas fa-thermometer-full','fa-thermometer-0' => 'fas fa-thermometer-empty','fa-thermometer-1' => 'fas fa-thermometer-quarter','fa-thermometer-2' => 'fas fa-thermometer-half','fa-thermometer-3' => 'fas fa-thermometer-three-quarters','fa-thermometer-4' => 'fas fa-thermometer-full','fa-thumb-tack' => 'fas fa-thumbtack','fa-thumbs-o-down' => 'far fa-thumbs-down','fa-thumbs-o-up' => 'far fa-thumbs-up','fa-ticket' => 'fas fa-ticket-alt','fa-times-circle-o' => 'far fa-times-circle','fa-times-rectangle' => 'fas fa-window-close','fa-times-rectangle-o' => 'far fa-window-close','fa-toggle-down' => 'far fa-caret-square-down','fa-toggle-left' => 'far fa-caret-square-left','fa-toggle-right' => 'far fa-caret-square-right','fa-toggle-up' => 'far fa-caret-square-up','fa-trash' => 'fas fa-trash-alt','fa-trash-o' => 'far fa-trash-alt','fa-trello' => 'fab fa-trello','fa-tripadvisor' => 'fab fa-tripadvisor','fa-try' => 'fas fa-lira-sign','fa-tumblr' => 'fab fa-tumblr','fa-tumblr-square' => 'fab fa-tumblr-square','fa-turkish-lira' => 'fas fa-lira-sign','fa-twitch' => 'fab fa-twitch','fa-twitter' => 'fab fa-twitter','fa-twitter-square' => 'fab fa-twitter-square','fa-unsorted' => 'fas fa-sort','fa-usb' => 'fab fa-usb','fa-usd' => 'fas fa-dollar-sign','fa-user-circle-o' => 'far fa-user-circle','fa-user-o' => 'far fa-user','fa-vcard' => 'fas fa-address-card','fa-vcard-o' => 'far fa-address-card','fa-viacoin' => 'fab fa-viacoin','fa-viadeo' => 'fab fa-viadeo','fa-viadeo-square' => 'fab fa-viadeo-square','fa-video-camera' => 'fas fa-video','fa-vimeo' => 'fab fa-vimeo-v','fa-vimeo-square' => 'fab fa-vimeo-square','fa-vine' => 'fab fa-vine','fa-vk' => 'fab fa-vk','fa-volume-control-phone' => 'fas fa-phone-volume','fa-warning' => 'fas fa-exclamation-triangle','fa-wechat' => 'fab fa-weixin','fa-weibo' => 'fab fa-weibo','fa-weixin' => 'fab fa-weixin','fa-whatsapp' => 'fab fa-whatsapp','fa-wheelchair-alt' => 'fab fa-accessible-icon','fa-wikipedia-w' => 'fab fa-wikipedia-w','fa-window-close-o' => 'far fa-window-close','fa-window-maximize' => 'far fa-window-maximize','fa-window-restore' => 'far fa-window-restore','fa-windows' => 'fab fa-windows','fa-won' => 'fas fa-won-sign','fa-wordpress' => 'fab fa-wordpress','fa-wpbeginner' => 'fab fa-wpbeginner','fa-wpexplorer' => 'fab fa-wpexplorer','fa-wpforms' => 'fab fa-wpforms','fa-xing' => 'fab fa-xing','fa-xing-square' => 'fab fa-xing-square','fa-y-combinator' => 'fab fa-y-combinator','fa-y-combinator-square' => 'fab fa-hacker-news','fa-yahoo' => 'fab fa-yahoo','fa-yc' => 'fab fa-y-combinator','fa-yc-square' => 'fab fa-hacker-news','fa-yelp' => 'fab fa-yelp','fa-yen' => 'fas fa-yen-sign','fa-yoast' => 'fab fa-yoast','fa-youtube' => 'fab fa-youtube','fa-youtube-play' => 'fab fa-youtube','fa-youtube-square' => 'fab fa-youtube-square', /*H-code custom font*/ 'fa-facebook' => 'fab fa-facebook-f', 'fa-google-plus' => 'fab fa-google-plus-g', 'fa-linkedin' => 'fab fa-linkedin-in' );
		return $fa_icon_old;
	}
}

/**
 * Force All Page To Under Construction If "enable-under-construction" is enable
 */

if ( ! function_exists( 'hcode_under_construction_theme_option' ) ) :
	function hcode_under_construction_theme_option() {
		$hcode_under_construction = array(
			'id'       => 'enable_under_construction',
			'type'     => 'switch',
			'title'    => esc_html__('Enable Under Construction', 'hcode-addons' ),
			'default'  => false,
			'desc' => esc_html__('Select on to put the site under construction. Only administrator will be able to see frontend site. Please logout to check under construction mode is enabled or not.', 'hcode-addons'),
		);

		return $hcode_under_construction;
	}
endif;

if ( ! function_exists( 'hcode_get_address' ) ) {
	function hcode_get_address() {
		$protocol = hcode_get_protocol();

		// Fallbacks for CLI or missing server context
		$host = isset( $_SERVER['HTTP_HOST'] ) ? $_SERVER['HTTP_HOST'] : 'localhost';
		$uri  = isset( $_SERVER['REQUEST_URI'] ) ? $_SERVER['REQUEST_URI'] : '/';

		return $protocol . '://' . $host . $uri;
	}
}

if ( ! function_exists( 'hcode_get_protocol' ) ) {
	function hcode_get_protocol() {
		$protocol = 'http';

		// Check for HTTPS
		if ( isset( $_SERVER["HTTPS"] ) && strtolower( $_SERVER["HTTPS"] ) == "on" ) {
			$protocol = 'https';
		}

		return $protocol;
	}
}
		
add_action('init', 'hcode_force_under_construction', 1);
if ( ! function_exists( 'hcode_force_under_construction' ) ) {
	function hcode_force_under_construction() {

		$do_redirect = '';
		$userrequest = str_ireplace( home_url('/'), '', hcode_get_address() );
		$userrequest = rtrim( $userrequest,'' );

		if ( hcode_option('enable_under_construction') == 1 && !current_user_can('level_10') && hcode_option('under_construction_page') != '' ) { 

			if ( strpos($userrequest, '/contact-form-7/v1') !== false ) {
				return;
			}
			
			if ( strpos( $userrequest, 'wp-login') !== 0 && strpos($userrequest, 'wp-admin') !== 0 ) {

				if ( get_option('permalink_structure') ) {
					
					$maintenance_page_id  = hcode_option('under_construction_page');
					$maintenance_page_url = get_permalink( $maintenance_page_id );
					$hcode_get_page       = str_ireplace( home_url('/'), '', $maintenance_page_url );
					$hcode_get_page       = rtrim( $hcode_get_page,'' );
					$do_redirect          = '/' . $hcode_get_page;
					// Make sure it gets all the proper decoding and rtrim action
					$userrequest   = str_replace( '*','(.*)',$userrequest );
					$hcode_pattern = '/^' . str_replace( '/', '\/', rtrim( $userrequest, '/' ) ) . '/';
					$do_redirect   = str_replace( '*','$1',$do_redirect );
					$output        = preg_replace( $hcode_pattern, $do_redirect, $userrequest );

					if ( $output !== $userrequest) {
						// pattern matched, perform redirect
						$do_redirect = $output;
					}

				} else {

					$do_redirect = '/?page_id=' . hcode_option('under_construction_page');
				}

			} else {
				// simple comparison redirect
				$do_redirect = $userrequest;
			}
			
			if ($do_redirect !== '' && trim($do_redirect,'/') !== trim($userrequest,'/')) {
				// check if destination needs the domain prepended

				if (strpos($do_redirect,'/') === 0){
					$do_redirect = home_url().$do_redirect;
				}

				header ('Location: ' . $do_redirect);
				exit();
				
			}
		}

	} // end funcion redirect
}

/**
 * To Add Under Construction Notice To Adminbar For All Logged User
 */
if ( ! function_exists( 'hcode_admin_bar_under_construction_notice' ) ) {
	function hcode_admin_bar_under_construction_notice() {
		global $wp_admin_bar;
		
		if( hcode_option( 'enable_under_construction' ) == 1 ) {
			$wp_admin_bar->add_menu( array(
				'id' => 'admin-bar-under-construction-notice',
				'parent' => 'top-secondary',
				'href' => admin_url( 'themes.php?page=hcode_theme_settings' ),
				'title' => '<span style="color: #FF0000;">'.esc_html__( 'Under Construction', 'hcode-addons' ).'</span>'
			) );
		}
	}
}
add_action( 'admin_bar_menu', 'hcode_admin_bar_under_construction_notice' );


// Remove Empty P tag
if( ! function_exists( 'hcode_remove_wpautop' ) ) {
  function hcode_remove_wpautop( $content, $force_br = true ) {
	if ( $force_br ) {
	  $content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
	}
	return do_shortcode( shortcode_unautop( $content ) );
  }
}

if ( ! function_exists( 'hcode_post_meta' ) ) {
	function hcode_post_meta( $option ){
		global $post;
		$value = get_post_meta( $post->ID, $option.'_single', true);
		return $value;
	}
}

/* For Image Caption */
if ( ! function_exists( 'hcode_option_image_caption' ) ) {
	function hcode_option_image_caption( $attach_id ){
		global $hcode_theme_settings, $post;
		$option = 'enable_lightbox_caption';
		if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
			$option_value = $hcode_theme_settings[$option];
			$img_meta = wp_get_attachment_metadata( $attach_id );
			$attachment = get_post( $attach_id );
			$img_info = array(
				'caption' => $attachment->post_excerpt,
			);
			if($option_value == '1'){
				return $img_info;
			}else{
				return;
			}
		}
		return;
	}
}

/* For Lightbox Image Title */
if ( ! function_exists( 'hcode_option_lightbox_image_title' ) ) {
	function hcode_option_lightbox_image_title( $attach_id ){
		global $hcode_theme_settings, $post;
		$option = 'enable_lightbox_title';
		if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
			$option_value = $hcode_theme_settings[$option];
			$img_meta = wp_get_attachment_metadata( $attach_id );
			$attachment = get_post( $attach_id );
			$img_info = array(
				'title' => $attachment->post_title
			);
			if($option_value == '1'){
				return $img_info;
			}else{
				return;
			}
		}
		return;
	}
}

if ( ! function_exists( 'hcode_get_the_excerpt_theme' ) ) {

	function hcode_get_the_excerpt_theme( $length ) {
		return hcode_Excerpt::hcode_get_by_length( $length );
	}
}

if ( ! function_exists( 'hcode_extract_shortcode_contents' ) ) :
	/**
	 * Extract text contents from all shortcodes for usage in excerpts
	 *
	 * @return string The shortcode contents
	 **/
	function hcode_extract_shortcode_contents( $m ) {
		global $shortcode_tags;

		// Setup the array of all registered shortcodes
		$shortcodes = array_keys( $shortcode_tags );
		$no_space_shortcodes = array( 'dropcap' );
		$omitted_shortcodes  = array( 'slide' );

		// Extract contents from all shortcodes recursively
		if ( in_array( $m[2], $shortcodes ) && ! in_array( $m[2], $omitted_shortcodes ) ) {
			$pattern = get_shortcode_regex();
			// Add space the excerpt by shortcode, except for those who should stick together, like dropcap
			$space = ' ' ;
			if ( in_array( $m[2], $no_space_shortcodes ) ) {
				$space = '' ;
			}
			$content = preg_replace_callback( "/$pattern/s", 'hcode_extract_shortcode_contents', rtrim( $m[5] ) . $space );
			return $content;
		}

		// allow [[foo]] syntax for escaping a tag
		if ( $m[1] == '[' && $m[6] == ']' ) {
			return substr( $m[0], 1, -1 );
		}

	   return $m[1] . $m[6];
	}
endif;

if ( ! function_exists( 'hcode_registered_sidebars_array' ) ) :
function hcode_registered_sidebars_array() {
	global $wp_registered_sidebars;
	if( ! empty( $wp_registered_sidebars ) && is_array( $wp_registered_sidebars ) ){ 
		$sidebar_array = array();
		$sidebar_array['default'] = 'Default';
		foreach( $wp_registered_sidebars as $sidebar ){
			$sidebar_array[$sidebar['id']] = $sidebar['name'];
		}
	}
	return $sidebar_array;
}
endif;

if ( ! function_exists( 'hcode_addons_get_header_layout' ) ) :
	function hcode_addons_get_header_layout() {

		return array(  
					'default'     => esc_html__( 'Default', 'hcode-addons' ),
					'headertype1' => esc_html__( 'Light Header', 'hcode-addons' ),
					'headertype2' => esc_html__( 'Dark Header', 'hcode-addons' ),
					'headertype3' => esc_html__( 'Dark Transparent Header', 'hcode-addons' ),
					'headertype4' => esc_html__( 'Light Transparent Header', 'hcode-addons' ),
					'headertype5' => esc_html__( 'Static Sticky Header', 'hcode-addons' ),
					'headertype6' => esc_html__( 'White Sticky Header', 'hcode-addons' ),
					'headertype7' => esc_html__( 'Gray Header', 'hcode-addons' ),
					'headertype8' => esc_html__( 'Non Sticky Header', 'hcode-addons' ),
					'headertype9' => esc_html__( 'Hamburger Header 1', 'hcode-addons' ),
					'headertype10'=> esc_html__( 'Hamburger Header 2', 'hcode-addons' ),
					'headertype11'=> esc_html__( 'Hamburger Header 3', 'hcode-addons' ),
				);
	}
endif;

if( ! function_exists( 'hcode_get_intermediate_image_sizes' ) ) :
	function hcode_get_intermediate_image_sizes() {
		global $wp_version;
		$image_sizes = array( 'full', 'thumbnail', 'medium', 'medium_large', 'large' ); // Standard sizes
		if( $wp_version >= '4.7.0' ){
			$_wp_additional_image_sizes = wp_get_additional_image_sizes();
			if ( ! empty( $_wp_additional_image_sizes ) ) {
				$image_sizes = array_merge( $image_sizes, array_keys( $_wp_additional_image_sizes ) );
			}
			return apply_filters( 'intermediate_image_sizes', $image_sizes );
		} else {
			return $image_sizes;
		}
	}
endif;

if( ! function_exists( 'hcode_get_image_sizes' ) ) :
	function hcode_get_image_sizes() {
		global $_wp_additional_image_sizes;

		$sizes = array();

		foreach ( get_intermediate_image_sizes() as $_size ) {
			if ( in_array( $_size, array('full', 'thumbnail', 'medium', 'medium_large', 'large') ) ) {
				$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
				$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
				$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array(
					'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
					'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
				);
			}
		}
		return $sizes;
	}
endif;

if( ! function_exists( 'hcode_get_image_size' ) ) :
	function hcode_get_image_size( $size ) {
		$sizes = hcode_get_image_sizes();

		if ( isset( $sizes[ $size ] ) ) {
			return $sizes[ $size ];
		}

		return false;
	}
endif;

if( ! function_exists( 'hcode_get_thumbnail_image_sizes' ) ) :
	function hcode_get_thumbnail_image_sizes() {

		$thumbnail_image_sizes = array();

		// Hackily add in the data link parameter.
		$hcode_srcset = hcode_get_intermediate_image_sizes();

		if(!empty($hcode_srcset)) {
			foreach ( $hcode_srcset as $value => $label ){
				
				if( 'full' === $label ) {
					$data = esc_html__( 'Original Full Size', 'hcode-addons' );
				} else {
					$hcode_srcset_image_data = hcode_get_image_size( $label );
					$width = ( $hcode_srcset_image_data['width'] == 0 ) ? esc_html( 'Auto', 'hcode-addons' ) : $hcode_srcset_image_data['width'].'px';
					$height = ( $hcode_srcset_image_data['height'] == 0 ) ? esc_html( 'Auto', 'hcode-addons' ) : $hcode_srcset_image_data['height'].'px';

					$data = ucwords( str_replace( '_', ' ', str_replace( '-', ' ', esc_attr( $label ) ) ) ).' ('.esc_attr( $width ).' X '.esc_attr( $height ).')';
				}

				$thumbnail_image_sizes[$data] = $label;
			}
		}

		return $thumbnail_image_sizes;
	}
endif;

add_action( 'hcode_remove_third_party_script_style', 'hcode_remove_third_party_script_style' );
if( ! function_exists( 'hcode_remove_third_party_script_style' ) ) :
	function hcode_remove_third_party_script_style(){
		global $hcode_theme_settings;       
		if( isset( $hcode_theme_settings['hcode_remove_font_awesome_third_party_style'] ) && $hcode_theme_settings['hcode_remove_font_awesome_third_party_style'] == 1 ){
			// Dequeue Font Awesome Style
			wp_deregister_style( 'font-awesome' );
			wp_dequeue_style( 'font-awesome' );
		}

		$hcode_performance_remove_wp_block_library = ( isset( $hcode_theme_settings['hcode_performance_remove_wp_block_library'] ) ) ? $hcode_theme_settings['hcode_performance_remove_wp_block_library'] : '';
		if( $hcode_performance_remove_wp_block_library == 1 ) {
			wp_deregister_style( 'wp-block-library' );
			wp_dequeue_style( 'wp-block-library' );
		}
	}
endif;


// For Change VC default font awesome icons
if ( ! function_exists( 'hcode_vc_font_awesome_icon' ) ) {
	function hcode_vc_font_awesome_icon( $icons ) {

		$hcode_fontawesome_solid = hcode_fontawesome_solid();
		$hcode_fontawesome_reg = hcode_fontawesome_reg();
		$hcode_fontawesome_brand = hcode_fontawesome_brand();

		$icons = array();

		// Solid Font Awesome Icons
		if ( ! empty( $hcode_fontawesome_solid ) && is_array( $hcode_fontawesome_solid ) ) {
			foreach ( $hcode_fontawesome_solid as $val ) {

				$icons[]['fas '.$val] ='fas '.$val;
			}
		}
		// Regular Font Awesome Icons
		if ( ! empty( $hcode_fontawesome_reg ) && is_array( $hcode_fontawesome_reg ) ) {
			foreach ( $hcode_fontawesome_reg as $val ) {

				$icons[]['far '.$val] ='far '.$val;
			}
		}
		// Brand Font Awesome Icons
		if ( ! empty( $hcode_fontawesome_brand ) && is_array( $hcode_fontawesome_brand ) ) {
			foreach ( $hcode_fontawesome_brand as $val ) {

				$icons[]['fab '.$val] ='fab '.$val;
			}
		}
		return $icons;
	}
}
add_filter( 'vc_iconpicker-type-fontawesome', 'hcode_vc_font_awesome_icon' , 999 );

if ( ! function_exists( 'hcode_override_woocommerce_cart_widget' ) ) {
	function hcode_override_woocommerce_cart_widget() {
		if ( class_exists( 'WC_Widget_Layered_Nav' ) ) {
			if ( class_exists( 'WC_Widget_Cart' ) ) {
				if ( file_exists( WP_PLUGIN_DIR.'/hcode-addons/widgets/templates/hcode-widget-cart.php') ) {
					unregister_widget( 'WC_Widget_Cart' );
					require_once( HCODE_ADDONS_ROOT.'/widgets/templates/hcode-widget-cart.php' );
					register_widget( 'Hcode_Widget_Cart' );
				}
			}
			if ( file_exists( WP_PLUGIN_DIR.'/hcode-addons/widgets/templates/hcode-widget-color-attribute.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/widgets/templates/hcode-widget-color-attribute.php' );
				register_widget( 'Hcode_Widget_Color_Attribute' );
			}
		}
	  
	}
}
add_action( 'widgets_init', 'hcode_override_woocommerce_cart_widget', 15 );

/* Performance Settings */

if( ! function_exists( 'disable_emojis_tinymce' ) ) {
	function disable_emojis_tinymce( $plugins ) {
		if ( is_array( $plugins ) ) {
			return array_diff( $plugins, array( 'wpemoji' ) );
		} else {
			return array();
		}
	}
}

add_action( 'init', 'hcode_addons_performance_callback' );

if( ! function_exists( 'hcode_addons_performance_callback' ) ) {
	function hcode_addons_performance_callback(){
		global $hcode_theme_settings;
		
		$hcode_performance_remove_emojis = ( isset( $hcode_theme_settings['hcode_performance_remove_emojis'] ) ) ? $hcode_theme_settings['hcode_performance_remove_emojis'] : '';
		if( $hcode_performance_remove_emojis == 1 ) {
			remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
			remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
			remove_action( 'wp_print_styles', 'print_emoji_styles' );
			remove_action( 'admin_print_styles', 'print_emoji_styles' ); 
			remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
			remove_filter( 'comment_text_rss', 'wp_staticize_emoji' ); 
			remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
			add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
		}

		$hcode_performance_remove_emojis = ( isset( $hcode_theme_settings['hcode_performance_remove_query_string'] ) ) ? $hcode_theme_settings['hcode_performance_remove_query_string'] : '';
		if( !is_admin() && $hcode_performance_remove_emojis == 1 ) {
			add_filter( 'script_loader_src', 'hcode_remove_query_strings_split', 15 );
			add_filter( 'style_loader_src', 'hcode_remove_query_strings_split', 15 );
		}

	}
}

if( ! function_exists( 'hcode_remove_query_strings_split' ) ) {
	function hcode_remove_query_strings_split( $src ){
	   $output = preg_split("/(&ver|\?ver)/", $src);
	   return $output[0];
	}
}

add_action( 'wp_footer', 'hcode_disable_embed_script' );
if( ! function_exists( 'hcode_disable_embed_script' ) ) {
	function hcode_disable_embed_script(){
		global $hcode_theme_settings;

		$hcode_performance_remove_embeds_script = ( isset( $hcode_theme_settings['hcode_performance_remove_embeds_script'] ) ) ? $hcode_theme_settings['hcode_performance_remove_embeds_script'] : '';
		if( $hcode_performance_remove_embeds_script == 1 ) {
			wp_dequeue_script( 'wp-embed' );
		}
	}
}
