<?php
/**
 * Map For Alert Message
 *
 * @package H-Code
 */
?>
<?php
vc_map( 
  array(
    'name' => __('Alert Message', 'hcode-addons'),
    'base' => 'hcode_alert_massage',
    'category' => 'H-Code',
    'description' => __( 'Create an alert message', 'hcode-addons' ),
    'icon' => 'fa-solid fa-exclamation-triangle h-code-shortcode-icon', //URL or CSS class with icon image.
    'params' => array(
    array(
      'type' => 'dropdown',
        'admin_label' => true,
        'class' => '',
        'heading' => __('Alert Message Style', 'hcode-addons'),
        'param_name' => 'hcode_alert_massage_premade_style',
        'value' => array(__('Select Alert Message Style', 'hcode-addons') => '',
                 __('Select Alert Style1', 'hcode-addons') => 'alert-massage-style-1',
                         __('Select Alert Style2', 'hcode-addons') => 'alert-massage-style-2',
                         __('Select Alert Style3', 'hcode-addons') => 'alert-massage-style-3',
                         __('Select Alert Style4', 'hcode-addons') => 'alert-massage-style-4',
                         __('Select Alert Style5', 'hcode-addons') => 'alert-massage-style-5',
                         __('Select Alert Style6', 'hcode-addons') => 'alert-massage-style-6',
                         __('Select Alert Style7', 'hcode-addons') => 'alert-massage-style-7',
                         __('Select Alert Style8', 'hcode-addons') => 'alert-massage-style-8',
                      ),
    ),
    array(
          'type' => 'hcode_preview_image',
          'heading' => __('Style for tab', 'hcode-addons'),
          'param_name' => 'alert_massage_preview_image',
    ),
    array(
        'type' => 'dropdown',
        'heading' => __('Alert Message Type', 'hcode-addons'),
        'param_name' => 'hcode_alert_massage_type',
        'admin_label' => true,
        'value' => array(__('Select Alert Message Type', 'hcode-addons') => '',
                         __('Success Message', 'hcode-addons') => 'success',
                         __('Info Message', 'hcode-addons') => 'info',
                         __('Warning Message', 'hcode-addons') => 'warning',
                         __('Danger Message', 'hcode-addons') => 'danger',
                        ),
      'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Custom Icon', 'hcode-addons'),
      'param_name' => 'custom_icon',
      'value' => array(__('NO', 'hcode-addons') => '0',
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3')),
    ),
    array(
      'type' => 'attach_image',
      'heading' => __('Custom Icon Image', 'hcode-addons'),
      'param_name' => 'custom_icon_image',
      'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
      'description' => __( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'hcode-addons' ),
    ),
    array(
      'type' => 'hcode_icon',
        'heading' => __('Select Icon', 'hcode-addons'),
        'param_name' => 'hcode_message_icon',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
    ),
    array(
        'type' => 'textfield',
        'heading' => __('Title (Highlighted in bold)', 'hcode-addons'),
        'param_name' => 'hcode_highliget_title',
        'admin_label' => true,
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
    ),
    array(
        'type' => 'textarea',
        'heading' => __('Subtitle', 'hcode-addons'),
        'param_name' => 'hcode_subtitle',
        'admin_label' => true,
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
    ),
    array(
          'type' => 'hcode_custom_switch_option',
          'class' => '',
          'heading' => __('Show Close Button', 'hcode-addons'),
          'param_name' => 'show_close_button',
          'value' => array(__('NO', 'hcode-addons') => '0', 
                             __('YES', 'hcode-addons') => '1'
                            ),
          'description' => __( 'Select YES to show close button in Message', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Title Color', 'hcode-addons' ),
        'param_name' => 'hcode_title_color',
        'description' => __( 'Choose Title Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Color Settings',
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Subtitle Color', 'hcode-addons' ),
        'param_name' => 'hcode_subtitle_color',
        'description' => __( 'Choose SubTitle Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Color Settings',
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Icon Color', 'hcode-addons' ),
        'param_name' => 'hcode_icon_color',
        'description' => __( 'Choose Icon Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3')),
        'group' => 'Color Settings',
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Border Color', 'hcode-addons' ),
        'param_name' => 'hcode_border_color',
        'description' => __( 'Choose Border Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Color Settings',
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Background Color', 'hcode-addons' ),
        'param_name' => 'hcode_bg_color',
        'description' => __( 'Choose Background Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Color Settings',
    ),
    array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Close Button Color', 'hcode-addons' ),
        'param_name' => 'hcode_close_button_color',
        'description' => __( 'Choose button Color', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'show_close_button', 'value' => array('1')),
        'group' => 'Color Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('text-align'),
        'hide_font_settings_element_md' => array('text-align'),
        'hide_font_settings_element_sm' => array('text-align'),
        'hide_font_settings_element_xs' => array('text-align'),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Font Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_font_subtitle',
        'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('text-align'),
        'hide_font_settings_element_md' => array('text-align'),
        'hide_font_settings_element_sm' => array('text-align'),
        'hide_font_settings_element_xs' => array('text-align'),
        'dependency'  => array( 'element' => 'hcode_alert_massage_premade_style', 'value' => array('alert-massage-style-1','alert-massage-style-2','alert-massage-style-3','alert-massage-style-4','alert-massage-style-5','alert-massage-style-6','alert-massage-style-7','alert-massage-style-8')),
        'group' => 'Font Settings',
    ),
    array(
        'type' => 'hcode_custom_srcset',
        'param_name' => 'hcode_icon_image_srcset',
        'heading' => __('Icon Image SRCSET', 'hcode-addons' ),
        'value' => 'full',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'group' => 'SRCSET',
    ),
    $hcode_vc_extra_id,
    $hcode_vc_extra_class,
    ),
  ) 
);