<?php
/**
 * Map For Button
 *
 * @package H-Code
 */

vc_map( array(
  'icon' => 'h-code-shortcode-icon fa-solid fa-stop',
  'name' => __('Button', 'hcode-addons'),
  'description' => __( 'Add an awesome button', 'hcode-addons' ),  
  'base' => 'hcode_button',
  'category' => 'H-Code',
  'content_element' => true,
  'params' => array(
      array(
        'type' => 'dropdown',
        'admin_label' => true,
        'heading' => __('Button Style', 'hcode-addons'),
        'param_name' => 'button_style',
        'value' => array(__('Select Button Style', 'hcode-addons') => '',
                  __('Style 1', 'hcode-addons') => 'style1',
                  __('Style 2', 'hcode-addons') => 'style2',
                  __('Style 3', 'hcode-addons') => 'style3',
                  __('Style 4', 'hcode-addons') => 'style4',
                  __('Style 5', 'hcode-addons') => 'style5',
                  __('Style 6', 'hcode-addons') => 'style6',
                  __('Style 7', 'hcode-addons') => 'style7',
                  __('Style 8', 'hcode-addons') => 'style8',
                  __('Style 9', 'hcode-addons') => 'style9',
                  __('Style 10', 'hcode-addons') => 'style10',
                  __('Style 11', 'hcode-addons') => 'style11',
                  __('Style 12', 'hcode-addons') => 'style12',
                  __('Style 13', 'hcode-addons') => 'style13',
                  __('Style 14', 'hcode-addons') => 'style14',
                  __('Style 15', 'hcode-addons') => 'style15',
                  __('Style 16', 'hcode-addons') => 'style16',
                  __('Style 17', 'hcode-addons') => 'style17',
                  __('Style 18', 'hcode-addons') => 'style18',
                  __('Style 19', 'hcode-addons') => 'style19',
                  __('Style 20', 'hcode-addons') => 'style20',
                  __('Style 21', 'hcode-addons') => 'style21',
                  __('Style 22', 'hcode-addons') => 'style22',
                  __('Style 23', 'hcode-addons') => 'style23',
                  __('Style 24', 'hcode-addons') => 'style24',
                  __('Style 25', 'hcode-addons') => 'style25',
        ),
      ),  
      array(
          'type' => 'hcode_preview_image',
          'heading' => __('Select pre-made style', 'hcode-addons'),
          'param_name' => 'hcode_button_preview_image',
          'value' => array(__('Please select style', 'hcode-addons') => '',
                            __('Style 1', 'hcode-addons') => 'style1',
                            __('Style 2', 'hcode-addons') => 'style2',
                            __('Style 3', 'hcode-addons') => 'style3',
                            __('Style 4', 'hcode-addons') => 'style4',
                            __('Style 5', 'hcode-addons') => 'style5',
                            __('Style 6', 'hcode-addons') => 'style6',
                            __('Style 7', 'hcode-addons') => 'style7',
                            __('Style 8', 'hcode-addons') => 'style8',
                            __('Style 9', 'hcode-addons') => 'style9',
                            __('Style 10', 'hcode-addons') => 'style10',
                            __('Style 11', 'hcode-addons') => 'style11',
                            __('Style 12', 'hcode-addons') => 'style12',
                            __('Style 13', 'hcode-addons') => 'style13',
                            __('Style 14', 'hcode-addons') => 'style14',
                            __('Style 15', 'hcode-addons') => 'style15',
                            __('Style 16', 'hcode-addons') => 'style16',
                            __('Style 17', 'hcode-addons') => 'style17',
                            __('Style 18', 'hcode-addons') => 'style18',
                            __('Style 19', 'hcode-addons') => 'style19',
                            __('Style 20', 'hcode-addons') => 'style20',
                            __('Style 21', 'hcode-addons') => 'style21',
                            __('Style 22', 'hcode-addons') => 'style22',
                            __('Style 23', 'hcode-addons') => 'style23',
                            __('Style 24', 'hcode-addons') => 'style24',
                            __('Style 25', 'hcode-addons') => 'style25',
                          ),
      ),
      array(
          'type' => 'dropdown',
          'heading' => __('Button Size', 'hcode-addons'),
          'param_name' => 'button_type',
          'value' => array(__('Select Button Size', 'hcode-addons') => '',
                    __('Large', 'hcode-addons') => 'large',
                    __('Medium', 'hcode-addons') => 'medium',
                    __('Small', 'hcode-addons') => 'small',
                    __('Very Small', 'hcode-addons') => 'vsmall',
        ),
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style21','style24','style25') ),
      ),
      array(
          'type' => 'dropdown',
          'heading' => __('Button Version Type', 'hcode-addons'),
          'param_name' => 'button_version_type',
          'value' => array(__('Select Button Version Type', 'hcode-addons') => '',
                    __('Primary', 'hcode-addons') => 'primary',
                    __('Success', 'hcode-addons') => 'success',
                    __('Info', 'hcode-addons') => 'info',
                    __('Warning', 'hcode-addons') => 'warning',
                    __('Danger', 'hcode-addons') => 'danger',
        ),
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style21','style24','style25') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'class' => '',
          'heading' => __('Add Extra Large Class', 'hcode-addons'),
          'param_name' => 'extra_large',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style19','style20','style21','style22','style23','style24','style25') ),
          'description' => __( 'Select yes to add extra large class', 'hcode-addons' ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Custom Icon', 'hcode-addons'),
        'param_name' => 'custom_icon',
        'value' => array(__('NO', 'hcode-addons') => '0',
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'button_style', 'value' => array('style16','style17','style18','style19','style20','style22','style23') ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => __('Custom Icon Image', 'hcode-addons'),
        'param_name' => 'custom_icon_image',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => __( 'Recommended size: Large - 26px X 26px, Medium - 22px X 22px, Small - 18px X 18px, Extra Small - 16px X 16px', 'hcode-addons' ),
      ),
      array(
        'type' => 'hcode_icon',
        'heading' => __('Select Icon Type', 'hcode-addons'),
        'param_name' => 'button_icon',
        'admin_label' => true,
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Button Sub Text', 'hcode-addons'),
          'param_name' => 'button_sub_text',
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style24') ),
      ),
      array(
          'type'        => 'vc_link',
          'heading'     => __('Button Config', 'hcode-addons' ),
          'param_name'  => 'button_text',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style19','style20','style21','style22','style23','style24','style25') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'class' => '',
          'heading' => __('Required Padding Setting?', 'hcode-addons'),
          'param_name' => 'padding_setting',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style19','style20','style21','style22','style23','style24','style25') ),
          'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_padding',
        'param_name' => 'desktop_padding',
        'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_padding',
        'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),

        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_padding',
        'param_name' => 'ipad_padding',
        'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_padding',
        'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_padding',
        'param_name' => 'mobile_padding',
        'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_padding',
        'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'class' => '',
        'heading' => __('Required Margin Setting?', 'hcode-addons'),
        'param_name' => 'margin_setting',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style19','style20','style21','style22','style23','style24','style25') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_margin',
        'param_name' => 'desktop_margin',
        'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_margin',
        'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_margin',
        'param_name' => 'ipad_margin',
        'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_margin',
        'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_margin',
        'param_name' => 'mobile_margin',
        'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_margin',
        'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type'        => 'hcode_button_settings',
        'param_name'  => 'button_settings',
        'heading'     => esc_html__( 'Button Color Settings', 'hcode-addons' ),
        'group' => 'Button Configuration',
        'dependency' => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style19','style20','style21','style24','style25') ),
        'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices', 'hcode-addons' ),
        'hide_font_settings_element' => array( 'text-align','icon-color','icon-hover-color'),
      ),
      array(
        'type'        => 'hcode_button_settings',
        'param_name'  => 'button_settings_icon',
        'heading'     => esc_html__( 'Button Font Settings', 'hcode-addons' ),
        'group' => 'Button Configuration',
        'dependency' => array( 'element' => 'button_style', 'value' => array('style16','style17','style18') ),
        'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices', 'hcode-addons' ),
        'hide_font_settings_element' => array( 'text-align' ),
      ),
      array(
          'type' => 'hcode_animation_style',
          'param_name' => 'hcode_column_animation_style',
          'heading' => __('Animation Style', 'hcode-addons' ),
          'value' => '',
          'dependency'  => array( 'element' => 'button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style11','style12','style13','style14','style15','style16','style17','style18','style19','style20','style21','style22','style23','style24','style25') ),
          'group' => 'Animation',
      ),
      array(
          'type' => 'hcode_custom_srcset',
          'param_name' => 'hcode_icon_image_srcset',
          'heading' => __('Icon Image SRCSET', 'hcode-addons' ),
          'value' => 'full',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
          'group' => 'SRCSET',
      ),

      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
  )
) );