<?php
/**
 * Map For Row
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Row */
/*-----------------------------------------------------------------------------------*/

vc_map( 
  array(
      'name' => __( 'Row' , 'hcode-addons' ),
      'base' => 'vc_row',
      'description' => __( 'Place content elements inside the section','hcode-addons' ),
      'icon' => 'fa-solid fa-th h-code-shortcode-icon',
      'is_container' => true,
      'js_view' => 'VcRowView',
      'category' => 'H-Code',
      'params' => array(
          array(
            'type' => 'checkbox',
            'heading' => __( 'Equal height', 'hcode-addons' ),
            'param_name' => 'equal_height',
            'description' => __( 'If checked columns will be set to equal height.', 'hcode-addons' ),
            'value' => array( __( 'Yes', 'hcode-addons' ) => 'yes' )
          ),
          array(
            'type' => 'dropdown',
            'heading' => __( 'Content Position', 'hcode-addons' ),
            'param_name' => 'content_placement',
            'value' => array(
              __( 'Middle', 'hcode-addons' ) => 'middle',
              __( 'Top', 'hcode-addons' ) => 'top',
              __( 'Bottom', 'hcode-addons' ) => 'bottom',
            ),
            'std' => 'middle',
            'description' => __( 'Select content position within columns.', 'hcode-addons' ),
            'dependency' => array( 'element' => 'equal_height', 'value' => array('yes') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_style',
            'heading' => __( 'Please Select Row Style','hcode-addons' ),
            'value' => array(__('Please Select Row Style', 'hcode-addons') => '',
                             __('Color', 'hcode-addons') => 'color',
                             __('Image', 'hcode-addons') => 'image',
                            ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Background Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_bg_color',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('color') ),
          ),
          array(
            'type' => 'attach_image',
            'heading' => __( 'Background Image', 'hcode-addons' ),
            'param_name' => 'hcode_row_bg_image',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_image_type',
            'heading' => __( 'Background Image Type', 'hcode-addons' ),
            'value' => array(__('Select Background Image Type', 'hcode-addons') => '',
                             __('Parallax', 'hcode-addons') => 'parallax',
                             __('Background Image', 'hcode-addons') => 'background-image',
                            ),
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_bg_image_type', 
            'heading' => __( 'Background Image Type', 'hcode-addons' ),
            'value' => array(__('Select Background Image Type', 'hcode-addons') => '',
                             __('Fix Background', 'hcode-addons') => 'fix-background',
                             __('Cover Background', 'hcode-addons') => 'cover-background',
                             __('Fill Background', 'hcode-addons') => 'fill',
                            ),
            'dependency' => array( 'element' => 'hcode_row_image_type', 'value' => array('background-image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_parallax_image_type',
            'heading' => __('Parallax Type', 'hcode-addons' ),
            'value' => array(__('no parallax', 'hcode-addons') => '',
                             __('Parallax1', 'hcode-addons') => 'parallax1',
                             __('Parallax2', 'hcode-addons') => 'parallax2',
                             __('Parallax3', 'hcode-addons') => 'parallax3',
                             __('Parallax4', 'hcode-addons') => 'parallax4',
                             __('Parallax5', 'hcode-addons') => 'parallax5',
                             __('Parallax6', 'hcode-addons') => 'parallax6',
                             __('Parallax7', 'hcode-addons') => 'parallax7',
                             __('Parallax8', 'hcode-addons') => 'parallax8',
                             __('Parallax9', 'hcode-addons') => 'parallax9',
                             __('Parallax10', 'hcode-addons') => 'parallax10',
                             __('Parallax11', 'hcode-addons') => 'parallax11',
                             __('Parallax12', 'hcode-addons') => 'parallax12',
                            ),
            'dependency' => array( 'element' => 'hcode_row_image_type', 'value' => array('parallax') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Set Background Image Position Y to Top In Internet Explorer', 'hcode-addons'),
                'param_name' => 'image_bg_position_in_ie',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'hcode_row_image_type', 'value' => array('parallax') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Set Background Image Position Y to Top In Internet Explorer', 'hcode-addons'),
                'param_name' => 'image_fix_bg_position_in_ie',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'hcode_bg_image_type', 'value' => array('fix-background') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Column Without Row', 'hcode-addons'),
                'param_name' => 'column_without_row',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select ON to show Column without Row', 'hcode-addons' ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('100% Full-width, Without Container', 'hcode-addons'),
                'param_name' => 'show_full_width',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select YES to show fullwidth in row', 'hcode-addons' ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Container Fluid', 'hcode-addons'),
                'param_name' => 'show_container_fluid',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'show_full_width', 'value' => array('0', '') ),
                'description' => __( 'Select YES to show container fluid in row', 'hcode-addons' ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'edit_field_class' => 'vc_col-sm-6',
                'heading' => __('Fullscreen Class', 'hcode-addons'),
                'param_name' => 'fullscreen',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select YES to add (fullscreen) class in section', 'hcode-addons' ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'edit_field_class' => 'vc_col-sm-6',
                'heading' => __('Auto Height in Mobile', 'hcode-addons'),
                'param_name' => 'fullscreen_auto',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select YES to set auto height in section', 'hcode-addons' ),
                'dependency' => array( 'element' => 'fullscreen', 'value' => array('1') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __( 'Disable row', 'hcode-addons' ),
                'param_name' => 'disable_element', // Inner param name.
                'value' => array(__('NO', 'hcode-addons') => '', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'If selected YES the row won\'t be visible on the public side of your website. You can switch it back any time.', 'hcode-addons' ),
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('Position Relative', 'hcode-addons'),
              'param_name' => 'position_relative',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('Overflow Hidden', 'hcode-addons'),
              'param_name' => 'overflow_hidden',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('No Transition', 'hcode-addons'),
              'param_name' => 'no_transition',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Overlay Div', 'hcode-addons'),
                'param_name' => 'show_overlay',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
                'description' => __( 'Select ON to show overlay in row', 'hcode-addons' ),
                'group' => 'Opacity',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Hide Background For Mobile Device', 'hcode-addons'),
                'param_name' => 'hide_background',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select Yes to hide background in mobile device', 'hcode-addons' ),
                'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
                'group' => 'Hide Background',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_overlay_opacity',
            'heading' => __('Overlay Opacity', 'hcode-addons'),
            'value' => array(__('no opacity', 'hcode-addons') => '',
                             '0.1' => '0.1',
                             '0.2' => '0.2',
                             '0.3' => '0.3',
                             '0.4' => '0.4',
                             '0.5' => '0.5',
                             '0.6' => '0.6',
                             '0.7' => '0.7',
                             '0.8' => '0.8',
                             '0.9' => '0.9',
                             '1.0' => '1.0',
                            ),
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Overlay Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_overlay_color',
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Z Index', 'hcode-addons'),
            'param_name' => 'hcode_z_index',
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_border_position',
            'heading' => __('Row Border Position', 'hcode-addons' ),
            'value' => array(__('No Border', 'hcode-addons') => '',
                             __('Border Top', 'hcode-addons') => 'border-top',
                             __('Border Bottom', 'hcode-addons') => 'border-bottom',
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Border Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_border_color',
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Border Size', 'hcode-addons' ),
            'param_name' => 'hcode_border_size',
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'description' => __( 'Define border size like 2px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_border_type',
            'heading' => __( 'Border Type', 'hcode-addons' ),
            'value' => array(__('no border', 'hcode-addons') => '',
                             __('Dotted', 'hcode-addons') => 'dotted',
                             __('Dashed', 'hcode-addons') => 'dashed',
                             __('Solid', 'hcode-addons') => 'solid',
                             __('Double', 'hcode-addons') => 'double',
                            ),
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Padding Setting?', 'hcode-addons'),
            'param_name' => 'padding_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_padding',
            'param_name' => 'desktop_padding',
            'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_padding',
            'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_padding',
            'param_name' => 'ipad_padding',
            'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_padding',
            'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_padding',
            'param_name' => 'mobile_padding',
            'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_padding',
            'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Margin Setting?', 'hcode-addons'),
            'param_name' => 'margin_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
              'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_margin',
            'param_name' => 'desktop_margin',
            'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_margin',
            'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_margin',
            'param_name' => 'ipad_margin',
            'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_margin',
            'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_margin',
            'param_name' => 'mobile_margin',
            'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_margin',
            'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Display Settings?', 'hcode-addons'),
            'param_name' => 'display_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_display',
            'heading' => __('Display Setting (For Desktop Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Show', 'hcode-addons') => 'display-block',
                             __('Hide', 'hcode-addons') => 'display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mini_desktop_display',
            'heading' => __('Display Setting (For Mini Desktop Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Show', 'hcode-addons') => 'md-display-block',
                             __('Hide', 'hcode-addons') => 'md-display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_display',
            'heading' => __('Display Setting (For iPad/Tablet Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Show', 'hcode-addons') => 'sm-display-block',
                             __('Hide', 'hcode-addons') => 'sm-display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_display',
            'heading' => __('Display Setting (For Mobile Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Show', 'hcode-addons') => 'xs-display-block',
                             __('Hide', 'hcode-addons') => 'xs-display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height',
            'heading' => __('Min Height ( For Desktop )', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height_ipad',
            'heading' => __('Min Height ( For iPad)', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height_mobile',
            'heading' => __('Min Height ( For Mobile )', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_srcset',
            'param_name' => 'hcode_image_srcset',
            'heading' => __('Image SRCSET', 'hcode-addons' ),
            'value' => 'full',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
            'group' => 'SRCSET',
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('Scroll To Down', 'hcode-addons'),
              'param_name' => 'scroll_to_down',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
              'description' => __( 'Set Scroll To Down in section', 'hcode-addons' ),
              'group' => 'Scroll To Down',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'scroll_to_down_color',
            'heading' => __('Cursor Color', 'hcode-addons' ),
            'value' => array(__('Select Cursor Color', 'hcode-addons') => '',
                             __('Black Cursor', 'hcode-addons') => 'scroll-to-down',
                             __('White Cursor', 'hcode-addons') => 'scroll-to-down-white',
                            ),

            'dependency' => array( 'element' => 'scroll_to_down', 'value' => array('1') ),
            'group' => 'Scroll To Down',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Scroll Id', 'hcode-addons' ),
            'param_name' => 'scroll_to_down_id',
            'dependency' => array( 'element' => 'scroll_to_down', 'value' => array('1') ),
            'description' => __( 'Scroll to down section id ex. #about', 'hcode-addons' ),
            'group' => 'Scroll To Down',
          ),
          array(
            'type' => 'hcode_animation_style',
            'param_name' => 'hcode_row_animation_style',
            'heading' => __('Animation Style', 'hcode-addons' ),
            'value' => '',
            'group' => 'Animation',
          ),
          array(
            'type' => 'css_editor',
            'heading' => __( 'Css box', 'hcode-addons' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'hcode-addons' ),
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,
      ),
  )
);