<?php
/**
 * Shortcode For Feature Product
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Featured Product Block */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_featured_products_shortcode' ) ) {
    function hcode_featured_products_shortcode( $atts, $content = null ) {
        if(!class_exists( 'WooCommerce' )){
            return false;
        }
        $atts = shortcode_atts( array(
                'class' =>'',
                'id' => '',
                'recent_product_type' => '',
                'per_page'  => '6',
                'columns'   => '3',
                'orderby'   => 'date',
                'order'     => 'desc',
                'show_pagination' => '',
                'show_pagination_style' => '',
                'show_navigation' => '',
                'show_navigation_style' => '',
                'show_pagination_color_style' => '',
                'show_cursor_color_style' => '',
                'desktop_per_page' => '3',
                'mini_desktop_per_page' => '3',
                'ipad_per_page' => '2',
                'mobile_per_page' => '1',
                'hcode_image_carousel_loop' => '',
                'hcode_image_carousel_autoplay' => '',
                'stoponhover' => '',
                'slidespeed' => '3000',
                'custom_slidespeed' => '',
                'slidedelay' => '700',
                'custom_slidedelay' => '',
                'hcode_product_title_font_settings' => '',
                'hcode_product_price_font_settings' => '',
                'hcode_product_title_color' => '',
                'hcode_product_title_hover_color' => '',
                'hcode_product_price_color' => '',
                'poduct_button_settings' => '',

        ), $atts );

        global $hcode_featured_array, $font_settings_array, $hcode_blog_token;

        $hcode_blog_token       = !empty( $hcode_blog_token ) ? $hcode_blog_token : 0;
        $hcode_blog_token       = $hcode_blog_token + 1;
        $hcode_token_class      = 'hcode-blog-'.$hcode_blog_token;

        $hcode_product_title_font_settings_id = $hcode_product_title_font_settings_id_style = $hcode_product_title_font_settings_id_class = $hcode_product_price_font_settings_id = $hcode_product_price_font_settings_id_style = $hcode_product_price_font_settings_id_class = '';

        $responsive_id='';
        if( !empty( $atts['poduct_button_settings'] ) ) {
            $responsive_style = Hcode_Font_Color_Settings::generate_css( $atts['poduct_button_settings'], $responsive_id.'product-share.'.$hcode_token_class.' a' );
        } 
        (!empty( $responsive_style)) ? $hcode_featured_array[] = $responsive_style : '';
       
        // Product Title settings
        if( !empty( $atts['hcode_product_title_font_settings'] ) ) {
            $hcode_product_title_font_settings_id = uniqid('hcode-font-setting-');
            $hcode_product_title_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_product_title_font_settings'], $hcode_product_title_font_settings_id );
            $hcode_product_title_font_settings_id_class = ' '.$hcode_product_title_font_settings_id;
        }

        // Product Price settings
        if( !empty( $atts['hcode_product_price_font_settings'] ) ) {
            $hcode_product_price_font_settings_id = uniqid('hcode-font-setting-');
            $hcode_product_price_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_product_price_font_settings'], $hcode_product_price_font_settings_id.' .'.$hcode_token_class.' + .price del, .'.$hcode_token_class.' + .price ins, .'.$hcode_token_class.' + .price .amount' );
            $hcode_product_price_font_settings_id_class = ' '.$hcode_product_price_font_settings_id;
        }

        ( !empty( $hcode_product_title_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_product_title_font_settings_id_style : '';
        ( !empty( $hcode_product_price_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_product_price_font_settings_id_style : '';

        $product_title_setting = ( $hcode_product_title_font_settings_id_class ) ? 'class="'.$hcode_product_title_font_settings_id_class.'"' : '';

        // Coloe Settings
        !empty( $atts['hcode_product_title_color'] ) ? $hcode_featured_array[] = '.product-name.'.$hcode_token_class.' a { color: '.$atts['hcode_product_title_color'].' !important}' : '';
        !empty( $atts['hcode_product_title_hover_color'] ) ? $hcode_featured_array[] = '.product-name.'.$hcode_token_class.' a:hover { color: '.$atts['hcode_product_title_hover_color'].' !important}' : '';

        !empty( $atts['hcode_product_price_color'] ) ? $hcode_featured_array[] = '.'.$hcode_token_class.' + .price del, .'.$hcode_token_class.' + .price ins, .'.$hcode_token_class.' + .price .amount { color: '.$atts['hcode_product_price_color'].' !important}' : '';


        $meta_query  = WC()->query->get_meta_query();
        $tax_query   = WC()->query->get_tax_query();
        $tax_query[] = array(
            'taxonomy' => 'product_visibility',
            'field'    => 'name',
            'terms'    => 'featured',
            'operator' => 'IN',
        );

        $query_args = array(
            'post_type'           => 'product',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'posts_per_page'      => $atts['per_page'],
            'orderby'             => $atts['orderby'],
            'order'               => $atts['order'],
            'meta_query'          => $meta_query,
            'tax_query'           => $tax_query,
        );

        global $woocommerce_loop;

        $products                    = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $query_args, $atts ) );
        $columns                     = absint( $atts['columns'] );
        $woocommerce_loop['columns'] = $columns;
        $loop_name                   = 'recent_products';
        $id = ( $atts['id'] ) ? ' id= "'.$atts['id'].'"': '';
        $class = ( $atts['class'] ) ? $atts['class']: '';
        
        ob_start();


        if ( $products->have_posts() ) : ?>

            <?php do_action( "woocommerce_shortcode_before_{$loop_name}_loop" ); ?>

            <?php
                if( 'slider' === $atts['recent_product_type'] ) {
                $pagination = ( $atts['show_pagination'] == 1 ) ? hcode_owl_pagination_slider_classes($atts['show_pagination_style']) : '';
                $pagination_style = ( $atts['show_pagination'] == 1 ) ? hcode_owl_pagination_color_classes($atts['show_pagination_color_style']) : '';
                $navigation = ( $atts['show_navigation'] == 1 ) ? hcode_owl_navigation_slider_classes($atts['show_navigation_style']) : '' ;
                $show_cursor_color_style = ( $atts['show_cursor_color_style'] ) ? ' '.$atts['show_cursor_color_style'] : ' black-cursor';
                ?>
                <div class="owl-carousel owl-prev-next-simple <?php echo $class.$show_cursor_color_style.$pagination.$navigation.$pagination_style ?> hcode-featured-<?php echo $atts['recent_product_type']?> owl-theme" <?php echo $id;?>>
                <?php 
                }
                
                while ( $products->have_posts() ) : $products->the_post();

                    global $product, $woocommerce_loop;

                    // Store loop count we're currently on
                    if ( empty( $woocommerce_loop['loop'] ) ) {
                        $woocommerce_loop['loop'] = 0;
                    }

                    // Store column count for displaying the grid
                    if ( empty( $woocommerce_loop['columns'] ) ) {
                        $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
                    }

                    // Ensure visibility
                    if ( ! $product || ! $product->is_visible() ) {
                        return;
                    }
                        
                    // Increase loop count
                    $woocommerce_loop['loop']++;

                    // Extra post classes
                    $classes = array();
                    if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
                        $classes[] = 'first';
                    }
                    if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
                        $classes[] = 'last';
                    }

                    if( 'slider' === $atts['recent_product_type'] ){
                        $classes[] = 'item';
                    } else {
                        // For Column
                        switch ($woocommerce_loop['columns']) {
                            case '6':
                                $set_column = '2';
                                break;
                            case '4':
                                $set_column = '3';
                                break;
                            case '3':
                                $set_column = '4';
                                break;
                            case '2':
                                $set_column = '6';
                                break;
                            case '1':
                                $set_column = '12';
                                break;
                            default:
                                # code...
                                break;
                        }
                        $classes[] = 'col-md-'.$set_column.' col-sm-'.$set_column;
                    }
                    ?>
                    <div <?php post_class( $classes ); ?>>
                        <div class="home-product text-center position-relative overflow-hidden margin-ten no-margin-top">
                            <div class="product-image-wrapper">
                                <a href="<?php echo get_permalink(); ?>">
                                    <?php
                                        if ( has_post_thumbnail() ) {
                                            the_post_thumbnail( 'shop_catalog' );
                                        } elseif ( wc_placeholder_img_src() ) {
                                            echo wc_placeholder_img( 'shop_catalog' );
                                        }
                                    ?>
                                </a>
                                <?php do_action ( 'hcode_sale_flash' ); ?>
                            </div>
                            <?php
                                echo '<div class="product-content-wrapper'.$hcode_product_price_font_settings_id_class.'">';
                                    echo '<span class="product-name text-uppercase '.$hcode_token_class.'">';
                                        echo '<a '.$product_title_setting.' href="'.get_permalink().'">';
                                            wc_get_template( 'loop/title.php' );
                                        echo '</a>';
                                    echo '</span>';
                                    
                                    do_action( 'woocommerce_after_shop_loop_item_title' );
                                    
                                    echo '<div class="quick-buy">';
                                        echo '<div class="product-share '.$hcode_token_class.'">';
                                            do_action( 'woocommerce_after_shop_loop_item' );
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            ?>
                        </div>
                    </div>
                <?php endwhile; // end of the loop. ?>
                <?php if( 'slider' === $atts['recent_product_type'] ) { ?>
                    </div>
                <?php } ?>

            <?php do_action( "woocommerce_shortcode_after_{$loop_name}_loop" ); ?>

        <?php endif;

        woocommerce_reset_loop();
        wp_reset_postdata();
        if( 'slider' === $atts['recent_product_type'] ) {
            $slider_config = '';
            $slidespeed = ( $atts['slidespeed'] ) ? $atts['slidespeed'] : '3000';

            $custom_slidespeed = ( $atts['custom_slidespeed'] ) ? $atts['custom_slidespeed'] : '';
            if( $slidespeed == 'custom' && $custom_slidespeed && is_numeric( $custom_slidespeed ) ) {
                $slidespeed = $custom_slidespeed;
            }

            if( $slidespeed == 'custom' ) {
                $slidespeed = '3000';
            }

            $slidedelay = ( $atts['slidedelay'] ) ? $atts['slidedelay'] : '700';
            $custom_slidedelay = ( $atts['custom_slidedelay'] ) ? $atts['custom_slidedelay'] : '';
            if( $slidedelay == 'custom' && $custom_slidedelay && is_numeric( $custom_slidedelay ) ) {
                $slidedelay = $custom_slidedelay;
            }

            if( $slidedelay == 'custom' ) {
                $slidedelay = '700';
            }

            ( $atts['show_pagination'] == 1 ) ? $slider_config .= 'dots: true,' : $slider_config .= 'dots: false,';
            ( $atts['hcode_image_carousel_autoplay'] == 1 ) ? $slider_config .= 'autoplay:true, autoplayTimeout: '.$slidespeed.',autoplaySpeed: '.$slidedelay.',' : $slider_config .= 'autoPlay: false,';
            ( $atts['stoponhover'] == 1) ? $slider_config .= 'autoplayHoverPause: true, ' : $slider_config .= 'autoplayHoverPause: false, ';
            ( is_rtl() ) ? $slider_config .= 'rtl: true,' : '';
            ( $atts['hcode_image_carousel_loop'] == 1) ? $slider_config .= 'loop: true, ' : $slider_config .= 'loop: false, ';
            ( $atts['desktop_per_page'] || $atts['ipad_per_page'] || $atts['mobile_per_page'] || $atts['mini_desktop_per_page'] ) ? $slider_config .= "responsive:{ " : '';
            ( $atts['mobile_per_page'] ) ? $slider_config .= '0:{ items: '.$atts['mobile_per_page'].'},' : $slider_config .= '0:{ items: 1 },';
            ( $atts['ipad_per_page'] ) ? $slider_config .= '700:{ items: '.$atts['ipad_per_page'].' },' : $slider_config .= '700:{ items: 2 },';
            ( $atts['mini_desktop_per_page'] ) ? $slider_config .= '991:{ items: '.$atts['mini_desktop_per_page'].'},' : $slider_config .= '991:{ items: 3 },';
            ( $atts['desktop_per_page'] ) ? $slider_config .= '1200:{ items: '.$atts['desktop_per_page'].' },' : $slider_config .= '1200:{ items: 3 },';
            ( $atts['desktop_per_page'] || $atts['ipad_per_page'] || $atts['mobile_per_page'] ) ? $slider_config .= "}," : '';
            $slider_config .= 'navText: ["<i class=\'fa-solid fa-angle-left\'></i>", "<i class=\'fa-solid fa-angle-right\'></i>"]';
        ?>
        <script type="text/javascript">jQuery(document).ready(function(){ jQuery(".hcode-featured-slider").owlCarousel({ nav: true, <?php echo $slider_config; ?> }); });</script>
        <?php
        }
    return ob_get_clean();
    }
}
add_shortcode( 'hcode_featured_products', 'hcode_featured_products_shortcode' );