<?php
/**
 * Metabox Map
 *
 * @package H-Code 
 */
?>
<?php
if ( ! function_exists( 'hcode_meta_box_text' ) ) {
	function hcode_meta_box_text( $id, $label, $desc = '', $short_desc = '',$extra='', $hcode_dependency = '' ) {
		global $post;
		
		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ) {
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach ($hcode_dependency['value'] as $key => $value) {
				$val[] = $value; 
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}
		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo $label;
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				$hcode_meta_box_text_value = get_post_meta( $post->ID, $id, true );
				echo '<input type="text" id="'.$id.'" name="'.$id.'" value="'.$hcode_meta_box_text_value.'" />';
				if( $short_desc ) {
					echo '<span class="short-description">'.$short_desc.'</span>';
				}
				if( !empty( $extra ) && $hcode_meta_box_text_value != '' ) {
					echo '<input name="hcode_hidden_val_'.$extra.'" id="hcode_hidden_val_'.$extra.'" type="hidden" value="1" />';
				}
			echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_dropdown' ) ) {
	function hcode_meta_box_dropdown( $id, $label, $options, $desc = '',$extra='', $hcode_dependency = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ) {
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach ( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value;
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo $label;
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
	            echo '<select id="'.$id.'" class="hcode-meta-box-select" name="'.$id.'">';
	            	$hcode_meta_box_dropdown_value = get_post_meta( $post->ID, $id, true );
					foreach( $options as $key => $option ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $hcode_meta_box_dropdown_value, $key ) ?>><?php echo esc_attr( $option ); ?></option>
						<?php
					}
				echo '</select>';

				if( !empty( $extra ) && $hcode_meta_box_dropdown_value != '' ) {
					echo '<input name="hcode_hidden_val_'.$extra.'" id="hcode_hidden_val_'.$extra.'" type="hidden" value="1" />';
				}

			echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_dropdown_sidebar' ) ) {
	function hcode_meta_box_dropdown_sidebar( $id, $label, $options, $desc = '', $child_hidden = '', $hcode_dependency = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ) {
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value; 
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		$child_hidden = ( $child_hidden ) ? ' hide-child '.$child_hidden : '';
		echo '<div class="'.$id.'_box description_box'.$child_hidden.'"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				echo '<select id="'.$id.'" class="hcode-meta-box-sidebar-select" name="'.$id.'">';
					$hcode_meta_box_dropdown_sidebar_value = get_post_meta( $post->ID, $id, true );
					foreach( $options as $key => $option ) {
						?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $hcode_meta_box_dropdown_sidebar_value, $key ) ?>><?php echo esc_attr( $option ); ?></option>
						<?php
					}
				echo '</select>';
			echo '</div>';	
		echo '</div>';
	}
}

/* menu dropdown */

if ( ! function_exists( 'hcode_meta_box_dropdown_menu' ) ) {
	function hcode_meta_box_dropdown_menu( $id, $label, $options, $desc = '', $hcode_dependency = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ) {
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value;
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				echo '<select id="'.$id.'" class="hcode-meta-box-dropdown-menu" name="'.$id.'">';
					echo '<option value="">'.esc_html__( 'Default', 'hcode-addons' ).'</option>';
					$menus = wp_get_nav_menus();
					$hcode_meta_box_dropdown_menu_value = get_post_meta( $post->ID, $id, true );
					foreach( $menus as $key => $value ) {
						?>
						<option value="<?php echo esc_attr( $value->slug ); ?>" <?php selected( $hcode_meta_box_dropdown_menu_value, $value->slug ) ?>><?php echo esc_attr( $value->name ); ?></option>
						<?php
					}
				echo '</select>';
			echo '</div>';	
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_textarea' ) ) {
	function hcode_meta_box_textarea( $id, $label, $desc = '', $default = '' , $hcode_dependency = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ){
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value;
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				echo '<textarea cols="120" id="'.$id.'" name="'.$id.'">';
					$hcode_meta_box_textarea_value = get_post_meta( $post->ID, $id, true );
					if( $hcode_meta_box_textarea_value ) {
						echo esc_attr( $hcode_meta_box_textarea_value );
					}
				echo '</textarea>';
			echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_upload' ) ) {
	function hcode_meta_box_upload( $id, $label, $desc = '', $hcode_dependency = '', $hcode_image_popup_title = '', $hcode_image_popup_button_title = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ) {
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value; 
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		echo '<div id="'.$id.'_box" class="description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				$hcode_meta_box_upload_value = get_post_meta( $post->ID,  $id, true );
				$hcode_meta_box_upload_id = get_post_meta( $post->ID,  $id.'_id', true );
				echo '<input name="'.$id.'" class="upload_field" id="hcode_upload" type="text" value="'.$hcode_meta_box_upload_value.'" />';
				echo '<input name="'.$id.'_thumb" class="'.$id.'_thumb" id="'.$id.'_thumb" type="hidden" value="'.$hcode_meta_box_upload_value.'" />';
				echo '<input name="'.$id.'_id" class="'.$id.'_id" type="hidden" value="'.$hcode_meta_box_upload_id.'" />';
				echo '<img alt="" class="upload_image_screenshort" src="'.$hcode_meta_box_upload_value.'" />';
				echo '<input data-popup-title="'.esc_attr( $hcode_image_popup_title ).'" data-popup-button-title="'.esc_attr( $hcode_image_popup_button_title ).'" class="hcode_upload_button" id="hcode_upload_button" type="button" value="'.esc_html__( "Browse", "hcode-addons" ).'" />';
				echo '<span class="hcode_remove_button button">'.esc_html__( "Remove", "hcode-addons" ).'</span>';      
			echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_upload_multiple' ) ) {
	function hcode_meta_box_upload_multiple( $id, $label, $desc = '',$extra='', $hcode_dependency = '', $hcode_image_popup_title = '', $hcode_image_popup_button_title = '' ) {
		global $post;

		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty( $hcode_dependency ) ){
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value;
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}
		
		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				$hcode_meta_box_upload_multiple_value = get_post_meta( $post->ID,  $id, true );
				echo '<input name="'.$id.'" class="upload_field" id="hcode_upload" type="hidden" value="'.$hcode_meta_box_upload_multiple_value.'" />';
				echo '<div class="multiple_images">';
					$val = explode( ",", $hcode_meta_box_upload_multiple_value );

					foreach( $val as $key => $value ) {
						if( !empty( $value ) ) {
							$image_url = wp_get_attachment_url( $value );
							echo '<div id='.$value.'>';
								echo '<img alt="" class="upload_image_screenshort_multiple" src="'.$image_url.'" style="width:100px;" />';
								echo '<a href="javascript:void(0)" class="remove">'.esc_html__( "Remove", "hcode-addons" ).'</a>';
							echo '</div>';
						}
					}
		        echo '</div>';
				echo '<input data-popup-title="'.esc_attr( $hcode_image_popup_title ).'" data-popup-button-title="'.esc_attr( $hcode_image_popup_button_title ).'" class="hcode_upload_button_multiple" id="hcode_upload_button_multiple" type="button" value="'.esc_html__( "Browse", "hcode-addons" ).'" />'.esc_html__( "&nbsp;Select Files", "hcode-addons" );
		        if( !empty( $extra ) && $hcode_meta_box_upload_multiple_value != '') {
					echo '<input name="hcode_hidden_val_'.$extra.'" id="hcode_hidden_val_'.$extra.'" type="hidden" value="1" />';
				}
			echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'hcode_meta_box_colorpicker' ) ) {
	function hcode_meta_box_colorpicker( $id, $label, $desc = '', $hcode_dependency = '' ) {
		global $post;
        
		$dependency_attr = '';
		$dependency_arr = array();

		if( !empty($hcode_dependency) ){
			$val = array();
			$dependency_arr[] = 'data-element="'.$hcode_dependency['element'].'"';
			foreach( $hcode_dependency['value'] as $key => $value ) {
				$val[] = $value;
			}
			$dep_list = implode( ",", $val );
			$dependency_arr[] = 'data-value="'.$dep_list.'"';
			$dependency_attr = implode( " ", $dependency_arr );
		}

		echo '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
			echo '<div class="left-part">';
				echo esc_attr( $label );
				if( $desc ) {
					echo '<span class="description">'.$desc.'</span>';
				}
			echo '</div>';
			echo '<div class="right-part">';
				echo '<input type="text" class="hcode-color-picker" id="'.$id.'" name="'.$id.'" value="'.get_post_meta( $post->ID, $id, true ).'" />';
			echo '</div>';
		echo '</div>';
	}
}