<?php
/*
Plugin Name: H-Code Addons
Plugin URI: https://www.themezaa.com
Description: A part of H-Code theme
Version: 3.4
Author: Themezaa Team
Author URI: https://www.themezaa.com
Text Domain: hcode-addons
*/

defined('HCODE_ADDONS_ROOT') or define('HCODE_ADDONS_ROOT', dirname(__FILE__));
defined('HCODE_ADDONS_CUSTOM_POST_TYPE') or define('HCODE_ADDONS_CUSTOM_POST_TYPE', dirname(__FILE__).'/custom-post-type');
defined('HCODE_ADDONS_ROOT_DIR') or define('HCODE_ADDONS_ROOT_DIR', plugins_url().'/hcode-addons');

if( ! class_exists( 'Hcode_Addons_Post_Type' ) ) {
	class Hcode_Addons_Post_Type {
		// Construct
		public function __construct() {
			// Action For Register Custom Post Type "Portfolio".
			add_action( 'init', array( $this, 'hcode_addons_register_custom_post_type' ) );

			/* Plugin update notice */
			add_action( 'init', array( $this, 'hcode_addons_update_plugin_notice' ) );

			if ( file_exists( HCODE_ADDONS_ROOT.'/meta-box/meta-box.php' ) ) {
				require_once HCODE_ADDONS_ROOT.'/meta-box/meta-box.php';
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/hcode-shortcodes/hcode-shortcode-addons.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/hcode-shortcodes/hcode-shortcode-addons.php' );
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/hcode-shortcodes/hcode-addons-extra-functions.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/hcode-shortcodes/hcode-addons-extra-functions.php' );
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/widgets/hcode-latest-portfolio.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/widgets/hcode-latest-portfolio.php' );
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/widgets/hcode-portfolio-categories.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/widgets/hcode-portfolio-categories.php' );
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/widgets/hcode-custom-menu-widget.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/widgets/hcode-custom-menu-widget.php' );
			}

			if ( file_exists( HCODE_ADDONS_ROOT.'/widgets/hcode-recent-post-widget.php' ) ) {
				require_once( HCODE_ADDONS_ROOT.'/widgets/hcode-recent-post-widget.php' );
			}

			// Plugin Load Action.
			add_action( 'init', array( $this, 'hcode_addons_load_plugin_textdomain' ) );
			add_action( 'plugins_loaded', array( $this, 'hcode_woocommerce_functions' ) );
			add_action( 'wp_head', array( $this, 'hcode_user_agent_compatible' ) );
		}

		public function hcode_addons_update_plugin_notice() {
			require_once( HCODE_ADDONS_ROOT.'/includes/hcode-addons-update-plugin-notice.php' );
			if( ! function_exists( 'get_plugin_data' ) ){
		        require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		    }
			$hcode_addons_plugin_data = get_plugin_data( __FILE__ );
			$hcode_addons_plugin_current_version = $hcode_addons_plugin_data['Version'];
			$hcode_addons_plugin_remote_path = 'http://api.themezaa.com/h-code/update.php';
			$hcode_addons_plugin_slug = plugin_basename( __FILE__ );
			new Hcode_Addons_Update_Plugin_Notice ( $hcode_addons_plugin_current_version, $hcode_addons_plugin_remote_path, $hcode_addons_plugin_slug );
		}

		public function hcode_user_agent_compatible() { 
			if( isset( $_SERVER['HTTP_USER_AGENT'] ) && ( strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE' ) !== false ) ) {
				echo sprintf( '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />' );
			}
		}

		public function hcode_woocommerce_functions() {
			if ( class_exists( 'WooCommerce' ) ) { 
				$hcode_options = get_option( 'hcode_theme_setting' );
				$hcode_brand_status =  ( isset( $hcode_options['hcode_enable_brand_tax'] ) && $hcode_options['hcode_enable_brand_tax'] != '' ) ? $hcode_options['hcode_enable_brand_tax'] : '1';
				// Action For Detete Taxonomie.
				add_action( "delete_term", array( $this, 'delete_term' ), 5 );
				if( $hcode_brand_status == 1 ){
					// Create Brand Taxonomy
					add_action( 'init', array( $this, 'create_taxonomies' ));
					// Action Add Brand Field.
					add_action( 'product_brand_add_form_fields', array( $this, 'add_brands_fields' ) );
					// Action Edit Brand Field.
					add_action( 'product_brand_edit_form_fields', array( $this, 'edit_brands_fields' ), 10, 2 );
					// Action Save Brand Fields.
					add_action( 'created_term', array( $this, 'save_brands_fields' ), 10, 3 );
					add_action( 'edit_term', array( $this, 'save_brands_fields' ), 10, 3 );
					// Action For Add Brand Column.
					add_filter( 'manage_edit-product_brand_columns', array( $this, 'brands_columns' ) );
					add_filter( 'manage_product_brand_custom_column', array( $this, 'brands_column' ), 10, 3 );
					// Action Add Brand Widget.
					add_action( 'widgets_init', array( $this, 'hcode_brand_widget_include' ) );
					// Action Add Script.
					add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
				}
				// Action For Woocommerce Attribute
				add_action( 'import_start', array( $this, 'hcode_importer_compatibility' ) );
			}
		}

		/* To Register WooCommerce Product Attributes */
		public function hcode_importer_compatibility() {
			global $wpdb;

			$sample_data_xml = HCODE_THEME_IMPORTER . '/sample-data/H-Code.xml';
			$file = $sample_data_xml;
			$parser = new WXR_Parser();
			$import_data = $parser->parse( $file );

			if ( isset( $import_data['posts'] ) && ! empty( $import_data['posts'] ) ) {
				foreach ( $import_data['posts'] as $post ) {
					if ( 'product' === $post['post_type'] && ! empty( $post['terms'] ) ) {
						foreach ( $post['terms'] as $term ) {
							if ( strstr( $term['domain'], 'pa_' ) ) {
								if ( ! taxonomy_exists( $term['domain'] ) ) {
									$attribute_name = wc_sanitize_taxonomy_name( str_replace( 'pa_', '', $term['domain'] ) );

									// Create the taxonomy
									if ( ! in_array( $attribute_name, wc_get_attribute_taxonomies() ) ) {
										wc_create_attribute( array(
											'name'         => $attribute_name,
											'slug'         => $attribute_name,
											'type'         => 'select',
											'order_by'     => 'menu_order',
											'has_archives' => false,
										) );
									}

									// Register the taxonomy now so that the import works!
									register_taxonomy(
										$term['domain'],
										apply_filters( 'woocommerce_taxonomy_objects_' . $term['domain'], array( 'product' ) ),
										apply_filters( 'woocommerce_taxonomy_args_' . $term['domain'], array(
											'hierarchical' => true,
											'show_ui'      => false,
											'query_var'    => true,
											'rewrite'      => false,
										) )
									);
								}
							}
						}
					}
				}
			}
		}

		/* Load plugin textdomain. */
		public function hcode_addons_load_plugin_textdomain() {
		  load_plugin_textdomain( 'hcode-addons', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' ); 
		}

		/**
		* Load custom post types
		*/
		public function hcode_addons_register_custom_post_type() {
			require_once( HCODE_ADDONS_CUSTOM_POST_TYPE .'/hcode-theme-portfolio.php'); 
		}

		// create two taxonomies, genres and writers for the post type "product"
		public function create_taxonomies() {

			// Add new taxonomy, make it hierarchical (like categories)
			$shop_page_id = wc_get_page_id( 'shop' );
			$base_slug = $shop_page_id > 0 && get_page( $shop_page_id ) ? get_page_uri( $shop_page_id ) : 'shop';
			$category_base = get_option('woocommerce_prepend_shop_page_to_urls') == "yes" ? trailingslashit( $base_slug ) : '';
			$cap = version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) ? 'manage_woocommerce_products' : 'edit_products';		
			$labels = array(
				'name'              => __( 'Brands', 'hcode-addons' ),
				'singular_name'     => __( 'Brands', 'hcode-addons' ),
				'search_items'      => __( 'Search Brand', 'hcode-addons' ),
				'all_items'         => __( 'All Brands', 'hcode-addons' ),
				'parent_item'       => __( 'Parent Brands', 'hcode-addons'),
				'parent_item_colon' => __( 'Parent Brands:', 'hcode-addons' ),
				'edit_item'         => __( 'Edit Brands', 'hcode-addons'),
				'update_item'       => __( 'Update Brands', 'hcode-addons'),
				'add_new_item'      => __( 'Add New Brands', 'hcode-addons'),
				'new_item_name'     => __( 'New Brands Name', 'hcode-addons'),
				'menu_name'         => __( 'Brand', 'hcode-addons'),
			);
			$args = array(
				'hierarchical'      => true,
				'labels'            => $labels,
				'show_ui' 				=> true,
				'show_in_nav_menus' 	=> true,
				'capabilities'			=> array(
					'manage_terms' 		=> $cap,
					'edit_terms' 		=> $cap,
					'delete_terms' 		=> $cap,
					'assign_terms' 		=> $cap
				),
				'rewrite' 				=> array( 'slug' => $category_base . __( 'brand', 'hcode-addons' ), 
				'with_front'             => false, 
				'hierarchical' => true )
			);
			register_taxonomy( 'product_brand', array('product'), apply_filters( 'register_taxonomy_product_brand',$args ));	
		}  

		public function delete_term( $term_id ) {

			$term_id = (int) $term_id;

			if ( !empty($term_id ))
				return;

			global $wpdb;
			$wpdb->query( "DELETE FROM {$wpdb->woocommerce_termmeta} WHERE `woocommerce_term_id` = " . $term_id );
		}

		public function admin_scripts() {
			wp_enqueue_media();
		}

		public function add_brands_fields() { ?>
			<div class="form-field product_brand_thumbnail_main">
				<label><?php _e( 'Thumbnail', 'hcode-addons' ); ?></label>
				<div id="product_brand_thumbnail" class="thumb_img_preview" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( wc_placeholder_img_src() ); ?>" width="60px" height="60px" alt=""/></div>
				<div style="line-height: 60px;">
					<input type="hidden" id="product_brand_thumbnail_id" class="product_brand_thumb_id" name="product_brand_thumbnail_id" />
					<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'hcode-addons' ); ?></button>
					<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'hcode-addons' ); ?></button>
				</div>
				<div class="clear"></div>
			</div>
			<div class="form-field product_brand_logo_main">
				<label><?php _e( 'Logo', 'hcode-addons' ); ?></label>
				<div id="product_brand_logo" class="thumb_img_preview" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( wc_placeholder_img_src() ); ?>" width="60px" height="60px" alt="" /></div>
				<div style="line-height: 60px;">
					<input type="hidden" id="product_brand_logo_id" class="product_brand_thumb_id" name="product_brand_logo_id" />
					<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'hcode-addons' ); ?></button>
					<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'hcode-addons' ); ?></button>
				</div>
				<div class="clear"></div>
			</div>
			<script type="text/javascript">
				// Only show the "remove image" button when needed
				if ( !jQuery( '.product_brand_thumbnail_main #product_brand_thumbnail_id' ).val() ) {
						jQuery( '.product_brand_thumbnail_main .remove_image_button' ).hide();
				}
				if ( !jQuery( '.product_brand_logo_main #product_brand_logo_id' ).val() ) {
						jQuery( '.product_brand_logo_main .remove_image_button' ).hide();
				}
				jQuery( document ).on( 'click', '.upload_image_button', function( event ) {
					// Uploading files
					var file_frame;
						event.preventDefault();
						var currentdiv = jQuery(this).parent().parent();
						
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
								file_frame.open();
								return;
						}

						// Create the media frame.
						file_frame = wp.media.frames.downloadable_file = wp.media({
								title: '<?php _e( "Choose an image", "hcode-addons" ); ?>',
								button: {
										text: '<?php _e( "Use image", "hcode-addons" ); ?>'
								},
								multiple: false
						});

						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
								var attachment = file_frame.state().get( 'selection' ).first().toJSON();
								currentdiv.find( '.product_brand_thumb_id' ).val( attachment.id );
								currentdiv.find( '.thumb_img_preview img' ).attr( 'src', attachment.url );
								currentdiv.find( '.remove_image_button' ).show();
						});

						// Finally, open the modal.
						file_frame.open();
				});

				jQuery( document ).on( 'click', '.remove_image_button', function() {
					var currentdiv = jQuery(this).parent().parent();
						currentdiv.find( '.thumb_img_preview img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
						currentdiv.find( '.product_brand_thumb_id   ' ).val( '' );
						currentdiv.find( '.remove_image_button' ).hide();
						return false;
				});
				jQuery( document ).ajaxComplete( function( event, request, options ) {
					if ( request && 4 === request.readyState && 200 === request.status && options.data && 0 <= options.data.indexOf( 'action=add-tag' ) ) {

						var res = wpAjax.parseAjaxResponse( request.responseXML, 'ajax-response' );
						if ( ! res || res.errors ) {
							return;
						}
						// Clear Thumbnail fields on submit
						jQuery( '#product_brand_thumbnail' ).find( 'img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
						jQuery( '#product_brand_thumbnail_id' ).val( '' );
						jQuery( '.remove_image_button' ).hide();
						return;
					}
				});
			</script>
		<?php
		}

		public function edit_brands_fields( $term, $taxonomy ) {
			$display_type	= get_term_meta( $term->term_id, 'featured', true );
			$image = $image_logo = '';
			$thumbnail_id 	= absint( get_term_meta( $term->term_id, 'thumbnail_id', true ) );
			$logo_id 	= absint( get_term_meta( $term->term_id, 'logo_id', true ) );
			if ( $thumbnail_id ){
				$image = wp_get_attachment_thumb_url( $thumbnail_id );
			} else {
				$image = wc_placeholder_img_src();	
			}
					
			if($logo_id){
				$image_logo = wp_get_attachment_thumb_url( $logo_id );
			} else {
				$image_logo = wc_placeholder_img_src();	
			}
			?>
			<tr class="form-field">
				<th scope="row" valign="top"><label><?php _e( 'Thumbnail', 'hcode-addons' ); ?></label></th>
				<td>
					<div class="product_brand_thumbnail_main">
						<div id="product_brand_thumbnail" class="thumb_img_preview" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image ); ?>" width="60px" height="60px" alt="" /></div>
						<div style="line-height: 60px;">
							<input type="hidden" id="product_brand_thumbnail_id" name="product_brand_thumbnail_id" class="product_brand_thumb_id" value="<?php echo $thumbnail_id; ?>" />
							<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'hcode-addons' ); ?></button>
							<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'hcode-addons' ); ?></button>
						</div>
						<div class="clear"></div>
					</div>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top"><label><?php _e( 'Logo', 'hcode-addons' ); ?></label></th>
				<td>
					<div class="product_brand_logo_main">
					<div id="product_brand_logo" class="thumb_img_preview" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image_logo ); ?>" width="60px" height="60px" alt="" /></div>
					<div style="line-height: 60px;">
						<input type="hidden" id="product_brand_thumb_id" name="product_brand_logo_id" class="product_brand_thumb_id" value="<?php echo $logo_id; ?>" />
						<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'hcode-addons' ); ?></button>
						<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'hcode-addons' ); ?></button>
					</div>
					<div class="clear"></div>
					</div>
				</td>
				<script type="text/javascript">
					// Only show the "remove image" button when needed
					if ( '0' === jQuery( '.product_brand_thumbnail_main #product_brand_thumbnail_id' ).val() ) {
						jQuery( '.product_brand_thumbnail_main .remove_image_button' ).hide();
					}

					if ( '0' === jQuery( '.product_brand_logo_main #product_brand_thumb_id' ).val() ) {
						jQuery( '.product_brand_logo_main .remove_image_button' ).hide();
						jQuery( '.product_brand_logo_main #product_brand_thumb_id .thumb_img_preview img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
					}

					jQuery( document ).on( 'click', '.upload_image_button', function( event ) {
						// Uploading files
						var file_frame;
						event.preventDefault();
						var currentdiv = jQuery(this).parent().parent();

						// If the media frame already exists, reopen it.
						if ( file_frame ) {
								file_frame.open();
								return;
						}

						// Create the media frame.
						file_frame = wp.media.frames.downloadable_file = wp.media({
								title: '<?php _e( "Choose an image", "hcode-addons" ); ?>',
								button: {
										text: '<?php _e( "Use image", "hcode-addons" ); ?>'
								},
								multiple: false
						});

						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
								var attachment = file_frame.state().get( 'selection' ).first().toJSON();
								currentdiv.find( '.product_brand_thumb_id' ).val( attachment.id );
								currentdiv.find( '.thumb_img_preview img' ).attr( 'src', attachment.url );
								currentdiv.find( '.remove_image_button' ).show();
						});

						// Finally, open the modal.
						file_frame.open();
					});

					jQuery( document ).on( 'click', '.remove_image_button', function() {
						var currentdiv = jQuery(this).parent().parent();
						currentdiv.find( '.thumb_img_preview img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
						currentdiv.find( '.product_brand_thumb_id   ' ).val( '' );
						currentdiv.find( '.remove_image_button' ).hide();
						return false;
					});
				</script>
			</tr>
		<?php
		}

		public function save_brands_fields( $term_id, $tt_id, $taxonomy ) {
			if ( isset( $_POST['product_brand_thumbnail_id'] ) && 'product_brand' === $taxonomy ) {
				update_term_meta( $term_id, 'thumbnail_id', absint( $_POST['product_brand_thumbnail_id'] ) );
			}
			if ( isset( $_POST['product_brand_logo_id'] ) && 'product_brand' === $taxonomy ) {
				update_term_meta( $term_id, 'logo_id', absint( $_POST['product_brand_logo_id'] ) );
			}
			delete_transient( 'wc_term_counts' );
		}

		public function brands_columns( $columns ) {
				
			$new_columns = array();
			$new_columns['cb'] = $columns['cb'];
			$new_columns['thumb'] = __( 'Logo', 'hcode-addons' );
			$new_columns['banner_thumb'] = __( 'Banner', 'hcode-addons' );

			unset( $columns['cb'] );

			return array_merge( $new_columns, $columns );
			
		}

		public function brands_column( $columns, $column, $id ) {
			if ( 'thumb' == $column ) {

				$thumbnail_id = get_term_meta( $id, 'logo_id', true );

				if ( $thumbnail_id ) {
					$image = wp_get_attachment_thumb_url( $thumbnail_id );
				} else {
					$image = wc_placeholder_img_src();
				}

				// Prevent esc_url from breaking spaces in urls for image embeds
				// Ref: http://core.trac.wordpress.org/ticket/23605
				$image = str_replace( ' ', '%20', $image );

				$columns .= '<img src="' . esc_url( $image ) . '" alt="' . esc_attr__( 'Thumbnail', 'hcode-addons' ) . '" class="wp-post-image" height="48" width="48" />';

			}
			if ( 'banner_thumb' == $column ) {

				$thumbnail_id = get_term_meta( $id, 'thumbnail_id', true );

				if ( $thumbnail_id ) {
					$image = wp_get_attachment_thumb_url( $thumbnail_id );
				} else {
					$image = wc_placeholder_img_src();
				}

				// Prevent esc_url from breaking spaces in urls for image embeds
				// Ref: http://core.trac.wordpress.org/ticket/23605
				$image = str_replace( ' ', '%20', $image );

				$columns .= '<img src="' . esc_url( $image ) . '" alt="' . esc_attr__( 'Thumbnail', 'hcode-addons' ) . '" class="wp-post-image" height="48" width="48" />';

			}

			return $columns;
		}

		public function hcode_brand_widget_include(){
			if ( file_exists( HCODE_ADDONS_ROOT.'/hcode-brand/hcode-brand-widget.php' ) ) {
				include_once( HCODE_ADDONS_ROOT.'/hcode-brand/hcode-brand-widget.php' );
			}
			register_widget( 'Hcode_Brand_Addons_Widget' );
		}
	}
	$Hcode_Addons_Post_Type = new Hcode_Addons_Post_Type();
}