<?php
/**
 * Map For Blog
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Blog */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
    'name' => __( 'Blog List', 'hcode-addons' ),
    'description' => __( 'Create a blog list', 'hcode-addons' ),    
    'icon' => 'h-code-shortcode-icon fa-solid fa-list',
    'base' => 'hcode_blog',
    'category' => 'H-Code',
    'params' => array(
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Style', 'hcode-addons' ),
          'param_name' => 'hcode_blog_premade_style',
          'value' => array(__( 'Please Select Style', 'hcode-addons' ) => '',
                           __( 'Modern', 'hcode-addons' ) => 'modern',
                           __( 'Classic', 'hcode-addons' ) => 'classic',
                           __( 'Grid', 'hcode-addons' ) => 'grid',
                           __( 'Masonry', 'hcode-addons' ) => 'masonry',
                           __( 'Box', 'hcode-addons' ) => 'box',
                           __( 'List', 'hcode-addons' ) => 'list',
                          ),
          'std' => 'grid',
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Column Type', 'hcode-addons' ),
          'param_name' => 'hcode_blog_columns',
          'value' => array(__( 'Please Select Column Type', 'hcode-addons' ) => '',
                           __( '2 Columns', 'hcode-addons' ) => '2',
                           __( '3 Columns', 'hcode-addons' ) => '3',
                           __( '4 Columns', 'hcode-addons' ) => '4',
                           __( '5 Columns', 'hcode-addons' ) => '5',
                           __( '6 Columns', 'hcode-addons' ) => '6',
                          ),
          'std' => '3',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'grid', 'masonry', 'box' ) ),
      ),
      array(
          'type' => 'hcode_multiple_select_option',
          'heading' => __( 'Categories', 'hcode-addons' ),
          'param_name' => 'hcode_categories_list',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __( 'No. of Posts per Page', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 8', 'hcode-addons' ),
          'param_name' => 'hcode_post_per_page',
          'value'     => '15',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Pagination', 'hcode-addons' ),
          'param_name' => 'hcode_show_pagination',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'std' => '1',
          'description' => __( 'Select Yes to show pagination', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
      ),
      array(
          'type' => 'dropdown',
          'heading' => __( 'Pagination Style', 'hcode-addons' ),
          'param_name' => 'hcode_pagination_style',
          'value' => array(__( 'Number Pagination', 'hcode-addons' ) => 'number-pagination',
                           __( 'Infinite Scroll', 'hcode-addons' ) => 'infinite-scroll-pagination',
                          ),
          'std' => 'number-pagination',
          'dependency'  => array( 'element' => 'hcode_show_pagination', 'value' => array( '1' ) ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Post Title', 'hcode-addons' ),
          'param_name' => 'hcode_show_post_title',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select YES to show post title', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Thumbnail', 'hcode-addons' ),
          'param_name' => 'hcode_show_thumbnail',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show thumbnail', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Post Featured Image Only', 'hcode-addons' ),
          'param_name' => 'hcode_show_post_feature_image',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show post feature image', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_show_thumbnail', 'value' => array( '1' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Post Number', 'hcode-addons' ),
          'param_name' => 'hcode_show_post_number',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'std' => '1',
          'description' => __( 'Select YES to show post number', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern' ) ),
          'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'class' => '',
        'heading' => __( 'Show Separator', 'hcode-addons' ),
        'param_name' => 'hcode_show_separator',
        'value' => array(__( 'NO', 'hcode-addons' ) => '0', 
                         __( 'YES', 'hcode-addons' ) => '1'
                        ),
        'std' => '1',
        'description' => __( 'Select Yes to separator', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
        'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Author Name', 'hcode-addons' ),
          'param_name' => 'hcode_show_author_name',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show author name', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Date', 'hcode-addons' ),
          'param_name' => 'hcode_show_date',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show date', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __( 'Date Format', 'hcode-addons' ),
          'param_name'  => 'hcode_date_format',
          'description' => __( 'Date format should be like mm/dd/yyyy, <a target="_blank" href="https://codex.wordpress.org/Formatting_Date_and_Time">click here</a> to see other date formates', 'hcode-addons' ),
          'value'     => 'd m Y',
          'dependency'  => array( 'element' => 'hcode_show_date', 'value' => array( '1' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Categories', 'hcode-addons' ),
          'param_name' => 'hcode_show_categories',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show categories', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Excerpt', 'hcode-addons' ),
          'param_name' => 'hcode_show_excerpt',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show excerpt, no to show full content', 'hcode-addons' ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __( 'Excerpt Length', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 20', 'hcode-addons' ),
          'param_name'  => 'hcode_excerpt_length',
          'value'     => '55',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array( '1' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Full Content', 'hcode-addons' ),
          'param_name' => 'hcode_show_content',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show blog full content', 'hcode-addons' ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array( '0' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Content White Background', 'hcode-addons' ),
          'param_name' => 'hcode_show_white_bg',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show white background', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Like', 'hcode-addons' ),
          'param_name' => 'hcode_show_like',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show like', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Share', 'hcode-addons' ),
          'param_name' => 'hcode_show_share',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show share', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'box' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Comment', 'hcode-addons' ),
          'param_name' => 'hcode_show_comment',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show comment', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __( 'Show Continue Button', 'hcode-addons' ),
          'param_name' => 'hcode_show_continue_button',
          'value' => array(__( 'No', 'hcode-addons' ) => '0', 
                           __( 'Yes', 'hcode-addons' ) => '1'
                          ),
          'description' => __( 'Select Yes to show continue button', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __( 'Button Text', 'hcode-addons' ),
          'param_name'  => 'hcode_button_config',
          'dependency'  => array( 'element' => 'hcode_show_continue_button', 'value' => array( '1' ) ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Background Color', 'hcode-addons' ),
          'param_name' => 'hcode_background_color',
          'description' => __( 'Choose Background Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_show_white_bg', 'value' => array( '1' )),
          'group' => 'Color Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Title Color', 'hcode-addons' ),
          'param_name' => 'hcode_title_color',
          'description' => __( 'Choose Title Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_show_post_title', 'value' => array( '1' )),
          'group' => 'Color Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Meta Color', 'hcode-addons' ),
          'param_name' => 'hcode_meta_color',
          'description' => __( 'Choose Meta Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Color Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Excerpt Color', 'hcode-addons' ),
          'param_name' => 'hcode_excerpt_color',
          'description' => __( 'Choose Excerpt Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array( '1' ) ),
          'group' => 'Color Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Like / Comment Color', 'hcode-addons' ),
          'param_name' => 'hcode_like_comment_color',
          'description' => __( 'Choose Comment Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'box', 'list' ) ),
          'group' => 'Color Settings',
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Separator Color', 'hcode-addons' ),
          'param_name' => 'hcode_separator_color',
          'description' => __( 'Choose Separator Color', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_show_separator', 'value' => array( '1' ) ),
          'group' => 'Color Settings',
      ),
      array(
          'type'        => 'hcode_button_settings',
          'param_name'  => 'button_settings',
          'heading'     => esc_html__( 'Button Font Settings', 'hcode-addons' ),
          'group' => 'Button Configuration',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
          'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
          'hide_font_settings_element' => array( 'text-align', 'icon-color', 'icon-hover-color' ),
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Display Items Order by', 'hcode-addons' ),
          'param_name' => 'orderby',
          'value' => array(__( 'Select Order by', 'hcode-addons' ) => '',
                           __( 'Date', 'hcode-addons' ) => 'date',
                           __( 'ID', 'hcode-addons' ) => 'ID',
                           __( 'Author', 'hcode-addons' ) => 'author',
                           __( 'Title', 'hcode-addons' ) => 'title',
                           __( 'Modified', 'hcode-addons' ) => 'modified',
                           __( 'Random', 'hcode-addons' ) => 'rand',
                           __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                           __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                          ),
          'std' => 'date',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
          'group' => 'Order',
      ),
      array(
        'type' => 'dropdown',
        'admin_label' => true,
        'heading' => __( 'Display Items Sort by', 'hcode-addons' ),
        'param_name' => 'order',
        'value' => array(__( 'Select Sort by', 'hcode-addons' ) => '',
                         __( 'Descending', 'hcode-addons' ) => 'DESC',
                         __( 'Ascending', 'hcode-addons' ) => 'ASC',
                        ),
        'std' => 'DESC',
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
        'group' => 'Order',
      ),
      array(
        'type' => 'hcode_animation_style',
        'param_name' => 'hcode_animation_style',
        'heading' => __( 'Animation Style', 'hcode-addons' ),
        'value' => '',
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array( 'modern', 'classic', 'grid', 'masonry', 'list' ) ),
        'group' => 'Animation',
      ),
      array(
            'type' => 'hcode_custom_srcset',
            'param_name' => 'hcode_image_srcset',
            'heading' => __( 'Image SRCSET', 'hcode-addons' ),
            'value' => 'full',
            'dependency' => array( 'element' => 'hcode_show_thumbnail', 'value' => '1' ),
            'group' => 'SRCSET',
        ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
    ),
) );