<?php
/**
 * Map For Portfolio
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Portfolio */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
  'name' => __('Portfolio', 'hcode-addons'),
  'description' => __( 'Place portfolio items list', 'hcode-addons' ),
  'icon' => 'fa-solid fa-briefcase h-code-shortcode-icon',
  'base' => 'hcode_portfolio',
  'category' => 'H-Code',
  'params' => array(
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Portfolio Type', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_style',
          'value' => array(__('Select Portfolio Type', 'hcode-addons') => '',
                           __('Grid', 'hcode-addons') => 'grid',
                           __('Grid Gutter', 'hcode-addons') => 'grid-gutter',
                           __('Grid With Title', 'hcode-addons') => 'grid-with-title',
                           __('Wide', 'hcode-addons') => 'wide',
                           __('Wide Gutter', 'hcode-addons') => 'wide-gutter',
                           __('Wide With Title', 'hcode-addons') => 'wide-with-title',
                           __('Masonry', 'hcode-addons') => 'masonry',
          ),
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Column Type', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_columns',
          'value' => array(__('Select Column Type', 'hcode-addons') => '',
                           __('2 Columns', 'hcode-addons') => '2',
                           __('3 Columns', 'hcode-addons') => '3',
                           __('4 Columns', 'hcode-addons') => '4',
                           __('5 Columns', 'hcode-addons') => '5',
          ),
          'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Type of Selection', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_selection',
          'value' => array(__('Category', 'hcode-addons') => 'portfolio-category',
                           __('Tags', 'hcode-addons') => 'portfolio-tags',
          ),
          'std' => 'portfolio-category',
          'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
      ),
      array(
          'type' => 'hcode_multiple_portfolio_categories',
          'heading' => __('Select Categories', 'hcode-addons'),
          'param_name' => 'hcode_categories_list',
          'dependency' => array( 'element' => 'hcode_portfolio_selection', 'value' => array('portfolio-category') ),
      ),
      array(
          'type' => 'hcode_multiple_portfolio_tags',
          'heading' => __('Select Tags', 'hcode-addons'),
          'param_name' => 'hcode_tags_list',
          'dependency' => array( 'element' => 'hcode_portfolio_selection', 'value' => array('portfolio-tags') ),
      ),
      array(
            'type' => 'hcode_custom_switch_option',
            'heading' => __('Show Filter', 'hcode-addons'),
            'param_name' => 'hcode_show_filter',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select YES to show filter above portfolio', 'hcode-addons' ),
            'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
            'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Type of Selection', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_filter_selection',
          'value' => array(__('Category', 'hcode-addons') => 'portfolio-category',
                           __('Tags', 'hcode-addons') => 'portfolio-tags',
          ),
          'std' => 'portfolio-category',
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
            'type' => 'hcode_custom_switch_option',
            'heading' => __('Show All Categories Filter', 'hcode-addons'),
            'param_name' => 'hcode_show_all_categories_filter',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'std' => '1',
            'description' => __( 'Select YES to show filter above portfolio', 'hcode-addons' ),
            'dependency' => array( 'element' => 'hcode_portfolio_filter_selection', 'value' => 'portfolio-category' ),
            'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_multiple_portfolio_categories',
          'heading' => __('Select Default Category Selected', 'hcode-addons'),
          'param_name' => 'hcode_default_category_selected',    
          'multiple' => false,
          'dependency' => array( 'element' => 'hcode_portfolio_filter_selection', 'value' => 'portfolio-category' ),
          'group' => 'Settings',
      ),
      array(
            'type' => 'hcode_custom_switch_option',
            'heading' => __('Show All Tags Filter', 'hcode-addons'),
            'param_name' => 'hcode_show_all_tags_filter',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'std' => '1',
            'description' => __( 'Select YES to show filter above portfolio', 'hcode-addons' ),
            'dependency' => array( 'element' => 'hcode_portfolio_filter_selection', 'value' => 'portfolio-tags' ),
            'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_multiple_portfolio_tags',
          'heading' => __('Select Default Tags Selected', 'hcode-addons'),
          'param_name' => 'hcode_default_tags_selected',    
          'multiple' => false,
          'dependency' => array( 'element' => 'hcode_portfolio_filter_selection', 'value' => 'portfolio-tags' ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Categories / Tags Order By', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_categories_orderby',
          'value' => array(__('Select Order By', 'hcode-addons') => '',
                           __('Name', 'hcode-addons') => 'name',
                           __('Slug', 'hcode-addons') => 'slug',
                           __('Id', 'hcode-addons') => 'id',
                           __('Count', 'hcode-addons') => 'count',
          ),
          'std' => 'id',
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Categories / Tags Order', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_categories_order',
          'value' => array(__('Select Order', 'hcode-addons') => '',
                           __('Ascending', 'hcode-addons') => 'ASC',
                           __('Descending', 'hcode-addons') => 'DESC',
          ),
          'std' => 'ASC',
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Show Title', 'hcode-addons'),
        'param_name' => 'hcode_show_title',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'description' => __( 'Select YES to show Title', 'hcode-addons' ),
        'std' => '1',
        'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Show Subtitle', 'hcode-addons'),
        'param_name' => 'hcode_show_subtitle',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'description' => __( 'Select YES to show Subtitle', 'hcode-addons' ),
        'std' => '1',
        'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Show Infinite Pagination', 'hcode-addons'),
        'param_name' => 'hcode_show_infinite_pagination',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'description' => __( 'Select YES to show infinite pagination', 'hcode-addons' ),
        'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Show Separator', 'hcode-addons'),
        'param_name' => 'hcode_show_separator',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'description' => __( 'Select YES to show Separator', 'hcode-addons' ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Settings',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Separator Color', 'hcode-addons' ),
        'param_name' => 'hcode_sep_color',
        'dependency' => array( 'element' => 'hcode_show_separator', 'value' => array('1') ),
        'group' => 'Settings',
      ),  
      array(
        'type' => 'textfield',
        'heading' => __('Separator Height', 'hcode-addons' ),
        'param_name' => 'seperator_height',
        'value'     => '2px',
        'dependency' => array( 'element' => 'hcode_show_separator', 'value' => array('1') ),
        'description' => __( 'Define custom separator height in px like 2px', 'hcode-addons' ),
        'group' => 'Settings',
      ), 
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Show Button', 'hcode-addons'),
        'param_name' => 'hcode_show_button',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'description' => __( 'Select YES to show button', 'hcode-addons' ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid-with-title','wide-with-title') ),
        'group' => 'Settings',
      ),
      array(
        'type'        => 'textfield',
        'heading'     => __('Button Text', 'hcode-addons' ),
        'param_name'  => 'button_text',
        'dependency' => array( 'element' => 'hcode_show_button', 'value' => array('1') ),
        'group' => 'Settings',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Display Items Order by', 'hcode-addons' ),
        'param_name' => 'orderby',
        'value' => array(__('Select Order by', 'hcode-addons') => '',
                         __( 'Date', 'hcode-addons' ) => 'date',
                         __( 'ID', 'hcode-addons' ) => 'ID',
                         __( 'Author', 'hcode-addons' ) => 'author',
                         __( 'Title', 'hcode-addons' ) => 'title',
                         __( 'Modified', 'hcode-addons' ) => 'modified',
                         __( 'Random', 'hcode-addons' ) => 'rand',
                         __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                         __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                        ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Order'
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Display Items Sort by', 'hcode-addons' ),
        'param_name' => 'order',
        'value' => array(__('Select Sort by', 'hcode-addons') => '',
                         __( 'Descending', 'hcode-addons' ) => 'DESC',
                         __( 'Ascending', 'hcode-addons' ) => 'ASC',
                        ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Order'
      ),
      array(
        'type' => 'textfield',
        'heading' => __('No. of Post Per Page', 'hcode-addons'),
        'param_name' => 'hcode_post_per_page',
        'value'     => '15',
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Enable Lightbox Popup', 'hcode-addons'),
        'param_name' => 'hcode_enable_lightbox',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'class' => '',
        'heading' => __('Required Padding Setting?', 'hcode-addons'),
        'param_name' => 'padding_setting',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_padding',
        'param_name' => 'desktop_padding',
        'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_padding',
        'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_padding',
        'param_name' => 'ipad_padding',
        'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_padding',
        'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_padding',
        'param_name' => 'mobile_padding',
        'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_padding',
        'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'class' => '',
        'heading' => __('Required Margin Setting?', 'hcode-addons'),
        'param_name' => 'margin_setting',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_margin',
        'param_name' => 'desktop_margin',
        'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_margin',
        'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_margin',
        'param_name' => 'ipad_margin',
        'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_margin',
        'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_margin',
        'param_name' => 'mobile_margin',
        'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_margin',
        'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Title Text Color', 'hcode-addons' ),
        'param_name' => 'hcode_title_text_color',
        'dependency' => array( 'element' => 'hcode_show_title', 'value' => '1' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Subtitle Text Color', 'hcode-addons' ),
        'param_name' => 'hcode_subtitle_text_color',
        'dependency' => array( 'element' => 'hcode_show_subtitle', 'value' => '1' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Hover Background Color', 'hcode-addons' ),
        'param_name' => 'hcode_hover_bg_color',
        'group' => 'Style',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __('Filter Color', 'hcode-addons'),
        'param_name' => 'hcode_filter_color',
        'value' => array(__('Select Filter Color', 'hcode-addons') => '',
                         __('Black', 'hcode-addons') => 'nav-tabs-black',
                         __('Gray', 'hcode-addons') => 'nav-tabs-gray',
                         __('Custom', 'hcode-addons') => 'custom',
                ),
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_custom_color',
        'dependency' => array( 'element' => 'hcode_filter_color', 'value' => array('custom') ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Hover Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_hover_color',
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Border Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_border_color',
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Filter Style',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_title_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_subtitle_font',
        'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_filter_font',
        'heading'     => esc_html__( 'Font Settings For Filter', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('text-align'),
        'hide_font_settings_element_md' => array('text-align'),
        'hide_font_settings_element_sm' => array('text-align'),
        'hide_font_settings_element_xs' => array('text-align'),
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Font Settings',
      ),
      array(
        'type' => 'hcode_animation_style',
        'param_name' => 'hcode_animation_style',
        'heading' => __('Animation Style', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'hcode_portfolio_style', 'value' => array('grid','grid-gutter','grid-with-title','wide','wide-gutter','wide-with-title','masonry') ),
        'group' => 'Animation',
      ),
      array(
        'type' => 'hcode_custom_srcset',
        'param_name' => 'hcode_image_srcset',
        'heading' => __('Image SRCSET', 'hcode-addons' ),
        'value' => 'full',
        'group' => 'SRCSET',
      ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
  )
) );