<?php
/**
 * Map For Slider
 *
 * @package H-Code
 */
?>
<?php 
/*-----------------------------------------------------------------------------------*/
/* Slider */
/*-----------------------------------------------------------------------------------*/

vc_map( 
  array(
      'name' => __( 'Image Slider' , 'hcode-addons' ), //Name of your shortcode for human reading inside element list
      'base' => 'hcode_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
      'description' => __( 'Place an image slider', 'hcode-addons' ), //Short description of your element, it will be visible in 'Add element' window
      'class' => '', //CSS class which will be added to the shortcode's content element in the page edit screen in Visual Composer backend edit mode
      'as_parent' => array('only' => 'hcode_slide_content'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
      'icon' => 'fa-regular fa-image h-code-shortcode-icon', //URL or CSS class with icon image.
      'js_view' => 'VcColumnView',
      'category' => 'H-Code',
      'params' => array( //List of shortcode attributes. Array which holds your shortcode params, these params will be editable in shortcode settings page
          array(
              'type' => 'dropdown',
              'heading' => __('Image Slider Style', 'hcode-addons'),
              'param_name' => 'slider_premade_style',
              'admin_label' => true,
              'value' => array(__('Select a Slider Style', 'hcode-addons') => '',
                               __('Slider Style 1 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider1', 
                               __('Slider Style 2 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider2', 
                               __('Slider Style 3 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider3', 
                               __('Slider Style 4 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider4', 
                               __('Slider Style 5 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider5', 
                               __('Slider Style 6 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider6',
                               __('Slider Style 7 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider7',
                               __('Slider Style 8 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider8',
                               __('Slider Style 9 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider9',
                               __('Slider Style 10 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider10',
                               __('Slider Style 11 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider11',
                               __('Slider Style 12 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider12',
                               __('Slider Style 13 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider13',
                               __('Slider Style 14 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider14',
                               __('Slider Style 15 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider15',
                               __('Slider Style 16 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider16',
                               __('Slider Style 17 - Owl Carousel Fix Background', 'hcode-addons') => 'hcode-owl-slider17',
                               __('Slider Style 18 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider18',
                               __('Slider Style 19 - Owl Carousel Full Screen image tag', 'hcode-addons') => 'hcode-owl-slider19',
                               __('Slider Style 20 - Owl Carousel Content slider', 'hcode-addons') => 'hcode-owl-slider20',
                               __('Slider Style 21 - Owl Carousel project page', 'hcode-addons') => 'hcode-owl-slider21',
                               __('Slider Style 22 - Owl Carousel project page Background Slider', 'hcode-addons') => 'hcode-owl-slider22',
                               __('Slider Style 23 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider23',
                               __('Bootstrap Slider Style 1 - Bootstrap Full Screen', 'hcode-addons') => 'hcode-bootstrap-slider1',
                               __('Bootstrap Slider Style 2 - Bootstrap Full Screen', 'hcode-addons') => 'hcode-bootstrap-slider2',
                              ),
              'description' => __('Choose a pre-made Image Slider Style', 'hcode-addons'),
          ),
          array(
              'type' => 'hcode_preview_image',
              'heading' => __('Select pre-made style', 'hcode-addons'),
              'param_name' => 'slider_preview_image',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Show Pagination', 'hcode-addons'),
                'param_name' => 'show_pagination',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select ON to show pagination in slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Pagination Style', 'hcode-addons'),
              'param_name' => 'show_pagination_style',
              'value' => array(__('Select Pagination Style', 'hcode-addons') => '',
                               __('Dot Style', 'hcode-addons') => '0',
                               __('Line Style', 'hcode-addons') => '1',
                               __('Round Style', 'hcode-addons') => '2',
                              ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Pagination Color Style', 'hcode-addons'),
              'param_name' => 'show_pagination_color_style',
              'value' => array(__('Select Pagination Color Style', 'hcode-addons') => '',
                               __('Dark Style', 'hcode-addons') => '0',
                               __('Light Style', 'hcode-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Show Navigation', 'hcode-addons'),
                'param_name' => 'show_navigation',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select ON to show navigation in slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Navigation Style', 'hcode-addons'),
              'param_name' => 'show_navigation_style',
              'value' => array(__('Select Navigation Style', 'hcode-addons') => '',
                               __('Next/Prev Black Arrow', 'hcode-addons') => '0',
                               __('Next/Prev White Arrow', 'hcode-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'show_navigation', 'value' => array('1') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Cursor Color Style', 'hcode-addons'),
              'param_name' => 'show_cursor_color_style',
              'value' => array(__('Select Cursor Color Style', 'hcode-addons') => '',
                               __('White Cursor', 'hcode-addons') => 'white-cursor',
                               __('Black Cursor', 'hcode-addons') => 'black-cursor',
                               __('Default Cursor', 'hcode-addons') => 'no-cursor',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Slide Number Text', 'hcode-addons'),
              'param_name' => 'background_slide_number',
              'value' => array(__('Please Select Number Text', 'hcode-addons')  => '',
                               __('01', 'hcode-addons')  => '1',
                               __('02', 'hcode-addons')  => '2',
                               __('03', 'hcode-addons')  => '3',
                               __('04', 'hcode-addons')  => '4',
                               __('05', 'hcode-addons')  => '5',
                               __('06', 'hcode-addons')  => '6',
                               __('07', 'hcode-addons')  => '7',
                               __('08', 'hcode-addons')  => '8',
                               __('09', 'hcode-addons')  => '9',
                               __('10', 'hcode-addons') => '10',
                               __('Custom Number', 'hcode-addons') => 'custom-number',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Number Text', 'hcode-addons'),
              'param_name' => 'background_slide_custom_number',
              'dependency' => array( 'element' => 'background_slide_number', 'value' => array('custom-number') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Title', 'hcode-addons'),
              'param_name' => 'background_slide_title',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textarea',
              'heading' => __('Subtitle', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __( 'Show Separator', 'hcode-addons' ),
              'param_name' => 'background_show_separator',
              'value' => array(__('No', 'hcode-addons') => '0', 
                               __('Yes', 'hcode-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Subtitle 2', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle_text',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textarea',
              'heading' => __('Content', 'hcode-addons'),
              'param_name' => 'hcode_slider_content',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 1', 'hcode-addons'),
              'param_name' => 'background_slide_title1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 1', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 2', 'hcode-addons'),
              'param_name' => 'background_slide_title2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 2', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 3', 'hcode-addons'),
              'param_name' => 'background_slide_title3',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 3', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle3',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'attach_image',
              'heading' => __('Overlay Image', 'hcode-addons'),
              'param_name' => 'modeling_image',
              'holder' => 'div',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider10') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'hcode_animation_style',
              'heading' => __('Animation In', 'hcode-addons'),
              'param_name' => 'transition_style',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23') ),
              'group' => 'Slider Configuration',
          ),
          array(
              'type' => 'hcode_animation_style',
              'heading' => __('Animation Out', 'hcode-addons'),
              'param_name' => 'transition_animation_out',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23') ),
              'group' => 'Slider Configuration',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Autoplay', 'hcode-addons'),
                'param_name' => 'autoplay',
                'value' => array(__('False', 'hcode-addons') => '0', 
                                 __('True', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select TRUE to autoplay slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
                'group' => 'Slider Configuration',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Loop', 'hcode-addons'),
                'param_name' => 'loop',
                'value' => array(__('False', 'hcode-addons') => '0', 
                                 __('True', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select TRUE to loop slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23') ),
                'group' => 'Slider Configuration',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Stop On Hover', 'hcode-addons'),
                'param_name' => 'stoponhover',
                'value' => array(__('False', 'hcode-addons') => '0', 
                                 __('True', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select TRUE to stop autoplay when hover on slider', 'hcode-addons' ),
                'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
                'group' => 'Slider Configuration',
          ),
          
          array(
              'type' => 'dropdown',
              'heading' => __('Slide Delay Time', 'hcode-addons'),
              'param_name' => 'slidespeed',
              'value' => array(__('Select Slide Delay Time', 'hcode-addons') => '',
                               __('500', 'hcode-addons') => '500',
                               __('600', 'hcode-addons') => '600',
                               __('700', 'hcode-addons') => '700',
                               __('800', 'hcode-addons') => '800',
                               __('900', 'hcode-addons') => '900',
                               __('1000', 'hcode-addons') => '1000',
                               __('1100', 'hcode-addons') => '1100',
                               __('1200', 'hcode-addons') => '1200',
                               __('1300', 'hcode-addons') => '1300',
                               __('1400', 'hcode-addons') => '1400',
                               __('1500', 'hcode-addons') => '1500',
                               __('2000', 'hcode-addons') => '2000',
                               __('3000', 'hcode-addons') => '3000',
                               __('4000', 'hcode-addons') => '4000',
                               __('5000', 'hcode-addons') => '5000',
                               __('6000', 'hcode-addons') => '6000',
                               __('7000', 'hcode-addons') => '7000',
                               __('8000', 'hcode-addons') => '8000',
                               __('9000', 'hcode-addons') => '9000',
                               __('10000', 'hcode-addons') => '10000',
                               __('Custom', 'hcode-addons') => 'custom',
                              ),
              'std' => '3000',
              'description' => __('Select slide delay time (1ms = 100)', 'hcode-addons'),
              'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
              'group' => 'Slider Configuration',
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Custom Slide Delay Time', 'hcode-addons' ),
             'description' => __('Add custom slide delay time to this slider. Like "2000"', 'hcode-addons' ),
             'param_name'  => 'custom_slidespeed',
             'dependency' => array( 'element' => 'slidespeed', 'value' => 'custom' ),
             'group' => 'Slider Configuration',
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Slide Speed', 'hcode-addons'),
              'param_name' => 'slidedelay',
              'value' => array(__('Select Slide Speed', 'hcode-addons') => '',
                               __('500', 'hcode-addons') => '500',
                               __('600', 'hcode-addons') => '600',
                               __('700', 'hcode-addons') => '700',
                               __('800', 'hcode-addons') => '800',
                               __('900', 'hcode-addons') => '900',
                               __('1000', 'hcode-addons') => '1000',
                               __('1100', 'hcode-addons') => '1100',
                               __('1200', 'hcode-addons') => '1200',
                               __('1300', 'hcode-addons') => '1300',
                               __('1400', 'hcode-addons') => '1400',
                               __('1500', 'hcode-addons') => '1500',
                               __('2000', 'hcode-addons') => '2000',
                               __('3000', 'hcode-addons') => '3000',
                               __('4000', 'hcode-addons') => '4000',
                               __('5000', 'hcode-addons') => '5000',
                               __('6000', 'hcode-addons') => '6000',
                               __('7000', 'hcode-addons') => '7000',
                               __('8000', 'hcode-addons') => '8000',
                               __('9000', 'hcode-addons') => '9000',
                               __('10000', 'hcode-addons') => '10000',
                               __('Custom', 'hcode-addons') => 'custom',
                              ),
              'std' => '700',
              'description' => __('Select slide speed', 'hcode-addons'),
              'dependency'  => array( 'element' => 'hcode_image_carousel_autoplay', 'value' => array('1') ),
              'group' => 'Slider Configuration',
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Custom Slide Speed', 'hcode-addons' ),
             'description' => __('Add custom slide speed to this slider. Like "2000"', 'hcode-addons' ),
             'param_name'  => 'custom_slidedelay',
             'dependency' => array( 'element' => 'slidedelay', 'value' => 'custom' ),
             'group' => 'Slider Configuration',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Title Color', 'hcode-addons' ),
            'param_name' => 'background_slide_title_color',
            'description' => __( 'Choose Title Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider14','hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Subtitle Color', 'hcode-addons' ),
            'param_name' => 'background_slide_subtitle_color',
            'description' => __( 'Choose Subtitle Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider14','hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Background Color', 'hcode-addons' ),
            'param_name' => 'background_slide_bg_color',
            'description' => __( 'Choose Background Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider10', 'hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Overlay color', 'hcode-addons' ),
            'param_name' => 'hcode_overlay_color',
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1', 'hcode-owl-slider2', 'hcode-owl-slider3', 'hcode-owl-slider5', 'hcode-owl-slider8', 'hcode-owl-slider12', 'hcode-owl-slider15', 'hcode-owl-slider16', 'hcode-owl-slider21', 'hcode-bootstrap-slider1') ),
            'group' => esc_html__( 'Overlay', 'hcode-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Overlay opacity', 'hcode-addons'),
            'param_name' => 'hcode_overlay_opacity',
            'value' => array( esc_html__( 'Default opacity','hcode-addons') => '',
                              '0'  => '0',
                              '0.1'  => '0.1',
                              '0.2'  => '0.2',
                              '0.3'  => '0.3',
                              '0.4'  => '0.4',
                              '0.5'  => '0.5',
                              '0.6'  => '0.6',
                              '0.7'  => '0.7',
                              '0.8'  => '0.8',
                              '0.9'  => '0.9',
                              '1.0'  => '1.0',
                            ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1', 'hcode-owl-slider2', 'hcode-owl-slider3', 'hcode-owl-slider5', 'hcode-owl-slider8', 'hcode-owl-slider12', 'hcode-owl-slider15', 'hcode-owl-slider16', 'hcode-owl-slider21', 'hcode-bootstrap-slider1') ),
            'group' => esc_html__( 'Overlay', 'hcode-addons' ),
          ),
          array(
              'type'        => 'responsive_font_settings',
              'param_name'  => 'hcode_responsive_number_font',
              'heading'     => esc_html__( 'Font Settings For Number', 'hcode-addons' ),
              'hide_font_settings_element_lg' => array('text-align'),
              'hide_font_settings_element_md' => array('text-align'),
              'hide_font_settings_element_sm' => array('text-align'),
              'hide_font_settings_element_xs' => array('text-align'),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider22') ),
              'group' => 'Font Settings',
          ),
          array(
              'type'        => 'responsive_font_settings',
              'param_name'  => 'hcode_responsive_title_font',
              'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
              'hide_font_settings_element_lg' => array('text-align'),
              'hide_font_settings_element_md' => array('text-align'),
              'hide_font_settings_element_sm' => array('text-align'),
              'hide_font_settings_element_xs' => array('text-align'),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Font Settings',
          ),
          array(
              'type'        => 'responsive_font_settings',
              'param_name'  => 'hcode_responsive_subtitle_font',
              'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Font Settings',
          ),
          array(
              'type'        => 'responsive_font_settings',
              'param_name'  => 'hcode_responsive_subtitle2_font',
              'heading'     => esc_html__( 'Font Settings For Subtitle2', 'hcode-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Font Settings',
          ),
          array(
              'type' => 'hcode_custom_srcset',
              'param_name' => 'hcode_overlay_image_srcset',
              'heading' => __('Overlay Image SRCSET', 'hcode-addons' ),
              'value' => 'full',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider10') ),
              'group' => 'SRCSET',
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Slider ID', 'hcode-addons' ),
             'description' => 'Optional - Define element id (The id attribute specifies a unique id for an HTML element)',
             'param_name'  => 'hcode_slider_id',
             'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
             'group'       => 'Slider ID & Class'
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Slider Extra Class', 'hcode-addons' ),
             'description' => 'Optional - add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2"',
             'param_name'  => 'hcode_slider_class',
             'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
             'group'       => 'Slider ID & Class'
          ),
      ),
  )
);
vc_map( 
  array(
      'name' => __('Add Slide', 'hcode-addons'),
      'base' => 'hcode_slide_content',
      'description' => __( 'A slide for the image slider', 'hcode-addons' ),
      'as_child' => array('only' => 'hcode_slider'), // Use only|except attributes to limit parent (separate multiple values with comma)
      'icon' => 'fa-regular fa-image h-code-shortcode-icon', //URL or CSS class with icon image.
      'params' => array(
          array(
              'admin_label' => true,
              'type' => 'attach_image',
              'heading' => __('Slide Image', 'hcode-addons'),
              'param_name' => 'image',
          ),
          array(
              'type' => 'textfield',
              'admin_label' => true,
              'heading' => __('Title', 'hcode-addons'),
              'param_name' => 'title',
              'description' => __('Notes: It will only apply if your selected image slider style contains the title', 'hcode-addons'),
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Number', 'hcode-addons'),
              'param_name' => 'slide_number',
              'description' => __('Notes: It will only apply if your selected image slider style contains the number', 'hcode-addons'),
          ),
          array(
              'type' => 'textarea_html',
              'heading' => __('Content', 'hcode-addons'),
              'param_name' => 'content',
              'description' => __('Notes: It will only apply if your selected image slider style contains the content', 'hcode-addons'),
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __( 'Show Separator', 'hcode-addons' ),
              'param_name' => 'show_separator',
              'value' => array(__('No', 'hcode-addons') => '0', 
                               __('Yes', 'hcode-addons') => '1'
                              ),
              'description' => __('Notes: It will only apply if your selected image slider style contains the separator', 'hcode-addons'),
              'std' => '1',
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Choose Button', 'hcode-addons'),
              'param_name' => 'no_button',
              'value' => array(__('No Button', 'hcode-addons') => 'nobutton',
                               __('One Button', 'hcode-addons') => 'singlebutton',
                               __('Two Buttons', 'hcode-addons') => 'twobutton',
                              ),
              'description' => __('Hide/show buttons in slide (Notes: It will only apply if your selected image slider style contains the button)', 'hcode-addons'),
          ),
          array(
            'type'        => 'vc_link',
            'heading'     => __('Button 1 Configuration', 'hcode-addons' ),
            'param_name'  => 'first_button_config',
            'dependency'  => array( 'element' => 'no_button', 'value' => array('singlebutton','twobutton') ),
          ),

          array(
            'type'        => 'vc_link',
            'heading'     => __('Button 2 Configuration', 'hcode-addons' ),
            'param_name'  => 'second_button_config',
            'dependency'  => array( 'element' => 'no_button', 'value' => array('twobutton') ),
          ),
          array(
            'type'        => 'hcode_button_settings',
            'param_name'  => 'one_button_config',
            'heading'     => esc_html__( 'Button One Configuration', 'hcode-addons' ),
            'group' => 'Button Configuration',
            'dependency' => array( 'element' => 'no_button', 'value' => array('singlebutton','twobutton') ),
            'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
            'hide_font_settings_element'=>array('icon-color','icon-hover-color')
          ),
          array(
            'type'        => 'hcode_button_settings',
            'param_name'  => 'two_button_config',
            'heading'     => esc_html__( 'Button Two Configuration', 'hcode-addons' ),
            'group' => 'Button Configuration',
            'dependency' => array( 'element' => 'no_button', 'value' => array('singlebutton','twobutton') ),
            'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
            'hide_font_settings_element'=>array('icon-color','icon-hover-color')
          ),
          array(
            'type'        => 'hcode_button_settings',
            'param_name'  => 'two_button_config',
            'heading'     => esc_html__( 'Button Two Configuration', 'hcode-addons' ),
            'group' => 'Button Configuration',
            'dependency' => array( 'element' => 'no_button', 'value' => array('twobutton') ),
            'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
            'hide_font_settings_element'=>array('icon-color','icon-hover-color')
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Title Color', 'hcode-addons' ),
            'param_name' => 'hcode_title_color',
            'description' => __( 'Choose Title Color', 'hcode-addons' ),
            'group' => 'Color',
          ),
          array(
            'type'        => 'responsive_font_settings',
            'param_name'  => 'hcode_responsive_font',
            'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
            'hide_font_settings_element_lg' => array('text-align'),
            'hide_font_settings_element_md' => array('text-align'),
            'hide_font_settings_element_sm' => array('text-align'),
            'hide_font_settings_element_xs' => array('text-align'),
            'group' => 'Font Settings',
          ),
          array(
            'type'        => 'responsive_font_settings',
            'param_name'  => 'hcode_responsive_number_font',
            'heading'     => esc_html__( 'Font Settings For Number', 'hcode-addons' ),
            'hide_font_settings_element_lg' => array('text-align','font-transform'),
            'hide_font_settings_element_md' => array('text-align','font-transform'),
            'hide_font_settings_element_sm' => array('text-align','font-transform'),
            'hide_font_settings_element_xs' => array('text-align','font-transform'),
            'group' => 'Font Settings',
          ),
          array(
              'type' => 'hcode_custom_srcset',
              'param_name' => 'hcode_image_srcset',
              'heading' => __('Image SRCSET', 'hcode-addons' ),
              'value' => 'full',
              'group' => 'SRCSET',
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,
        ),
    ) 
);
/* Main Slider class*/
if(class_exists('WPBakeryShortCodesContainer')){ 
  class WPBakeryShortCode_hcode_slider extends WPBakeryShortCodesContainer { }
}
if(class_exists('WPBakeryShortCode')){
  class WPBakeryShortCode_hcode_slide_content extends WPBakeryShortCode { }
}