<?php
/**
 * Shortcode For Shop Top Five
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Shop Top Five Block */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_shop_top_five_shortcode' ) ) {
    function hcode_shop_top_five_shortcode( $atts, $content = null ) {

    if(!class_exists( 'WooCommerce' )){
        return false;
    }
    extract( shortcode_atts( array(
        'id' => '',
        'class' => '',
        'hcode_special_product_title_font_settings' => '',
        'hcode_special_product_title_color' => '',
        'hcode_special_product_title_hover_color' => '',
        'hcode_special_product_price_font_settings' => '',
        'hcode_special_product_price_color' => '',
        'special_poduct_button_settings' => '',
        'hcode_feature_product_title_font_settings' => '',
        'hcode_feature_product_title_color' => '',
        'hcode_feature_product_title_hover_color' => '',
        'hcode_special_feature_price_font_settings' => '',
        'hcode_feature_product_price_color' => '',
        'hcode_feature_product_content_color' => '',
        'special_feature_button_settings' => '',
    ), $atts ) );

    global $hcode_featured_array, $font_settings_array, $hcode_blog_token, $hcode_feature_blog_token;

    $hcode_blog_token       = !empty( $hcode_blog_token ) ? $hcode_blog_token : 0;
    $hcode_blog_token       = $hcode_blog_token + 1;
    $hcode_token_class      = 'hcode-blog-'.$hcode_blog_token;

    $hcode_feature_blog_token   = !empty( $hcode_feature_blog_token ) ? $hcode_feature_blog_token : 0;
    $hcode_feature_blog_token   = $hcode_feature_blog_token + 1;
    $hcode_feature_token_class  = 'hcode-blog-feature-'.$hcode_feature_blog_token;


    $hcode_special_product_title_font_settings_id = $hcode_special_product_title_font_settings_id_style = $hcode_special_product_title_font_settings_id_class = $hcode_special_product_price_font_settings_id = $hcode_special_product_price_font_settings_id_style = $hcode_special_product_price_font_settings_id_class = $hcode_feature_product_title_font_settings_id = $hcode_feature_product_title_font_settings_id_style = $hcode_feature_product_title_font_settings_id_class = $hcode_feature_product_price_font_settings_id = $hcode_feature_product_price_font_settings_id_style = $hcode_feature_product_price_font_settings_id_class = '';
    
    // Product Button Settings
    $responsive_id='';
    if( !empty( $atts['special_poduct_button_settings'] ) ) {
        $responsive_style = Hcode_Font_Color_Settings::generate_css( $atts['special_poduct_button_settings'], $responsive_id.''.$hcode_token_class.' .quick-buy .btn' );
    } 
    (!empty( $responsive_style)) ? $hcode_featured_array[] = $responsive_style : '';

    // Feature Product Button Settings
    $responsive_id='';
    if( !empty( $atts['special_feature_button_settings'] ) ) {
        $responsive_style = Hcode_Font_Color_Settings::generate_css( $atts['special_feature_button_settings'], $responsive_id.''.$hcode_feature_token_class.' .exclusive-style-text .btn' );
        //print_r($responsive_style);die;
    } 
    (!empty( $responsive_style)) ? $hcode_featured_array[] = $responsive_style : '';

    // Product Title settings
    if( !empty( $atts['hcode_special_product_title_font_settings'] ) ) {
        $hcode_special_product_title_font_settings_id = uniqid('hcode-font-setting-');
        $hcode_special_product_title_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_special_product_title_font_settings'], $hcode_special_product_title_font_settings_id );
        $hcode_special_product_title_font_settings_id_class = ' '.$hcode_special_product_title_font_settings_id;
    }
    
    // Product Price settings
    if( !empty( $atts['hcode_special_product_price_font_settings'] ) ) {
        $hcode_special_product_price_font_settings_id = uniqid('hcode-font-setting-');
        $hcode_special_product_price_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_special_product_price_font_settings'], $hcode_special_product_price_font_settings_id.' .'.$hcode_token_class.' .price del, .'.$hcode_token_class.' .price ins, .'.$hcode_token_class.' .price .amount' );
        $hcode_special_product_price_font_settings_id_class = ' '.$hcode_special_product_price_font_settings_id;
    }

    // Feature Product Title settings
    if( !empty( $atts['hcode_feature_product_title_font_settings'] ) ) {
        $hcode_feature_product_title_font_settings_id = uniqid('hcode-font-setting-');
        $hcode_feature_product_title_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_feature_product_title_font_settings'], $hcode_feature_product_title_font_settings_id );
        $hcode_feature_product_title_font_settings_id_class = ' '.$hcode_feature_product_title_font_settings_id;
    }

    // Feature Product Price settings
    if( !empty( $atts['hcode_special_feature_price_font_settings'] ) ) {
        $hcode_feature_product_price_font_settings_id = uniqid('hcode-font-setting-');
        $hcode_feature_product_price_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_special_feature_price_font_settings'], $hcode_feature_product_price_font_settings_id.' '.$hcode_feature_token_class.' .price del, .'.$hcode_feature_token_class.' .price ins, .'.$hcode_feature_token_class.' .price .amount' );
        $hcode_feature_product_price_font_settings_id_class = ' '.$hcode_feature_product_price_font_settings_id;
    }

    
    ( !empty( $hcode_special_product_title_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_special_product_title_font_settings_id_style : '';
    ( !empty( $hcode_special_product_price_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_special_product_price_font_settings_id_style : '';
    ( !empty( $hcode_feature_product_title_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_feature_product_title_font_settings_id_style : '';
    ( !empty( $hcode_feature_product_price_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_feature_product_price_font_settings_id_style : '';

    $product_title_setting = ( $hcode_special_product_title_font_settings_id_class ) ? 'class="'.$hcode_special_product_title_font_settings_id_class.'"' : '';
    $product_price_title_setting = ( $hcode_special_product_price_font_settings_id_class ) ? 'class="'.$hcode_special_product_price_font_settings_id_class.'"' : '';
    $feature_product_title_setting = ( $hcode_feature_product_title_font_settings_id_class ) ? 'class="'.$hcode_feature_product_title_font_settings_id_class.'"' : '';

    // Coloe Settings
    !empty( $atts['hcode_special_product_title_color'] ) ? $hcode_featured_array[] = '.'.$hcode_token_class.' .product-name a { color: '.$atts['hcode_special_product_title_color'].' !important}' : '';
    !empty( $atts['hcode_special_product_title_hover_color'] ) ? $hcode_featured_array[] = '.'.$hcode_token_class.' .product-name a:hover, .'.$hcode_token_class.' .text-med a:hover { color: '.$atts['hcode_special_product_title_hover_color'].' !important}' : '';
    !empty( $atts['hcode_special_product_price_color'] ) ? $hcode_featured_array[] = '.'.$hcode_token_class.' .price del, .'.$hcode_token_class.' .price ins, .'.$hcode_token_class.' .price .amount { color: '.$atts['hcode_special_product_price_color'].' !important}' : '';
    // Feature Coloe Settings
    !empty( $atts['hcode_feature_product_title_color'] ) ? $hcode_featured_array[] = '.'.$hcode_feature_token_class.' .text-med a { color: '.$atts['hcode_feature_product_title_color'].' !important}' : '';
    !empty( $atts['hcode_feature_product_title_hover_color'] ) ? $hcode_featured_array[] = '.'.$hcode_feature_token_class.' .text-med a:hover { color: '.$atts['hcode_feature_product_title_hover_color'].' !important}' : '';
    !empty( $atts['hcode_feature_product_price_color'] ) ? $hcode_featured_array[] = '.'.$hcode_feature_token_class.' .price del, .'.$hcode_feature_token_class.' .price ins { color: '.$atts['hcode_feature_product_price_color'].' !important}' : '';
    !empty( $atts['hcode_feature_product_content_color'] ) ? $hcode_featured_array[] = '.'.$hcode_feature_token_class.' .exclusive-style-text .short-description p { color: '.$atts['hcode_feature_product_content_color'].' !important}' : '';

    $id = ( $id ) ? 'id="'.$id.'"' : '';
    $class = ( $class ) ? $class : '';
    $query_args = array(
        'post_type'           => 'product',
        'post_status'         => 'publish',
        'ignore_sticky_posts' => 1,
        'posts_per_page'      => 2,
        'meta_query' => array(
            'relation' => 'AND',
            'hcode_feature_product_order' => array(
                'key' => 'hcode_feature_product_order',
                'value' => '',
                'compare' => '!='
            ), 
            'hcode_feature_product_shop' => array(
                        'key'   => 'hcode_feature_product_shop',
                        'value' => 'yes',
                        'compare' => '!='
                        ),
        ),
        'tax_query' => WC()->query->get_tax_query(),
        'orderby' => 'meta_value_num',
        'order'   => 'asc',
    );
    $products = new WP_Query( $query_args );

    ob_start();
    $count = 1;
    if ( $products->have_posts() ) : ?>
            <div <?php echo $id; ?> class="col-md-4 col-sm-4 col-xs-12 <?php echo $hcode_token_class;?> <?php echo $class;?>">
                <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                    <?php 
                    global $product, $woocommerce_loop;
                    // Store loop count we're currently on
                    if ( empty( $woocommerce_loop['loop'] ) ) {
                        $woocommerce_loop['loop'] = 0;
                    }
                    // Store column count for displaying the grid
                    if ( empty( $woocommerce_loop['columns'] ) ) {
                        $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 2 );
                    }
                    // Ensure visibility
                    if ( ! $product || ! $product->is_visible() ) {
                        return;
                    }
                    // Increase loop count
                    $woocommerce_loop['loop']++;
                    // Extra post classes
                    $classes = array();
                    if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
                        $classes[] = 'first';
                        $classes[] = 'home-product text-center position-relative overflow-hidden margin-ten no-margin-top';
                        
                    }
                    if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
                        $classes[] = 'last';
                        $classes[] ='home-product text-center position-relative overflow-hidden margin-ten no-margin-bottom';
                    }
                    ?>
                    <div <?php post_class($classes);?>>
                        <?php echo '<div class="product-image-wrapper'.$hcode_special_product_price_font_settings_id_class.'">'; ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php //do_action( 'woocommerce_before_shop_loop_item_title' );
                                if ( has_post_thumbnail() ) {
                                    the_post_thumbnail( 'shop_catalog' );
                                }elseif ( wc_placeholder_img_src() ) {
                                    echo wc_placeholder_img( 'shop_catalog' );
                                }
                                ?>
                            </a>
                            <?php do_action ( 'hcode_sale_flash' ); ?>
                        </div>
                        <div class="product-content-wrapper">
                            <span class="product-name text-uppercase">
                                <?php
                                    echo '<a '.$product_title_setting.$product_price_title_setting.' href="'.get_the_permalink().'">';
                                ?>    
                                <?php wc_get_template( 'loop/title.php' ); ?>
                                </a>
                            </span>
                            <?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
                            <div class="quick-buy">
                                <div class="product-share">
                                    <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                                </div>
                            </div>  
                        </div>        
                    </div>                
                <?php endwhile; // end of the loop. ?>    
        </div>
    <?php endif;

    woocommerce_reset_loop();
    wp_reset_postdata();

    // Get Special Feature product
    $meta_query   = WC()->query->get_meta_query();
    $meta_query[] = array(
        'key'   => 'hcode_feature_product_shop',
        'value' => 'yes'
    );

    $query_args = array(
        'post_type'           => 'product',
        'post_status'         => 'publish',
        'ignore_sticky_posts' => 1,
        'posts_per_page'      => 1,
        'orderby'             => 'meta_value_num',
        'meta_query' => array(
            'relation' => 'AND',
            'hcode_feature_product_shop' => array(
                'key' => 'hcode_feature_product_shop',
                'value' => 'yes',
                'compare' => '=='
            ), 
        ),
        'tax_query' => WC()->query->get_tax_query(),
    );

    $special_products = new WP_Query( $query_args );
    if ( $special_products->have_posts() ) : ?>
        <?php while ( $special_products->have_posts() ) : $special_products->the_post(); ?>
        <?php global $post, $product, $woocommerce; ?>
                
            <?php
                
                $attachment_ids = $product->get_gallery_image_ids();

                if ( has_post_thumbnail() ) {
                    $attachment_ids = array_merge (array(get_post_thumbnail_id()), $attachment_ids);
                }

                if ( $attachment_ids ) {
                    $loop       = 0;
                    $columns    = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
                    echo '<div class="col-md-4 col-sm-4 col-xs-12 exclusive-style no-padding xs-margin-top-ten '.$hcode_feature_token_class.'">';
                    echo '<!-- shop item slider -->
                        <div class="special-product-slide owl-carousel owl-theme owl-half-slider dark-pagination dark-pagination-without-next-prev-arrow">';
                        foreach ( $attachment_ids as $attachment_id ) {

                            $classes = array( 'zoom' );

                            if ( $loop == 0 || $loop % $columns == 0 )
                                $classes[] = 'first';

                            if ( ( $loop + 1 ) % $columns == 0 )
                                $classes[] = 'last';

                            $image_link = wp_get_attachment_url( $attachment_id );

                            if ( ! $image_link )
                                continue;

                            $image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'full' ) );
                            $image_class = esc_attr( implode( ' ', $classes ) );
                            $image_title = esc_attr( get_the_title( $attachment_id ) );

                            echo '<div class="item text-center">';
                                echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="%s" class="%s">%s</a>', get_permalink(), $image_class, $image ), $attachment_id, $post->ID, $image_class );
                            echo '</div>';
                                
                            $loop++;
                        }

                        echo '</div>';

                        echo '<div class="exclusive-style-text text-center">';
                        do_action ( 'hcode_sale_flash' );
                            echo '<p class="text-med font-weight-600 black-text text-uppercase letter-spacing-2">';
                                echo '<a '.$feature_product_title_setting.' href="'.get_the_permalink().'">';
                                    wc_get_template( 'loop/title.php' );
                                echo '</a>';
                            echo '</p>';
                            do_action( 'woocommerce_after_shop_loop_item_title' );
                            wc_get_template( 'single-product/short-description.php' );
                            do_action( 'woocommerce_after_shop_loop_item' );
                          echo '</div>';
                        echo '</div>';

                }
        endwhile; // end of the loop.
    endif;
    woocommerce_reset_loop();
    wp_reset_postdata();


    // for 3 & 4 product
    $query_args2 = array(
        'post_type'           => 'product',
        'post_status'         => 'publish',
        'ignore_sticky_posts' => 1,
        'posts_per_page'      => 4,
        'meta_query' => array(
            'relation' => 'AND',
            'hcode_feature_product_order' => array(
                'key' => 'hcode_feature_product_order',
                'value' => '',
                'compare' => '!='
            ), 
            'hcode_feature_product_shop' => array(
                        'key'   => 'hcode_feature_product_shop',
                        'value' => 'yes',
                        'compare' => '!='
                        ),
        ),
        'tax_query' => WC()->query->get_tax_query(),
        'orderby' => 'meta_value_num',
        'order'   => 'asc',
    );

    $second_products = new WP_Query( $query_args2 );
    $count = 1;

    if ( $second_products->have_posts() ) : ?>
        <div class="col-md-4 col-sm-4 col-xs-12 <?php echo $hcode_token_class;?>">
            <?php while ( $second_products->have_posts() ) : $second_products->the_post(); ?>

                <?php 
                if($count > 2){
                    
                global $product, $woocommerce_loop;

                // Store loop count we're currently on
                if ( empty( $woocommerce_loop['loop'] ) ) {
                    $woocommerce_loop['loop'] = 0;
                }

                // Store column count for displaying the grid
                if ( empty( $woocommerce_loop['columns'] ) ) {
                    $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 2 );
                }

                // Ensure visibility
                if ( ! $product || ! $product->is_visible() ) {
                    return;
                }

                // Increase loop count
                $woocommerce_loop['loop']++;

                // Extra post classes
                $classes = array();
                if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
                    $classes[] = 'first';
                    $classes[] = 'home-product text-center position-relative overflow-hidden margin-ten no-margin-top';
                    
                }
                if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
                    $classes[] = 'last';
                    $classes[] ='home-product text-center position-relative overflow-hidden margin-ten no-margin-bottom';
                }
                ?>
                <div <?php post_class($classes);?>>
                    <div class="product-image-wrapper">
                        <a href="<?php the_permalink(); ?>">
                            <?php //do_action( 'woocommerce_before_shop_loop_item_title' );
                                
                                if ( has_post_thumbnail() ) {
                                    the_post_thumbnail( 'shop_catalog' );
                                }elseif ( wc_placeholder_img_src() ) {
                                    echo wc_placeholder_img( 'shop_catalog' );
                                }
                            ?>
                        </a>
                        <?php do_action ( 'hcode_sale_flash' ); ?>
                    </div>
                    <div class="product-content-wrapper">
                        <span class="product-name text-uppercase">
                            <?php
                            echo '<a '.$product_title_setting.$product_price_title_setting.' href="'.get_the_permalink().'">';
                            ?> 
                            <?php wc_get_template( 'loop/title.php' ); ?>
                            </a>
                        </span>

                        <?php do_action( 'woocommerce_after_shop_loop_item_title' ); ?>

                        <div class="quick-buy">
                            <div class="product-share">
                                <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php 
            }
            $count++; 
            endwhile; // end of the loop. ?>    
        </div>
    <?php endif;

    woocommerce_reset_loop();
    wp_reset_postdata();
    return ob_get_clean();
    }
}
add_shortcode( 'hcode_shop_top_five', 'hcode_shop_top_five_shortcode' );