<div class="wrap support-page wpgmza-tabs-container wpgmza-wrap">
	<!-- Generic navigation -->
	<ul>
		<li>
			<a href="#documentation">
				<?php esc_html_e('Documentation', 'wp-google-maps'); ?>
			</a>
		</li>

		<li>
			<a href="#troubleshooting">
				<?php esc_html_e('Troubleshooting', 'wp-google-maps'); ?>
			</a>
		</li>

		<li>
			<a href="#system">
				<?php esc_html_e('System Info', 'wp-google-maps'); ?>
			</a>
		</li>

		<li>
			<a href="#support">
				<?php esc_html_e('Support', 'wp-google-maps'); ?>
			</a>
		</li>
	</ul>

	<!-- Documentation -->
	<div id="documentation">
		<div class="heading">
			<?php _e("General", "wp-google-maps"); ?>
		</div>

		<div class="hint">
			<?php _e("Getting started? Read through some of these articles to help you along your way.","wp-google-maps"); ?>
		</div>

		<div class="tab-row">
			<ul class="wpgmza-list-dots">
				<li>
					<a href='https://www.wpgmaps.com/help/docs/creating-your-first-map/' 
						target='_BLANK' 
						title='<?php _e("Creating your first map","wp-google-maps"); ?>'>
						<?php
						_e("Creating your first map","wp-google-maps"); 
						?>
					</a>
				</li>
				<li>
					<a href='https://www.wpgmaps.com/help/docs/displaying-your-map-on-your-wordpress-site/'
						target='_BLANK' 
						title='<?php _e("Creating a Map Block","wp-google-maps"); ?>'>
						<?php
						_e("Creating a Map Block","wp-google-maps");
						?>
					</a>
				</li>
				<li>
					<a href='https://www.wpgmaps.com/help/docs/creating-a-google-maps-api-key/' 
						target='_BLANK' 
						title='<?php _e("Creating a Google Maps API Key","wp-google-maps"); ?>'>
						<?php 
						_e("Creating a Google Maps API Key","wp-google-maps"); 
						?>
					</a>
				</li>
				<li>
					<a href='https://www.wpgmaps.com/help/'
						target='_BLANK' 
						title='<?php _e("WP Go Maps Documentation","wp-google-maps"); ?>'>
						<?php 
						_e("View all documentation.","wp-google-maps"); 
						?>
					</a>
				</li>
			</ul>
		</div>
	</div>

	<!-- Troubleshooting -->
	<div id="troubleshooting">
		<div class="heading">
			<?php _e("Troubleshooting", "wp-google-maps"); ?>
		</div>

		<div class="hint">
			<?php _e("WP Go Maps has a diverse and wide range of features which may, from time to time, run into conflicts with the thousands of themes and other plugins on the market.","wp-google-maps"); ?> 
		</div>

		<div class="tab-row">
			<ul class="wpgmza-list-dots">
				<li>
					<a href='https://www.wpgmaps.com/help/docs/my-map-is-not-showing-on-my-website/' target='_BLANK' title='<?php _e("My map is not showing on my website","wp-google-maps"); ?>'><?php _e("My map is not showing on my website","wp-google-maps"); ?></a>
				</li>
				<li>
					<a href='https://www.wpgmaps.com/help/docs/markers-are-not-showing-on-my-map-on-the-front-end/' target='_BLANK' title='<?php _e("My markers are not showing on my map in the front-end","wp-google-maps"); ?>'><?php _e("My markers are not showing on my map in the front-end","wp-google-maps"); ?></a>
				</li>
				<li>
					<a href='https://www.wpgmaps.com/help/docs/im-getting-a-jquery-not-found-error/' target='_BLANK' title='<?php esc_attr_e("I'm getting jQuery errors showing on my website","wp-google-maps"); ?>'><?php _e("I'm getting jQuery errors showing on my website","wp-google-maps"); ?></a>
				</li>
			</ul>
		</div>
	</div>

	<!-- System Info -->
	<div id="system">
		<div class="heading">
			<?php _e("System Info", "wp-google-maps"); ?>
		</div>

		<div class="hint">
			<?php _e("Our support team may ask for the following information to provide you with better support", "wp-google-maps"); ?>
		</div>

		<div class="tab-row">
			<pre class="system-info"></pre>
		</div>
		<div class="tab-row">
			<div class="wpgmza-button wpgmza-copy-sysinfo"><?php _e("Copy Info", "wp-google-maps"); ?></div> 
		</div>

	</div>

	<!-- Get support -->
	<div id="support">
		<div class="heading">
			<?php _e("Support", "wp-google-maps"); ?>
		</div>

		<div class="hint">
			<?php _e("Still need help? Use one of these links below.","wp-google-maps"); ?>
		</div>

		<div class="tab-row">
			<ul class="wpgmza-list-dots">
				<li><a href='https://www.wpgmaps.com/forums/' target='_BLANK' title='<?php _e("Support forum","wp-google-maps"); ?>'><?php _e("Support forum","wp-google-maps"); ?></a></li>
				<li><a href='https://www.facebook.com/groups/wpgooglemaps' target='_BLANK' title='<?php _e("Facebook Community","wp-google-maps"); ?>'><?php _e("Facebook Community","wp-google-maps"); ?></a></li>
				<li><a href='https://www.reddit.com/r/wpgooglemaps/' target='_BLANK' title='<?php _e("Reddit Community","wp-google-maps"); ?>'><?php _e("Reddit Community","wp-google-maps"); ?></a></li>
				<li><a href='https://www.wpgmaps.com/contact-us/' target='_BLANK' title='<?php _e("Contact us","wp-google-maps"); ?>'><?php _e("Contact us","wp-google-maps"); ?></a></li>
			</ul>
		</div>
	</div>
</div>
