<?php

/**
 * Redux Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 * Redux Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Redux Framework. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package     ReduxFramework
 * @subpackage  Field_Multi_Text
 * @author      Daniel J Griffiths (Ghost1227)
 * @author      Dovy Paukstys
 * @version     3.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Don't duplicate me!
if ( ! class_exists( 'ReduxFramework_images' ) ) {

    /**
     * Main ReduxFramework_multi_text class
     *
     * @since       1.0.0
     */
    class ReduxFramework_images {


        public $parent;
        public $field;
        public $value;

        /**
         * Field Constructor.
         * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        function __construct( $field, $value, $parent ) {
            $this->parent = $parent;
            $this->field  = $field;
            $this->value  = $value;
        }

        /**
         * Field Render Function.
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function render() {
            $i = 0;
                $select_value = (isset($this->value)) ? ' selected="selected"' : '';
                foreach ($this->field['options'] as $key => $option) 
                    { 
                       $header_title = $this->field['imgtitle']['imgtitle'.($i+1)];
                    $i++;
            
                        $checked = '';
                        $selected = '';
                        if($key == $this->value) {
                            $checked = 'checked';
                            $selected = 'of-radio-img-selected';  
                        }
                        echo '<span>';
                        echo '<input type="radio" id="of-radio-img-' . $this->field['id'] . $i . '" class="checkbox of-radio-img-radio" value="'.$key.'" name="'.$this->field['name'].'" '.$checked.' />';
                        echo '<div class="of-radio-img-label">'. $header_title .'</div>';
                        echo '<img src="'.$option.'" alt="" class="of-radio-img-img '. $selected .'" onClick="document.getElementById(\'of-radio-img-'. $this->field['id'] . $i.'\').checked = true;" />';
                        echo '</span>';               
                    }
        }

        /**
         * Enqueue Function.
         * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
    }
}