<?php
/**
 * Page or Template Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'fa-regular fa-file-alt',
    'title' => esc_html__('Page/Template', 'H-Code'),
    'fields' => array(
        
        /*  Under Construction */
        array(
            'id'        => 'opt_accordion_begin_under_construction',
            'type'      => 'accordion',
            'title'     => esc_html__('Under Construction Page', 'H-Code'),
            'subtitle'  => esc_html__('Select page to display when site is in under construction mode', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'=>'under_construction_page',
            'type' => 'select',
            'title' => esc_html__('Under Construction Page', 'H-Code'),
            'data' => 'pages'
        ),
        array(
            'id'        => 'opt_accordion_end_under_construction',
            'type'      => 'accordion',
            'position'  => 'end'
        ),

        /*  Comment */
        array(
            'id'        => 'opt_accordion_begin_comment_settings',
            'type'      => 'accordion',
            'title'     => esc_html__('Comments Settings', 'H-Code'),
            'subtitle'  => esc_html__('Enable/Disable comments in post or portfolio page', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'=>'hcode_enable_page_comment',
            'type' => 'switch', 
            'title' => esc_html__('Enable Comments in Page', 'H-Code'),
            'default'  => false,
        ),
        array(
            'id'=>'hcode_enable_post_comment',
            'type' => 'switch', 
            'title' => esc_html__('Enable Comments in Post', 'H-Code'),
            'default' => true,
        ),
        array(
            'id'=>'hcode_enable_portfolio_comment',
            'type' => 'switch', 
            'title' => esc_html__('Enable Comments in Portfolio', 'H-Code'),
            'default' => false,
        ),
        array(
            'id'        => 'opt_accordion_end_comment_settings',
            'type'      => 'accordion',
            'position'  => 'end'
        ),

        /*  404 Page */
        array(
            'id'        => 'opt_accordion_begin_404_settings',
            'type'      => 'accordion',
            'title'     => esc_html__('404 Page Settings', 'H-Code'),
            'subtitle'  => esc_html__('Set title, content, image, button text and button URL for 404 / page not found page', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'       => '404_title_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Title Text', 'H-Code' ),
            'default'  => '404!'
        ),
        array(
            'id'       => '404_content_text',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content Text', 'H-Code' ),
            'default'  => 'The page you were looking<br/>for could not be found.'
        ),
        array(
            'id'       => '404_image',
            'type'     => 'media',
            'preview'  => true,
            'url'      => true,  
            'title'    => esc_html__( '404 Background Image', 'H-Code' ),
            'subtitle' => esc_html__( 'Upload image', 'H-Code' ),
        ),
        array(
            'id'=>'404_image_srcset',
            'type' => 'select',
            'title' => esc_html__('404 Image SRCSET', 'H-Code'),
            'data' => 'image_sizes',
        ),
        array(
            'id'       => '404_bg_color',
            'type'     => 'color',
            'title'    => __( 'Background color', 'H-Code' ),
        ),
        array(
            'id'       => '404_font_color',
            'type'     => 'color',
            'title'    => esc_html__( '404 Content Font Color', 'H-Code' ),
            'default'  => ''
        ),
        array(
            'id'=>'404_enable_text_button',
            'type' => 'switch', 
            'title' => esc_html__('Enable Button', 'H-Code'),
            'default' => true,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'       => '404_button',
            'type'     => 'text',
            'title'    => esc_html__( 'Button Text', 'H-Code' ),
            'required' => array('404_enable_text_button', 'equals', '1'),
            'default'  => 'Go to home page'
        ),
        array(
            'id'=>'404_button_url',
            'type' => 'select',
            'title' => esc_html__('Button Url', 'H-Code'),
            'data' => 'pages',
            'required'  => array('404_enable_text_button', 'equals', '1'),
        ),
        array(
            'id'=>'404_enable_search',
            'type' => 'switch', 
            'title' => esc_html__('Enable Search', 'H-Code'),
            'default' => true,
        ),
        array(
            'id'        => 'opt_accordion_end_404_settings',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
    )
);
?>