<?php
/**
 * H-Code Theme Extra Function.
 *
 * @package H-Code
 */
?>
<?php
if ( ! function_exists( 'hcode_set_header' ) ) {
    function hcode_set_header( $id ){
        if( get_post_type( $id ) == 'portfolio' && is_singular('portfolio') ){
            $enable_ajax = get_post_meta($id,'hcode_enable_ajax_popup_single',true);
        }else{
            $enable_ajax = '';
        }
        
        if($enable_ajax == 'yes'){
            remove_all_actions('wp_head');
        }
    }
}

if ( ! function_exists( 'hcode_set_footer' ) ) {
    function hcode_set_footer( $id ){
        if(get_post_type( $id ) == 'portfolio' && is_singular('portfolio')){
            $enable_ajax = get_post_meta($id,'hcode_enable_ajax_popup_single',true);
        }else{
            $enable_ajax = '';
        }

        if($enable_ajax == 'yes'){
            remove_all_actions('wp_footer');
            add_action( 'wp_footer','hcode_hook_for_ajax_page' );
            add_action( 'wp_footer', 'hcode_addons_generate_custom_css' );
        }
    }
}

if ( ! function_exists( 'hcode_add_ajax_page_div_header' ) ) {
    function hcode_add_ajax_page_div_header( $id ){
        if( get_post_type( $id ) == 'portfolio' && is_singular('portfolio') ){
            $enable_ajax = get_post_meta($id,'hcode_enable_ajax_popup_single',true);
        }else{
            $enable_ajax = '';
        }
        
        if($enable_ajax == 'yes'){
            echo '<div class="bg-white">';
        }
    }
}

if ( ! function_exists( 'hcode_add_ajax_page_div_footer' ) ) {
    function hcode_add_ajax_page_div_footer( $id ){
        if(get_post_type( $id ) == 'portfolio' && is_singular('portfolio')){
            $enable_ajax = get_post_meta($id,'hcode_enable_ajax_popup_single',true);
        }else{
            $enable_ajax = '';
        }

        if($enable_ajax == 'yes'){
            echo '</div>';
        }
    }
}

if ( ! function_exists( 'hcode_post_meta' ) ) {
    function hcode_post_meta( $option ){
        global $post;
        $value = get_post_meta( $post->ID, $option.'_single', true);
        return $value;
    }
}

if ( ! function_exists( 'hcode_option' ) ) {
    function hcode_option( $option ){
        global $hcode_theme_settings, $post;
        $hcode_single = false;
        if(is_singular()){
            $value = get_post_meta( $post->ID, $option.'_single', true);
            $hcode_single = true;
        }

        if($hcode_single == true){
            if (is_string($value) && (strlen($value) > 0 || is_array($value)) && ($value != 'default' && $value != 'Select Sidebar')  ) {
                return $value;
            }
        }
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            return $option_value;
        }
        return false;
    }
}

if ( ! function_exists( 'hcode_option_post' ) ) {
    function hcode_option_post( $option ){
        global $hcode_theme_settings, $post;
        $option_post = '';
        $hcode_single = false;

        if(is_singular()){
            $value = get_post_meta( $post->ID, $option.'_single', true);
            $hcode_single = true;
        }

        if($hcode_single == true){
            if (is_string($value) && (strlen($value) > 0 || is_array($value)) && ($value != 'default' && $value != 'Select Sidebar')  ) {
                return $value;
            }
        }
        $option_post = $option.'_post';
        if(isset($hcode_theme_settings[$option_post]) && $hcode_theme_settings[$option_post] != ''){
            $option_value = $hcode_theme_settings[$option_post];
            return $option_value;
        }
        return false;
    }
}

if ( ! function_exists( 'hcode_option_portfolio' ) ) {
    function hcode_option_portfolio( $option ){
        global $hcode_theme_settings, $post;
        $option_post = '';
        $hcode_single = false;

        if(is_singular()){
            $value = get_post_meta( $post->ID, $option.'_single', true);
            $hcode_single = true;
        }

        if($hcode_single == true){
            if (is_string($value) && (strlen($value) > 0 || is_array($value)) && ($value != 'default' && $value != 'Select Sidebar')  ) {
                return $value;
            }
        }
        $option_post = $option.'_portfolio';
        if(isset($hcode_theme_settings[$option_post]) && $hcode_theme_settings[$option_post] != ''){
            $option_value = $hcode_theme_settings[$option_post];
            return $option_value;
        }
        return false;
    }
}

if ( ! function_exists( 'hcode_option_single' ) ) {
    function hcode_option_single( $option ){
        global $hcode_theme_settings, $post;
        $hcode_single = false;
        if(is_singular()){
            $value = get_post_meta( $post->ID, $option.'_single', true);
            $hcode_single = true;
        }

        if($hcode_single == true){
            if (is_string($value) && (strlen($value) > 0 || is_array($value)) && ($value != 'default' && $value != 'Select Sidebar')  ) {
                return $value;
            }
        }
        if( isset( $hcode_theme_settings[$option.'_all'] ) && $hcode_theme_settings[$option.'_all'] != '' && !empty( $hcode_theme_settings[$option.'_all'] ) ){
            $option_value = $hcode_theme_settings[$option.'_all'];
            return $option_value;
        }
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            return $option_value;
        }
        return false;
    }
}

/* Filter For the_post_thumbnail function attributes */
if( ! function_exists( 'hcode_filter_the_post_thumbnail_atts' ) ) :
    function hcode_filter_the_post_thumbnail_atts( $atts, $attachment ) {

        global $hcode_theme_settings;

        if( isset( $hcode_theme_settings['enable_image_alt'] ) && $hcode_theme_settings['enable_image_alt'] != '' ) {
            if( $hcode_theme_settings['enable_image_alt'] == '1' ) {
                $hcode_image_alt_text = get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true );
                $atts['alt'] = $hcode_image_alt_text;
            } else {
                $atts['alt'] = '';
            }
        }

        if( isset( $hcode_theme_settings['enable_image_title'] ) && $hcode_theme_settings['enable_image_title'] != '' ) {
            if( $hcode_theme_settings['enable_image_title'] == 1 && $attachment->post_title ){
                $atts['title'] = esc_attr( $attachment->post_title );
            }
        }
        return $atts;
    }
endif;
add_filter( 'wp_get_attachment_image_attributes', 'hcode_filter_the_post_thumbnail_atts', 10, 2 );

/* For Image Alt Text */
if ( ! function_exists( 'hcode_option_image_alt' ) ) {
    function hcode_option_image_alt( $attach_id ){
        global $hcode_theme_settings, $post;
        $option = 'enable_image_alt';
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            $img_meta = wp_get_attachment_metadata( $attach_id );
            $attachment = get_post( $attach_id );

            if( !empty( $attachment->ID ) ) {
                $img_info = array(
                    'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
                );
                if($option_value == '1'){
                    return $img_info;
                }
            }
        }
        return;
    }
}

/* For Image Title */
if ( ! function_exists( 'hcode_option_image_title' ) ) {
    function hcode_option_image_title( $attach_id ){
        global $hcode_theme_settings, $post;
        $option = 'enable_image_title';
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            $img_meta = wp_get_attachment_metadata( $attach_id );
            $attachment = get_post( $attach_id );
            $img_info = array(
                'title' => $attachment->post_title
            );
            if($option_value == '1'){
                return $img_info;
            }else{
                return;
            }
        }
        return;
    }
}

/* For Image Caption */
if ( ! function_exists( 'hcode_option_image_caption' ) ) {
    function hcode_option_image_caption( $attach_id ){
        global $hcode_theme_settings, $post;
        $option = 'enable_lightbox_caption';
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            $img_meta = wp_get_attachment_metadata( $attach_id );
            $attachment = get_post( $attach_id );
            $img_info = array(
                'caption' => $attachment->post_excerpt,
            );
            if($option_value == '1'){
                return $img_info;
            }else{
                return;
            }
        }
        return;
    }
}

/* For Lightbox Image Title */
if ( ! function_exists( 'hcode_option_lightbox_image_title' ) ) {
    function hcode_option_lightbox_image_title( $attach_id ){
        global $hcode_theme_settings, $post;
        $option = 'enable_lightbox_title';
        if(isset($hcode_theme_settings[$option]) && $hcode_theme_settings[$option] != ''){
            $option_value = $hcode_theme_settings[$option];
            $img_meta = wp_get_attachment_metadata( $attach_id );
            $attachment = get_post( $attach_id );
            $img_info = array(
                'title' => $attachment->post_title
            );
            if($option_value == '1'){
                return $img_info;
            }else{
                return;
            }
        }
        return;
    }
}

if ( ! function_exists( 'hcode_option_url' ) ) {
    function hcode_option_url($option) {
        $image = hcode_option($option);
        if (is_array($image) && isset($image['url']) && !empty($image['url'])) {
            return $image['url'];
        }
        return false;
    }
}

add_action( 'wp_before_admin_bar_render', 'hcode_remove_customizer_adminbar' ); 
if ( ! function_exists( 'hcode_remove_customizer_adminbar' ) ) {
    function hcode_remove_customizer_adminbar() {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('customize');
    }
}

if ( ! function_exists( 'hcode_breadcrumb_li_display' ) ) {
    function hcode_breadcrumb_li_display() {

        if( class_exists( 'WooCommerce' ) && ( is_product_category() || is_tax('product_brand') || is_shop() || is_product_taxonomy() ) ) {// check woocommerce category, brand, shop page

            ob_start();
                do_action('hcode_woocommerce_breadcrumb');
            return ob_get_clean();

        } elseif (class_exists('breadcrumb_navigation_xt')) {
            $hcode_enable_category_breadcrumb = '';
            $hcode_options = get_option( 'hcode_theme_setting' );
            if( is_singular('post') ){
                $hcode_enable_category_breadcrumb = ( isset($hcode_options['hcode_enable_breadcrumb_category']) && $hcode_options['hcode_enable_breadcrumb_category'] == 1 ) ? true : false;
            }elseif( is_singular('portfolio') ){
                $hcode_enable_category_breadcrumb = ( isset($hcode_options['hcode_enable_breadcrumb_category_portfolio']) && $hcode_options['hcode_enable_breadcrumb_category_portfolio'] == 1 ) ? true : false;
            }

            $page_title_show_breadcrumb = true;
            if( is_singular( 'portfolio' ) ) {
                $page_title_show_breadcrumb = ( isset( $hcode_options['hcode_page_breadcrumb_title_show_portfolio'] ) && $hcode_options['hcode_page_breadcrumb_title_show_portfolio'] == 1 ) ? true : false;
            } elseif( is_tax( 'portfolio-category' ) || is_tax( 'portfolio-tags' ) || is_post_type_archive( 'portfolio' ) ) {
                $page_title_show_breadcrumb = ( isset( $hcode_options['hcode_category_page_breadcrumb_title_show'] ) && $hcode_options['hcode_category_page_breadcrumb_title_show'] == 1 ) ? true : false;
            } elseif( is_search() || is_category() || is_archive() ) {
                $page_title_show_breadcrumb = ( isset( $hcode_options['hcode_archive_page_breadcrumb_title_show'] ) && $hcode_options['hcode_archive_page_breadcrumb_title_show'] == 1 ) ? true : false;
            } else {
                $page_title_show_breadcrumb = ( isset( $hcode_options['hcode_page_show_breadcrumb_title'] ) && $hcode_options['hcode_page_show_breadcrumb_title'] == 1 ) ? true : false;
            }

            $hcode_breadcrumb = new breadcrumb_navigation_xt;
            $hcode_breadcrumb->opt['static_frontpage'] = false;
            $hcode_breadcrumb->opt['url_blog'] = '';
            $hcode_breadcrumb->opt['title_blog'] = __('Home','H-Code');
            $hcode_breadcrumb->opt['title_home'] = __('Home','H-Code');
            $hcode_breadcrumb->opt['separator'] = '';
            $hcode_breadcrumb->opt['tag_page_prefix'] = '';
            $hcode_breadcrumb->opt['singleblogpost_category_display'] = $hcode_enable_category_breadcrumb;
            $hcode_breadcrumb->opt['breadcrumb_title_hide'] = $page_title_show_breadcrumb;

            return $hcode_breadcrumb->display();
        }
    }    
}

/* page title option for archive pages*/
if ( ! function_exists( 'hcode_get_title_part_for_archive' ) ) {
    function hcode_get_title_part_for_archive(){

        global $wp_query, $hcode_featured_array;

        $top_header_class = $page_title = '';

        $hcode_options          = get_option( 'hcode_theme_setting' );

        $hcode_enable_header    = hcode_option('hcode_enable_header');
        $hcode_header_layout    = hcode_option('hcode_header_layout');
        $header_logo_position   = hcode_option( 'hcode_header_logo_position' );
        $hcode_enable_mini_header = hcode_option( 'hcode_enable_mini_header' );
        $hcode_enable_mini_header_mobile = hcode_option( 'hcode_enable_mini_header_mobile' );

        if( class_exists( 'WooCommerce' ) && ( is_product_category() || is_tax('product_brand') || is_tax('product_tag') || is_shop() ) ) {// check woocommerce category, brand, shop page

            $enable_title               = hcode_option('hcode_enable_wc_category_title_wrapper');
            $page_title_premade_style   = hcode_option('hcode_wc_category_page_title_premade_style');
            $page_title_image           = hcode_option('hcode_wc_category_title_background');
            $hcode_title_parallax_effect= hcode_option('hcode_wc_category_title_parallax_effect');
            $page_subtitle              = hcode_option('hcode_wc_category_header_subtitle');
            $page_title_show_breadcrumb = hcode_option('hcode_wc_category_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option('hcode_wc_category_page_title_show_separator');
            $hcode_header_layout        = hcode_option('hcode_header_layout_woocommerce');
            $hcode_enable_header        = hcode_option('hcode_enable_header_woocommerce');
            $hcode_category_description = hcode_option('hcode_wc_category_description');
            
            if( hcode_option( 'hcode_header_logo_position_woocommerce' ) ) {
                $header_logo_position       = hcode_option( 'hcode_header_logo_position_woocommerce' );
            }
            
            $enable_title = $enable_title != '' ? $enable_title : '1';
            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-wc-style';
            $page_title_show_breadcrumb = $page_title_show_breadcrumb != '' ? $page_title_show_breadcrumb : '1';
   
        } elseif(is_singular('portfolio')){// check single page for portfolio

            $enable_title               = hcode_option_portfolio('hcode_enable_title_wrapper');
            $page_title_premade_style   = hcode_option_portfolio('hcode_page_title_premade_style');
            $page_title_image           = hcode_option_portfolio('hcode_title_background');
            $hcode_title_parallax_effect= hcode_option_portfolio('hcode_title_parallax_effect');
            $page_subtitle              = hcode_option_portfolio('hcode_header_subtitle');
            $page_title_show_breadcrumb = hcode_option_portfolio('hcode_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option_portfolio('hcode_page_title_show_separator');
                 
            $enable_title = $enable_title != '' ? $enable_title : '1';
            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-small-gray';
            $page_title_show_breadcrumb = $page_title_show_breadcrumb != '' ? $page_title_show_breadcrumb : '1';

            if( class_exists( 'WooCommerce' ) && (is_product() || is_product_category() || is_product_tag()) || is_404()){
                $enable_header = '2';
            }else{
                $enable_header = hcode_option('hcode_enable_header');
            }
            if($enable_header == '1' || $enable_header == '2'){
                $hcode_enable_header = hcode_option('hcode_enable_header');
                $hcode_header_layout = hcode_option('hcode_header_layout');
      

                if($enable_header == '2'){
                    $hcode_options = get_option( 'hcode_theme_setting' );
                    $hcode_enable_header = (isset($hcode_options['hcode_enable_header'])) ? $hcode_options['hcode_enable_header'] : '';
                }
            }
            
        } elseif(is_tax('portfolio-category') || is_tax('portfolio-tags') || is_post_type_archive('portfolio')){// check category, tag page for portfolio

            $enable_title               = hcode_option('hcode_enable_category_title_wrapper');
            $page_title_premade_style   = hcode_option('hcode_category_page_title_premade_style');
            $page_title_image           = hcode_option('hcode_category_title_background');
            $hcode_title_parallax_effect= hcode_option('hcode_category_title_parallax_effect');
            $page_subtitle              = hcode_option('hcode_category_header_subtitle');
            $page_title_show_breadcrumb = hcode_option('hcode_category_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option('hcode_category_page_title_show_separator');
                 
            $enable_title = $enable_title != '' ? $enable_title : '1';
            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-small-gray';
            $page_title_show_breadcrumb = $page_title_show_breadcrumb != '' ? $page_title_show_breadcrumb : '1';

        } elseif(is_search() || is_category() || is_archive()){// check archive, category, search, author page

            $enable_title               = hcode_option('hcode_enable_archive_title_wrapper');
            $page_title_premade_style   = hcode_option('hcode_archive_page_title_premade_style');
            $page_title_image           = hcode_option('hcode_archive_title_background');
            $hcode_title_parallax_effect= hcode_option('hcode_archive_title_parallax_effect');
            $page_subtitle              = hcode_option('hcode_archive_header_subtitle');
            $page_title_show_breadcrumb = hcode_option('hcode_archive_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option('hcode_archive_page_title_show_separator');
            $hcode_header_layout        = hcode_option('hcode_header_layout_general');
            $hcode_enable_header        = hcode_option('hcode_enable_header_general');
            if( hcode_option( 'hcode_header_logo_position_general' ) ) {
                $header_logo_position       = hcode_option( 'hcode_header_logo_position_general' );
            }

            $enable_title = $enable_title != '' ? $enable_title : '1';
            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-small-gray';
            $page_title_show_breadcrumb = $page_title_show_breadcrumb != '' ? $page_title_show_breadcrumb : '1';
  
        } elseif( is_home() ) {// default blog page

            $enable_title               = hcode_option('hcode_enable_blog_title_wrapper');
            $page_title_premade_style   = hcode_option('hcode_blog_page_title_premade_style');
            $page_title_image           = hcode_option('hcode_blog_title_background');
            $hcode_title_parallax_effect= hcode_option('hcode_blog_title_parallax_effect');
            $page_subtitle              = hcode_option('hcode_blog_header_subtitle');
            $page_title_show_breadcrumb = hcode_option('hcode_blog_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option('hcode_blog_page_title_show_separator');
                 
            $enable_title = $enable_title != '' ? $enable_title : '1';
            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-small-gray';
            $page_title_show_breadcrumb = $page_title_show_breadcrumb != '' ? $page_title_show_breadcrumb : '1';
 
        } else {

            $enable_title = hcode_option('hcode_enable_title_wrapper');

            if( $enable_title == '1' ){
                $hcode_options = get_option( 'hcode_theme_setting' );
                $enable_title = ( isset($hcode_options['hcode_enable_title_wrapper']) ) ? $hcode_options['hcode_enable_title_wrapper'] : '';
            }

            $page_title_premade_style   = hcode_option('hcode_page_title_premade_style');
            $page_title_image           = hcode_option('hcode_title_background');
            $hcode_title_parallax_effect= hcode_option('hcode_title_parallax_effect');
            $page_subtitle              = hcode_option('hcode_header_subtitle');
            $page_title_show_breadcrumb = hcode_option('hcode_page_title_show_breadcrumb');
            $page_title_show_separater  = hcode_option('hcode_page_title_show_separator');

            $page_title_premade_style   = !empty( $page_title_premade_style ) ? $page_title_premade_style : 'title-small-gray';

            if( class_exists( 'WooCommerce' ) && (is_product() || is_product_category() || is_product_tag()) || is_404()){
                $enable_header = '2';
            }else{
                $enable_header = hcode_option('hcode_enable_header');
            }
            if($enable_header == '1' || $enable_header == '2'){
                $hcode_enable_header = hcode_option('hcode_enable_header');
                $hcode_header_layout = hcode_option('hcode_header_layout');

                if($enable_header == '2'){
                    $hcode_options = get_option( 'hcode_theme_setting' );
                    $hcode_enable_header = (isset($hcode_options['hcode_enable_header'])) ? $hcode_options['hcode_enable_header'] : '';
                }
            }
        }

        if($enable_title == 0 || is_404()) {
            return;
        }
        
        if( class_exists( 'WooCommerce' ) && ( is_shop() || is_product_category() || is_product_tag() || is_tax( 'product_brand' ) || is_product_taxonomy() ) ) {
            if ( apply_filters( 'woocommerce_show_page_title', true ) ) {
                ob_start();
                    woocommerce_page_title();
                    $page_title .= ob_get_contents();
                ob_end_clean();
            }
        } elseif( is_post_type_archive( 'portfolio' ) ) {
            $page_title .= ( isset( $hcode_options['hcode_portfolio_cat_title'] ) ) ? $hcode_options['hcode_portfolio_cat_title'] : '';
        } elseif( is_search() ) {
            $page_title .= __( 'Search For ', 'H-Code' ).'"'.get_search_query().'"';
        } elseif( is_author() ) {
            $page_title .= get_the_author();
        } elseif( is_archive() ) {
            if ( is_day() ) {
                $page_title .= get_the_date();
            } elseif ( is_month() ) {
                $page_title .= get_the_date( _x( 'F Y', 'monthly archives date format', 'H-Code' ) );
            } elseif ( is_year() ) {
                $page_title .= get_the_date( _x( 'Y', 'yearly archives date format', 'H-Code' ) );
            }
            $page_title .= single_cat_title( '', false );
        } elseif( is_home() ) {
            $page_title .= ( isset( $hcode_options['hcode_blog_page_title'] ) ) ? $hcode_options['hcode_blog_page_title'] : '';
        } else {
            $page_title .= get_the_title();
        }

        $page_title_image_id = '';
        if( is_array( $page_title_image ) ) {
            $page_title_image_id = $page_title_image['id'];
            $page_title_image = $page_title_image['url'];
        }

        $hcode_bg_page_title_color = hcode_option('hcode_bg_page_title_color');
        $hcode_bg_page_title_opacity = hcode_option('hcode_bg_page_title_opacity');
        $hcode_page_title_title_color = hcode_option('hcode_page_title_title_color');
        $hcode_page_title_subtitle_color = hcode_option('hcode_page_title_subtitle_color');
        $hcode_page_title_sep_color = hcode_option('hcode_page_title_sep_color');
        $hcode_page_title_breadcrumb_color = hcode_option('hcode_page_title_breadcrumb_color');
        $hcode_page_title_breadcrumb_hover_color = hcode_option('hcode_page_title_breadcrumb_hover_color');

        !empty( $hcode_bg_page_title_color ) ? $hcode_featured_array[] = '.page-title-section, .page-title-default-bg { background-color: '.$hcode_bg_page_title_color.'}' : '';

        !empty( $hcode_bg_page_title_opacity ) ? $hcode_featured_array[] = '.page-title-default-bg { opacity: '.$hcode_bg_page_title_opacity.'}' : '';

        !empty( $hcode_page_title_title_color ) ? $hcode_featured_array[] = '.page-title-section h1 { color: '.$hcode_page_title_title_color.'}' : '';

        !empty( $hcode_page_title_subtitle_color ) ? $hcode_featured_array[] = '.page-title-section span { color: '.$hcode_page_title_subtitle_color.'}' : '';

        !empty( $hcode_page_title_sep_color ) ? $hcode_featured_array[] = '.page-title-section .separator-line { background-color: '.$hcode_page_title_sep_color.'}' : '';

        !empty( $hcode_page_title_breadcrumb_color ) ? $hcode_featured_array[] = '.page-title-section ul li a, .page-title-section ul li { color: '.$hcode_page_title_breadcrumb_color.'}' : '';

        !empty( $hcode_page_title_breadcrumb_hover_color ) ? $hcode_featured_array[] = '.page-title-section ul li a:hover { color: '.$hcode_page_title_breadcrumb_hover_color.'}' : '';

        $output = '';

        switch ($page_title_premade_style) {
            case 'title-white':

                echo '<section class="page-title-section page-title border-bottom-light border-top-light bg-white">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 slideInUp wow" data-wow-duration="300ms">';
                                    if($page_title){
                                        echo '<h1 class="black-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-black no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase sm-no-margin-top wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-gray-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;

            case 'title-gray':
                
                echo '<section class="page-title-section page-title bg-gray">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 slideInUp wow" data-wow-duration="300ms">';
                                    if($page_title){
                                        echo '<h1 class="black-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-black no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase sm-no-margin-top wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-gray-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;

            case 'title-dark-gray':
                
                echo '<section class="page-title-section page-title bg-dark-gray">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 slideInUp wow" data-wow-duration="300ms">';
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="white-text xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase sm-no-margin-top wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-white-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;

            case 'title-black':

                echo '<section class="page-title-section page-title bg-black">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 slideInUp wow" data-wow-duration="300ms">';
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="white-text xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase sm-no-margin-top wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-white-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-with-image':
                
                $image_url = $page_title_image ;
                if( esc_url( $image_url ) ) {
                    if( $page_title_image_id ) {
                        $img_id = $page_title_image_id;
                    } else {
                        $img_id = hcode_get_attachment_id_from_url( $image_url  );
                    }
                    $hcode_srcset = $hcode_srcset_data = $hcode_srcset_classes = $hcode_image_url = '';
                    $hcode_srcset = wp_get_attachment_image_srcset( $img_id, 'full' );
                    if( $hcode_srcset ){
                        $hcode_srcset_data = ' data-bg-srcset="'.esc_attr( $hcode_srcset ).'"';
                        $hcode_srcset_classes = ' bg-image-srcset';
                    }

                    $hcode_image_url = wp_get_attachment_image_src( $img_id, 'full' );

                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.$hcode_srcset_classes.' parallax-fix" style="background: url('.$hcode_image_url[0].'); background-position: 50% 0%;"'.$hcode_srcset_data.'>';
                } else {
                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.' parallax-fix">';
                }
                    echo '<div class="page-title-default-bg opacity-medium bg-black"></div>';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 slideInUp wow" data-wow-duration="300ms">';
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="white-text xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase sm-no-margin-top wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-white-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-large':

                $image_url = $page_title_image ;

                if( esc_url( $image_url ) ) {
                    if( $page_title_image_id ) {
                        $img_id = $page_title_image_id;
                    } else {
                        $img_id = hcode_get_attachment_id_from_url( $image_url  );
                    }
                    $hcode_srcset = $hcode_srcset_data = $hcode_srcset_classes = '';
                    $hcode_srcset = wp_get_attachment_image_srcset( $img_id, 'full' );
                    if( $hcode_srcset ){
                        $hcode_srcset_data = ' data-bg-srcset="'.esc_attr( $hcode_srcset ).'"';
                        $hcode_srcset_classes = ' bg-image-srcset';
                    }
                    $hcode_image_url = wp_get_attachment_image_src($img_id, 'full' );
                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.$hcode_srcset_classes.' parallax-fix page-title-large" style="background: url('.$image_url.'); background-position: 50% 0%;"'.$hcode_srcset_data.'>';
                } else {
                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.' parallax-fix page-title-large">';
                }
                    echo '<div class="page-title-default-bg opacity-medium bg-black"></div>';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            echo '<div class="col-md-12 col-sm-12 text-center animated fadeInUp">';
                                if($page_title != '' || $page_subtitle != ''){
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line bg-yellow no-margin-top margin-four"></div>';
                                    }
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="white-text">'.$page_subtitle.'</span>';
                                    }
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;
            case 'title-large-without-overlay':

                $image_url = $page_title_image ;

                if( esc_url( $image_url ) ) {
                    if( $page_title_image_id ) {
                        $img_id = $page_title_image_id;
                    } else {
                        $img_id = hcode_get_attachment_id_from_url( $image_url  );
                    }
                    $hcode_srcset = $hcode_srcset_data = $hcode_srcset_classes = '';
                    $hcode_srcset = wp_get_attachment_image_srcset( $img_id, 'full' );
                    if( $hcode_srcset ){
                        $hcode_srcset_data = ' data-bg-srcset="'.esc_attr( $hcode_srcset ).'"';
                        $hcode_srcset_classes = ' bg-image-srcset';
                    }
                    $hcode_image_url = wp_get_attachment_image_src($img_id, 'full' );
                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.$hcode_srcset_classes.' parallax-fix page-title-large" style="background: url('.$image_url.'); background-position: 50% 0%;"'.$hcode_srcset_data.'>';
                } else {
                    echo '<section class="page-title-section page-title '.$hcode_title_parallax_effect.' parallax-fix page-title-large">';
                }
                    echo '<div class="container">';
                        echo '<div class="row">';
                            echo '<div class="col-md-12 col-sm-12 text-center animated fadeInUp">';
                                if($page_title != '' || $page_subtitle != ''){
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line bg-yellow no-margin-top margin-four"></div>';
                                    }
                                    if($page_title){
                                        echo '<h1 class="black-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="text-uppercase gray-text">'.$page_subtitle.'</span>';
                                    }
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;
            case 'title-small-white':

                echo '<section class="page-title-section page-title page-title-small border-bottom-light border-top-light bg-white">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 animated fadeInUp">';
                                    
                                    if($page_title){
                                        echo '<h1 class="black-text">'.$page_title.'</h1>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-black no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-gray-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';
                break;
            case 'title-small-gray':

                echo '<section class="page-title-section page-title page-title-small bg-gray">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 animated fadeInUp">';
                                    
                                    if($page_title){
                                        echo '<h1 class="black-text">'.$page_title.'</h1>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-black no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-gray-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-small-dark-gray':

                echo '<section class="page-title-section page-title page-title-small bg-dark-gray border-bottom-light border-top-light">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 animated fadeInUp">';
                                    
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-white-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-small-black':

                echo '<section class="page-title-section page-title page-title-small bg-black border-bottom-light border-top-light">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != ''){
                                echo '<div class="col-lg-8 col-md-7 col-sm-12 animated fadeInUp">';
                                    
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white no-margin-lr sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                            if($page_title_show_breadcrumb == 1){
                                echo '<div class="col-lg-4 col-md-5 col-sm-12 breadcrumb text-uppercase wow fadeInUp xs-display-none" data-wow-duration="600ms">';
                                    echo '<ul class="breadcrumb-white-text">';
                                        echo hcode_breadcrumb_li_display();
                                    echo '</ul>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-center-align':

                echo '<section class="page-title-section page-title bg-black border-bottom-light border-top-light">';
                    echo '<div class="container">';
                        echo '<div class="row">';
                            if($page_title != '' || $page_subtitle != ''){
                                echo '<div class="col-md-12 col-sm-12 animated text-center fadeInUp">';
                                    
                                    if($page_title){
                                        echo '<h1 class="white-text">'.$page_title.'</h1>';
                                    }
                                    if($page_subtitle){
                                        echo '<span class="white-text xs-display-none">'.$page_subtitle.'</span>';
                                    }
                                    if($page_title_show_separater == 1){
                                        echo '<div class="separator-line margin-three bg-white sm-margin-top-three sm-margin-bottom-three no-margin-bottom xs-display-none"></div>';
                                    }
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</section>';

                break;
            case 'title-wc-style':
                if( class_exists( 'WooCommerce' ) ) {
                    if( is_shop() ) {
                        
                        $description = $page_subtitle;

                        // get the image URL
                        $image_url = $page_title_image;
                        if( esc_url( $image_url ) ) {
                            if( $page_title_image_id ) {
                                $img_id = $page_title_image_id;
                            } else {
                                $img_id = hcode_get_attachment_id_from_url( $image_url  );
                            }
                            $hcode_srcset = $hcode_srcset_data = $hcode_srcset_classes = '';
                            $hcode_srcset = wp_get_attachment_image_srcset( $img_id, 'full' );
                            if( $hcode_srcset ){
                                $hcode_srcset_data = ' data-bg-srcset="'.esc_attr( $hcode_srcset ).'"';
                                $hcode_srcset_classes = ' bg-image-srcset';
                            }
                            $hcode_image_url = wp_get_attachment_image_src($img_id, 'full' );
                            echo '<section class="page-title-section page-title parallax3 parallax-fix page-title-large page-title-shop'.$hcode_srcset_classes.'" style="background: url('.esc_url( $hcode_image_url[0] ).');"'.$hcode_srcset_data.'>';
                        } else {
                            echo '<section class="page-title-section page-title parallax3 parallax-fix page-title-large page-title-shop">';
                        }

                        echo '<div class="page-title-default-bg opacity-light bg-dark-gray"></div>
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12 col-sm-12 wow fadeIn">';
                                        if ( ! empty( $description ) ) {
                                            echo '<span class="text-uppercase white-text">'.$description.'</span>';
                                        }
                                        echo '<h1 class="white-text">' . $page_title . '</h1>';
                        echo '</div>';
                                    if( $page_title_show_breadcrumb ):
                                        echo '<div class="col-md-12 col-sm-12 breadcrumb text-uppercase margin-three no-margin-bottom wow fadeIn">';
                                            echo '<ul class="woocommerce-breadcrumb-main breadcrumb-white-text">';
                                                echo hcode_breadcrumb_li_display();
                                            echo '</ul>
                                        </div>';
                                    endif;
                        echo '</div>
                            </div>
                                </section>';
                    } else {
                        
                        // get the query object
                        $product_category       = $wp_query->get_queried_object();

                        // get the thumbnail id user the term_id
                        $thumbnail_id           = get_term_meta( $product_category->term_id, 'thumbnail_id', true );

                        // get the image URL
                        $product_category_image = !empty( $thumbnail_id ) ? $thumbnail_id : $page_title_image_id;
                        
                        // get the subline / description
                        $description            = get_queried_object()->description;
                        $description            = !empty( $description ) && !is_shop() ? $description : $page_subtitle;

                        
                        if( $product_category_image ) {
                            $img_id = $product_category_image;
                            $hcode_srcset = $hcode_srcset_data = $hcode_srcset_classes = '';
                            $hcode_srcset = wp_get_attachment_image_srcset( $img_id, 'full' );
                            if( $hcode_srcset ){
                                $hcode_srcset_data = ' data-bg-srcset="'.esc_attr( $hcode_srcset ).'"';
                                $hcode_srcset_classes = ' bg-image-srcset';
                            }
                            $hcode_image_url = wp_get_attachment_image_src($img_id, 'full' );
                            echo '<section class="page-title-section page-title parallax3 parallax-fix page-title-large page-title-shop'.$hcode_srcset_classes.'" style="background: url('.esc_url( $hcode_image_url[0] ).'); background-position: 50% 0%;"'.$hcode_srcset_data.'>';
                        } else {
                            echo '<section class="page-title-section page-title parallax3 parallax-fix page-title-large page-title-shop">';
                        }

                            echo '<div class="opacity-light bg-dark-gray"></div>';
                            echo '<div class="container">';
                                echo '<div class="row">';
                                    echo '<div class="col-md-12 col-sm-12 wow fadeIn">';
                                        if ( ! empty( $description ) && $hcode_category_description == 1 ) {
                                            echo '<span class="text-uppercase white-text">'.$description.'</span>';
                                        }
                                        if( $page_title ) {
                                            echo '<h1 class="white-text">'.$page_title.'</h1>';
                                        }
                                    echo '</div>';
                                    if( $page_title_show_breadcrumb ):
                                        echo '<div class="col-md-12 col-sm-12 breadcrumb text-uppercase margin-three no-margin-bottom wow fadeIn">';
                                            echo '<ul class="woocommerce-breadcrumb-main breadcrumb-white-text">';
                                                echo hcode_breadcrumb_li_display();
                                            echo '</ul>
                                        </div>';
                                    endif;
                                echo '</div>';
                            echo '</div>';
                        echo '</section>';
                    }
                }

                break;
        }
    }
}

if ( ! function_exists( 'hcode_categories_postcount_filter' ) ) {
    function hcode_categories_postcount_filter ($variable) {
       $variable = str_replace('(', '<span class="light-gray-text">/ ', $variable);
       $variable = str_replace(')', '</span>', $variable);
       return $variable;
    }
}
add_filter('wp_list_categories','hcode_categories_postcount_filter');

add_filter('wp_list_categories', 'hcode_add_new_class_list_categories');
if ( ! function_exists( 'hcode_add_new_class_list_categories' ) ) {
    function hcode_add_new_class_list_categories($list) {
        $list = str_replace('cat-item ', 'cat-item widget-category-list light-gray-text ', $list); 
        return $list;
    }
}

add_filter('get_archives_link', 'hcode_archive_count_no_brackets');
if ( ! function_exists( 'hcode_archive_count_no_brackets' ) ) {
    function hcode_archive_count_no_brackets($links) {
        $links = str_replace('(', '<span class="light-gray-text">/ ', $links);
        $links = str_replace(')', '</span>', $links);
        return $links;
    }
}
add_filter('get_archives_link', 'hcode_add_new_class_list_archives');
if ( ! function_exists( 'hcode_add_new_class_list_archives' ) ) {
    function hcode_add_new_class_list_archives($list) {
        $list = str_replace('<li>', '<li class="widget-category-list"> ', $list); 
        return $list;
    }
}

if ( ! function_exists( 'hcode_wp_tag_cloud_filter' ) ) {
    function hcode_wp_tag_cloud_filter($return, $args)
    {
      return '<div class="tags_cloud tags">'.$return.'</div>';
    }
}
add_filter('wp_tag_cloud','hcode_wp_tag_cloud_filter', 10, 2);
/*  comment form customization   */

if ( ! function_exists( 'hcode_theme_comment' ) ) {
    function hcode_theme_comment($comment, $args, $depth) {
        
        $GLOBALS['comment'] = $comment;
        extract($args, EXTR_SKIP);

        if ( 'div' == $args['style'] ) {
            $tag = 'div';
            $add_below = 'comment';
        } else {
            $tag = 'li';
            $add_below = 'div-comment';
        }
            
    ?>
        <<?php echo esc_html( $tag ) ?> <?php comment_class( empty( $args['has_children'] ) ? 'blog-comment' : 'blog-comment parent' ) ?> id="comment-<?php comment_ID() ?>">
        <?php if ( 'div' != $args['style'] ) : ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
        <?php endif; ?>
            
        <?php if ( $comment->comment_approved == '0' ) : ?>
            <em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'H-Code' ); ?></em>
            <br />
        <?php endif; ?>
        <div class="comment-author vcard comment-avtar">
            <?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] );   ?>
        </div>
        <div class="comment-right comment-text overflow-hidden position-relative">
                <div class="blog-date no-padding-top">
                    <div class="comment-meta commentmetadata">
                            <?php 
                                $comment_author_url  = get_comment_author_url( $comment );
                                if ( !empty( $comment_author_url ) ) {
                            ?>
                                <a rel="external nofollow" href="<?php echo get_comment_author_url( $comment ); ?>">
                            <?php }
                            
                            printf( esc_html__( '%s, ', 'H-Code' ), get_comment_author( $comment ) );
                            
                            if ( !empty( $comment_author_url ) ) { ?>
                            </a>
                            <?php } ?>
                            
                            <?php
                            /* translators: comment date */
                            printf( esc_html__('%s','H-Code'), get_comment_date( '', $comment ) );
                            ?>
                            
                            <?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                    </div>
                </div>
                <?php comment_text(); ?>
        </div>
        <?php if ( 'div' != $args['style'] ) : ?>
        </div>
        <?php endif; ?>
    <?php
    }
}

// filter to replace class on reply link
add_filter('comment_reply_link', 'hcode_replace_reply_link_class');
if ( ! function_exists( 'hcode_replace_reply_link_class' ) ) {
    function hcode_replace_reply_link_class($class){
        $class = str_replace( "class='comment-reply-link", "class='comment-reply-link comment-reply inner-link bg-black", $class );
        return $class;
    }
}

add_filter('the_category', 'hcode_the_category');
if ( ! function_exists( 'hcode_the_category' ) ) {
    function hcode_the_category($cat_list)
    {
        return str_ireplace('<a', '<a class="white-text"', $cat_list);
    }
}

if ( ! function_exists( 'hcode_get_attachment_id_from_url' ) ) {
    function hcode_get_attachment_id_from_url($image_url) {
        global $wpdb;
        $image = '';
        $attachment = false;
        if ( '' == $image_url )
                return;

        $upload_dir_paths = wp_upload_dir();
        
        if ( false !== strpos( $image_url, $upload_dir_paths['baseurl'] ) ) {

            // Remove the upload path base directory from the attachment URL
            $image_url = str_replace( $upload_dir_paths['baseurl'] . '/', '', $image_url );

            $attachment = $wpdb->get_var( $wpdb->prepare( "SELECT hcodeposts.ID FROM $wpdb->posts hcodeposts, $wpdb->postmeta hcodepostmeta WHERE hcodeposts.ID = hcodepostmeta.post_id AND hcodepostmeta.meta_key = '_wp_attached_file' AND hcodepostmeta.meta_value = '%s' AND hcodeposts.post_type = 'attachment'", $image_url ) );
        }
        return $attachment;
    }
}

/* Post Navigation */
if ( ! function_exists( 'hcode_single_post_navigation' ) ) :
    function hcode_single_post_navigation() {
        if( is_singular( 'post' ) ) {

            $link = '';
            // no image
            $hcode_options = get_option( 'hcode_theme_setting' );
            $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
            $hcode_post_pagination_type = ( isset( $hcode_options['hcode_post_pagination_type'] ) ) ? $hcode_options['hcode_post_pagination_type'] : 'category';

            if( $hcode_post_pagination_type == 'post_tag' || $hcode_post_pagination_type == 'category' ){

                if( $hcode_post_pagination_type == 'category' ){
                    $cat = get_the_category(); 
                    $current_cat_id = $cat[0]->cat_ID;
                    $link = get_category_link( $current_cat_id );

                    $args = array( 
                        'category' => $current_cat_id,
                        'posts_per_page' => -1,
                    );
                } else {
                    $tags = get_the_tags();
                    $current_tag_id = $tags[0]->term_id;
                    $link = get_tag_link( $current_tag_id );                    
                    $args = array( 
                        'tag_id' => $current_tag_id,
                        'posts_per_page' => -1,
                    );
                }

                $posts = get_posts( $args );

                // get IDs of posts retrieved from get_posts
                $ids = array();
                foreach ( $posts as $thepost ) {
                    $ids[] = $thepost->ID;
                }
            
                $thisindex = array_search( get_the_ID(), $ids );

                if( ( $thisindex - 1 ) < 0 ) {
                    $previd = '';
                } else {
                    $previd = $ids[ $thisindex - 1 ];
                }

                if( ( $thisindex + 1 ) > count( $ids ) - 1 ) {
                    $nextid = '';
                } else {
                    $nextid = $ids[ $thisindex + 1 ];
                }
            } else {
                $previd = '';
                $nextid = '';

                $prev_post = get_previous_post();
                if( !empty( $prev_post ) ) {
                  $previd = $prev_post->ID;
                }

                $next_post = get_next_post();
                if( !empty( $next_post ) ) {
                  $nextid = $next_post->ID;
                }

                $cat = get_the_category();
                if( !empty( $cat ) ) {
                    $current_cat_id = $cat[0]->cat_ID;
                    $link = get_category_link( $current_cat_id );   
                }
            }

            $related_post_style = hcode_option( 'enable_navigation_style' );    
            
            if( $related_post_style == 'normal' ){ 

                echo '<div class="next-previous-project-style2" role="navigation">';
                    echo '<div class="previous-link">';
                        if ( ! empty( $previd) ) {
                            echo '<a rel="prev" class="border-right" href="'.get_permalink( $previd ).'">';
                                echo '<i class="fa-solid fa-angle-left"></i>&nbsp;<span>'.esc_html__( "Previous Post", "H-Code" ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                    echo '<div class="back-to-category">';
                        $navigation_post_category_link = ( isset( $hcode_options['navigation_post_category_link'] ) ) ? $hcode_options['navigation_post_category_link'] : '';
                        $navigation_post_category_link_target = ( isset( $hcode_options['navigation_post_category_link_target'] ) ) ? $hcode_options['navigation_post_category_link_target'] : '_self';

                        if( $navigation_post_category_link ) {
                            echo '<a href="'.esc_url( $navigation_post_category_link ).'" class="text-uppercase back-project" target="'.$navigation_post_category_link_target.'">';
                                echo '<i class="fa-solid fa-th-large"></i>';
                            echo '</a>';
                        } else {
                            if( $link ) {
                                echo '<a href="'.esc_url( $link ).'" class="text-uppercase back-project" target="'.$navigation_post_category_link_target.'">';
                                    echo '<i class="fa-solid fa-th-large"></i>';
                                echo '</a>';
                            }
                        }
                    echo '</div>';
                    echo '<div class="next-link">';
                        if ( ! empty( $nextid ) ) {
                            echo '<a rel="next" class="border-left-1px" href="'.get_permalink( $nextid ).'">';
                                echo '<span>'.esc_html__( "Next Post", "H-Code" ).'</span>&nbsp;<i class="fa-solid fa-angle-right"></i>';
                            echo '</a>';
                        }
                    echo '</div>';
                echo '</div>';
            }
            
            if( $related_post_style == 'modern' ) {

                $navigation_image_srcset  = !empty( $hcode_options['navigation_image_srcset'] ) ? $hcode_options['navigation_image_srcset'] : 'full';
                echo '<div class="next-previous-project xs-display-none">';
                    if ( $nextid ) {
                        echo '<div class="next-project">';
                            echo '<a rel="next" href="'.get_permalink( $nextid ).'">';

                                $next_project_img = HCODE_THEME_ASSETS . '/images/next-project.png';
                                if( file_exists( $next_project_img ) ) {
                                    echo '<img alt="'.__( "Next Post", "H-Code" ).'" class="next-project-img" src="'.HCODE_THEME_ASSETS_URI.'/images/next-project.png" width="33" height="83">';
                                }
                                echo '<span>'.esc_html__( 'Next Post', 'H-Code' ).'</span>';

                                if ( $nextid &&  has_post_thumbnail( $nextid ) ) {
                                    echo get_the_post_thumbnail( $nextid, $navigation_image_srcset );
                                } else {
                                    $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                                    if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                        echo wp_get_attachment_image( $hcode_no_image['id'], $navigation_image_srcset );
                                    } else {
                                        $default_img = HCODE_THEME_ASSETS . '/images/no-image-133x83.jpg';
                                        if( file_exists( $default_img ) ) {
                                            echo '<img src="'.HCODE_THEME_ASSETS_URI.'/images/no-image-133x83.jpg" width="133" height="83"  alt="'.esc_html__( 'No Image', 'H-Code' ).'" />';
                                        }
                                    }
                                }
                            echo '</a>';
                        echo '</div>';
                    }
                    if( $previd ) {
                        echo '<div class="previous-project">';
                            echo '<a rel="prev" href="'.get_permalink( $previd ).'">';
                                if ( $previd &&  has_post_thumbnail( $previd ) ) {
                                    echo get_the_post_thumbnail( $previd, $navigation_image_srcset );
                                } else {

                                    $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                                    if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                        echo wp_get_attachment_image( $hcode_no_image['id'], $navigation_image_srcset );
                                    } else {
                                        $default_img = HCODE_THEME_ASSETS . '/images/no-image-133x83.jpg';
                                        if( file_exists( $default_img ) ) {
                                            echo '<img src="'.HCODE_THEME_ASSETS_URI.'/images/no-image-133x83.jpg" width="133" height="83"  alt="'.esc_html__( 'No Image', 'H-Code' ).'" />';
                                        }
                                    }
                                }
                                $previous_project_img = HCODE_THEME_ASSETS . '/images/previous-project.png';
                                if( file_exists( $previous_project_img ) ) {
                                    echo '<img alt="'.__( "Previous Post", "H-Code" ).'" class="previous-project-img" src="'.HCODE_THEME_ASSETS_URI.'/images/previous-project.png" width="33" height="83">';
                                }
                                echo '<span>'.esc_html__( 'Previous Post','H-Code' ).'</span>';
                            echo '</a>';
                        echo '</div>';
                    }
                echo '</div>';
            }
        } else {
            return;
        }
    }
endif;

/* Portfolio Navigation */
if ( ! function_exists( 'hcode_single_portfolio_navigation' ) ) :
    function hcode_single_portfolio_navigation() {
        $hcode_options = get_option( 'hcode_theme_setting' );
        $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
        $hcode_portfolio_pagination_type = ( isset( $hcode_options['hcode_portfolio_pagination_type'] ) ) ? $hcode_options['hcode_portfolio_pagination_type'] : '';

        $link = $previd = $nextid = $next_image = $prev_image = $thumb_icon = $thumb_icon_next = '';

        if( $hcode_portfolio_pagination_type == 'portfolio-tags' || $hcode_portfolio_pagination_type == 'portfolio-category' ){
            if( isset( $hcode_no_image['url'] ) ) {
                $image_thumb = $hcode_no_image['url'];
            } else {
                $image_thumb = '';
            }

            $terms = get_the_terms( get_the_ID() , $hcode_portfolio_pagination_type );
            
            if( empty($terms) ) {
                return;
            }

            $link = get_term_link( $terms[0]->slug, $hcode_portfolio_pagination_type );

            $args = array( 
                'post_type' => 'portfolio',
                'posts_per_page' => -1,
                'tax_query' => array(
                    array(
                        'taxonomy' => $hcode_portfolio_pagination_type,
                        'terms' => array( $terms[0]->term_id ),
                        'field' => 'term_id',
                        'operator' => 'IN',
                    ),
                ),
                'meta_query' => array(
                    array(
                        'key'       => 'hcode_enable_ajax_popup_single',
                        'value'     => 'yes',
                        'compare'   => '!=',
                    )
                )
            );
            $posts = get_posts( $args );
            
            $ids = array();
            foreach ( $posts as $thepost ) {
                $ids[] = $thepost->ID;
            }

            $thisindex = array_search( get_the_ID(), $ids );
            if( ( $thisindex - 1 ) < 0 ) {
                $previd = '';
            } else {
                $previd = $ids[ $thisindex - 1 ];
            }
            if( ( $thisindex + 1 ) > count( $ids ) - 1 ) {
                $nextid = '';
            } else {
                $nextid = $ids[ $thisindex + 1 ];
            }

        } else {

            $prev_post = get_previous_post();
            if( !empty( $prev_post ) ) {
              $previd = $prev_post->ID;
            }

            $next_post = get_next_post();
            if( !empty( $next_post ) ) {
              $nextid = $next_post->ID;
            }

            $terms = get_the_terms( get_the_ID() , 'portfolio-category' );
            if( !empty( $terms ) ) {
                $link = get_term_link( $terms[0]->slug, 'portfolio-category' );
            }
        }

        $related_portfolio_style = hcode_option( 'enable_navigation_portfolio_style' );

        if( $related_portfolio_style == 'normal' ) {
            echo '<div class="next-previous-project-style2" role="navigation">';
                echo '<div class="previous-link">';
                    if ( $previd ) {
                        echo '<a rel="prev" class="border-right" href="'.get_permalink( $previd ).'"><i class="fa-solid fa-angle-left"></i>&nbsp;<span>'.esc_html__( "Previous Project", "H-Code" ).'</span></a>';
                    }
                echo '</div>';
                echo '<div class="back-to-category">';
                    $navigation_portfolio_category_link = ( isset( $hcode_options['navigation_portfolio_category_link'] ) ) ? $hcode_options['navigation_portfolio_category_link'] : '';
                    $navigation_portfolio_category_link_target = ( isset( $hcode_options['navigation_portfolio_category_link_target'] ) ) ? $hcode_options['navigation_portfolio_category_link_target'] : '_self';

                    if( $navigation_portfolio_category_link ) {
                        echo '<a href="'.esc_url( $navigation_portfolio_category_link ).'" class="text-uppercase back-project" target="'.$navigation_portfolio_category_link_target.'">';
                            echo '<i class="fa-solid fa-th-large"></i>';
                        echo '</a>';
                    } else {
                        if( $link ) {
                            echo '<a href="'.esc_url( $link ).'" class="border-right text-uppercase back-project" target="'.$navigation_portfolio_category_link_target.'"><i class="fa-solid fa-th-large"></i></a>';
                        }
                    }
                echo '</div>';
                echo '<div class="next-link">';
                    if( $nextid ) {
                        echo '<a rel="next" class="border-left-1px" href="'.get_permalink( $nextid ).'"><span>'.esc_html__( "Next Project", "H-Code" ).'</span>&nbsp;<i class="fa-solid fa-angle-right"></i></a>';
                    }
                echo '</div>';
            echo '</div>';
        }
        
        if( $related_portfolio_style == 'modern' ) {

            $portfolio_navigation_image_srcset = !empty( $hcode_options['portfolio_navigation_image_srcset'] ) ? $hcode_options['portfolio_navigation_image_srcset'] : 'full';
            
            echo '<div class="next-previous-project xs-display-none">';
                if ( $nextid ) {
                    echo '<div class="next-project">';
                        echo '<a rel="next" href="'.get_permalink( $nextid ).'">';
                        $next_project_img = HCODE_THEME_ASSETS . '/images/next-project.png';
                        if( file_exists( $next_project_img ) ) {
                            echo '<img alt="'.__( "Next Project", "H-Code" ).'" class="next-project-img" src="'.HCODE_THEME_ASSETS_URI.'/images/next-project.png" width="33" height="83">';
                        }
                        echo '<span>'.esc_html__( 'Next Project', 'H-Code' ).'</span>';
                        
                        if ( $nextid &&  has_post_thumbnail( $nextid ) ) {
                            echo get_the_post_thumbnail( $nextid, $portfolio_navigation_image_srcset );
                        } else {
                            $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                            if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                echo wp_get_attachment_image( $hcode_no_image['id'], $portfolio_navigation_image_srcset );
                            } else {
                                $default_img = HCODE_THEME_ASSETS . '/images/no-image-133x83.jpg';
                                if( file_exists( $default_img ) ) {
                                    echo '<img src="'.HCODE_THEME_ASSETS_URI.'/images/no-image-133x83.jpg" width="133" height="83"  alt="'.esc_html__( 'No Image', 'H-Code' ).'" />';
                                }
                            }
                        }
                        echo '</a>';
                    echo '</div>';
                } 
                if( $previd ) {
                    echo '<div class="previous-project">';
                    echo '<a rel="prev" href="'.get_permalink( $previd ).'">';
                        if ( $previd &&  has_post_thumbnail( $previd ) ) {
                            echo get_the_post_thumbnail( $previd, $portfolio_navigation_image_srcset );
                        } else {
                            $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                            if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                echo wp_get_attachment_image( $hcode_no_image['id'], $portfolio_navigation_image_srcset );
                            } else {
                                $default_img = HCODE_THEME_ASSETS . '/images/no-image-133x83.jpg';
                                if( file_exists( $default_img ) ) {
                                    echo '<img src="'.HCODE_THEME_ASSETS_URI.'/images/no-image-133x83.jpg" width="133" height="83"  alt="'.esc_html__( 'No Image', 'H-Code' ).'" />';
                                }
                            }
                        }
                        $previous_project_img = HCODE_THEME_ASSETS . '/images/previous-project.png';
                        if( file_exists( $previous_project_img ) ) {
                            echo '<img alt="'.__( "Previous Project", "H-Code" ).'" class="previous-project-img" src="'.HCODE_THEME_ASSETS_URI.'/images/previous-project.png" width="33" height="83">';
                        }
                        echo '<span>'.esc_html__( 'Previous Project', 'H-Code' ).'</span>';
                    echo '</a>';
                    echo '</div>';
                }
            echo '</div>';
        }
    }
endif;

/* For Adding Class Into Single Post Pagination*/
if ( ! function_exists( 'hcode_posts_link_next_class' ) ) {
    function hcode_posts_link_next_class($format){
         $format = str_replace('href=', 'class="next" href=', $format);
         return $format;
    }
}
add_filter('next_post_link', 'hcode_posts_link_next_class');

if ( ! function_exists( 'hcode_posts_link_prev_class' ) ) {
    function hcode_posts_link_prev_class($format) {
         $format = str_replace('href=', 'class="previous" href=', $format);
         return $format;
    }
}
add_filter('previous_post_link', 'hcode_posts_link_prev_class');

/* Single blog page related post */
/* Post Navigation */
if ( ! function_exists( 'hcode_single_post_related_posts' ) ) :

    function hcode_single_post_related_posts( $post_type = 'post', $number_posts = '3') {

        $args = $output = $title = '';
        $hcode_options = get_option( 'hcode_theme_setting' ); 
    
        $related_post_image_srcset  = !empty($hcode_options['related_post_image_srcset']) ? $hcode_options['related_post_image_srcset'] : 'full';

        $title = (isset($hcode_options['hcode_related_post_title'])) ? $hcode_options['hcode_related_post_title'] : '';
        $enable_excerpt = (isset($hcode_options['hcode_enable_related_posts_excerpt'])) ? $hcode_options['hcode_enable_related_posts_excerpt'] : '';
        $enable_title   = (isset($hcode_options['hcode_enable_related_posts_title'])) ? $hcode_options['hcode_enable_related_posts_title'] : '';
        $enable_author  = (isset($hcode_options['hcode_enable_related_posts_author'])) ? $hcode_options['hcode_enable_related_posts_author'] : '';
        $enable_date    = (isset($hcode_options['hcode_enable_related_posts_date'])) ? $hcode_options['hcode_enable_related_posts_date'] : '';
        $date_format    = (isset($hcode_options['hcode_related_posts_date_format'])) ? $hcode_options['hcode_related_posts_date_format'] : '';
        $enable_separator = (isset($hcode_options['hcode_enable_related_posts_separator'])) ? $hcode_options['hcode_enable_related_posts_separator'] : '';
        $enable_like    = (isset($hcode_options['hcode_enable_related_posts_like'])) ? $hcode_options['hcode_enable_related_posts_like'] : '';
        $enable_comments= (isset($hcode_options['hcode_enable_related_posts_comments'])) ? $hcode_options['hcode_enable_related_posts_comments'] : '';
        $excerpt_length = (isset($hcode_options['hcode_related_post_excerpt_length'])) ? $hcode_options['hcode_related_post_excerpt_length'] : '';

        $recent_post = new WP_Query();

        if( $number_posts == 0 ) {
            return $recent_post;
        }

        $args = array(
            'category__in'          => wp_get_post_categories( get_the_ID() ),
            'ignore_sticky_posts'   => 0,
            'posts_per_page'        => $number_posts,
            'post__not_in'          => array( get_the_ID() ),
        );

        $recent_post = new WP_Query( $args );
        if ( $recent_post->have_posts() ) {

            $style_setting = '';            
            $enable_comment = hcode_option( 'hcode_enable_post_comment' );

            if( $enable_comment == 1 ) {
                $style_setting = 'border-top xs-no-padding-bottom xs-padding-five-top';
            } else {
                $style_setting = 'xs-no-margin xs-no-padding';
            }
            
            echo '<section class="hcode-related-post-wrapper no-padding clear-both"><div class="container"><div class="row">';
            echo '<div class="wpb_column hcode-column-container col-md-12 no-padding"><div class="hcode-divider '.$style_setting.' margin-five-top padding-five-bottom"></div></div>';
            if( $title ) {
                echo '<div class="col-md-12 col-sm-12 center-col text-center margin-eight no-margin-top xs-padding-ten-top">';
                    echo '<h3 class="blog-single-full-width-h3">'.esc_html( $title ).'</h3>';
                echo '</div>';
            }
            echo '<div class="blog-grid-listing padding-ten-bottom col-md-12 col-sm-12 col-xs-12 no-padding">';
            $i=1;
            while ( $recent_post->have_posts() ) {

                // Added in v1.8
                $hcode_post_classes = $post_image_output = '';
                ob_start();
                    post_class();
                    $hcode_post_classes .= ob_get_contents();
                ob_end_clean();
                $wow_duration = ($i * 300).'ms';
                echo '<div '.$hcode_post_classes.'>';
                    echo '<div class="col-md-4 col-sm-4 col-xs-12 blog-listing no-margin-bottom xs-margin-bottom-ten wow fadeInUp" data-wow-duration="'.$wow_duration.'">';
                    $recent_post->the_post();

                        if ( has_post_thumbnail() ) {
                            $post_image_output .= get_the_post_thumbnail( get_the_ID(), $related_post_image_srcset );
                        } else {

                            $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                            if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                $post_image_output .= wp_get_attachment_image( $hcode_no_image['id'], $related_post_image_srcset );
                            } else {
                                $default_img = HCODE_THEME_ASSETS . '/images/no-image-374x234.jpg';
                                if( file_exists( $default_img ) ) {
                                    $post_image_output .= '<img src="'.HCODE_THEME_ASSETS_URI.'/images/no-image-374x234.jpg" width="374" height="234"  alt="'.esc_html__( 'No Image', 'H-Code' ).'" />';
                                }
                            }
                        }

                        if( $post_image_output ) {
                            echo'<div class="blog-image"><a href="'.get_permalink().'">'.$post_image_output.'</a></div>';
                        }
                        
                        echo'<div class="blog-details no-padding hcode-related-blog">';
                            if( $enable_author == 1 || $enable_date == 1 ) {
                                echo'<div class="blog-date">';
                                    if( $enable_author == 1 ) {
                                        echo esc_html__( 'Posted by ', 'H-Code' );
                                        echo '<span class="author vcard"><a class="url fn n" href='.get_author_posts_url( get_the_author_meta( 'ID' ) ).'>'.get_the_author().'</a></span>';
                                    }
                                    if( $enable_date == 1 ) {
                                        echo ( $enable_author == 1 ? ' | ' : '' ).'<span class="published">'.get_the_date( $date_format, get_the_ID()).'</span><time class="updated display-none" datetime="'.esc_attr( get_the_modified_date( 'c' ) ).'">'.get_the_modified_date( $date_format ).'</time>';
                                    }
                                echo'</div>';
                            }

                            if( $enable_title == 1 ) {
                                echo'<div class="blog-title entry-title"><a href="'.get_permalink().'">'.get_the_title().'</a></div>';
                            }

                            if( $enable_excerpt == 1 ) {
                                echo'<div class="blog-short-description entry-content">'.hcode_get_the_excerpt_theme( $excerpt_length ).'</div>';
                            }

                            if( $enable_separator == 1 ) {
                                echo'<div class="separator-line bg-black no-margin-lr"></div>';
                            }
                            echo '<div class="related-post-bottom-wrapper">';
                            
                                if( $enable_like == 1 ) {
                                    echo get_simple_likes_button( get_the_ID() );
                                }

                                if( $enable_comments == 1 && ( comments_open() || get_comments_number() ) ) {
                                    ob_start();
                                        comments_popup_link( __( '<i class="fa-regular fa-comment"></i>Leave a comment', 'H-Code' ), __( '<i class="fa-regular fa-comment"></i>1 Comment', 'H-Code' ), __( '<i class="fa-regular fa-comment"></i>% Comment(s)', 'H-Code' ), 'comment' );
                                        echo ob_get_contents();  
                                    ob_end_clean();
                                }
                            echo '</div>';
                        echo'</div>';
                    echo  '</div>';
                echo  '</div>';
                $i++;
            }
            wp_reset_postdata();
            echo  '</div>';
            echo '</div></div></section>';
        }
    }
endif;

/* Single Portfolio Related Items */
if ( ! function_exists( 'hcode_single_portfolio_related_posts' ) ) :

    function hcode_single_portfolio_related_posts( $post_type = 'portfolio', $number_posts = '3' ) {
        global $post;
        $args = $output = '';
        $related_post_terms = array();    
        $hcode_options = get_option( 'hcode_theme_setting' ); 
        
        $related_portfolio_image_srcset  = !empty( $hcode_options['related_portfolio_image_srcset'] ) ? $hcode_options['related_portfolio_image_srcset'] : 'full';
        $title = ( isset( $hcode_options['hcode_related_title'] ) ) ? $hcode_options['hcode_related_title'] : '';

        $recent_post = new WP_Query();

        if( $number_posts == 0 ) {
            return $recent_post;
        }
        
        $terms = get_the_terms( get_the_ID() , 'portfolio-category' );

        if( $terms ) {
            foreach ($terms as $key => $value) {
                $related_post_terms[] = $value->term_id;
            }
        }
        $args = array(
            'post_type' => $post_type,
            'posts_per_page' => $number_posts,        
            'post__not_in' => array( get_the_ID() ),
            'tax_query' => array(
                array(
                    'taxonomy' => 'portfolio-category',
                    'terms' => $related_post_terms,
                    'field' => 'term_id',
                ),
            ),
            'meta_query' => array(
                array(
                    'key'       => 'hcode_link_type_single',
                    'value'     => 'ajax-popup',
                    'compare'   => '!=',
                )
            )
        );

        $recent_post = new WP_Query( $args );

        if ( $recent_post->have_posts() ) {
            
            echo '<div class="wpb_column hcode-column-container col-md-12 no-padding"><div class="hcode-divider border-top sm-padding-five-top xs-padding-five-top padding-five-bottom"></div></div><section class="clear-both no-padding-top"><div class="container"><div class="row">';
            if( $title ) {
                echo '<div class="col-md-12 col-sm-12 text-center">';
                    echo '<h3 class="section-title">'.esc_html( $title ).'</h3>';
                echo '</div>';
            }
            echo '<div class="work-3col gutter work-with-title ipad-3col">';
                echo '<div class="col-md-12 grid-gallery overflow-hidden content-section">';
                    echo '<div class="tab-content">';
                        echo '<ul class="grid masonry-items">';
                    while ( $recent_post->have_posts() ) : $recent_post->the_post();
                        // Added in v1.8
                        $hcode_post_classes = '';
                        $hcode_post_class_list = array();
                        $hcode_post_class_list[] = 'portfolio-id-'.get_the_ID().'';
                        ob_start();
                            post_class( $hcode_post_class_list );
                            $hcode_post_classes .= ob_get_contents();
                        ob_end_clean();

                        echo '<li '.$hcode_post_classes.'>';
                            echo '<figure>';
                                $portfolio_subtitle = hcode_post_meta( 'hcode_subtitle' );
                                echo  '<div class="gallery-img">';
                                    echo  '<a href="'.get_permalink().'">';
                                        if ( has_post_thumbnail() ) {
                                            echo get_the_post_thumbnail( get_the_ID(), $related_portfolio_image_srcset );
                                        } else {
                                            $hcode_no_image = ( isset( $hcode_options['hcode_no_image'] ) ) ? $hcode_options['hcode_no_image'] : '';
                                            if( isset( $hcode_no_image['url'] ) && $hcode_no_image['url'] ) {
                                                echo wp_get_attachment_image( $hcode_no_image['id'], $related_portfolio_image_srcset );
                                            } else {
                                                $default_img = HCODE_THEME_ASSETS . '/images/no-image-374x234.jpg';
                                                if( file_exists( $default_img ) ) {
                                                    echo '<img src="' . HCODE_THEME_ASSETS_URI . '/images/no-image-374x234.jpg" width="374" height="234" alt="'.__( 'No Image', 'H-Code' ).'" />';
                                                }
                                            }                                                
                                        }
                                    echo '</a>';
                                echo '</div>';
                                if( get_the_title() || $portfolio_subtitle ) {
                                    echo '<figcaption>';
                                        echo '<h3 class="entry-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
                                        echo '<p>'.esc_html( $portfolio_subtitle ).'</p>';
                                    echo '</figcaption>';
                                }
                            echo '</figure>';
                        echo '</li>';
                    endwhile;
                    wp_reset_postdata();
                        echo '</ul>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
            echo '</div></div></section>';
        }
    }
endif;

if ( ! function_exists( 'hcode_posts_customize' ) ) {
    function hcode_posts_customize($query) {
        $hcode_options = get_option( 'hcode_theme_setting' );
        if( !is_admin() && $query->is_main_query()):
            if( class_exists( 'WooCommerce' ) && ( is_product_category() || is_product_tag() || is_tax( 'product_brand' ) || $query->is_post_type_archive( 'product' ) || is_product_taxonomy() ) ) {
                if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = ''; }
                $hcode_item_per_page = (isset($hcode_options['hcode_category_product_per_page'])) ? $hcode_options['hcode_category_product_per_page'] : '';
                $query->set('posts_per_page', $hcode_item_per_page);
                $query->set('paged', $paged);
            } elseif(is_tax('portfolio-category') || is_post_type_archive('portfolio')) {
                $hcode_item_per_page = (isset($hcode_options['hcode_portfolio_cat_item_per_page'])) ? $hcode_options['hcode_portfolio_cat_item_per_page'] : '';
                $query->set('posts_per_page', $hcode_item_per_page);
            } elseif ((is_category() || is_archive() || is_author() || is_tag())) {
                if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = 1; }
                $hcode_item_per_page = (isset($hcode_options['hcode_general_item_per_page'])) ? $hcode_options['hcode_general_item_per_page'] : '';
                $query->set('posts_per_page', $hcode_item_per_page);
                $query->set('paged', $paged);
            } elseif(is_search()) {
                $search_content_slug = array();
                if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = 1; }
                $hcode_item_per_page = (isset($hcode_options['hcode_general_item_per_page'])) ? $hcode_options['hcode_general_item_per_page'] : '';
                $query->set('posts_per_page', $hcode_item_per_page);
                $query->set('paged', $paged);
                $search_content = (isset($hcode_options['hcode_general_search_content_settings'])) ? $hcode_options['hcode_general_search_content_settings'] : '';
                if( $search_content ){
                    foreach ( $search_content as $key => $value ) {
                        if (strpos( $value, 'only-' ) === 0 ) {
                            $search_content_slug[] = str_replace('only-', '', $value);   
                        }else{
                            $search_content_slug[] = $value;
                        }
                    }
                }
                
                if( !empty($search_content_slug)){
                    $query->set('post_type', $search_content_slug);
                }
            }elseif( is_home() ){
                if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } else if ( get_query_var('page') ) {$paged = get_query_var('page'); } else {$paged = 1; }
                $hcode_item_per_page = (isset($hcode_options['hcode_blog_page_item_per_page'])) ? $hcode_options['hcode_blog_page_item_per_page'] : '';
                $query->set('posts_per_page', $hcode_item_per_page);
                $query->set('paged', $paged);
            }

        endif;
    }
}
add_action('pre_get_posts', 'hcode_posts_customize');

if ( ! function_exists( 'hcode_get_the_excerpt_theme' ) ) {

    function hcode_get_the_excerpt_theme( $length ) {
        return hcode_Excerpt::hcode_get_by_length( $length );
    }
}

if ( ! function_exists( 'hcode_get_the_post_content' ) ) {
    function hcode_get_the_post_content() {
        return apply_filters( 'the_content', get_the_content() );
    }
}

if ( ! function_exists( 'hcode_widgets' ) ) {
    function hcode_widgets() {
        $custom_sidebars = hcode_option('sidebar_creation');
        if (is_array($custom_sidebars)) {
            foreach ($custom_sidebars as $sidebar) {

                if (empty($sidebar)) {
                    continue;
                }

                register_sidebar ( array (
                    'name' => $sidebar,
                    'id' => sanitize_title ( $sidebar ),
                    'before_widget' => '<div id="%1$s" class="custom-widget %2$s">',
                    'after_widget' => '</div>',
                    'before_title'  => '<h5 class="sidebar-title widget-title">',
                    'after_title'   => '</h5><div class="thin-separator-line bg-dark-gray no-margin-lr margin-tb-20px"></div>',
                ) );
            }
        }
    }
}
add_action( 'widgets_init', 'hcode_widgets' );

/* For contact Form 7 select default */
if ( ! function_exists( 'hcode_wpcf7_form_elements' ) ) {
    function hcode_wpcf7_form_elements($html) {
        $text = __("Select Position", "H-Code");
        $html = str_replace('---', '' . $text . '', $html);
        return $html;
    }
}
add_filter('wpcf7_form_elements', 'hcode_wpcf7_form_elements');

/* For Wordpress4.4 move comment textarea bottom */
if ( ! function_exists( 'hcode_move_comment_field_to_bottom' ) ) {
    function hcode_move_comment_field_to_bottom( $fields ) {

        if( class_exists( 'WooCommerce' ) && is_product() ) {
            $comment_field = $fields['comment'];
            unset( $fields['comment'] );
            $fields['comment'] = $comment_field;
        } else {
            $comment_field = $fields['comment'];
            $cookies = $fields['cookies'];
            unset( $fields['comment'] );
            unset( $fields['cookies'] );
            $fields['comment'] = $comment_field;
            $fields['cookies'] = $cookies;
        }
        return $fields;
    }
}
add_filter( 'comment_form_fields', 'hcode_move_comment_field_to_bottom' );

if ( ! function_exists( 'hcode_get_sidebar' ) ) {
    function hcode_get_sidebar( $sidebar_name="0" ){
        if( $sidebar_name != "0" ) {
            dynamic_sidebar( $sidebar_name );
        } else {
            dynamic_sidebar( 'hcode-sidebar-1' );
        }
    }
}

/* Hook For ajax page */
if ( ! function_exists( 'hcode_hook_for_ajax_page' ) ) {
    function hcode_hook_for_ajax_page() {
        
        echo "<script>
        ( function( $ ) {
        'use strict';
            
            var isMobile = false;
            var isiPhoneiPad = false;
            
            if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
                isMobile = true;
            }
            if (/iPhone|iPad|iPod/i.test(navigator.userAgent)) {
                isiPhoneiPad = true;
            }
            $(document).ready(function () {
                $('.owl-dots > .owl-dot').click(function (e) {
                    if ($(e.target).is('.mfp-close')){
                        return;
                    }else{
                        $(this).trigger('to.owl.carousel', [$(this).index(), 300]);
                        return false;
                    }
                });
                $('.owl-nav > .owl-prev').click(function (e) {
                    console.log(e.target);
                    if ($(e.target).is('.mfp-close'))
                        return;
                    return false;
                });
                $('.owl-nav > .owl-next').click(function (e) {
                    if ($(e.target).is('.mfp-close'))
                        return;
                    return false;
                });

                $('.masonry-items').imagesLoaded(function () {
                    $('.masonry-items').isotope({
                        itemSelector: 'li',
                        layoutMode: 'masonry'
                    });
                });
                SetResizeContent();
                SetResizeHeaderMenu();

                if( !isiPhoneiPad || !isMobile ) {
                    $('[data-hover=dropdown]').dropdownHover();
                }
            });

            function SetResizeHeaderMenu() {
                var width = $('nav.navbar').children('div.container').width();
                $('ul.mega-menu-full').each(function () {
                    $(this).css('width', width + 'px');
                });
            }
            function SetResizeContent() {
                var minheight = $(window).height();
                var minwidth = $(window).width();
                $('.full-screen').css('min-height', minheight);
                $('.menu-first-level').each(function () {
                    $(this).find('ul.collapse').removeClass('in');
                    var menu_link = $(this).children('a');
                    var dataurl = menu_link.attr('data-redirect-url');
                    var datadefaulturl = menu_link.attr('data-default-url');
                    if (minwidth >= 992) {
                        $(menu_link).removeAttr('data-toggle');
                        $(this).children('a').attr('href', dataurl);
                    } else {
                        $(menu_link).attr('data-toggle', 'collapse');
                        $(this).children('a').attr('href', datadefaulturl);
                    }
                });
            }
            $(window).resize(function () {
                setTimeout(function () {
                    SetResizeHeaderMenu();
                    SetResizeContent();
                }, 200);
            });

        })( jQuery );
        </script>";

    }
}

/* If Font Icon Not Available add from here */
if ( ! function_exists( 'hcode_fontawesome_icons_solid' ) ) :
    function hcode_fontawesome_icons_solid() {
        $fa_icons_solid = array( "fa-0", "fa-1", "fa-2", "fa-3", "fa-4", "fa-5", "fa-6", "fa-7", "fa-8", "fa-9", "fa-fill-drip", "fa-arrows-to-circle", "fa-circle-chevron-right", "fa-at", "fa-trash-can", "fa-text-height", "fa-user-xmark", "fa-stethoscope", "fa-message", "fa-info", "fa-down-left-and-up-right-to-center", "fa-explosion", "fa-file-lines", "fa-wave-square", "fa-ring", "fa-building-un", "fa-dice-three", "fa-calendar-days", "fa-anchor-circle-check", "fa-building-circle-arrow-right", "fa-volleyball", "fa-arrows-up-to-line", "fa-sort-down", "fa-circle-minus", "fa-door-open", "fa-right-from-bracket", "fa-atom", "fa-soap", "fa-icons", "fa-microphone-lines-slash", "fa-bridge-circle-check", "fa-pump-medical", "fa-fingerprint", "fa-hand-point-right", "fa-magnifying-glass-location", "fa-forward-step", "fa-face-smile-beam", "fa-flag-checkered", "fa-football", "fa-school-circle-exclamation", "fa-crop", "fa-angles-down", "fa-users-rectangle", "fa-people-roof", "fa-people-line", "fa-beer-mug-empty", "fa-diagram-predecessor", "fa-arrow-up-long", "fa-fire-flame-simple", "fa-person", "fa-laptop", "fa-file-csv", "fa-menorah", "fa-truck-plane", "fa-record-vinyl", "fa-face-grin-stars", "fa-bong", "fa-spaghetti-monster-flying", "fa-arrow-down-up-across-line", "fa-spoon", "fa-jar-wheat", "fa-envelopes-bulk", "fa-file-circle-exclamation", "fa-circle-h", "fa-pager", "fa-address-book", "fa-strikethrough", "fa-k", "fa-landmark-flag", "fa-pencil", "fa-backward", "fa-caret-right", "fa-comments", "fa-paste", "fa-code-pull-request", "fa-clipboard-list", "fa-truck-ramp-box", "fa-user-check", "fa-vial-virus", "fa-sheet-plastic", "fa-blog", "fa-user-ninja", "fa-person-arrow-up-from-line", "fa-scroll-torah", "fa-broom-ball", "fa-toggle-off", "fa-box-archive", "fa-person-drowning", "fa-arrow-down-9-1", "fa-face-grin-tongue-squint", "fa-spray-can", "fa-truck-monster", "fa-w", "fa-earth-africa", "fa-rainbow", "fa-circle-notch", "fa-tablet-screen-button", "fa-paw", "fa-cloud", "fa-trowel-bricks", "fa-face-flushed", "fa-hospital-user", "fa-tent-arrow-left-right", "fa-gavel", "fa-binoculars", "fa-microphone-slash", "fa-box-tissue", "fa-motorcycle", "fa-bell-concierge", "fa-pen-ruler", "fa-people-arrows", "fa-mars-and-venus-burst", "fa-square-caret-right", "fa-scissors", "fa-sun-plant-wilt", "fa-toilets-portable", "fa-hockey-puck", "fa-table", "fa-magnifying-glass-arrow-right", "fa-tachograph-digital", "fa-users-slash", "fa-clover", "fa-reply", "fa-star-and-crescent", "fa-house-fire", "fa-square-minus", "fa-helicopter", "fa-compass", "fa-square-caret-down", "fa-file-circle-question", "fa-laptop-code", "fa-swatchbook", "fa-prescription-bottle", "fa-bars", "fa-people-group", "fa-hourglass-end", "fa-heart-crack", "fa-square-up-right", "fa-face-kiss-beam", "fa-film", "fa-ruler-horizontal", "fa-people-robbery", "fa-lightbulb", "fa-caret-left", "fa-circle-exclamation", "fa-school-circle-xmark", "fa-arrow-right-from-bracket", "fa-circle-chevron-down", "fa-unlock-keyhole", "fa-cloud-showers-heavy", "fa-headphones-simple", "fa-sitemap", "fa-circle-dollar-to-slot", "fa-memory", "fa-road-spikes", "fa-fire-burner", "fa-flag", "fa-hanukiah", "fa-feather", "fa-volume-low", "fa-comment-slash", "fa-cloud-sun-rain", "fa-compress", "fa-wheat-awn", "fa-ankh", "fa-hands-holding-child", "fa-asterisk", "fa-square-check", "fa-peseta-sign", "fa-heading", "fa-ghost", "fa-list", "fa-square-phone-flip", "fa-cart-plus", "fa-gamepad", "fa-circle-dot", "fa-face-dizzy", "fa-egg", "fa-house-medical-circle-xmark", "fa-campground", "fa-folder-plus", "fa-futbol", "fa-paintbrush", "fa-lock", "fa-gas-pump", "fa-hot-tub-person", "fa-map-location", "fa-house-flood-water", "fa-tree", "fa-bridge-lock", "fa-sack-dollar", "fa-pen-to-square", "fa-car-side", "fa-share-nodes", "fa-heart-circle-minus", "fa-hourglass-half", "fa-microscope", "fa-sink", "fa-bag-shopping", "fa-arrow-down-z-a", "fa-mitten", "fa-person-rays", "fa-users", "fa-eye-slash", "fa-flask-vial", "fa-hand", "fa-om", "fa-worm", "fa-house-circle-xmark", "fa-plug", "fa-chevron-up", "fa-hand-spock", "fa-stopwatch", "fa-face-kiss", "fa-bridge-circle-xmark", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-ear-deaf", "fa-road-circle-check", "fa-dice-five", "fa-square-rss", "fa-land-mine-on", "fa-i-cursor", "fa-stamp", "fa-stairs", "fa-i", "fa-hryvnia-sign", "fa-pills", "fa-face-grin-wide", "fa-tooth", "fa-v", "fa-bangladeshi-taka-sign", "fa-bicycle", "fa-staff-snake", "fa-head-side-cough-slash", "fa-truck-medical", "fa-wheat-awn-circle-exclamation", "fa-snowman", "fa-mortar-pestle", "fa-road-barrier", "fa-school", "fa-igloo", "fa-joint", "fa-angle-right", "fa-horse", "fa-q", "fa-g", "fa-notes-medical", "fa-temperature-half", "fa-dong-sign", "fa-capsules", "fa-poo-storm", "fa-face-frown-open", "fa-hand-point-up", "fa-money-bill", "fa-bookmark", "fa-align-justify", "fa-umbrella-beach", "fa-helmet-un", "fa-bullseye", "fa-bacon", "fa-hand-point-down", "fa-arrow-up-from-bracket", "fa-folder", "fa-file-waveform", "fa-radiation", "fa-chart-simple", "fa-mars-stroke", "fa-vial", "fa-gauge", "fa-wand-magic-sparkles", "fa-e", "fa-pen-clip", "fa-bridge-circle-exclamation", "fa-user", "fa-school-circle-check", "fa-dumpster", "fa-van-shuttle", "fa-building-user", "fa-square-caret-left", "fa-highlighter", "fa-key", "fa-bullhorn", "fa-globe", "fa-synagogue", "fa-person-half-dress", "fa-road-bridge", "fa-location-arrow", "fa-c", "fa-tablet-button", "fa-building-lock", "fa-pizza-slice", "fa-money-bill-wave", "fa-chart-area", "fa-house-flag", "fa-person-circle-minus", "fa-ban", "fa-camera-rotate", "fa-spray-can-sparkles", "fa-star", "fa-repeat", "fa-cross", "fa-box", "fa-venus-mars", "fa-arrow-pointer", "fa-maximize", "fa-charging-station", "fa-shapes", "fa-shuffle", "fa-person-running", "fa-mobile-retro", "fa-grip-lines-vertical", "fa-spider", "fa-hands-bound", "fa-file-invoice-dollar", "fa-plane-circle-exclamation", "fa-x-ray", "fa-spell-check", "fa-slash", "fa-computer-mouse", "fa-arrow-right-to-bracket", "fa-shop-slash", "fa-server", "fa-virus-covid-slash", "fa-shop-lock", "fa-hourglass-start", "fa-blender-phone", "fa-building-wheat", "fa-person-breastfeeding", "fa-right-to-bracket", "fa-venus", "fa-passport", "fa-heart-pulse", "fa-people-carry-box", "fa-temperature-high", "fa-microchip", "fa-crown", "fa-weight-hanging", "fa-xmarks-lines", "fa-file-prescription", "fa-weight-scale", "fa-user-group", "fa-arrow-up-a-z", "fa-chess-knight", "fa-face-laugh-squint", "fa-wheelchair", "fa-circle-arrow-up", "fa-toggle-on", "fa-person-walking", "fa-l", "fa-fire", "fa-bed-pulse", "fa-shuttle-space", "fa-face-laugh", "fa-folder-open", "fa-heart-circle-plus", "fa-code-fork", "fa-city", "fa-microphone-lines", "fa-pepper-hot", "fa-unlock", "fa-colon-sign", "fa-headset", "fa-store-slash", "fa-road-circle-xmark", "fa-user-minus", "fa-mars-stroke-up", "fa-champagne-glasses", "fa-clipboard", "fa-house-circle-exclamation", "fa-file-arrow-up", "fa-wifi", "fa-bath", "fa-underline", "fa-user-pen", "fa-signature", "fa-stroopwafel", "fa-bold", "fa-anchor-lock", "fa-building-ngo", "fa-manat-sign", "fa-not-equal", "fa-border-top-left", "fa-map-location-dot", "fa-jedi", "fa-square-poll-vertical", "fa-mug-hot", "fa-car-battery", "fa-gift", "fa-dice-two", "fa-chess-queen", "fa-glasses", "fa-chess-board", "fa-building-circle-check", "fa-person-chalkboard", "fa-mars-stroke-right", "fa-hand-back-fist", "fa-square-caret-up", "fa-cloud-showers-water", "fa-chart-bar", "fa-hands-bubbles", "fa-less-than-equal", "fa-train", "fa-eye-low-vision", "fa-crow", "fa-sailboat", "fa-window-restore", "fa-square-plus", "fa-torii-gate", "fa-frog", "fa-bucket", "fa-image", "fa-microphone", "fa-cow", "fa-caret-up", "fa-screwdriver", "fa-folder-closed", "fa-house-tsunami", "fa-square-nfi", "fa-arrow-up-from-ground-water", "fa-martini-glass", "fa-rotate-left", "fa-table-columns", "fa-lemon", "fa-head-side-mask", "fa-handshake", "fa-gem", "fa-dolly", "fa-smoking", "fa-minimize", "fa-monument", "fa-snowplow", "fa-angles-right", "fa-cannabis", "fa-circle-play", "fa-tablets", "fa-ethernet", "fa-euro-sign", "fa-chair", "fa-circle-check", "fa-circle-stop", "fa-compass-drafting", "fa-plate-wheat", "fa-icicles", "fa-person-shelter", "fa-neuter", "fa-id-badge", "fa-marker", "fa-face-laugh-beam", "fa-helicopter-symbol", "fa-universal-access", "fa-circle-chevron-up", "fa-lari-sign", "fa-volcano", "fa-person-walking-dashed-line-arrow-right", "fa-sterling-sign", "fa-viruses", "fa-square-person-confined", "fa-user-tie", "fa-arrow-down-long", "fa-tent-arrow-down-to-line", "fa-certificate", "fa-reply-all", "fa-suitcase", "fa-person-skating", "fa-filter-circle-dollar", "fa-camera-retro", "fa-circle-arrow-down", "fa-file-import", "fa-square-arrow-up-right", "fa-box-open", "fa-scroll", "fa-spa", "fa-location-pin-lock", "fa-pause", "fa-hill-avalanche", "fa-temperature-empty", "fa-bomb", "fa-registered", "fa-address-card", "fa-scale-unbalanced-flip", "fa-subscript", "fa-diamond-turn-right", "fa-burst", "fa-house-laptop", "fa-face-tired", "fa-money-bills", "fa-smog", "fa-crutch", "fa-font-awesome", "fa-cloud-arrow-up", "fa-palette", "fa-arrows-turn-right", "fa-vest", "fa-ferry", "fa-arrows-down-to-people", "fa-seedling", "fa-left-right", "fa-boxes-packing", "fa-circle-arrow-left", "fa-group-arrows-rotate", "fa-bowl-food", "fa-candy-cane", "fa-arrow-down-wide-short", "fa-cloud-bolt", "fa-text-slash", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-arrows-left-right", "fa-house-lock", "fa-cloud-arrow-down", "fa-children", "fa-chalkboard", "fa-user-large-slash", "fa-envelope-open", "fa-handshake-simple-slash", "fa-mattress-pillow", "fa-guarani-sign", "fa-arrows-rotate", "fa-fire-extinguisher", "fa-cruzeiro-sign", "fa-greater-than-equal", "fa-shield-halved", "fa-book-atlas", "fa-virus", "fa-envelope-circle-check", "fa-layer-group", "fa-arrows-to-dot", "fa-archway", "fa-heart-circle-check", "fa-house-chimney-crack", "fa-file-zipper", "fa-square", "fa-martini-glass-empty", "fa-couch", "fa-cedi-sign", "fa-italic", "fa-church", "fa-comments-dollar", "fa-democrat", "fa-z", "fa-person-skiing", "fa-road-lock", "fa-a", "fa-temperature-arrow-down", "fa-feather-pointed", "fa-p", "fa-snowflake", "fa-newspaper", "fa-rectangle-ad", "fa-circle-arrow-right", "fa-filter-circle-xmark", "fa-locust", "fa-sort", "fa-list-ol", "fa-person-dress-burst", "fa-money-check-dollar", "fa-vector-square", "fa-bread-slice", "fa-language", "fa-face-kiss-wink-heart", "fa-filter", "fa-question", "fa-file-signature", "fa-up-down-left-right", "fa-house-chimney-user", "fa-hand-holding-heart", "fa-puzzle-piece", "fa-money-check", "fa-star-half-stroke", "fa-code", "fa-whiskey-glass", "fa-building-circle-exclamation", "fa-magnifying-glass-chart", "fa-arrow-up-right-from-square", "fa-cubes-stacked", "fa-won-sign", "fa-virus-covid", "fa-austral-sign", "fa-f", "fa-leaf", "fa-road", "fa-taxi", "fa-person-circle-plus", "fa-chart-pie", "fa-bolt-lightning", "fa-sack-xmark", "fa-file-excel", "fa-file-contract", "fa-fish-fins", "fa-building-flag", "fa-face-grin-beam", "fa-object-ungroup", "fa-poop", "fa-location-pin", "fa-kaaba", "fa-toilet-paper", "fa-helmet-safety", "fa-eject", "fa-circle-right", "fa-plane-circle-check", "fa-face-rolling-eyes", "fa-object-group", "fa-chart-line", "fa-mask-ventilator", "fa-arrow-right", "fa-signs-post", "fa-cash-register", "fa-person-circle-question", "fa-h", "fa-tarp", "fa-screwdriver-wrench", "fa-arrows-to-eye", "fa-plug-circle-bolt", "fa-heart", "fa-mars-and-venus", "fa-house-user", "fa-dumpster-fire", "fa-house-crack", "fa-martini-glass-citrus", "fa-face-surprise", "fa-bottle-water", "fa-circle-pause", "fa-toilet-paper-slash", "fa-apple-whole", "fa-kitchen-set", "fa-r", "fa-temperature-quarter", "fa-cube", "fa-bitcoin-sign", "fa-shield-dog", "fa-solar-panel", "fa-lock-open", "fa-elevator", "fa-money-bill-transfer", "fa-money-bill-trend-up", "fa-house-flood-water-circle-arrow-right", "fa-square-poll-horizontal", "fa-circle", "fa-backward-fast", "fa-recycle", "fa-user-astronaut", "fa-plane-slash", "fa-trademark", "fa-basketball", "fa-satellite-dish", "fa-circle-up", "fa-mobile-screen-button", "fa-volume-high", "fa-users-rays", "fa-wallet", "fa-clipboard-check", "fa-file-audio", "fa-burger", "fa-wrench", "fa-bugs", "fa-rupee-sign", "fa-file-image", "fa-circle-question", "fa-plane-departure", "fa-handshake-slash", "fa-book-bookmark", "fa-code-branch", "fa-hat-cowboy", "fa-bridge", "fa-phone-flip", "fa-truck-front", "fa-cat", "fa-anchor-circle-exclamation", "fa-truck-field", "fa-route", "fa-clipboard-question", "fa-panorama", "fa-comment-medical", "fa-teeth-open", "fa-file-circle-minus", "fa-tags", "fa-wine-glass", "fa-forward-fast", "fa-face-meh-blank", "fa-square-parking", "fa-house-signal", "fa-bars-progress", "fa-faucet-drip", "fa-cart-flatbed", "fa-ban-smoking", "fa-terminal", "fa-mobile-button", "fa-house-medical-flag", "fa-basket-shopping", "fa-tape", "fa-bus-simple", "fa-eye", "fa-face-sad-cry", "fa-audio-description", "fa-person-military-to-person", "fa-file-shield", "fa-user-slash", "fa-pen", "fa-tower-observation", "fa-file-code", "fa-signal", "fa-bus", "fa-heart-circle-xmark", "fa-house-chimney", "fa-window-maximize", "fa-face-frown", "fa-prescription", "fa-shop", "fa-floppy-disk", "fa-vihara", "fa-scale-unbalanced", "fa-sort-up", "fa-comment-dots", "fa-plant-wilt", "fa-diamond", "fa-face-grin-squint", "fa-hand-holding-dollar", "fa-bacterium", "fa-hand-pointer", "fa-drum-steelpan", "fa-hand-scissors", "fa-hands-praying", "fa-arrow-rotate-right", "fa-biohazard", "fa-location-crosshairs", "fa-mars-double", "fa-child-dress", "fa-users-between-lines", "fa-lungs-virus", "fa-face-grin-tears", "fa-phone", "fa-calendar-xmark", "fa-child-reaching", "fa-head-side-virus", "fa-user-gear", "fa-arrow-up-1-9", "fa-door-closed", "fa-shield-virus", "fa-dice-six", "fa-mosquito-net", "fa-bridge-water", "fa-person-booth", "fa-text-width", "fa-hat-wizard", "fa-pen-fancy", "fa-person-digging", "fa-trash", "fa-gauge-simple", "fa-book-medical", "fa-poo", "fa-quote-right", "fa-shirt", "fa-cubes", "fa-divide", "fa-tenge-sign", "fa-headphones", "fa-hands-holding", "fa-hands-clapping", "fa-republican", "fa-arrow-left", "fa-person-circle-xmark", "fa-ruler", "fa-align-left", "fa-dice-d6", "fa-restroom", "fa-j", "fa-users-viewfinder", "fa-file-video", "fa-up-right-from-square", "fa-table-cells", "fa-file-pdf", "fa-book-bible", "fa-o", "fa-suitcase-medical", "fa-user-secret", "fa-otter", "fa-person-dress", "fa-comment-dollar", "fa-business-time", "fa-table-cells-large", "fa-book-tanakh", "fa-phone-volume", "fa-hat-cowboy-side", "fa-clipboard-user", "fa-child", "fa-lira-sign", "fa-satellite", "fa-plane-lock", "fa-tag", "fa-comment", "fa-cake-candles", "fa-envelope", "fa-angles-up", "fa-paperclip", "fa-arrow-right-to-city", "fa-ribbon", "fa-lungs", "fa-arrow-up-9-1", "fa-litecoin-sign", "fa-border-none", "fa-circle-nodes", "fa-parachute-box", "fa-indent", "fa-truck-field-un", "fa-hourglass", "fa-mountain", "fa-user-doctor", "fa-circle-info", "fa-cloud-meatball", "fa-camera", "fa-square-virus", "fa-meteor", "fa-car-on", "fa-sleigh", "fa-arrow-down-1-9", "fa-hand-holding-droplet", "fa-water", "fa-calendar-check", "fa-braille", "fa-prescription-bottle-medical", "fa-landmark", "fa-truck", "fa-crosshairs", "fa-person-cane", "fa-tent", "fa-vest-patches", "fa-check-double", "fa-arrow-down-a-z", "fa-money-bill-wheat", "fa-cookie", "fa-arrow-rotate-left", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-dumbbell", "fa-rectangle-list", "fa-tarp-droplet", "fa-house-medical-circle-check", "fa-person-skiing-nordic", "fa-calendar-plus", "fa-plane-arrival", "fa-circle-left", "fa-train-subway", "fa-chart-gantt", "fa-indian-rupee-sign", "fa-crop-simple", "fa-money-bill-1", "fa-left-long", "fa-dna", "fa-virus-slash", "fa-minus", "fa-chess", "fa-arrow-left-long", "fa-plug-circle-check", "fa-street-view", "fa-franc-sign", "fa-volume-off", "fa-hands-asl-interpreting", "fa-gear", "fa-droplet-slash", "fa-mosque", "fa-mosquito", "fa-star-of-david", "fa-person-military-rifle", "fa-cart-shopping", "fa-vials", "fa-plug-circle-plus", "fa-place-of-worship", "fa-grip-vertical", "fa-arrow-turn-up", "fa-u", "fa-square-root-variable", "fa-clock", "fa-backward-step", "fa-pallet", "fa-faucet", "fa-baseball-bat-ball", "fa-s", "fa-timeline", "fa-keyboard", "fa-caret-down", "fa-house-chimney-medical", "fa-temperature-three-quarters", "fa-mobile-screen", "fa-plane-up", "fa-piggy-bank", "fa-battery-half", "fa-mountain-city", "fa-coins", "fa-khanda", "fa-sliders", "fa-folder-tree", "fa-network-wired", "fa-map-pin", "fa-hamsa", "fa-cent-sign", "fa-flask", "fa-person-pregnant", "fa-wand-sparkles", "fa-ellipsis-vertical", "fa-ticket", "fa-power-off", "fa-right-long", "fa-flag-usa", "fa-laptop-file", "fa-tty", "fa-diagram-next", "fa-person-rifle", "fa-house-medical-circle-exclamation", "fa-closed-captioning", "fa-person-hiking", "fa-venus-double", "fa-images", "fa-calculator", "fa-people-pulling", "fa-n", "fa-cable-car", "fa-cloud-rain", "fa-building-circle-xmark", "fa-ship", "fa-arrows-down-to-line", "fa-download", "fa-face-grin", "fa-delete-left", "fa-eye-dropper", "fa-file-circle-check", "fa-forward", "fa-mobile", "fa-face-meh", "fa-align-center", "fa-book-skull", "fa-id-card", "fa-outdent", "fa-heart-circle-exclamation", "fa-house", "fa-calendar-week", "fa-laptop-medical", "fa-b", "fa-file-medical", "fa-dice-one", "fa-kiwi-bird", "fa-arrow-right-arrow-left", "fa-rotate-right", "fa-utensils", "fa-arrow-up-wide-short", "fa-mill-sign", "fa-bowl-rice", "fa-skull", "fa-tower-broadcast", "fa-truck-pickup", "fa-up-long", "fa-stop", "fa-code-merge", "fa-upload", "fa-hurricane", "fa-mound", "fa-toilet-portable", "fa-compact-disc", "fa-file-arrow-down", "fa-caravan", "fa-shield-cat", "fa-bolt", "fa-glass-water", "fa-oil-well", "fa-vault", "fa-mars", "fa-toilet", "fa-plane-circle-xmark", "fa-yen-sign", "fa-ruble-sign", "fa-sun", "fa-guitar", "fa-face-laugh-wink", "fa-horse-head", "fa-bore-hole", "fa-industry", "fa-circle-down", "fa-arrows-turn-to-dots", "fa-florin-sign", "fa-arrow-down-short-wide", "fa-less-than", "fa-angle-down", "fa-car-tunnel", "fa-head-side-cough", "fa-grip-lines", "fa-thumbs-down", "fa-user-lock", "fa-arrow-right-long", "fa-anchor-circle-xmark", "fa-ellipsis", "fa-chess-pawn", "fa-kit-medical", "fa-person-through-window", "fa-toolbox", "fa-hands-holding-circle", "fa-bug", "fa-credit-card", "fa-car", "fa-hand-holding-hand", "fa-book-open-reader", "fa-mountain-sun", "fa-arrows-left-right-to-line", "fa-dice-d20", "fa-truck-droplet", "fa-file-circle-xmark", "fa-temperature-arrow-up", "fa-medal", "fa-bed", "fa-square-h", "fa-podcast", "fa-temperature-full", "fa-bell", "fa-superscript", "fa-plug-circle-xmark", "fa-star-of-life", "fa-phone-slash", "fa-paint-roller", "fa-handshake-angle", "fa-location-dot", "fa-file", "fa-greater-than", "fa-person-swimming", "fa-arrow-down", "fa-droplet", "fa-eraser", "fa-earth-americas", "fa-person-burst", "fa-dove", "fa-battery-empty", "fa-socks", "fa-inbox", "fa-section", "fa-gauge-high", "fa-envelope-open-text", "fa-hospital", "fa-wine-bottle", "fa-chess-rook", "fa-bars-staggered", "fa-dharmachakra", "fa-hotdog", "fa-person-walking-with-cane", "fa-drum", "fa-ice-cream", "fa-heart-circle-bolt", "fa-fax", "fa-paragraph", "fa-check-to-slot", "fa-star-half", "fa-boxes-stacked", "fa-link", "fa-ear-listen", "fa-tree-city", "fa-play", "fa-font", "fa-rupiah-sign", "fa-magnifying-glass", "fa-table-tennis-paddle-ball", "fa-person-dots-from-line", "fa-trash-can-arrow-up", "fa-naira-sign", "fa-cart-arrow-down", "fa-walkie-talkie", "fa-file-pen", "fa-receipt", "fa-square-pen", "fa-suitcase-rolling", "fa-person-circle-exclamation", "fa-chevron-down", "fa-battery-full", "fa-skull-crossbones", "fa-code-compare", "fa-list-ul", "fa-school-lock", "fa-tower-cell", "fa-down-long", "fa-ranking-star", "fa-chess-king", "fa-person-harassing", "fa-brazilian-real-sign", "fa-landmark-dome", "fa-arrow-up", "fa-tv", "fa-shrimp", "fa-list-check", "fa-jug-detergent", "fa-circle-user", "fa-user-shield", "fa-wind", "fa-car-burst", "fa-y", "fa-person-snowboarding", "fa-truck-fast", "fa-fish", "fa-user-graduate", "fa-circle-half-stroke", "fa-clapperboard", "fa-circle-radiation", "fa-baseball", "fa-jet-fighter-up", "fa-diagram-project", "fa-copy", "fa-volume-xmark", "fa-hand-sparkles", "fa-grip", "fa-share-from-square", "fa-child-combatant", "fa-gun", "fa-square-phone", "fa-plus", "fa-expand", "fa-computer", "fa-xmark", "fa-arrows-up-down-left-right", "fa-chalkboard-user", "fa-peso-sign", "fa-building-shield", "fa-baby", "fa-users-line", "fa-quote-left", "fa-tractor", "fa-trash-arrow-up", "fa-arrow-down-up-lock", "fa-lines-leaning", "fa-ruler-combined", "fa-copyright", "fa-equals", "fa-blender", "fa-teeth", "fa-shekel-sign", "fa-map", "fa-rocket", "fa-photo-film", "fa-folder-minus", "fa-store", "fa-arrow-trend-up", "fa-plug-circle-minus", "fa-sign-hanging", "fa-bezier-curve", "fa-bell-slash", "fa-tablet", "fa-school-flag", "fa-fill", "fa-angle-up", "fa-drumstick-bite", "fa-holly-berry", "fa-chevron-left", "fa-bacteria", "fa-hand-lizard", "fa-notdef", "fa-disease", "fa-briefcase-medical", "fa-genderless", "fa-chevron-right", "fa-retweet", "fa-car-rear", "fa-pump-soap", "fa-video-slash", "fa-battery-quarter", "fa-radio", "fa-baby-carriage", "fa-traffic-light", "fa-thermometer", "fa-vr-cardboard", "fa-hand-middle-finger", "fa-percent", "fa-truck-moving", "fa-glass-water-droplet", "fa-display", "fa-face-smile", "fa-thumbtack", "fa-trophy", "fa-person-praying", "fa-hammer", "fa-hand-peace", "fa-rotate", "fa-spinner", "fa-robot", "fa-peace", "fa-gears", "fa-warehouse", "fa-arrow-up-right-dots", "fa-splotch", "fa-face-grin-hearts", "fa-dice-four", "fa-sim-card", "fa-transgender", "fa-mercury", "fa-arrow-turn-down", "fa-person-falling-burst", "fa-award", "fa-ticket-simple", "fa-building", "fa-angles-left", "fa-qrcode", "fa-clock-rotate-left", "fa-face-grin-beam-sweat", "fa-file-export", "fa-shield", "fa-arrow-up-short-wide", "fa-house-medical", "fa-golf-ball-tee", "fa-circle-chevron-left", "fa-house-chimney-window", "fa-pen-nib", "fa-tent-arrow-turn-left", "fa-tents", "fa-wand-magic", "fa-dog", "fa-carrot", "fa-moon", "fa-wine-glass-empty", "fa-cheese", "fa-yin-yang", "fa-music", "fa-code-commit", "fa-temperature-low", "fa-person-biking", "fa-broom", "fa-shield-heart", "fa-gopuram", "fa-earth-oceania", "fa-square-xmark", "fa-hashtag", "fa-up-right-and-down-left-from-center", "fa-oil-can", "fa-t", "fa-hippo", "fa-chart-column", "fa-infinity", "fa-vial-circle-check", "fa-person-arrow-down-to-line", "fa-voicemail", "fa-fan", "fa-person-walking-luggage", "fa-up-down", "fa-cloud-moon-rain", "fa-calendar", "fa-trailer", "fa-bahai", "fa-sd-card", "fa-dragon", "fa-shoe-prints", "fa-circle-plus", "fa-face-grin-tongue-wink", "fa-hand-holding", "fa-plug-circle-exclamation", "fa-link-slash", "fa-clone", "fa-person-walking-arrow-loop-left", "fa-arrow-up-z-a", "fa-fire-flame-curved", "fa-tornado", "fa-file-circle-plus", "fa-book-quran", "fa-anchor", "fa-border-all", "fa-face-angry", "fa-cookie-bite", "fa-arrow-trend-down", "fa-rss", "fa-draw-polygon", "fa-scale-balanced", "fa-gauge-simple-high", "fa-shower", "fa-desktop", "fa-m", "fa-table-list", "fa-comment-sms", "fa-book", "fa-user-plus", "fa-check", "fa-battery-three-quarters", "fa-house-circle-check", "fa-angle-left", "fa-diagram-successor", "fa-truck-arrow-right", "fa-arrows-split-up-and-left", "fa-hand-fist", "fa-cloud-moon", "fa-briefcase", "fa-person-falling", "fa-image-portrait", "fa-user-tag", "fa-rug", "fa-earth-europe", "fa-cart-flatbed-suitcase", "fa-rectangle-xmark", "fa-baht-sign", "fa-book-open", "fa-book-journal-whills", "fa-handcuffs", "fa-triangle-exclamation", "fa-database", "fa-share", "fa-bottle-droplet", "fa-mask-face", "fa-hill-rockslide", "fa-right-left", "fa-paper-plane", "fa-road-circle-exclamation", "fa-dungeon", "fa-align-right", "fa-money-bill-1-wave", "fa-life-ring", "fa-hands", "fa-calendar-day", "fa-water-ladder", "fa-arrows-up-down", "fa-face-grimace", "fa-wheelchair-move", "fa-turn-down", "fa-person-walking-arrow-right", "fa-square-envelope", "fa-dice", "fa-bowling-ball", "fa-brain", "fa-bandage", "fa-calendar-minus", "fa-circle-xmark", "fa-gifts", "fa-hotel", "fa-earth-asia", "fa-id-card-clip", "fa-magnifying-glass-plus", "fa-thumbs-up", "fa-user-clock", "fa-hand-dots", "fa-file-invoice", "fa-window-minimize", "fa-mug-saucer", "fa-brush", "fa-mask", "fa-magnifying-glass-minus", "fa-ruler-vertical", "fa-user-large", "fa-train-tram", "fa-user-nurse", "fa-syringe", "fa-cloud-sun", "fa-stopwatch-20", "fa-square-full", "fa-magnet", "fa-jar", "fa-note-sticky", "fa-bug-slash", "fa-arrow-up-from-water-pump", "fa-bone", "fa-user-injured", "fa-face-sad-tear", "fa-plane", "fa-tent-arrows-down", "fa-exclamation", "fa-arrows-spin", "fa-print", "fa-turkish-lira-sign", "fa-dollar-sign", "fa-x", "fa-magnifying-glass-dollar", "fa-users-gear", "fa-person-military-pointing", "fa-building-columns", "fa-umbrella", "fa-trowel", "fa-d", "fa-stapler", "fa-masks-theater", "fa-kip-sign", "fa-hand-point-left", "fa-handshake-simple", "fa-jet-fighter", "fa-square-share-nodes", "fa-barcode", "fa-plus-minus", "fa-video", "fa-graduation-cap", "fa-hand-holding-medical", "fa-person-circle-check", "fa-turn-up" );
        return $fa_icons_solid;
    }
endif;


if ( ! function_exists( 'hcode_fontawesome_icons_reg' ) ) :
    function hcode_fontawesome_icons_reg() {
        $fa_icons_reg = array( "fa-trash-can", "fa-message", "fa-file-lines", "fa-calendar-days", "fa-hand-point-right", "fa-face-smile-beam", "fa-face-grin-stars", "fa-address-book", "fa-comments", "fa-paste", "fa-face-grin-tongue-squint", "fa-face-flushed", "fa-square-caret-right", "fa-square-minus", "fa-compass", "fa-square-caret-down", "fa-face-kiss-beam", "fa-lightbulb", "fa-flag", "fa-square-check", "fa-circle-dot", "fa-face-dizzy", "fa-futbol", "fa-pen-to-square", "fa-hourglass-half", "fa-eye-slash", "fa-hand", "fa-hand-spock", "fa-face-kiss", "fa-face-grin-tongue", "fa-chess-bishop", "fa-face-grin-wink", "fa-face-grin-wide", "fa-face-frown-open", "fa-hand-point-up", "fa-bookmark", "fa-hand-point-down", "fa-folder", "fa-user", "fa-square-caret-left", "fa-star", "fa-chess-knight", "fa-face-laugh-squint", "fa-face-laugh", "fa-folder-open", "fa-clipboard", "fa-chess-queen", "fa-hand-back-fist", "fa-square-caret-up", "fa-chart-bar", "fa-window-restore", "fa-square-plus", "fa-image", "fa-folder-closed", "fa-lemon", "fa-handshake", "fa-gem", "fa-circle-play", "fa-circle-check", "fa-circle-stop", "fa-id-badge", "fa-face-laugh-beam", "fa-registered", "fa-address-card", "fa-face-tired", "fa-font-awesome", "fa-face-smile-wink", "fa-file-word", "fa-file-powerpoint", "fa-envelope-open", "fa-file-zipper", "fa-square", "fa-snowflake", "fa-newspaper", "fa-face-kiss-wink-heart", "fa-star-half-stroke", "fa-file-excel", "fa-face-grin-beam", "fa-object-ungroup", "fa-circle-right", "fa-face-rolling-eyes", "fa-object-group", "fa-heart", "fa-face-surprise", "fa-circle-pause", "fa-circle", "fa-circle-up", "fa-file-audio", "fa-file-image", "fa-circle-question", "fa-face-meh-blank", "fa-eye", "fa-face-sad-cry", "fa-file-code", "fa-window-maximize", "fa-face-frown", "fa-floppy-disk", "fa-comment-dots", "fa-face-grin-squint", "fa-hand-pointer", "fa-hand-scissors", "fa-face-grin-tears", "fa-calendar-xmark", "fa-file-video", "fa-file-pdf", "fa-comment", "fa-envelope", "fa-hourglass", "fa-calendar-check", "fa-hard-drive", "fa-face-grin-squint-tears", "fa-rectangle-list", "fa-calendar-plus", "fa-circle-left", "fa-money-bill-1", "fa-clock", "fa-keyboard", "fa-closed-captioning", "fa-images", "fa-face-grin", "fa-face-meh", "fa-id-card", "fa-sun", "fa-face-laugh-wink", "fa-circle-down", "fa-thumbs-down", "fa-chess-pawn", "fa-credit-card", "fa-bell", "fa-file", "fa-hospital", "fa-chess-rook", "fa-star-half", "fa-chess-king", "fa-circle-user", "fa-copy", "fa-share-from-square", "fa-copyright", "fa-map", "fa-bell-slash", "fa-hand-lizard", "fa-face-smile", "fa-hand-peace", "fa-face-grin-hearts", "fa-building", "fa-face-grin-beam-sweat", "fa-moon", "fa-calendar", "fa-face-grin-tongue-wink", "fa-clone", "fa-face-angry", "fa-rectangle-xmark", "fa-paper-plane", "fa-life-ring", "fa-face-grimace", "fa-calendar-minus", "fa-circle-xmark", "fa-thumbs-up", "fa-window-minimize", "fa-square-full", "fa-note-sticky", "fa-face-sad-tear", "fa-hand-point-left" );
        return $fa_icons_reg;
    }
endif;

if ( ! function_exists( 'hcode_fontawesome_icons_brand' ) ) :
    function hcode_fontawesome_icons_brand() {
        $fa_icons_brand = array( "fa-monero", "fa-hooli", "fa-yelp", "fa-cc-visa", "fa-lastfm", "fa-shopware", "fa-creative-commons-nc", "fa-aws", "fa-redhat", "fa-yoast", "fa-cloudflare", "fa-ups", "fa-wpexplorer", "fa-dyalog", "fa-bity", "fa-stackpath", "fa-buysellads", "fa-first-order", "fa-modx", "fa-guilded", "fa-vnv", "fa-square-js", "fa-microsoft", "fa-qq", "fa-orcid", "fa-java", "fa-invision", "fa-creative-commons-pd-alt", "fa-centercode", "fa-glide-g", "fa-drupal", "fa-hire-a-helper", "fa-creative-commons-by", "fa-unity", "fa-whmcs", "fa-rocketchat", "fa-vk", "fa-untappd", "fa-mailchimp", "fa-css3-alt", "fa-square-reddit", "fa-vimeo-v", "fa-contao", "fa-square-font-awesome", "fa-deskpro", "fa-sistrix", "fa-square-instagram", "fa-battle-net", "fa-the-red-yeti", "fa-square-hacker-news", "fa-edge", "fa-threads", "fa-napster", "fa-square-snapchat", "fa-google-plus-g", "fa-artstation", "fa-markdown", "fa-sourcetree", "fa-google-plus", "fa-diaspora", "fa-foursquare", "fa-stack-overflow", "fa-github-alt", "fa-phoenix-squadron", "fa-pagelines", "fa-algolia", "fa-red-river", "fa-creative-commons-sa", "fa-safari", "fa-google", "fa-square-font-awesome-stroke", "fa-atlassian", "fa-linkedin-in", "fa-digital-ocean", "fa-nimblr", "fa-chromecast", "fa-evernote", "fa-hacker-news", "fa-creative-commons-sampling", "fa-adversal", "fa-creative-commons", "fa-watchman-monitoring", "fa-fonticons", "fa-weixin", "fa-shirtsinbulk", "fa-codepen", "fa-git-alt", "fa-lyft", "fa-rev", "fa-windows", "fa-wizards-of-the-coast", "fa-square-viadeo", "fa-meetup", "fa-centos", "fa-adn", "fa-cloudsmith", "fa-pied-piper-alt", "fa-square-dribbble", "fa-codiepie", "fa-node", "fa-mix", "fa-steam", "fa-cc-apple-pay", "fa-scribd", "fa-debian", "fa-openid", "fa-instalod", "fa-expeditedssl", "fa-sellcast", "fa-square-twitter", "fa-r-project", "fa-delicious", "fa-freebsd", "fa-vuejs", "fa-accusoft", "fa-ioxhost", "fa-fonticons-fi", "fa-app-store", "fa-cc-mastercard", "fa-itunes-note", "fa-golang", "fa-kickstarter", "fa-grav", "fa-weibo", "fa-uncharted", "fa-firstdraft", "fa-square-youtube", "fa-wikipedia-w", "fa-wpressr", "fa-angellist", "fa-galactic-republic", "fa-nfc-directional", "fa-skype", "fa-joget", "fa-fedora", "fa-stripe-s", "fa-meta", "fa-laravel", "fa-hotjar", "fa-bluetooth-b", "fa-sticker-mule", "fa-creative-commons-zero", "fa-hips", "fa-behance", "fa-reddit", "fa-discord", "fa-chrome", "fa-app-store-ios", "fa-cc-discover", "fa-wpbeginner", "fa-confluence", "fa-mdb", "fa-dochub", "fa-accessible-icon", "fa-ebay", "fa-amazon", "fa-unsplash", "fa-yarn", "fa-square-steam", "fa-500px", "fa-square-vimeo", "fa-asymmetrik", "fa-font-awesome", "fa-gratipay", "fa-apple", "fa-hive", "fa-gitkraken", "fa-keybase", "fa-apple-pay", "fa-padlet", "fa-amazon-pay", "fa-square-github", "fa-stumbleupon", "fa-fedex", "fa-phoenix-framework", "fa-shopify", "fa-neos", "fa-square-threads", "fa-hackerrank", "fa-researchgate", "fa-swift", "fa-angular", "fa-speakap", "fa-angrycreative", "fa-y-combinator", "fa-empire", "fa-envira", "fa-square-gitlab", "fa-studiovinari", "fa-pied-piper", "fa-wordpress", "fa-product-hunt", "fa-firefox", "fa-linode", "fa-goodreads", "fa-square-odnoklassniki", "fa-jsfiddle", "fa-sith", "fa-themeisle", "fa-page4", "fa-hashnode", "fa-react", "fa-cc-paypal", "fa-squarespace", "fa-cc-stripe", "fa-creative-commons-share", "fa-bitcoin", "fa-keycdn", "fa-opera", "fa-itch-io", "fa-umbraco", "fa-galactic-senate", "fa-ubuntu", "fa-draft2digital", "fa-stripe", "fa-houzz", "fa-gg", "fa-dhl", "fa-square-pinterest", "fa-xing", "fa-blackberry", "fa-creative-commons-pd", "fa-playstation", "fa-quinscape", "fa-less", "fa-blogger-b", "fa-opencart", "fa-vine", "fa-paypal", "fa-gitlab", "fa-typo3", "fa-reddit-alien", "fa-yahoo", "fa-dailymotion", "fa-affiliatetheme", "fa-pied-piper-pp", "fa-bootstrap", "fa-odnoklassniki", "fa-nfc-symbol", "fa-ethereum", "fa-speaker-deck", "fa-creative-commons-nc-eu", "fa-patreon", "fa-avianex", "fa-ello", "fa-gofore", "fa-bimobject", "fa-facebook-f", "fa-square-google-plus", "fa-mandalorian", "fa-first-order-alt", "fa-osi", "fa-google-wallet", "fa-d-and-d-beyond", "fa-periscope", "fa-fulcrum", "fa-cloudscale", "fa-forumbee", "fa-mizuni", "fa-schlix", "fa-square-xing", "fa-bandcamp", "fa-wpforms", "fa-cloudversify", "fa-usps", "fa-megaport", "fa-magento", "fa-spotify", "fa-optin-monster", "fa-fly", "fa-aviato", "fa-itunes", "fa-cuttlefish", "fa-blogger", "fa-flickr", "fa-viber", "fa-soundcloud", "fa-digg", "fa-tencent-weibo", "fa-symfony", "fa-maxcdn", "fa-etsy", "fa-facebook-messenger", "fa-audible", "fa-think-peaks", "fa-bilibili", "fa-erlang", "fa-x-twitter", "fa-cotton-bureau", "fa-dashcube", "fa-42-group", "fa-stack-exchange", "fa-elementor", "fa-square-pied-piper", "fa-creative-commons-nd", "fa-palfed", "fa-superpowers", "fa-resolving", "fa-xbox", "fa-searchengin", "fa-tiktok", "fa-square-facebook", "fa-renren", "fa-linux", "fa-glide", "fa-linkedin", "fa-hubspot", "fa-deploydog", "fa-twitch", "fa-ravelry", "fa-mixer", "fa-square-lastfm", "fa-vimeo", "fa-mendeley", "fa-uniregistry", "fa-figma", "fa-creative-commons-remix", "fa-cc-amazon-pay", "fa-dropbox", "fa-instagram", "fa-cmplid", "fa-facebook", "fa-gripfire", "fa-jedi-order", "fa-uikit", "fa-fort-awesome-alt", "fa-phabricator", "fa-ussunnah", "fa-earlybirds", "fa-trade-federation", "fa-autoprefixer", "fa-whatsapp", "fa-slideshare", "fa-google-play", "fa-viadeo", "fa-line", "fa-google-drive", "fa-servicestack", "fa-simplybuilt", "fa-bitbucket", "fa-imdb", "fa-deezer", "fa-raspberry-pi", "fa-jira", "fa-docker", "fa-screenpal", "fa-bluetooth", "fa-gitter", "fa-d-and-d", "fa-microblog", "fa-cc-diners-club", "fa-gg-circle", "fa-pied-piper-hat", "fa-kickstarter-k", "fa-yandex", "fa-readme", "fa-html5", "fa-sellsy", "fa-sass", "fa-wirsindhandwerk", "fa-buromobelexperte", "fa-salesforce", "fa-octopus-deploy", "fa-medapps", "fa-ns8", "fa-pinterest-p", "fa-apper", "fa-fort-awesome", "fa-waze", "fa-cc-jcb", "fa-snapchat", "fa-fantasy-flight-games", "fa-rust", "fa-wix", "fa-square-behance", "fa-supple", "fa-rebel", "fa-css3", "fa-staylinked", "fa-kaggle", "fa-space-awesome", "fa-deviantart", "fa-cpanel", "fa-goodreads-g", "fa-square-git", "fa-square-tumblr", "fa-trello", "fa-creative-commons-nc-jp", "fa-get-pocket", "fa-perbyte", "fa-grunt", "fa-weebly", "fa-connectdevelop", "fa-leanpub", "fa-black-tie", "fa-themeco", "fa-python", "fa-android", "fa-bots", "fa-free-code-camp", "fa-hornbill", "fa-js", "fa-ideal", "fa-git", "fa-dev", "fa-sketch", "fa-yandex-international", "fa-cc-amex", "fa-uber", "fa-github", "fa-php", "fa-alipay", "fa-youtube", "fa-skyatlas", "fa-firefox-browser", "fa-replyd", "fa-suse", "fa-jenkins", "fa-twitter", "fa-rockrms", "fa-pinterest", "fa-buffer", "fa-npm", "fa-yammer", "fa-btc", "fa-dribbble", "fa-stumbleupon-circle", "fa-internet-explorer", "fa-stubber", "fa-telegram", "fa-old-republic", "fa-odysee", "fa-square-whatsapp", "fa-node-js", "fa-edge-legacy", "fa-slack", "fa-medrt", "fa-usb", "fa-tumblr", "fa-vaadin", "fa-quora", "fa-square-x-twitter", "fa-reacteurope", "fa-medium", "fa-amilia", "fa-mixcloud", "fa-flipboard", "fa-viacoin", "fa-critical-role", "fa-sitrox", "fa-discourse", "fa-joomla", "fa-mastodon", "fa-airbnb", "fa-wolf-pack-battalion", "fa-buy-n-large", "fa-gulp", "fa-creative-commons-sampling-plus", "fa-strava", "fa-ember", "fa-canadian-maple-leaf", "fa-teamspeak", "fa-pushed", "fa-wordpress-simple", "fa-nutritionix", "fa-wodu", "fa-google-pay", "fa-intercom", "fa-zhihu", "fa-korvue", "fa-pix", "fa-steam-symbol" );
        return $fa_icons_brand;
    }
endif;

if ( ! function_exists( 'hcode_fontawesome_icons_old' ) ) :
    function hcode_fontawesome_icons_old() {
        $fa_icon_old = array( 'fa-500px' => 'fab fa-500px','fa-address-book-o' => 'far fa-address-book','fa-address-card-o' => 'far fa-address-card','fa-adn' => 'fab fa-adn','fa-amazon' => 'fab fa-amazon','fa-android' => 'fab fa-android','fa-angellist' => 'fab fa-angellist','fa-apple' => 'fab fa-apple','fa-area-chart' => 'fas fa-chart-area','fa-arrow-circle-o-down' => 'far fa-arrow-alt-circle-down','fa-arrow-circle-o-left' => 'far fa-arrow-alt-circle-left','fa-arrow-circle-o-right' => 'far fa-arrow-alt-circle-right','fa-arrow-circle-o-up' => 'far fa-arrow-alt-circle-up','fa-arrows' => 'fas fa-arrows-alt','fa-arrows-alt' => 'fas fa-expand-arrows-alt','fa-arrows-h' => 'fas fa-arrows-alt-h','fa-arrows-v' => 'fas fa-arrows-alt-v','fa-asl-interpreting' => 'fas fa-american-sign-language-interpreting','fa-automobile' => 'fas fa-car','fa-bandcamp' => 'fab fa-bandcamp','fa-bank' => 'fas fa-university','fa-bar-chart' => 'far fa-chart-bar','fa-bar-chart-o' => 'far fa-chart-bar','fa-bathtub' => 'fas fa-bath','fa-battery' => 'fas fa-battery-full','fa-battery-0' => 'fas fa-battery-empty','fa-battery-1' => 'fas fa-battery-quarter','fa-battery-2' => 'fas fa-battery-half','fa-battery-3' => 'fas fa-battery-three-quarters','fa-battery-4' => 'fas fa-battery-full','fa-behance' => 'fab fa-behance','fa-behance-square' => 'fab fa-behance-square','fa-bell-o' => 'far fa-bell','fa-bell-slash-o' => 'far fa-bell-slash','fa-bitbucket' => 'fab fa-bitbucket','fa-bitbucket-square' => 'fab fa-bitbucket','fa-bitcoin' => 'fab fa-btc','fa-black-tie' => 'fab fa-black-tie','fa-bluetooth' => 'fab fa-bluetooth','fa-bluetooth-b' => 'fab fa-bluetooth-b','fa-bookmark-o' => 'far fa-bookmark','fa-btc' => 'fab fa-btc','fa-building-o' => 'far fa-building','fa-buysellads' => 'fab fa-buysellads','fa-cab' => 'fas fa-taxi','fa-calendar' => 'fas fa-calendar-alt','fa-calendar-check-o' => 'far fa-calendar-check','fa-calendar-minus-o' => 'far fa-calendar-minus','fa-calendar-o' => 'far fa-calendar','fa-calendar-plus-o' => 'far fa-calendar-plus','fa-calendar-times-o' => 'far fa-calendar-times','fa-caret-square-o-down' => 'far fa-caret-square-down','fa-caret-square-o-left' => 'far fa-caret-square-left','fa-caret-square-o-right' => 'far fa-caret-square-right','fa-caret-square-o-up' => 'far fa-caret-square-up','fa-cc' => 'far fa-closed-captioning','fa-cc-amex' => 'fab fa-cc-amex','fa-cc-diners-club' => 'fab fa-cc-diners-club','fa-cc-discover' => 'fab fa-cc-discover','fa-cc-jcb' => 'fab fa-cc-jcb','fa-cc-mastercard' => 'fab fa-cc-mastercard','fa-cc-paypal' => 'fab fa-cc-paypal','fa-cc-stripe' => 'fab fa-cc-stripe','fa-cc-visa' => 'fab fa-cc-visa','fa-chain' => 'fas fa-link','fa-chain-broken' => 'fas fa-unlink','fa-check-circle-o' => 'far fa-check-circle','fa-check-square-o' => 'far fa-check-square','fa-chrome' => 'fab fa-chrome','fa-circle-o' => 'far fa-circle','fa-circle-o-notch' => 'fas fa-circle-notch','fa-circle-thin' => 'far fa-circle','fa-clipboard' => 'far fa-clipboard','fa-clock-o' => 'far fa-clock','fa-clone' => 'far fa-clone','fa-close' => 'fas fa-times','fa-cloud-download' => 'fas fa-cloud-download-alt','fa-cloud-upload' => 'fas fa-cloud-upload-alt','fa-cny' => 'fas fa-yen-sign','fa-code-fork' => 'fas fa-code-branch','fa-codepen' => 'fab fa-codepen','fa-codiepie' => 'fab fa-codiepie','fa-comment-o' => 'far fa-comment','fa-commenting' => 'far fa-comment-dots','fa-commenting-o' => 'far fa-comment-dots','fa-comments-o' => 'far fa-comments','fa-compass' => 'far fa-compass','fa-connectdevelop' => 'fab fa-connectdevelop','fa-contao' => 'fab fa-contao','fa-copyright' => 'far fa-copyright','fa-creative-commons' => 'fab fa-creative-commons','fa-credit-card' => 'far fa-credit-card','fa-credit-card-alt' => 'fas fa-credit-card','fa-css3' => 'fab fa-css3','fa-cutlery' => 'fas fa-utensils','fa-dashboard' => 'fas fa-tachometer-alt','fa-dashcube' => 'fab fa-dashcube','fa-deafness' => 'fas fa-deaf','fa-dedent' => 'fas fa-outdent','fa-delicious' => 'fab fa-delicious','fa-deviantart' => 'fab fa-deviantart','fa-diamond' => 'far fa-gem','fa-digg' => 'fab fa-digg','fa-dollar' => 'fas fa-dollar-sign','fa-dot-circle-o' => 'far fa-dot-circle','fa-dribbble' => 'fab fa-dribbble','fa-drivers-license' => 'fas fa-id-card','fa-drivers-license-o' => 'far fa-id-card','fa-dropbox' => 'fab fa-dropbox','fa-drupal' => 'fab fa-drupal','fa-edge' => 'fab fa-edge','fa-eercast' => 'fab fa-sellcast','fa-empire' => 'fab fa-empire','fa-envelope-o' => 'far fa-envelope','fa-envelope-open-o' => 'far fa-envelope-open','fa-envira' => 'fab fa-envira','fa-etsy' => 'fab fa-etsy','fa-eur' => 'fas fa-euro-sign','fa-euro' => 'fas fa-euro-sign','fa-exchange' => 'fas fa-exchange-alt','fa-expeditedssl' => 'fab fa-expeditedssl','fa-external-link' => 'fas fa-external-link-alt','fa-external-link-square' => 'fas fa-external-link-square-alt','fa-eye' => 'far fa-eye','fa-eye-slash' => 'far fa-eye-slash','fa-eyedropper' => 'fas fa-eye-dropper','fa-fa' => 'fab fa-font-awesome','fa-facebook' => 'fab fa-facebook-f','fa-facebook-f' => 'fab fa-facebook-f','fa-facebook-official' => 'fab fa-facebook','fa-facebook-square' => 'fab fa-facebook-square','fa-feed' => 'fas fa-rss','fa-file-archive-o' => 'far fa-file-archive','fa-file-audio-o' => 'far fa-file-audio','fa-file-code-o' => 'far fa-file-code','fa-file-excel-o' => 'far fa-file-excel','fa-file-image-o' => 'far fa-file-image','fa-file-movie-o' => 'far fa-file-video','fa-file-o' => 'far fa-file','fa-file-pdf-o' => 'far fa-file-pdf','fa-file-photo-o' => 'far fa-file-image','fa-file-picture-o' => 'far fa-file-image','fa-file-powerpoint-o' => 'far fa-file-powerpoint','fa-file-sound-o' => 'far fa-file-audio','fa-file-text' => 'fas fa-file-alt','fa-file-text-o' => 'far fa-file-alt','fa-file-video-o' => 'far fa-file-video','fa-file-word-o' => 'far fa-file-word','fa-file-zip-o' => 'far fa-file-archive','fa-files-o' => 'far fa-copy','fa-firefox' => 'fab fa-firefox','fa-first-order' => 'fab fa-first-order','fa-flag-o' => 'far fa-flag','fa-flash' => 'fas fa-bolt','fa-flickr' => 'fab fa-flickr','fa-floppy-o' => 'far fa-save','fa-folder-o' => 'far fa-folder','fa-folder-open-o' => 'far fa-folder-open','fa-font-awesome' => 'fab fa-font-awesome','fa-fonticons' => 'fab fa-fonticons','fa-fort-awesome' => 'fab fa-fort-awesome','fa-forumbee' => 'fab fa-forumbee','fa-foursquare' => 'fab fa-foursquare','fa-free-code-camp' => 'fab fa-free-code-camp','fa-frown-o' => 'far fa-frown','fa-futbol-o' => 'far fa-futbol','fa-gbp' => 'fas fa-pound-sign','fa-ge' => 'fab fa-empire','fa-gear' => 'fas fa-cog','fa-gears' => 'fas fa-cogs','fa-get-pocket' => 'fab fa-get-pocket','fa-gg' => 'fab fa-gg','fa-gg-circle' => 'fab fa-gg-circle','fa-git' => 'fab fa-git','fa-git-square' => 'fab fa-git-square','fa-github' => 'fab fa-github','fa-github-alt' => 'fab fa-github-alt','fa-github-square' => 'fab fa-github-square','fa-gitlab' => 'fab fa-gitlab','fa-gittip' => 'fab fa-gratipay','fa-glass' => 'fas fa-glass-martini','fa-glide' => 'fab fa-glide','fa-glide-g' => 'fab fa-glide-g','fa-google' => 'fab fa-google','fa-google-plus' => 'fab fa-google-plus-g','fa-google-plus-circle' => 'fab fa-google-plus','fa-google-plus-official' => 'fab fa-google-plus','fa-google-plus-square' => 'fab fa-google-plus-square','fa-google-wallet' => 'fab fa-google-wallet','fa-gratipay' => 'fab fa-gratipay','fa-grav' => 'fab fa-grav','fa-group' => 'fas fa-users','fa-hacker-news' => 'fab fa-hacker-news','fa-hand-grab-o' => 'far fa-hand-rock','fa-hand-lizard-o' => 'far fa-hand-lizard','fa-hand-o-down' => 'far fa-hand-point-down','fa-hand-o-left' => 'far fa-hand-point-left','fa-hand-o-right' => 'far fa-hand-point-right','fa-hand-o-up' => 'far fa-hand-point-up','fa-hand-paper-o' => 'far fa-hand-paper','fa-hand-peace-o' => 'far fa-hand-peace','fa-hand-pointer-o' => 'far fa-hand-pointer','fa-hand-rock-o' => 'far fa-hand-rock','fa-hand-scissors-o' => 'far fa-hand-scissors','fa-hand-spock-o' => 'far fa-hand-spock','fa-hand-stop-o' => 'far fa-hand-paper','fa-handshake-o' => 'far fa-handshake','fa-hard-of-hearing' => 'fas fa-deaf','fa-hdd-o' => 'far fa-hdd','fa-header' => 'fas fa-heading','fa-heart-o' => 'far fa-heart','fa-hospital-o' => 'far fa-hospital','fa-hotel' => 'fas fa-bed','fa-hourglass-1' => 'fas fa-hourglass-start','fa-hourglass-2' => 'fas fa-hourglass-half','fa-hourglass-3' => 'fas fa-hourglass-end','fa-hourglass-o' => 'far fa-hourglass','fa-houzz' => 'fab fa-houzz','fa-html5' => 'fab fa-html5','fa-id-badge' => 'far fa-id-badge','fa-id-card-o' => 'far fa-id-card','fa-ils' => 'fas fa-shekel-sign','fa-image' => 'far fa-image','fa-imdb' => 'fab fa-imdb','fa-inr' => 'fas fa-rupee-sign','fa-instagram' => 'fab fa-instagram','fa-institution' => 'fas fa-university','fa-internet-explorer' => 'fab fa-internet-explorer','fa-intersex' => 'fas fa-transgender','fa-ioxhost' => 'fab fa-ioxhost','fa-joomla' => 'fab fa-joomla','fa-jpy' => 'fas fa-yen-sign','fa-jsfiddle' => 'fab fa-jsfiddle','fa-keyboard-o' => 'far fa-keyboard','fa-krw' => 'fas fa-won-sign','fa-lastfm' => 'fab fa-lastfm','fa-lastfm-square' => 'fab fa-lastfm-square','fa-leanpub' => 'fab fa-leanpub','fa-legal' => 'fas fa-gavel','fa-lemon-o' => 'far fa-lemon','fa-level-down' => 'fas fa-level-down-alt','fa-level-up' => 'fas fa-level-up-alt','fa-life-bouy' => 'far fa-life-ring','fa-life-buoy' => 'far fa-life-ring','fa-life-ring' => 'far fa-life-ring','fa-life-saver' => 'far fa-life-ring','fa-lightbulb-o' => 'far fa-lightbulb','fa-line-chart' => 'fas fa-chart-line','fa-linkedin' => 'fab fa-linkedin-in','fa-linkedin-square' => 'fab fa-linkedin','fa-linode' => 'fab fa-linode','fa-linux' => 'fab fa-linux','fa-list-alt' => 'far fa-list-alt','fa-long-arrow-down' => 'fas fa-long-arrow-alt-down','fa-long-arrow-left' => 'fas fa-long-arrow-alt-left','fa-long-arrow-right' => 'fas fa-long-arrow-alt-right','fa-long-arrow-up' => 'fas fa-long-arrow-alt-up','fa-mail-forward' => 'fas fa-share','fa-mail-reply' => 'fas fa-reply','fa-mail-reply-all' => 'fas fa-reply-all','fa-map-marker' => 'fas fa-map-marker-alt','fa-map-o' => 'far fa-map','fa-maxcdn' => 'fab fa-maxcdn','fa-meanpath' => 'fab fa-font-awesome','fa-medium' => 'fab fa-medium','fa-meetup' => 'fab fa-meetup','fa-meh-o' => 'far fa-meh','fa-minus-square-o' => 'far fa-minus-square','fa-mixcloud' => 'fab fa-mixcloud','fa-mobile' => 'fas fa-mobile-alt','fa-mobile-phone' => 'fas fa-mobile-alt','fa-modx' => 'fab fa-modx','fa-money' => 'far fa-money-bill-alt','fa-moon-o' => 'far fa-moon','fa-mortar-board' => 'fas fa-graduation-cap','fa-navicon' => 'fas fa-bars','fa-newspaper-o' => 'far fa-newspaper','fa-object-group' => 'far fa-object-group','fa-object-ungroup' => 'far fa-object-ungroup','fa-odnoklassniki' => 'fab fa-odnoklassniki','fa-odnoklassniki-square' => 'fab fa-odnoklassniki-square','fa-opencart' => 'fab fa-opencart','fa-openid' => 'fab fa-openid','fa-opera' => 'fab fa-opera','fa-optin-monster' => 'fab fa-optin-monster','fa-pagelines' => 'fab fa-pagelines','fa-paper-plane-o' => 'far fa-paper-plane','fa-paste' => 'far fa-clipboard','fa-pause-circle-o' => 'far fa-pause-circle','fa-paypal' => 'fab fa-paypal','fa-pencil' => 'fas fa-pencil-alt','fa-pencil-square' => 'fas fa-pen-square','fa-pencil-square-o' => 'far fa-edit','fa-photo' => 'far fa-image','fa-picture-o' => 'far fa-image','fa-pie-chart' => 'fas fa-chart-pie','fa-pied-piper' => 'fab fa-pied-piper','fa-pied-piper-alt' => 'fab fa-pied-piper-alt','fa-pied-piper-pp' => 'fab fa-pied-piper-pp','fa-pinterest' => 'fab fa-pinterest','fa-pinterest-p' => 'fab fa-pinterest-p','fa-pinterest-square' => 'fab fa-pinterest-square','fa-play-circle-o' => 'far fa-play-circle','fa-plus-square-o' => 'far fa-plus-square','fa-product-hunt' => 'fab fa-product-hunt','fa-qq' => 'fab fa-qq','fa-question-circle-o' => 'far fa-question-circle','fa-quora' => 'fab fa-quora','fa-ra' => 'fab fa-rebel','fa-ravelry' => 'fab fa-ravelry','fa-rebel' => 'fab fa-rebel','fa-reddit' => 'fab fa-reddit','fa-reddit-alien' => 'fab fa-reddit-alien','fa-reddit-square' => 'fab fa-reddit-square','fa-refresh' => 'fas fa-sync','fa-registered' => 'far fa-registered','fa-remove' => 'fas fa-times','fa-renren' => 'fab fa-renren','fa-reorder' => 'fas fa-bars','fa-repeat' => 'fas fa-redo','fa-resistance' => 'fab fa-rebel','fa-rmb' => 'fas fa-yen-sign','fa-rotate-left' => 'fas fa-undo','fa-rotate-right' => 'fas fa-redo','fa-rouble' => 'fas fa-ruble-sign','fa-rub' => 'fas fa-ruble-sign','fa-ruble' => 'fas fa-ruble-sign','fa-rupee' => 'fas fa-rupee-sign','fa-s15' => 'fas fa-bath','fa-safari' => 'fab fa-safari','fa-scissors' => 'fas fa-cut','fa-scribd' => 'fab fa-scribd','fa-sellsy' => 'fab fa-sellsy','fa-send' => 'fas fa-paper-plane','fa-send-o' => 'far fa-paper-plane','fa-share-square-o' => 'far fa-share-square','fa-shekel' => 'fas fa-shekel-sign','fa-sheqel' => 'fas fa-shekel-sign','fa-shield' => 'fas fa-shield-alt','fa-shirtsinbulk' => 'fab fa-shirtsinbulk','fa-sign-in' => 'fas fa-sign-in-alt','fa-sign-out' => 'fas fa-sign-out-alt','fa-signing' => 'fas fa-sign-language','fa-simplybuilt' => 'fab fa-simplybuilt','fa-skyatlas' => 'fab fa-skyatlas','fa-skype' => 'fab fa-skype','fa-slack' => 'fab fa-slack','fa-sliders' => 'fas fa-sliders-h','fa-slideshare' => 'fab fa-slideshare','fa-smile-o' => 'far fa-smile','fa-snapchat' => 'fab fa-snapchat','fa-snapchat-ghost' => 'fab fa-snapchat-ghost','fa-snapchat-square' => 'fab fa-snapchat-square','fa-snowflake-o' => 'far fa-snowflake','fa-soccer-ball-o' => 'far fa-futbol','fa-sort-alpha-asc' => 'fas fa-sort-alpha-down','fa-sort-alpha-desc' => 'fas fa-sort-alpha-up','fa-sort-amount-asc' => 'fas fa-sort-amount-down','fa-sort-amount-desc' => 'fas fa-sort-amount-up','fa-sort-asc' => 'fas fa-sort-up','fa-sort-desc' => 'fas fa-sort-down','fa-sort-numeric-asc' => 'fas fa-sort-numeric-down','fa-sort-numeric-desc' => 'fas fa-sort-numeric-up','fa-soundcloud' => 'fab fa-soundcloud','fa-spoon' => 'fas fa-utensil-spoon','fa-spotify' => 'fab fa-spotify','fa-square-o' => 'far fa-square','fa-stack-exchange' => 'fab fa-stack-exchange','fa-stack-overflow' => 'fab fa-stack-overflow','fa-star-half-empty' => 'far fa-star-half','fa-star-half-full' => 'far fa-star-half','fa-star-half-o' => 'far fa-star-half','fa-star-o' => 'far fa-star','fa-steam' => 'fab fa-steam','fa-steam-square' => 'fab fa-steam-square','fa-sticky-note-o' => 'far fa-sticky-note','fa-stop-circle-o' => 'far fa-stop-circle','fa-stumbleupon' => 'fab fa-stumbleupon','fa-stumbleupon-circle' => 'fab fa-stumbleupon-circle','fa-sun-o' => 'far fa-sun','fa-superpowers' => 'fab fa-superpowers','fa-support' => 'far fa-life-ring','fa-tablet' => 'fas fa-tablet-alt','fa-tachometer' => 'fas fa-tachometer-alt','fa-telegram' => 'fab fa-telegram','fa-television' => 'fas fa-tv','fa-tencent-weibo' => 'fab fa-tencent-weibo','fa-themeisle' => 'fab fa-themeisle','fa-thermometer' => 'fas fa-thermometer-full','fa-thermometer-0' => 'fas fa-thermometer-empty','fa-thermometer-1' => 'fas fa-thermometer-quarter','fa-thermometer-2' => 'fas fa-thermometer-half','fa-thermometer-3' => 'fas fa-thermometer-three-quarters','fa-thermometer-4' => 'fas fa-thermometer-full','fa-thumb-tack' => 'fas fa-thumbtack','fa-thumbs-o-down' => 'far fa-thumbs-down','fa-thumbs-o-up' => 'far fa-thumbs-up','fa-ticket' => 'fas fa-ticket-alt','fa-times-circle-o' => 'far fa-times-circle','fa-times-rectangle' => 'fas fa-window-close','fa-times-rectangle-o' => 'far fa-window-close','fa-toggle-down' => 'far fa-caret-square-down','fa-toggle-left' => 'far fa-caret-square-left','fa-toggle-right' => 'far fa-caret-square-right','fa-toggle-up' => 'far fa-caret-square-up','fa-trash' => 'fas fa-trash-alt','fa-trash-o' => 'far fa-trash-alt','fa-trello' => 'fab fa-trello','fa-tripadvisor' => 'fab fa-tripadvisor','fa-try' => 'fas fa-lira-sign','fa-tumblr' => 'fab fa-tumblr','fa-tumblr-square' => 'fab fa-tumblr-square','fa-turkish-lira' => 'fas fa-lira-sign','fa-twitch' => 'fab fa-twitch','fa-twitter' => 'fab fa-twitter','fa-twitter-square' => 'fab fa-twitter-square','fa-unsorted' => 'fas fa-sort','fa-usb' => 'fab fa-usb','fa-usd' => 'fas fa-dollar-sign','fa-user-circle-o' => 'far fa-user-circle','fa-user-o' => 'far fa-user','fa-vcard' => 'fas fa-address-card','fa-vcard-o' => 'far fa-address-card','fa-viacoin' => 'fab fa-viacoin','fa-viadeo' => 'fab fa-viadeo','fa-viadeo-square' => 'fab fa-viadeo-square','fa-video-camera' => 'fas fa-video','fa-vimeo' => 'fab fa-vimeo-v','fa-vimeo-square' => 'fab fa-vimeo-square','fa-vine' => 'fab fa-vine','fa-vk' => 'fab fa-vk','fa-volume-control-phone' => 'fas fa-phone-volume','fa-warning' => 'fas fa-exclamation-triangle','fa-wechat' => 'fab fa-weixin','fa-weibo' => 'fab fa-weibo','fa-weixin' => 'fab fa-weixin','fa-whatsapp' => 'fab fa-whatsapp','fa-wheelchair-alt' => 'fab fa-accessible-icon','fa-wikipedia-w' => 'fab fa-wikipedia-w','fa-window-close-o' => 'far fa-window-close','fa-window-maximize' => 'far fa-window-maximize','fa-window-restore' => 'far fa-window-restore','fa-windows' => 'fab fa-windows','fa-won' => 'fas fa-won-sign','fa-wordpress' => 'fab fa-wordpress','fa-wpbeginner' => 'fab fa-wpbeginner','fa-wpexplorer' => 'fab fa-wpexplorer','fa-wpforms' => 'fab fa-wpforms','fa-xing' => 'fab fa-xing','fa-xing-square' => 'fab fa-xing-square','fa-y-combinator' => 'fab fa-y-combinator','fa-y-combinator-square' => 'fab fa-hacker-news','fa-yahoo' => 'fab fa-yahoo','fa-yc' => 'fab fa-y-combinator','fa-yc-square' => 'fab fa-hacker-news','fa-yelp' => 'fab fa-yelp','fa-yen' => 'fas fa-yen-sign','fa-yoast' => 'fab fa-yoast','fa-youtube' => 'fab fa-youtube','fa-youtube-play' => 'fab fa-youtube','fa-youtube-square' => 'fab fa-youtube-square', /*H-code custom font*/ 'fa-facebook' => 'fab fa-facebook-f', 'fa-google-plus' => 'fab fa-google-plus-g', 'fa-linkedin' => 'fab fa-linkedin-in' );
    return $fa_icon_old;
    }
endif;

if ( ! function_exists( 'hcode_get_all_font_icons' ) ) :
    function hcode_get_all_font_icons() {

        $hcode_etline_icons = array( 'icon-mobile' => 'icon-mobile', 'icon-laptop' => 'icon-laptop', 'icon-desktop' => 'icon-desktop', 'icon-tablet' => 'icon-tablet', 'icon-phone' => 'icon-phone', 'icon-document' => 'icon-document', 'icon-documents' => 'icon-documents', 'icon-search' => 'icon-search', 'icon-clipboard' => 'icon-clipboard', 'icon-newspaper' => 'icon-newspaper', 'icon-notebook' => 'icon-notebook', 'icon-book-open' => 'icon-book-open', 'icon-browser' => 'icon-browser', 'icon-calendar' => 'icon-calendar', 'icon-presentation' => 'icon-presentation', 'icon-picture' => 'icon-picture', 'icon-pictures' => 'icon-pictures', 'icon-video' => 'icon-video', 'icon-camera' => 'icon-camera', 'icon-printer' => 'icon-printer', 'icon-toolbox' => 'icon-toolbox', 'icon-briefcase' => 'icon-briefcase', 'icon-wallet' => 'icon-wallet', 'icon-gift' => 'icon-gift', 'icon-bargraph' => 'icon-bargraph', 'icon-grid' => 'icon-grid', 'icon-expand' => 'icon-expand', 'icon-focus' => 'icon-focus', 'icon-edit' => 'icon-edit', 'icon-adjustments' => 'icon-adjustments', 'icon-ribbon' => 'icon-ribbon', 'icon-hourglass' => 'icon-hourglass', 'icon-lock' => 'icon-lock', 'icon-megaphone' => 'icon-megaphone', 'icon-shield' => 'icon-shield', 'icon-trophy' => 'icon-trophy', 'icon-flag' => 'icon-flag', 'icon-map' => 'icon-map', 'icon-puzzle' => 'icon-puzzle', 'icon-basket' => 'icon-basket', 'icon-envelope' => 'icon-envelope', 'icon-streetsign' => 'icon-streetsign', 'icon-telescope' => 'icon-telescope', 'icon-gears' => 'icon-gears', 'icon-key' => 'icon-key', 'icon-paperclip' => 'icon-paperclip', 'icon-attachment' => 'icon-attachment', 'icon-pricetags' => 'icon-pricetags', 'icon-lightbulb' => 'icon-lightbulb', 'icon-layers' => 'icon-layers', 'icon-pencil' => 'icon-pencil', 'icon-tools' => 'icon-tools', 'icon-tools-2' => 'icon-tools-2', 'icon-scissors' => 'icon-scissors', 'icon-paintbrush' => 'icon-paintbrush', 'icon-magnifying-glass' => 'icon-magnifying-glass', 'icon-circle-compass' => 'icon-circle-compass', 'icon-linegraph' => 'icon-linegraph', 'icon-mic' => 'icon-mic', 'icon-strategy' => 'icon-strategy', 'icon-beaker' => 'icon-beaker', 'icon-caution' => 'icon-caution', 'icon-recycle' => 'icon-recycle', 'icon-anchor' => 'icon-anchor', 'icon-profile-male' => 'icon-profile-male', 'icon-profile-female' => 'icon-profile-female', 'icon-bike' => 'icon-bike', 'icon-wine' => 'icon-wine', 'icon-hotairballoon' => 'icon-hotairballoon', 'icon-globe' => 'icon-globe', 'icon-genius' => 'icon-genius', 'icon-map-pin' => 'icon-map-pin', 'icon-dial' => 'icon-dial', 'icon-chat' => 'icon-chat', 'icon-heart' => 'icon-heart', 'icon-cloud' => 'icon-cloud', 'icon-upload' => 'icon-upload', 'icon-download' => 'icon-download', 'icon-target' => 'icon-target', 'icon-hazardous' => 'icon-hazardous', 'icon-piechart' => 'icon-piechart', 'icon-speedometer' => 'icon-speedometer', 'icon-global' => 'icon-global', 'icon-compass' => 'icon-compass', 'icon-lifesaver' => 'icon-lifesaver', 'icon-clock' => 'icon-clock', 'icon-aperture' => 'icon-aperture', 'icon-quote' => 'icon-quote', 'icon-scope' => 'icon-scope', 'icon-alarmclock' => 'icon-alarmclock', 'icon-refresh' => 'icon-refresh', 'icon-happy' => 'icon-happy', 'icon-sad' => 'icon-sad', 'icon-facebook' => 'icon-facebook', 'icon-twitter' => 'icon-twitter', 'icon-googleplus' => 'icon-googleplus', 'icon-rss' => 'icon-rss', 'icon-tumblr' => 'icon-tumblr', 'icon-linkedin' => 'icon-linkedin', 'icon-dribbble' => 'icon-dribbble' );
       
        $hcode_fa_icons_solid = array( 'fa-solid fa-ad' => 'fa-solid fa-ad', 'fa-solid fa-address-book' => 'fa-solid fa-address-book', 'fa-solid fa-address-card' => 'fa-solid fa-address-card', 'fa-solid fa-adjust' => 'fa-solid fa-adjust', 'fa-solid fa-air-freshener' => 'fa-solid fa-air-freshener', 'fa-solid fa-align-center' => 'fa-solid fa-align-center', 'fa-solid fa-align-justify' => 'fa-solid fa-align-justify', 'fa-solid fa-align-left' => 'fa-solid fa-align-left', 'fa-solid fa-align-right' => 'fa-solid fa-align-right', 'fa-solid fa-allergies' => 'fa-solid fa-allergies', 'fa-solid fa-ambulance' => 'fa-solid fa-ambulance', 'fa-solid fa-american-sign-language-interpreting' => 'fa-solid fa-american-sign-language-interpreting', 'fa-solid fa-anchor' => 'fa-solid fa-anchor', 'fa-solid fa-angle-double-down' => 'fa-solid fa-angle-double-down', 'fa-solid fa-angle-double-left' => 'fa-solid fa-angle-double-left', 'fa-solid fa-angle-double-right' => 'fa-solid fa-angle-double-right', 'fa-solid fa-angle-double-up' => 'fa-solid fa-angle-double-up', 'fa-solid fa-angle-down' => 'fa-solid fa-angle-down', 'fa-solid fa-angle-left' => 'fa-solid fa-angle-left', 'fa-solid fa-angle-right' => 'fa-solid fa-angle-right', 'fa-solid fa-angle-up' => 'fa-solid fa-angle-up', 'fa-solid fa-angry' => 'fa-solid fa-angry', 'fa-solid fa-ankh' => 'fa-solid fa-ankh', 'fa-solid fa-apple-alt' => 'fa-solid fa-apple-alt', 'fa-solid fa-archive' => 'fa-solid fa-archive', 'fa-solid fa-archway' => 'fa-solid fa-archway', 'fa-solid fa-arrow-alt-circle-down' => 'fa-solid fa-arrow-alt-circle-down', 'fa-solid fa-arrow-alt-circle-left' => 'fa-solid fa-arrow-alt-circle-left', 'fa-solid fa-arrow-alt-circle-right' => 'fa-solid fa-arrow-alt-circle-right', 'fa-solid fa-arrow-alt-circle-up' => 'fa-solid fa-arrow-alt-circle-up', 'fa-solid fa-arrow-circle-down' => 'fa-solid fa-arrow-circle-down', 'fa-solid fa-arrow-circle-left' => 'fa-solid fa-arrow-circle-left', 'fa-solid fa-arrow-circle-right' => 'fa-solid fa-arrow-circle-right', 'fa-solid fa-arrow-circle-up' => 'fa-solid fa-arrow-circle-up', 'fa-solid fa-arrow-down' => 'fa-solid fa-arrow-down', 'fa-solid fa-arrow-left' => 'fa-solid fa-arrow-left', 'fa-solid fa-arrow-right' => 'fa-solid fa-arrow-right', 'fa-solid fa-arrow-up' => 'fa-solid fa-arrow-up', 'fa-solid fa-arrows-alt' => 'fa-solid fa-arrows-alt', 'fa-solid fa-arrows-alt-h' => 'fa-solid fa-arrows-alt-h', 'fa-solid fa-arrows-alt-v' => 'fa-solid fa-arrows-alt-v', 'fa-solid fa-assistive-listening-systems' => 'fa-solid fa-assistive-listening-systems', 'fa-solid fa-asterisk' => 'fa-solid fa-asterisk', 'fa-solid fa-at' => 'fa-solid fa-at', 'fa-solid fa-atlas' => 'fa-solid fa-atlas', 'fa-solid fa-atom' => 'fa-solid fa-atom', 'fa-solid fa-audio-description' => 'fa-solid fa-audio-description', 'fa-solid fa-award' => 'fa-solid fa-award', 'fa-solid fa-baby' => 'fa-solid fa-baby', 'fa-solid fa-baby-carriage' => 'fa-solid fa-baby-carriage', 'fa-solid fa-backspace' => 'fa-solid fa-backspace', 'fa-solid fa-backward' => 'fa-solid fa-backward', 'fa-solid fa-bacon' => 'fa-solid fa-bacon', 'fa-solid fa-balance-scale' => 'fa-solid fa-balance-scale', 'fa-solid fa-balance-scale-left' => 'fa-solid fa-balance-scale-left', 'fa-solid fa-balance-scale-right' => 'fa-solid fa-balance-scale-right', 'fa-solid fa-ban' => 'fa-solid fa-ban', 'fa-solid fa-band-aid' => 'fa-solid fa-band-aid', 'fa-solid fa-barcode' => 'fa-solid fa-barcode', 'fa-solid fa-bars' => 'fa-solid fa-bars', 'fa-solid fa-baseball-ball' => 'fa-solid fa-baseball-ball', 'fa-solid fa-basketball-ball' => 'fa-solid fa-basketball-ball', 'fa-solid fa-bath' => 'fa-solid fa-bath', 'fa-solid fa-battery-empty' => 'fa-solid fa-battery-empty', 'fa-solid fa-battery-full' => 'fa-solid fa-battery-full', 'fa-solid fa-battery-half' => 'fa-solid fa-battery-half', 'fa-solid fa-battery-quarter' => 'fa-solid fa-battery-quarter', 'fa-solid fa-battery-three-quarters' => 'fa-solid fa-battery-three-quarters', 'fa-solid fa-bed' => 'fa-solid fa-bed', 'fa-solid fa-beer' => 'fa-solid fa-beer', 'fa-solid fa-bell' => 'fa-solid fa-bell', 'fa-solid fa-bell-slash' => 'fa-solid fa-bell-slash', 'fa-solid fa-bezier-curve' => 'fa-solid fa-bezier-curve', 'fa-solid fa-bible' => 'fa-solid fa-bible', 'fa-solid fa-bicycle' => 'fa-solid fa-bicycle', 'fa-solid fa-biking' => 'fa-solid fa-biking', 'fa-solid fa-binoculars' => 'fa-solid fa-binoculars', 'fa-solid fa-biohazard' => 'fa-solid fa-biohazard', 'fa-solid fa-birthday-cake' => 'fa-solid fa-birthday-cake', 'fa-solid fa-blender' => 'fa-solid fa-blender', 'fa-solid fa-blender-phone' => 'fa-solid fa-blender-phone', 'fa-solid fa-blind' => 'fa-solid fa-blind', 'fa-solid fa-blog' => 'fa-solid fa-blog', 'fa-solid fa-bold' => 'fa-solid fa-bold', 'fa-solid fa-bolt' => 'fa-solid fa-bolt', 'fa-solid fa-bomb' => 'fa-solid fa-bomb', 'fa-solid fa-bone' => 'fa-solid fa-bone', 'fa-solid fa-bong' => 'fa-solid fa-bong', 'fa-solid fa-book' => 'fa-solid fa-book', 'fa-solid fa-book-dead' => 'fa-solid fa-book-dead', 'fa-solid fa-book-medical' => 'fa-solid fa-book-medical', 'fa-solid fa-book-open' => 'fa-solid fa-book-open', 'fa-solid fa-book-reader' => 'fa-solid fa-book-reader', 'fa-solid fa-bookmark' => 'fa-solid fa-bookmark', 'fa-solid fa-border-all' => 'fa-solid fa-border-all', 'fa-solid fa-border-none' => 'fa-solid fa-border-none', 'fa-solid fa-border-style' => 'fa-solid fa-border-style', 'fa-solid fa-bowling-ball' => 'fa-solid fa-bowling-ball', 'fa-solid fa-box' => 'fa-solid fa-box', 'fa-solid fa-box-open' => 'fa-solid fa-box-open', 'fa-solid fa-boxes' => 'fa-solid fa-boxes', 'fa-solid fa-braille' => 'fa-solid fa-braille', 'fa-solid fa-brain' => 'fa-solid fa-brain', 'fa-solid fa-bread-slice' => 'fa-solid fa-bread-slice', 'fa-solid fa-briefcase' => 'fa-solid fa-briefcase', 'fa-solid fa-briefcase-medical' => 'fa-solid fa-briefcase-medical', 'fa-solid fa-broadcast-tower' => 'fa-solid fa-broadcast-tower', 'fa-solid fa-broom' => 'fa-solid fa-broom', 'fa-solid fa-brush' => 'fa-solid fa-brush', 'fa-solid fa-bug' => 'fa-solid fa-bug', 'fa-solid fa-building' => 'fa-solid fa-building', 'fa-solid fa-bullhorn' => 'fa-solid fa-bullhorn', 'fa-solid fa-bullseye' => 'fa-solid fa-bullseye', 'fa-solid fa-burn' => 'fa-solid fa-burn', 'fa-solid fa-bus' => 'fa-solid fa-bus', 'fa-solid fa-bus-alt' => 'fa-solid fa-bus-alt', 'fa-solid fa-business-time' => 'fa-solid fa-business-time', 'fa-solid fa-calculator' => 'fa-solid fa-calculator', 'fa-solid fa-calendar' => 'fa-solid fa-calendar', 'fa-solid fa-calendar-alt' => 'fa-solid fa-calendar-alt', 'fa-solid fa-calendar-check' => 'fa-solid fa-calendar-check', 'fa-solid fa-calendar-day' => 'fa-solid fa-calendar-day', 'fa-solid fa-calendar-minus' => 'fa-solid fa-calendar-minus', 'fa-solid fa-calendar-plus' => 'fa-solid fa-calendar-plus', 'fa-solid fa-calendar-times' => 'fa-solid fa-calendar-times', 'fa-solid fa-calendar-week' => 'fa-solid fa-calendar-week', 'fa-solid fa-camera' => 'fa-solid fa-camera', 'fa-solid fa-camera-retro' => 'fa-solid fa-camera-retro', 'fa-solid fa-campground' => 'fa-solid fa-campground', 'fa-solid fa-candy-cane' => 'fa-solid fa-candy-cane', 'fa-solid fa-cannabis' => 'fa-solid fa-cannabis', 'fa-solid fa-capsules' => 'fa-solid fa-capsules', 'fa-solid fa-car' => 'fa-solid fa-car', 'fa-solid fa-car-alt' => 'fa-solid fa-car-alt', 'fa-solid fa-car-battery' => 'fa-solid fa-car-battery', 'fa-solid fa-car-crash' => 'fa-solid fa-car-crash', 'fa-solid fa-car-side' => 'fa-solid fa-car-side', 'fa-solid fa-caret-down' => 'fa-solid fa-caret-down', 'fa-solid fa-caret-left' => 'fa-solid fa-caret-left', 'fa-solid fa-caret-right' => 'fa-solid fa-caret-right', 'fa-solid fa-caret-square-down' => 'fa-solid fa-caret-square-down', 'fa-solid fa-caret-square-left' => 'fa-solid fa-caret-square-left', 'fa-solid fa-caret-square-right' => 'fa-solid fa-caret-square-right', 'fa-solid fa-caret-square-up' => 'fa-solid fa-caret-square-up', 'fa-solid fa-caret-up' => 'fa-solid fa-caret-up', 'fa-solid fa-carrot' => 'fa-solid fa-carrot', 'fa-solid fa-cart-arrow-down' => 'fa-solid fa-cart-arrow-down', 'fa-solid fa-cart-plus' => 'fa-solid fa-cart-plus', 'fa-solid fa-cash-register' => 'fa-solid fa-cash-register', 'fa-solid fa-cat' => 'fa-solid fa-cat', 'fa-solid fa-certificate' => 'fa-solid fa-certificate', 'fa-solid fa-chair' => 'fa-solid fa-chair', 'fa-solid fa-chalkboard' => 'fa-solid fa-chalkboard', 'fa-solid fa-chalkboard-teacher' => 'fa-solid fa-chalkboard-teacher', 'fa-solid fa-charging-station' => 'fa-solid fa-charging-station', 'fa-solid fa-chart-area' => 'fa-solid fa-chart-area', 'fa-solid fa-chart-bar' => 'fa-solid fa-chart-bar', 'fa-solid fa-chart-line' => 'fa-solid fa-chart-line', 'fa-solid fa-chart-pie' => 'fa-solid fa-chart-pie', 'fa-solid fa-check' => 'fa-solid fa-check', 'fa-solid fa-check-circle' => 'fa-solid fa-check-circle', 'fa-solid fa-check-double' => 'fa-solid fa-check-double', 'fa-solid fa-check-square' => 'fa-solid fa-check-square', 'fa-solid fa-cheese' => 'fa-solid fa-cheese', 'fa-solid fa-chess' => 'fa-solid fa-chess', 'fa-solid fa-chess-bishop' => 'fa-solid fa-chess-bishop', 'fa-solid fa-chess-board' => 'fa-solid fa-chess-board', 'fa-solid fa-chess-king' => 'fa-solid fa-chess-king', 'fa-solid fa-chess-knight' => 'fa-solid fa-chess-knight', 'fa-solid fa-chess-pawn' => 'fa-solid fa-chess-pawn', 'fa-solid fa-chess-queen' => 'fa-solid fa-chess-queen', 'fa-solid fa-chess-rook' => 'fa-solid fa-chess-rook', 'fa-solid fa-chevron-circle-down' => 'fa-solid fa-chevron-circle-down', 'fa-solid fa-chevron-circle-left' => 'fa-solid fa-chevron-circle-left', 'fa-solid fa-chevron-circle-right' => 'fa-solid fa-chevron-circle-right', 'fa-solid fa-chevron-circle-up' => 'fa-solid fa-chevron-circle-up', 'fa-solid fa-chevron-down' => 'fa-solid fa-chevron-down', 'fa-solid fa-chevron-left' => 'fa-solid fa-chevron-left', 'fa-solid fa-chevron-right' => 'fa-solid fa-chevron-right', 'fa-solid fa-chevron-up' => 'fa-solid fa-chevron-up', 'fa-solid fa-child' => 'fa-solid fa-child', 'fa-solid fa-church' => 'fa-solid fa-church', 'fa-solid fa-circle' => 'fa-solid fa-circle', 'fa-solid fa-circle-notch' => 'fa-solid fa-circle-notch', 'fa-solid fa-city' => 'fa-solid fa-city', 'fa-solid fa-clinic-medical' => 'fa-solid fa-clinic-medical', 'fa-solid fa-clipboard' => 'fa-solid fa-clipboard', 'fa-solid fa-clipboard-check' => 'fa-solid fa-clipboard-check', 'fa-solid fa-clipboard-list' => 'fa-solid fa-clipboard-list', 'fa-solid fa-clock' => 'fa-solid fa-clock', 'fa-solid fa-clone' => 'fa-solid fa-clone', 'fa-solid fa-closed-captioning' => 'fa-solid fa-closed-captioning', 'fa-solid fa-cloud' => 'fa-solid fa-cloud', 'fa-solid fa-cloud-download-alt' => 'fa-solid fa-cloud-download-alt', 'fa-solid fa-cloud-meatball' => 'fa-solid fa-cloud-meatball', 'fa-solid fa-cloud-moon' => 'fa-solid fa-cloud-moon', 'fa-solid fa-cloud-moon-rain' => 'fa-solid fa-cloud-moon-rain', 'fa-solid fa-cloud-rain' => 'fa-solid fa-cloud-rain', 'fa-solid fa-cloud-showers-heavy' => 'fa-solid fa-cloud-showers-heavy', 'fa-solid fa-cloud-sun' => 'fa-solid fa-cloud-sun', 'fa-solid fa-cloud-sun-rain' => 'fa-solid fa-cloud-sun-rain', 'fa-solid fa-cloud-upload-alt' => 'fa-solid fa-cloud-upload-alt', 'fa-solid fa-cocktail' => 'fa-solid fa-cocktail', 'fa-solid fa-code' => 'fa-solid fa-code', 'fa-solid fa-code-branch' => 'fa-solid fa-code-branch', 'fa-solid fa-coffee' => 'fa-solid fa-coffee', 'fa-solid fa-cog' => 'fa-solid fa-cog', 'fa-solid fa-cogs' => 'fa-solid fa-cogs', 'fa-solid fa-coins' => 'fa-solid fa-coins', 'fa-solid fa-columns' => 'fa-solid fa-columns', 'fa-solid fa-comment' => 'fa-solid fa-comment', 'fa-solid fa-comment-alt' => 'fa-solid fa-comment-alt', 'fa-solid fa-comment-dollar' => 'fa-solid fa-comment-dollar', 'fa-solid fa-comment-dots' => 'fa-solid fa-comment-dots', 'fa-solid fa-comment-medical' => 'fa-solid fa-comment-medical', 'fa-solid fa-comment-slash' => 'fa-solid fa-comment-slash', 'fa-solid fa-comments' => 'fa-solid fa-comments', 'fa-solid fa-comments-dollar' => 'fa-solid fa-comments-dollar', 'fa-solid fa-compact-disc' => 'fa-solid fa-compact-disc', 'fa-solid fa-compass' => 'fa-solid fa-compass', 'fa-solid fa-compress' => 'fa-solid fa-compress', 'fa-solid fa-compress-arrows-alt' => 'fa-solid fa-compress-arrows-alt', 'fa-solid fa-concierge-bell' => 'fa-solid fa-concierge-bell', 'fa-solid fa-cookie' => 'fa-solid fa-cookie', 'fa-solid fa-cookie-bite' => 'fa-solid fa-cookie-bite', 'fa-solid fa-copy' => 'fa-solid fa-copy', 'fa-solid fa-copyright' => 'fa-solid fa-copyright', 'fa-solid fa-couch' => 'fa-solid fa-couch', 'fa-solid fa-credit-card' => 'fa-solid fa-credit-card', 'fa-solid fa-crop' => 'fa-solid fa-crop', 'fa-solid fa-crop-alt' => 'fa-solid fa-crop-alt', 'fa-solid fa-cross' => 'fa-solid fa-cross', 'fa-solid fa-crosshairs' => 'fa-solid fa-crosshairs', 'fa-solid fa-crow' => 'fa-solid fa-crow', 'fa-solid fa-crown' => 'fa-solid fa-crown', 'fa-solid fa-crutch' => 'fa-solid fa-crutch', 'fa-solid fa-cube' => 'fa-solid fa-cube', 'fa-solid fa-cubes' => 'fa-solid fa-cubes', 'fa-solid fa-cut' => 'fa-solid fa-cut', 'fa-solid fa-database' => 'fa-solid fa-database', 'fa-solid fa-deaf' => 'fa-solid fa-deaf', 'fa-solid fa-democrat' => 'fa-solid fa-democrat', 'fa-solid fa-desktop' => 'fa-solid fa-desktop', 'fa-solid fa-dharmachakra' => 'fa-solid fa-dharmachakra', 'fa-solid fa-diagnoses' => 'fa-solid fa-diagnoses', 'fa-solid fa-dice' => 'fa-solid fa-dice', 'fa-solid fa-dice-d20' => 'fa-solid fa-dice-d20', 'fa-solid fa-dice-d6' => 'fa-solid fa-dice-d6', 'fa-solid fa-dice-five' => 'fa-solid fa-dice-five', 'fa-solid fa-dice-four' => 'fa-solid fa-dice-four', 'fa-solid fa-dice-one' => 'fa-solid fa-dice-one', 'fa-solid fa-dice-six' => 'fa-solid fa-dice-six', 'fa-solid fa-dice-three' => 'fa-solid fa-dice-three', 'fa-solid fa-dice-two' => 'fa-solid fa-dice-two', 'fa-solid fa-digital-tachograph' => 'fa-solid fa-digital-tachograph', 'fa-solid fa-directions' => 'fa-solid fa-directions', 'fa-solid fa-divide' => 'fa-solid fa-divide', 'fa-solid fa-dizzy' => 'fa-solid fa-dizzy', 'fa-solid fa-dna' => 'fa-solid fa-dna', 'fa-solid fa-dog' => 'fa-solid fa-dog', 'fa-solid fa-dollar-sign' => 'fa-solid fa-dollar-sign', 'fa-solid fa-dolly' => 'fa-solid fa-dolly', 'fa-solid fa-dolly-flatbed' => 'fa-solid fa-dolly-flatbed', 'fa-solid fa-donate' => 'fa-solid fa-donate', 'fa-solid fa-door-closed' => 'fa-solid fa-door-closed', 'fa-solid fa-door-open' => 'fa-solid fa-door-open', 'fa-solid fa-dot-circle' => 'fa-solid fa-dot-circle', 'fa-solid fa-dove' => 'fa-solid fa-dove', 'fa-solid fa-download' => 'fa-solid fa-download', 'fa-solid fa-drafting-compass' => 'fa-solid fa-drafting-compass', 'fa-solid fa-dragon' => 'fa-solid fa-dragon', 'fa-solid fa-draw-polygon' => 'fa-solid fa-draw-polygon', 'fa-solid fa-drum' => 'fa-solid fa-drum', 'fa-solid fa-drum-steelpan' => 'fa-solid fa-drum-steelpan', 'fa-solid fa-drumstick-bite' => 'fa-solid fa-drumstick-bite', 'fa-solid fa-dumbbell' => 'fa-solid fa-dumbbell', 'fa-solid fa-dumpster' => 'fa-solid fa-dumpster', 'fa-solid fa-dumpster-fire' => 'fa-solid fa-dumpster-fire', 'fa-solid fa-dungeon' => 'fa-solid fa-dungeon', 'fa-solid fa-edit' => 'fa-solid fa-edit', 'fa-solid fa-egg' => 'fa-solid fa-egg', 'fa-solid fa-eject' => 'fa-solid fa-eject', 'fa-solid fa-ellipsis-h' => 'fa-solid fa-ellipsis-h', 'fa-solid fa-ellipsis-v' => 'fa-solid fa-ellipsis-v', 'fa-solid fa-envelope' => 'fa-solid fa-envelope', 'fa-solid fa-envelope-open' => 'fa-solid fa-envelope-open', 'fa-solid fa-envelope-open-text' => 'fa-solid fa-envelope-open-text', 'fa-solid fa-envelope-square' => 'fa-solid fa-envelope-square', 'fa-solid fa-equals' => 'fa-solid fa-equals', 'fa-solid fa-eraser' => 'fa-solid fa-eraser', 'fa-solid fa-ethernet' => 'fa-solid fa-ethernet', 'fa-solid fa-euro-sign' => 'fa-solid fa-euro-sign', 'fa-solid fa-exchange-alt' => 'fa-solid fa-exchange-alt', 'fa-solid fa-exclamation' => 'fa-solid fa-exclamation', 'fa-solid fa-exclamation-circle' => 'fa-solid fa-exclamation-circle', 'fa-solid fa-exclamation-triangle' => 'fa-solid fa-exclamation-triangle', 'fa-solid fa-expand' => 'fa-solid fa-expand', 'fa-solid fa-expand-arrows-alt' => 'fa-solid fa-expand-arrows-alt', 'fa-solid fa-external-link-alt' => 'fa-solid fa-external-link-alt', 'fa-solid fa-external-link-square-alt' => 'fa-solid fa-external-link-square-alt', 'fa-solid fa-eye' => 'fa-solid fa-eye', 'fa-solid fa-eye-dropper' => 'fa-solid fa-eye-dropper', 'fa-solid fa-eye-slash' => 'fa-solid fa-eye-slash', 'fa-solid fa-fan' => 'fa-solid fa-fan', 'fa-solid fa-fax' => 'fa-solid fa-fax', 'fa-solid fa-feather' => 'fa-solid fa-feather', 'fa-solid fa-feather-alt' => 'fa-solid fa-feather-alt', 'fa-solid fa-female' => 'fa-solid fa-female', 'fa-solid fa-fighter-jet' => 'fa-solid fa-fighter-jet', 'fa-solid fa-file' => 'fa-solid fa-file', 'fa-solid fa-file-alt' => 'fa-solid fa-file-alt', 'fa-solid fa-file-archive' => 'fa-solid fa-file-archive', 'fa-solid fa-file-audio' => 'fa-solid fa-file-audio', 'fa-solid fa-file-code' => 'fa-solid fa-file-code', 'fa-solid fa-file-contract' => 'fa-solid fa-file-contract', 'fa-solid fa-file-csv' => 'fa-solid fa-file-csv', 'fa-solid fa-file-download' => 'fa-solid fa-file-download', 'fa-solid fa-file-excel' => 'fa-solid fa-file-excel', 'fa-solid fa-file-export' => 'fa-solid fa-file-export', 'fa-solid fa-file-image' => 'fa-solid fa-file-image', 'fa-solid fa-file-import' => 'fa-solid fa-file-import', 'fa-solid fa-file-invoice' => 'fa-solid fa-file-invoice', 'fa-solid fa-file-invoice-dollar' => 'fa-solid fa-file-invoice-dollar', 'fa-solid fa-file-medical' => 'fa-solid fa-file-medical', 'fa-solid fa-file-medical-alt' => 'fa-solid fa-file-medical-alt', 'fa-solid fa-file-pdf' => 'fa-solid fa-file-pdf', 'fa-solid fa-file-powerpoint' => 'fa-solid fa-file-powerpoint', 'fa-solid fa-file-prescription' => 'fa-solid fa-file-prescription', 'fa-solid fa-file-signature' => 'fa-solid fa-file-signature', 'fa-solid fa-file-upload' => 'fa-solid fa-file-upload', 'fa-solid fa-file-video' => 'fa-solid fa-file-video', 'fa-solid fa-file-word' => 'fa-solid fa-file-word', 'fa-solid fa-fill' => 'fa-solid fa-fill', 'fa-solid fa-fill-drip' => 'fa-solid fa-fill-drip', 'fa-solid fa-film' => 'fa-solid fa-film', 'fa-solid fa-filter' => 'fa-solid fa-filter', 'fa-solid fa-fingerprint' => 'fa-solid fa-fingerprint', 'fa-solid fa-fire' => 'fa-solid fa-fire', 'fa-solid fa-fire-alt' => 'fa-solid fa-fire-alt', 'fa-solid fa-fire-extinguisher' => 'fa-solid fa-fire-extinguisher', 'fa-solid fa-first-aid' => 'fa-solid fa-first-aid', 'fa-solid fa-fish' => 'fa-solid fa-fish', 'fa-solid fa-fist-raised' => 'fa-solid fa-fist-raised', 'fa-solid fa-flag' => 'fa-solid fa-flag', 'fa-solid fa-flag-checkered' => 'fa-solid fa-flag-checkered', 'fa-solid fa-flag-usa' => 'fa-solid fa-flag-usa', 'fa-solid fa-flask' => 'fa-solid fa-flask', 'fa-solid fa-flushed' => 'fa-solid fa-flushed', 'fa-solid fa-folder' => 'fa-solid fa-folder', 'fa-solid fa-folder-minus' => 'fa-solid fa-folder-minus', 'fa-solid fa-folder-open' => 'fa-solid fa-folder-open', 'fa-solid fa-folder-plus' => 'fa-solid fa-folder-plus', 'fa-solid fa-font' => 'fa-solid fa-font', 'fa-solid fa-football-ball' => 'fa-solid fa-football-ball', 'fa-solid fa-forward' => 'fa-solid fa-forward', 'fa-solid fa-frog' => 'fa-solid fa-frog', 'fa-solid fa-frown' => 'fa-solid fa-frown', 'fa-solid fa-frown-open' => 'fa-solid fa-frown-open', 'fa-solid fa-funnel-dollar' => 'fa-solid fa-funnel-dollar', 'fa-solid fa-futbol' => 'fa-solid fa-futbol', 'fa-solid fa-gamepad' => 'fa-solid fa-gamepad', 'fa-solid fa-gas-pump' => 'fa-solid fa-gas-pump', 'fa-solid fa-gavel' => 'fa-solid fa-gavel', 'fa-solid fa-gem' => 'fa-solid fa-gem', 'fa-solid fa-genderless' => 'fa-solid fa-genderless', 'fa-solid fa-ghost' => 'fa-solid fa-ghost', 'fa-solid fa-gift' => 'fa-solid fa-gift', 'fa-solid fa-gifts' => 'fa-solid fa-gifts', 'fa-solid fa-glass-cheers' => 'fa-solid fa-glass-cheers', 'fa-solid fa-glass-martini' => 'fa-solid fa-glass-martini', 'fa-solid fa-glass-martini-alt' => 'fa-solid fa-glass-martini-alt', 'fa-solid fa-glass-whiskey' => 'fa-solid fa-glass-whiskey', 'fa-solid fa-glasses' => 'fa-solid fa-glasses', 'fa-solid fa-globe' => 'fa-solid fa-globe', 'fa-solid fa-globe-africa' => 'fa-solid fa-globe-africa', 'fa-solid fa-globe-americas' => 'fa-solid fa-globe-americas', 'fa-solid fa-globe-asia' => 'fa-solid fa-globe-asia', 'fa-solid fa-globe-europe' => 'fa-solid fa-globe-europe', 'fa-solid fa-golf-ball' => 'fa-solid fa-golf-ball', 'fa-solid fa-gopuram' => 'fa-solid fa-gopuram', 'fa-solid fa-graduation-cap' => 'fa-solid fa-graduation-cap', 'fa-solid fa-greater-than' => 'fa-solid fa-greater-than', 'fa-solid fa-greater-than-equal' => 'fa-solid fa-greater-than-equal', 'fa-solid fa-grimace' => 'fa-solid fa-grimace', 'fa-solid fa-grin' => 'fa-solid fa-grin', 'fa-solid fa-grin-alt' => 'fa-solid fa-grin-alt', 'fa-solid fa-grin-beam' => 'fa-solid fa-grin-beam', 'fa-solid fa-grin-beam-sweat' => 'fa-solid fa-grin-beam-sweat', 'fa-solid fa-grin-hearts' => 'fa-solid fa-grin-hearts', 'fa-solid fa-grin-squint' => 'fa-solid fa-grin-squint', 'fa-solid fa-grin-squint-tears' => 'fa-solid fa-grin-squint-tears', 'fa-solid fa-grin-stars' => 'fa-solid fa-grin-stars', 'fa-solid fa-grin-tears' => 'fa-solid fa-grin-tears', 'fa-solid fa-grin-tongue' => 'fa-solid fa-grin-tongue', 'fa-solid fa-grin-tongue-squint' => 'fa-solid fa-grin-tongue-squint', 'fa-solid fa-grin-tongue-wink' => 'fa-solid fa-grin-tongue-wink', 'fa-solid fa-grin-wink' => 'fa-solid fa-grin-wink', 'fa-solid fa-grip-horizontal' => 'fa-solid fa-grip-horizontal', 'fa-solid fa-grip-lines' => 'fa-solid fa-grip-lines', 'fa-solid fa-grip-lines-vertical' => 'fa-solid fa-grip-lines-vertical', 'fa-solid fa-grip-vertical' => 'fa-solid fa-grip-vertical', 'fa-solid fa-guitar' => 'fa-solid fa-guitar', 'fa-solid fa-h-square' => 'fa-solid fa-h-square', 'fa-solid fa-hamburger' => 'fa-solid fa-hamburger', 'fa-solid fa-hammer' => 'fa-solid fa-hammer', 'fa-solid fa-hamsa' => 'fa-solid fa-hamsa', 'fa-solid fa-hand-holding' => 'fa-solid fa-hand-holding', 'fa-solid fa-hand-holding-heart' => 'fa-solid fa-hand-holding-heart', 'fa-solid fa-hand-holding-usd' => 'fa-solid fa-hand-holding-usd', 'fa-solid fa-hand-lizard' => 'fa-solid fa-hand-lizard', 'fa-solid fa-hand-middle-finger' => 'fa-solid fa-hand-middle-finger', 'fa-solid fa-hand-paper' => 'fa-solid fa-hand-paper', 'fa-solid fa-hand-peace' => 'fa-solid fa-hand-peace', 'fa-solid fa-hand-point-down' => 'fa-solid fa-hand-point-down', 'fa-solid fa-hand-point-left' => 'fa-solid fa-hand-point-left', 'fa-solid fa-hand-point-right' => 'fa-solid fa-hand-point-right', 'fa-solid fa-hand-point-up' => 'fa-solid fa-hand-point-up', 'fa-solid fa-hand-pointer' => 'fa-solid fa-hand-pointer', 'fa-solid fa-hand-rock' => 'fa-solid fa-hand-rock', 'fa-solid fa-hand-scissors' => 'fa-solid fa-hand-scissors', 'fa-solid fa-hand-spock' => 'fa-solid fa-hand-spock', 'fa-solid fa-hands' => 'fa-solid fa-hands', 'fa-solid fa-hands-helping' => 'fa-solid fa-hands-helping', 'fa-solid fa-handshake' => 'fa-solid fa-handshake', 'fa-solid fa-hanukiah' => 'fa-solid fa-hanukiah', 'fa-solid fa-hard-hat' => 'fa-solid fa-hard-hat', 'fa-solid fa-hashtag' => 'fa-solid fa-hashtag', 'fa-solid fa-hat-wizard' => 'fa-solid fa-hat-wizard', 'fa-solid fa-hdd' => 'fa-solid fa-hdd', 'fa-solid fa-heading' => 'fa-solid fa-heading', 'fa-solid fa-headphones' => 'fa-solid fa-headphones', 'fa-solid fa-headphones-alt' => 'fa-solid fa-headphones-alt', 'fa-solid fa-headset' => 'fa-solid fa-headset', 'fa-solid fa-heart' => 'fa-solid fa-heart', 'fa-solid fa-heart-broken' => 'fa-solid fa-heart-broken', 'fa-solid fa-heartbeat' => 'fa-solid fa-heartbeat', 'fa-solid fa-helicopter' => 'fa-solid fa-helicopter', 'fa-solid fa-highlighter' => 'fa-solid fa-highlighter', 'fa-solid fa-hiking' => 'fa-solid fa-hiking', 'fa-solid fa-hippo' => 'fa-solid fa-hippo', 'fa-solid fa-history' => 'fa-solid fa-history', 'fa-solid fa-hockey-puck' => 'fa-solid fa-hockey-puck', 'fa-solid fa-holly-berry' => 'fa-solid fa-holly-berry', 'fa-solid fa-home' => 'fa-solid fa-home', 'fa-solid fa-horse' => 'fa-solid fa-horse', 'fa-solid fa-horse-head' => 'fa-solid fa-horse-head', 'fa-solid fa-hospital' => 'fa-solid fa-hospital', 'fa-solid fa-hospital-alt' => 'fa-solid fa-hospital-alt', 'fa-solid fa-hospital-symbol' => 'fa-solid fa-hospital-symbol', 'fa-solid fa-hot-tub' => 'fa-solid fa-hot-tub', 'fa-solid fa-hotdog' => 'fa-solid fa-hotdog', 'fa-solid fa-hotel' => 'fa-solid fa-hotel', 'fa-solid fa-hourglass' => 'fa-solid fa-hourglass', 'fa-solid fa-hourglass-end' => 'fa-solid fa-hourglass-end', 'fa-solid fa-hourglass-half' => 'fa-solid fa-hourglass-half', 'fa-solid fa-hourglass-start' => 'fa-solid fa-hourglass-start', 'fa-solid fa-house-damage' => 'fa-solid fa-house-damage', 'fa-solid fa-hryvnia' => 'fa-solid fa-hryvnia', 'fa-solid fa-i-cursor' => 'fa-solid fa-i-cursor', 'fa-solid fa-ice-cream' => 'fa-solid fa-ice-cream', 'fa-solid fa-icicles' => 'fa-solid fa-icicles', 'fa-solid fa-icons' => 'fa-solid fa-icons', 'fa-solid fa-id-badge' => 'fa-solid fa-id-badge', 'fa-solid fa-id-card' => 'fa-solid fa-id-card', 'fa-solid fa-id-card-alt' => 'fa-solid fa-id-card-alt', 'fa-solid fa-igloo' => 'fa-solid fa-igloo', 'fa-solid fa-image' => 'fa-solid fa-image', 'fa-solid fa-images' => 'fa-solid fa-images', 'fa-solid fa-inbox' => 'fa-solid fa-inbox', 'fa-solid fa-indent' => 'fa-solid fa-indent', 'fa-solid fa-industry' => 'fa-solid fa-industry', 'fa-solid fa-infinity' => 'fa-solid fa-infinity', 'fa-solid fa-info' => 'fa-solid fa-info', 'fa-solid fa-info-circle' => 'fa-solid fa-info-circle', 'fa-solid fa-italic' => 'fa-solid fa-italic', 'fa-solid fa-jedi' => 'fa-solid fa-jedi', 'fa-solid fa-joint' => 'fa-solid fa-joint', 'fa-solid fa-journal-whills' => 'fa-solid fa-journal-whills', 'fa-solid fa-kaaba' => 'fa-solid fa-kaaba', 'fa-solid fa-key' => 'fa-solid fa-key', 'fa-solid fa-keyboard' => 'fa-solid fa-keyboard', 'fa-solid fa-khanda' => 'fa-solid fa-khanda', 'fa-solid fa-kiss' => 'fa-solid fa-kiss', 'fa-solid fa-kiss-beam' => 'fa-solid fa-kiss-beam', 'fa-solid fa-kiss-wink-heart' => 'fa-solid fa-kiss-wink-heart', 'fa-solid fa-kiwi-bird' => 'fa-solid fa-kiwi-bird', 'fa-solid fa-landmark' => 'fa-solid fa-landmark', 'fa-solid fa-language' => 'fa-solid fa-language', 'fa-solid fa-laptop' => 'fa-solid fa-laptop', 'fa-solid fa-laptop-code' => 'fa-solid fa-laptop-code', 'fa-solid fa-laptop-medical' => 'fa-solid fa-laptop-medical', 'fa-solid fa-laugh' => 'fa-solid fa-laugh', 'fa-solid fa-laugh-beam' => 'fa-solid fa-laugh-beam', 'fa-solid fa-laugh-squint' => 'fa-solid fa-laugh-squint', 'fa-solid fa-laugh-wink' => 'fa-solid fa-laugh-wink', 'fa-solid fa-layer-group' => 'fa-solid fa-layer-group', 'fa-solid fa-leaf' => 'fa-solid fa-leaf', 'fa-solid fa-lemon' => 'fa-solid fa-lemon', 'fa-solid fa-less-than' => 'fa-solid fa-less-than', 'fa-solid fa-less-than-equal' => 'fa-solid fa-less-than-equal', 'fa-solid fa-level-down-alt' => 'fa-solid fa-level-down-alt', 'fa-solid fa-level-up-alt' => 'fa-solid fa-level-up-alt', 'fa-solid fa-life-ring' => 'fa-solid fa-life-ring', 'fa-solid fa-lightbulb' => 'fa-solid fa-lightbulb', 'fa-solid fa-link' => 'fa-solid fa-link', 'fa-solid fa-lira-sign' => 'fa-solid fa-lira-sign', 'fa-solid fa-list' => 'fa-solid fa-list', 'fa-solid fa-list-alt' => 'fa-solid fa-list-alt', 'fa-solid fa-list-ol' => 'fa-solid fa-list-ol', 'fa-solid fa-list-ul' => 'fa-solid fa-list-ul', 'fa-solid fa-location-arrow' => 'fa-solid fa-location-arrow', 'fa-solid fa-lock' => 'fa-solid fa-lock', 'fa-solid fa-lock-open' => 'fa-solid fa-lock-open', 'fa-solid fa-long-arrow-alt-down' => 'fa-solid fa-long-arrow-alt-down', 'fa-solid fa-long-arrow-alt-left' => 'fa-solid fa-long-arrow-alt-left', 'fa-solid fa-long-arrow-alt-right' => 'fa-solid fa-long-arrow-alt-right', 'fa-solid fa-long-arrow-alt-up' => 'fa-solid fa-long-arrow-alt-up', 'fa-solid fa-low-vision' => 'fa-solid fa-low-vision', 'fa-solid fa-luggage-cart' => 'fa-solid fa-luggage-cart', 'fa-solid fa-magic' => 'fa-solid fa-magic', 'fa-solid fa-magnet' => 'fa-solid fa-magnet', 'fa-solid fa-mail-bulk' => 'fa-solid fa-mail-bulk', 'fa-solid fa-male' => 'fa-solid fa-male', 'fa-solid fa-map' => 'fa-solid fa-map', 'fa-solid fa-map-marked' => 'fa-solid fa-map-marked', 'fa-solid fa-map-marked-alt' => 'fa-solid fa-map-marked-alt', 'fa-solid fa-map-marker' => 'fa-solid fa-map-marker', 'fa-solid fa-map-marker-alt' => 'fa-solid fa-map-marker-alt', 'fa-solid fa-map-pin' => 'fa-solid fa-map-pin', 'fa-solid fa-map-signs' => 'fa-solid fa-map-signs', 'fa-solid fa-marker' => 'fa-solid fa-marker', 'fa-solid fa-mars' => 'fa-solid fa-mars', 'fa-solid fa-mars-double' => 'fa-solid fa-mars-double', 'fa-solid fa-mars-stroke' => 'fa-solid fa-mars-stroke', 'fa-solid fa-mars-stroke-h' => 'fa-solid fa-mars-stroke-h', 'fa-solid fa-mars-stroke-v' => 'fa-solid fa-mars-stroke-v', 'fa-solid fa-mask' => 'fa-solid fa-mask', 'fa-solid fa-medal' => 'fa-solid fa-medal', 'fa-solid fa-medkit' => 'fa-solid fa-medkit', 'fa-solid fa-meh' => 'fa-solid fa-meh', 'fa-solid fa-meh-blank' => 'fa-solid fa-meh-blank', 'fa-solid fa-meh-rolling-eyes' => 'fa-solid fa-meh-rolling-eyes', 'fa-solid fa-memory' => 'fa-solid fa-memory', 'fa-solid fa-menorah' => 'fa-solid fa-menorah', 'fa-solid fa-mercury' => 'fa-solid fa-mercury', 'fa-solid fa-meteor' => 'fa-solid fa-meteor', 'fa-solid fa-microchip' => 'fa-solid fa-microchip', 'fa-solid fa-microphone' => 'fa-solid fa-microphone', 'fa-solid fa-microphone-alt' => 'fa-solid fa-microphone-alt', 'fa-solid fa-microphone-alt-slash' => 'fa-solid fa-microphone-alt-slash', 'fa-solid fa-microphone-slash' => 'fa-solid fa-microphone-slash', 'fa-solid fa-microscope' => 'fa-solid fa-microscope', 'fa-solid fa-minus' => 'fa-solid fa-minus', 'fa-solid fa-minus-circle' => 'fa-solid fa-minus-circle', 'fa-solid fa-minus-square' => 'fa-solid fa-minus-square', 'fa-solid fa-mitten' => 'fa-solid fa-mitten', 'fa-solid fa-mobile' => 'fa-solid fa-mobile', 'fa-solid fa-mobile-alt' => 'fa-solid fa-mobile-alt', 'fa-solid fa-money-bill' => 'fa-solid fa-money-bill', 'fa-solid fa-money-bill-alt' => 'fa-solid fa-money-bill-alt', 'fa-solid fa-money-bill-wave' => 'fa-solid fa-money-bill-wave', 'fa-solid fa-money-bill-wave-alt' => 'fa-solid fa-money-bill-wave-alt', 'fa-solid fa-money-check' => 'fa-solid fa-money-check', 'fa-solid fa-money-check-alt' => 'fa-solid fa-money-check-alt', 'fa-solid fa-monument' => 'fa-solid fa-monument', 'fa-solid fa-moon' => 'fa-solid fa-moon', 'fa-solid fa-mortar-pestle' => 'fa-solid fa-mortar-pestle', 'fa-solid fa-mosque' => 'fa-solid fa-mosque', 'fa-solid fa-motorcycle' => 'fa-solid fa-motorcycle', 'fa-solid fa-mountain' => 'fa-solid fa-mountain', 'fa-solid fa-mouse-pointer' => 'fa-solid fa-mouse-pointer', 'fa-solid fa-mug-hot' => 'fa-solid fa-mug-hot', 'fa-solid fa-music' => 'fa-solid fa-music', 'fa-solid fa-network-wired' => 'fa-solid fa-network-wired', 'fa-solid fa-neuter' => 'fa-solid fa-neuter', 'fa-solid fa-newspaper' => 'fa-solid fa-newspaper', 'fa-solid fa-not-equal' => 'fa-solid fa-not-equal', 'fa-solid fa-notes-medical' => 'fa-solid fa-notes-medical', 'fa-solid fa-object-group' => 'fa-solid fa-object-group', 'fa-solid fa-object-ungroup' => 'fa-solid fa-object-ungroup', 'fa-solid fa-oil-can' => 'fa-solid fa-oil-can', 'fa-solid fa-om' => 'fa-solid fa-om', 'fa-solid fa-otter' => 'fa-solid fa-otter', 'fa-solid fa-outdent' => 'fa-solid fa-outdent', 'fa-solid fa-pager' => 'fa-solid fa-pager', 'fa-solid fa-paint-brush' => 'fa-solid fa-paint-brush', 'fa-solid fa-paint-roller' => 'fa-solid fa-paint-roller', 'fa-solid fa-palette' => 'fa-solid fa-palette', 'fa-solid fa-pallet' => 'fa-solid fa-pallet', 'fa-solid fa-paper-plane' => 'fa-solid fa-paper-plane', 'fa-solid fa-paperclip' => 'fa-solid fa-paperclip', 'fa-solid fa-parachute-box' => 'fa-solid fa-parachute-box', 'fa-solid fa-paragraph' => 'fa-solid fa-paragraph', 'fa-solid fa-parking' => 'fa-solid fa-parking', 'fa-solid fa-passport' => 'fa-solid fa-passport', 'fa-solid fa-pastafarianism' => 'fa-solid fa-pastafarianism', 'fa-solid fa-paste' => 'fa-solid fa-paste', 'fa-solid fa-pause' => 'fa-solid fa-pause', 'fa-solid fa-pause-circle' => 'fa-solid fa-pause-circle', 'fa-solid fa-paw' => 'fa-solid fa-paw', 'fa-solid fa-peace' => 'fa-solid fa-peace', 'fa-solid fa-pen' => 'fa-solid fa-pen', 'fa-solid fa-pen-alt' => 'fa-solid fa-pen-alt', 'fa-solid fa-pen-fancy' => 'fa-solid fa-pen-fancy', 'fa-solid fa-pen-nib' => 'fa-solid fa-pen-nib', 'fa-solid fa-pen-square' => 'fa-solid fa-pen-square', 'fa-solid fa-pencil-alt' => 'fa-solid fa-pencil-alt', 'fa-solid fa-pencil-ruler' => 'fa-solid fa-pencil-ruler', 'fa-solid fa-people-carry' => 'fa-solid fa-people-carry', 'fa-solid fa-pepper-hot' => 'fa-solid fa-pepper-hot', 'fa-solid fa-percent' => 'fa-solid fa-percent', 'fa-solid fa-percentage' => 'fa-solid fa-percentage', 'fa-solid fa-person-booth' => 'fa-solid fa-person-booth', 'fa-solid fa-phone' => 'fa-solid fa-phone', 'fa-solid fa-phone-alt' => 'fa-solid fa-phone-alt', 'fa-solid fa-phone-slash' => 'fa-solid fa-phone-slash', 'fa-solid fa-phone-square' => 'fa-solid fa-phone-square', 'fa-solid fa-phone-square-alt' => 'fa-solid fa-phone-square-alt', 'fa-solid fa-phone-volume' => 'fa-solid fa-phone-volume', 'fa-solid fa-photo-video' => 'fa-solid fa-photo-video', 'fa-solid fa-piggy-bank' => 'fa-solid fa-piggy-bank', 'fa-solid fa-pills' => 'fa-solid fa-pills', 'fa-solid fa-pizza-slice' => 'fa-solid fa-pizza-slice', 'fa-solid fa-place-of-worship' => 'fa-solid fa-place-of-worship', 'fa-solid fa-plane' => 'fa-solid fa-plane', 'fa-solid fa-plane-arrival' => 'fa-solid fa-plane-arrival', 'fa-solid fa-plane-departure' => 'fa-solid fa-plane-departure', 'fa-solid fa-play' => 'fa-solid fa-play', 'fa-solid fa-play-circle' => 'fa-solid fa-play-circle', 'fa-solid fa-plug' => 'fa-solid fa-plug', 'fa-solid fa-plus' => 'fa-solid fa-plus', 'fa-solid fa-plus-circle' => 'fa-solid fa-plus-circle', 'fa-solid fa-plus-square' => 'fa-solid fa-plus-square', 'fa-solid fa-podcast' => 'fa-solid fa-podcast', 'fa-solid fa-poll' => 'fa-solid fa-poll', 'fa-solid fa-poll-h' => 'fa-solid fa-poll-h', 'fa-solid fa-poo' => 'fa-solid fa-poo', 'fa-solid fa-poo-storm' => 'fa-solid fa-poo-storm', 'fa-solid fa-poop' => 'fa-solid fa-poop', 'fa-solid fa-portrait' => 'fa-solid fa-portrait', 'fa-solid fa-pound-sign' => 'fa-solid fa-pound-sign', 'fa-solid fa-power-off' => 'fa-solid fa-power-off', 'fa-solid fa-pray' => 'fa-solid fa-pray', 'fa-solid fa-praying-hands' => 'fa-solid fa-praying-hands', 'fa-solid fa-prescription' => 'fa-solid fa-prescription', 'fa-solid fa-prescription-bottle' => 'fa-solid fa-prescription-bottle', 'fa-solid fa-prescription-bottle-alt' => 'fa-solid fa-prescription-bottle-alt', 'fa-solid fa-print' => 'fa-solid fa-print', 'fa-solid fa-procedures' => 'fa-solid fa-procedures', 'fa-solid fa-project-diagram' => 'fa-solid fa-project-diagram', 'fa-solid fa-puzzle-piece' => 'fa-solid fa-puzzle-piece', 'fa-solid fa-qrcode' => 'fa-solid fa-qrcode', 'fa-solid fa-question' => 'fa-solid fa-question', 'fa-solid fa-question-circle' => 'fa-solid fa-question-circle', 'fa-solid fa-quidditch' => 'fa-solid fa-quidditch', 'fa-solid fa-quote-left' => 'fa-solid fa-quote-left', 'fa-solid fa-quote-right' => 'fa-solid fa-quote-right', 'fa-solid fa-quran' => 'fa-solid fa-quran', 'fa-solid fa-radiation' => 'fa-solid fa-radiation', 'fa-solid fa-radiation-alt' => 'fa-solid fa-radiation-alt', 'fa-solid fa-rainbow' => 'fa-solid fa-rainbow', 'fa-solid fa-random' => 'fa-solid fa-random', 'fa-solid fa-receipt' => 'fa-solid fa-receipt', 'fa-solid fa-recycle' => 'fa-solid fa-recycle', 'fa-solid fa-redo' => 'fa-solid fa-redo', 'fa-solid fa-redo-alt' => 'fa-solid fa-redo-alt', 'fa-solid fa-registered' => 'fa-solid fa-registered', 'fa-solid fa-remove-format' => 'fa-solid fa-remove-format', 'fa-solid fa-reply' => 'fa-solid fa-reply', 'fa-solid fa-reply-all' => 'fa-solid fa-reply-all', 'fa-solid fa-republican' => 'fa-solid fa-republican', 'fa-solid fa-restroom' => 'fa-solid fa-restroom', 'fa-solid fa-retweet' => 'fa-solid fa-retweet', 'fa-solid fa-ribbon' => 'fa-solid fa-ribbon', 'fa-solid fa-ring' => 'fa-solid fa-ring', 'fa-solid fa-road' => 'fa-solid fa-road', 'fa-solid fa-robot' => 'fa-solid fa-robot', 'fa-solid fa-rocket' => 'fa-solid fa-rocket', 'fa-solid fa-route' => 'fa-solid fa-route', 'fa-solid fa-rss' => 'fa-solid fa-rss', 'fa-solid fa-rss-square' => 'fa-solid fa-rss-square', 'fa-solid fa-ruble-sign' => 'fa-solid fa-ruble-sign', 'fa-solid fa-ruler' => 'fa-solid fa-ruler', 'fa-solid fa-ruler-combined' => 'fa-solid fa-ruler-combined', 'fa-solid fa-ruler-horizontal' => 'fa-solid fa-ruler-horizontal', 'fa-solid fa-ruler-vertical' => 'fa-solid fa-ruler-vertical', 'fa-solid fa-running' => 'fa-solid fa-running', 'fa-solid fa-rupee-sign' => 'fa-solid fa-rupee-sign', 'fa-solid fa-sad-cry' => 'fa-solid fa-sad-cry', 'fa-solid fa-sad-tear' => 'fa-solid fa-sad-tear', 'fa-solid fa-satellite' => 'fa-solid fa-satellite', 'fa-solid fa-satellite-dish' => 'fa-solid fa-satellite-dish', 'fa-solid fa-save' => 'fa-solid fa-save', 'fa-solid fa-school' => 'fa-solid fa-school', 'fa-solid fa-screwdriver' => 'fa-solid fa-screwdriver', 'fa-solid fa-scroll' => 'fa-solid fa-scroll', 'fa-solid fa-sd-card' => 'fa-solid fa-sd-card', 'fa-solid fa-search' => 'fa-solid fa-search', 'fa-solid fa-search-dollar' => 'fa-solid fa-search-dollar', 'fa-solid fa-search-location' => 'fa-solid fa-search-location', 'fa-solid fa-search-minus' => 'fa-solid fa-search-minus', 'fa-solid fa-search-plus' => 'fa-solid fa-search-plus', 'fa-solid fa-seedling' => 'fa-solid fa-seedling', 'fa-solid fa-server' => 'fa-solid fa-server', 'fa-solid fa-shapes' => 'fa-solid fa-shapes', 'fa-solid fa-share' => 'fa-solid fa-share', 'fa-solid fa-share-alt' => 'fa-solid fa-share-alt', 'fa-solid fa-share-alt-square' => 'fa-solid fa-share-alt-square', 'fa-solid fa-share-square' => 'fa-solid fa-share-square', 'fa-solid fa-shekel-sign' => 'fa-solid fa-shekel-sign', 'fa-solid fa-shield-alt' => 'fa-solid fa-shield-alt', 'fa-solid fa-ship' => 'fa-solid fa-ship','fa-solid fa-shoe-prints' => 'fa-solid fa-shoe-prints', 'fa-solid fa-shopping-bag' => 'fa-solid fa-shopping-bag', 'fa-solid fa-shopping-basket' => 'fa-solid fa-shopping-basket', 'fa-solid fa-shopping-cart' => 'fa-solid fa-shopping-cart', 'fa-solid fa-shower' => 'fa-solid fa-shower', 'fa-solid fa-shuttle-van' => 'fa-solid fa-shuttle-van', 'fa-solid fa-sign' => 'fa-solid fa-sign', 'fa-solid fa-sign-in-alt' => 'fa-solid fa-sign-in-alt', 'fa-solid fa-sign-language' => 'fa-solid fa-sign-language', 'fa-solid fa-sign-out-alt' => 'fa-solid fa-sign-out-alt', 'fa-solid fa-signal' => 'fa-solid fa-signal', 'fa-solid fa-signature' => 'fa-solid fa-signature', 'fa-solid fa-sim-card' => 'fa-solid fa-sim-card', 'fa-solid fa-sitemap' => 'fa-solid fa-sitemap', 'fa-solid fa-skating' => 'fa-solid fa-skating', 'fa-solid fa-skiing' => 'fa-solid fa-skiing', 'fa-solid fa-skiing-nordic' => 'fa-solid fa-skiing-nordic', 'fa-solid fa-skull' => 'fa-solid fa-skull', 'fa-solid fa-skull-crossbones' => 'fa-solid fa-skull-crossbones', 'fa-solid fa-slash' => 'fa-solid fa-slash', 'fa-solid fa-sleigh' => 'fa-solid fa-sleigh', 'fa-solid fa-sliders-h' => 'fa-solid fa-sliders-h', 'fa-solid fa-smile' => 'fa-solid fa-smile', 'fa-solid fa-smile-beam' => 'fa-solid fa-smile-beam', 'fa-solid fa-smile-wink' => 'fa-solid fa-smile-wink', 'fa-solid fa-smog' => 'fa-solid fa-smog', 'fa-solid fa-smoking' => 'fa-solid fa-smoking', 'fa-solid fa-smoking-ban' => 'fa-solid fa-smoking-ban', 'fa-solid fa-sms' => 'fa-solid fa-sms', 'fa-solid fa-snowboarding' => 'fa-solid fa-snowboarding', 'fa-solid fa-snowflake' => 'fa-solid fa-snowflake', 'fa-solid fa-snowman' => 'fa-solid fa-snowman', 'fa-solid fa-snowplow' => 'fa-solid fa-snowplow', 'fa-solid fa-socks' => 'fa-solid fa-socks', 'fa-solid fa-solar-panel' => 'fa-solid fa-solar-panel', 'fa-solid fa-sort' => 'fa-solid fa-sort', 'fa-solid fa-sort-alpha-down' => 'fa-solid fa-sort-alpha-down', 'fa-solid fa-sort-alpha-down-alt' => 'fa-solid fa-sort-alpha-down-alt', 'fa-solid fa-sort-alpha-up' => 'fa-solid fa-sort-alpha-up', 'fa-solid fa-sort-alpha-up-alt' => 'fa-solid fa-sort-alpha-up-alt', 'fa-solid fa-sort-amount-down' => 'fa-solid fa-sort-amount-down', 'fa-solid fa-sort-amount-down-alt' => 'fa-solid fa-sort-amount-down-alt', 'fa-solid fa-sort-amount-up' => 'fa-solid fa-sort-amount-up', 'fa-solid fa-sort-amount-up-alt' => 'fa-solid fa-sort-amount-up-alt', 'fa-solid fa-sort-down' => 'fa-solid fa-sort-down', 'fa-solid fa-sort-numeric-down' => 'fa-solid fa-sort-numeric-down', 'fa-solid fa-sort-numeric-down-alt' => 'fa-solid fa-sort-numeric-down-alt', 'fa-solid fa-sort-numeric-up' => 'fa-solid fa-sort-numeric-up', 'fa-solid fa-sort-numeric-up-alt' => 'fa-solid fa-sort-numeric-up-alt', 'fa-solid fa-sort-up' => 'fa-solid fa-sort-up', 'fa-solid fa-spa' => 'fa-solid fa-spa', 'fa-solid fa-space-shuttle' => 'fa-solid fa-space-shuttle', 'fa-solid fa-spell-check' => 'fa-solid fa-spell-check', 'fa-solid fa-spider' => 'fa-solid fa-spider', 'fa-solid fa-spinner' => 'fa-solid fa-spinner', 'fa-solid fa-splotch' => 'fa-solid fa-splotch', 'fa-solid fa-spray-can' => 'fa-solid fa-spray-can', 'fa-solid fa-square' => 'fa-solid fa-square', 'fa-solid fa-square-full' => 'fa-solid fa-square-full', 'fa-solid fa-square-root-alt' => 'fa-solid fa-square-root-alt', 'fa-solid fa-stamp' => 'fa-solid fa-stamp', 'fa-solid fa-star' => 'fa-solid fa-star', 'fa-solid fa-star-and-crescent' => 'fa-solid fa-star-and-crescent', 'fa-solid fa-star-half' => 'fa-solid fa-star-half', 'fa-solid fa-star-half-alt' => 'fa-solid fa-star-half-alt', 'fa-solid fa-star-of-david' => 'fa-solid fa-star-of-david', 'fa-solid fa-star-of-life' => 'fa-solid fa-star-of-life', 'fa-solid fa-step-backward' => 'fa-solid fa-step-backward', 'fa-solid fa-step-forward' => 'fa-solid fa-step-forward', 'fa-solid fa-stethoscope' => 'fa-solid fa-stethoscope', 'fa-solid fa-sticky-note' => 'fa-solid fa-sticky-note', 'fa-solid fa-stop' => 'fa-solid fa-stop', 'fa-solid fa-stop-circle' => 'fa-solid fa-stop-circle', 'fa-solid fa-stopwatch' => 'fa-solid fa-stopwatch', 'fa-solid fa-store' => 'fa-solid fa-store', 'fa-solid fa-store-alt' => 'fa-solid fa-store-alt', 'fa-solid fa-stream' => 'fa-solid fa-stream', 'fa-solid fa-street-view' => 'fa-solid fa-street-view', 'fa-solid fa-strikethrough' => 'fa-solid fa-strikethrough', 'fa-solid fa-stroopwafel' => 'fa-solid fa-stroopwafel', 'fa-solid fa-subscript' => 'fa-solid fa-subscript', 'fa-solid fa-subway' => 'fa-solid fa-subway', 'fa-solid fa-suitcase' => 'fa-solid fa-suitcase', 'fa-solid fa-suitcase-rolling' => 'fa-solid fa-suitcase-rolling', 'fa-solid fa-sun' => 'fa-solid fa-sun', 'fa-solid fa-superscript' => 'fa-solid fa-superscript', 'fa-solid fa-surprise' => 'fa-solid fa-surprise', 'fa-solid fa-swatchbook' => 'fa-solid fa-swatchbook', 'fa-solid fa-swimmer' => 'fa-solid fa-swimmer', 'fa-solid fa-swimming-pool' => 'fa-solid fa-swimming-pool', 'fa-solid fa-synagogue' => 'fa-solid fa-synagogue', 'fa-solid fa-sync' => 'fa-solid fa-sync', 'fa-solid fa-sync-alt' => 'fa-solid fa-sync-alt', 'fa-solid fa-syringe' => 'fa-solid fa-syringe', 'fa-solid fa-table' => 'fa-solid fa-table', 'fa-solid fa-table-tennis' => 'fa-solid fa-table-tennis', 'fa-solid fa-tablet' => 'fa-solid fa-tablet', 'fa-solid fa-tablet-alt' => 'fa-solid fa-tablet-alt', 'fa-solid fa-tablets' => 'fa-solid fa-tablets', 'fa-solid fa-tachometer-alt' => 'fa-solid fa-tachometer-alt', 'fa-solid fa-tag' => 'fa-solid fa-tag', 'fa-solid fa-tags' => 'fa-solid fa-tags', 'fa-solid fa-tape' => 'fa-solid fa-tape', 'fa-solid fa-tasks' => 'fa-solid fa-tasks', 'fa-solid fa-taxi' => 'fa-solid fa-taxi', 'fa-solid fa-teeth' => 'fa-solid fa-teeth', 'fa-solid fa-teeth-open' => 'fa-solid fa-teeth-open', 'fa-solid fa-temperature-high' => 'fa-solid fa-temperature-high', 'fa-solid fa-temperature-low' => 'fa-solid fa-temperature-low', 'fa-solid fa-tenge' => 'fa-solid fa-tenge', 'fa-solid fa-terminal' => 'fa-solid fa-terminal', 'fa-solid fa-text-height' => 'fa-solid fa-text-height', 'fa-solid fa-text-width' => 'fa-solid fa-text-width', 'fa-solid fa-th' => 'fa-solid fa-th', 'fa-solid fa-th-large' => 'fa-solid fa-th-large', 'fa-solid fa-th-list' => 'fa-solid fa-th-list', 'fa-solid fa-theater-masks' => 'fa-solid fa-theater-masks', 'fa-solid fa-thermometer' => 'fa-solid fa-thermometer', 'fa-solid fa-thermometer-empty' => 'fa-solid fa-thermometer-empty', 'fa-solid fa-thermometer-full' => 'fa-solid fa-thermometer-full', 'fa-solid fa-thermometer-half' => 'fa-solid fa-thermometer-half', 'fa-solid fa-thermometer-quarter' => 'fa-solid fa-thermometer-quarter', 'fa-solid fa-thermometer-three-quarters' => 'fa-solid fa-thermometer-three-quarters', 'fa-solid fa-thumbs-down' => 'fa-solid fa-thumbs-down', 'fa-solid fa-thumbs-up' => 'fa-solid fa-thumbs-up', 'fa-solid fa-thumbtack' => 'fa-solid fa-thumbtack', 'fa-solid fa-ticket-alt' => 'fa-solid fa-ticket-alt', 'fa-solid fa-times' => 'fa-solid fa-times', 'fa-solid fa-times-circle' => 'fa-solid fa-times-circle', 'fa-solid fa-tint' => 'fa-solid fa-tint', 'fa-solid fa-tint-slash' => 'fa-solid fa-tint-slash', 'fa-solid fa-tired' => 'fa-solid fa-tired', 'fa-solid fa-toggle-off' => 'fa-solid fa-toggle-off', 'fa-solid fa-toggle-on' => 'fa-solid fa-toggle-on', 'fa-solid fa-toilet' => 'fa-solid fa-toilet', 'fa-solid fa-toilet-paper' => 'fa-solid fa-toilet-paper', 'fa-solid fa-toolbox' => 'fa-solid fa-toolbox', 'fa-solid fa-tools' => 'fa-solid fa-tools', 'fa-solid fa-tooth' => 'fa-solid fa-tooth', 'fa-solid fa-torah' => 'fa-solid fa-torah', 'fa-solid fa-torii-gate' => 'fa-solid fa-torii-gate', 'fa-solid fa-tractor' => 'fa-solid fa-tractor', 'fa-solid fa-trademark' => 'fa-solid fa-trademark', 'fa-solid fa-traffic-light' => 'fa-solid fa-traffic-light', 'fa-solid fa-train' => 'fa-solid fa-train', 'fa-solid fa-tram' => 'fa-solid fa-tram', 'fa-solid fa-transgender' => 'fa-solid fa-transgender', 'fa-solid fa-transgender-alt' => 'fa-solid fa-transgender-alt', 'fa-solid fa-trash' => 'fa-solid fa-trash', 'fa-solid fa-trash-alt' => 'fa-solid fa-trash-alt', 'fa-solid fa-trash-restore' => 'fa-solid fa-trash-restore', 'fa-solid fa-trash-restore-alt' => 'fa-solid fa-trash-restore-alt', 'fa-solid fa-tree' => 'fa-solid fa-tree', 'fa-solid fa-trophy' => 'fa-solid fa-trophy', 'fa-solid fa-truck' => 'fa-solid fa-truck', 'fa-solid fa-truck-loading' => 'fa-solid fa-truck-loading', 'fa-solid fa-truck-monster' => 'fa-solid fa-truck-monster', 'fa-solid fa-truck-moving' => 'fa-solid fa-truck-moving', 'fa-solid fa-truck-pickup' => 'fa-solid fa-truck-pickup', 'fa-solid fa-tshirt' => 'fa-solid fa-tshirt', 'fa-solid fa-tty' => 'fa-solid fa-tty', 'fa-solid fa-tv' => 'fa-solid fa-tv', 'fa-solid fa-umbrella' => 'fa-solid fa-umbrella', 'fa-solid fa-umbrella-beach' => 'fa-solid fa-umbrella-beach', 'fa-solid fa-underline' => 'fa-solid fa-underline', 'fa-solid fa-undo' => 'fa-solid fa-undo', 'fa-solid fa-undo-alt' => 'fa-solid fa-undo-alt', 'fa-solid fa-universal-access' => 'fa-solid fa-universal-access', 'fa-solid fa-university' => 'fa-solid fa-university', 'fa-solid fa-unlink' => 'fa-solid fa-unlink', 'fa-solid fa-unlock' => 'fa-solid fa-unlock', 'fa-solid fa-unlock-alt' => 'fa-solid fa-unlock-alt', 'fa-solid fa-upload' => 'fa-solid fa-upload', 'fa-solid fa-user' => 'fa-solid fa-user', 'fa-solid fa-user-alt' => 'fa-solid fa-user-alt', 'fa-solid fa-user-alt-slash' => 'fa-solid fa-user-alt-slash', 'fa-solid fa-user-astronaut' => 'fa-solid fa-user-astronaut', 'fa-solid fa-user-check' => 'fa-solid fa-user-check', 'fa-solid fa-user-circle' => 'fa-solid fa-user-circle', 'fa-solid fa-user-clock' => 'fa-solid fa-user-clock', 'fa-solid fa-user-cog' => 'fa-solid fa-user-cog', 'fa-solid fa-user-edit' => 'fa-solid fa-user-edit', 'fa-solid fa-user-friends' => 'fa-solid fa-user-friends', 'fa-solid fa-user-graduate' => 'fa-solid fa-user-graduate', 'fa-solid fa-user-injured' => 'fa-solid fa-user-injured', 'fa-solid fa-user-lock' => 'fa-solid fa-user-lock', 'fa-solid fa-user-md' => 'fa-solid fa-user-md', 'fa-solid fa-user-minus' => 'fa-solid fa-user-minus', 'fa-solid fa-user-ninja' => 'fa-solid fa-user-ninja', 'fa-solid fa-user-nurse' => 'fa-solid fa-user-nurse', 'fa-solid fa-user-plus' => 'fa-solid fa-user-plus', 'fa-solid fa-user-secret' => 'fa-solid fa-user-secret', 'fa-solid fa-user-shield' => 'fa-solid fa-user-shield', 'fa-solid fa-user-slash' => 'fa-solid fa-user-slash', 'fa-solid fa-user-tag' => 'fa-solid fa-user-tag', 'fa-solid fa-user-tie' => 'fa-solid fa-user-tie', 'fa-solid fa-user-times' => 'fa-solid fa-user-times', 'fa-solid fa-users' => 'fa-solid fa-users', 'fa-solid fa-users-cog' => 'fa-solid fa-users-cog', 'fa-solid fa-utensil-spoon' => 'fa-solid fa-utensil-spoon', 'fa-solid fa-utensils' => 'fa-solid fa-utensils', 'fa-solid fa-vector-square' => 'fa-solid fa-vector-square', 'fa-solid fa-venus' => 'fa-solid fa-venus', 'fa-solid fa-venus-double' => 'fa-solid fa-venus-double', 'fa-solid fa-venus-mars' => 'fa-solid fa-venus-mars', 'fa-solid fa-vial' => 'fa-solid fa-vial', 'fa-solid fa-vials' => 'fa-solid fa-vials', 'fa-solid fa-video' => 'fa-solid fa-video', 'fa-solid fa-video-slash' => 'fa-solid fa-video-slash', 'fa-solid fa-vihara' => 'fa-solid fa-vihara', 'fa-solid fa-voicemail' => 'fa-solid fa-voicemail', 'fa-solid fa-volleyball-ball' => 'fa-solid fa-volleyball-ball', 'fa-solid fa-volume-down' => 'fa-solid fa-volume-down', 'fa-solid fa-volume-mute' => 'fa-solid fa-volume-mute', 'fa-solid fa-volume-off' => 'fa-solid fa-volume-off', 'fa-solid fa-volume-up' => 'fa-solid fa-volume-up', 'fa-solid fa-vote-yea' => 'fa-solid fa-vote-yea', 'fa-solid fa-vr-cardboard' => 'fa-solid fa-vr-cardboard', 'fa-solid fa-walking' => 'fa-solid fa-walking', 'fa-solid fa-wallet' => 'fa-solid fa-wallet', 'fa-solid fa-warehouse' => 'fa-solid fa-warehouse', 'fa-solid fa-water' => 'fa-solid fa-water', 'fa-solid fa-wave-square' => 'fa-solid fa-wave-square', 'fa-solid fa-weight' => 'fa-solid fa-weight', 'fa-solid fa-weight-hanging' => 'fa-solid fa-weight-hanging', 'fa-solid fa-wheelchair' => 'fa-solid fa-wheelchair', 'fa-solid fa-wifi' => 'fa-solid fa-wifi', 'fa-solid fa-wind' => 'fa-solid fa-wind', 'fa-solid fa-window-close' => 'fa-solid fa-window-close', 'fa-solid fa-window-maximize' => 'fa-solid fa-window-maximize', 'fa-solid fa-window-minimize' => 'fa-solid fa-window-minimize', 'fa-solid fa-window-restore' => 'fa-solid fa-window-restore', 'fa-solid fa-wine-bottle' => 'fa-solid fa-wine-bottle', 'fa-solid fa-wine-glass' => 'fa-solid fa-wine-glass', 'fa-solid fa-wine-glass-alt' => 'fa-solid fa-wine-glass-alt', 'fa-solid fa-won-sign' => 'fa-solid fa-won-sign', 'fa-solid fa-wrench' => 'fa-solid fa-wrench', 'fa-solid fa-x-ray' => 'fa-solid fa-x-ray', 'fa-solid fa-yen-sign' => 'fa-solid fa-yen-sign', 'fa-solid fa-yin-yang' => 'fa-solid fa-yin-yang', 'fa-solid fa-0' => 'fa-solid fa-0','fa-solid fa-1' => 'fa-solid fa-1', 'fa-solid fa-2' => 'fa-solid fa-2', 'fa-solid fa-3' => 'fa-solid fa-3', 'fa-solid fa-4' => 'fa-solid fa-4', 'fa-solid fa-5' => 'fa-solid fa-5', 'fa-solid fa-6' => 'fa-solid fa-6', 'fa-solid fa-7' => 'fa-solid fa-7', 'fa-solid fa-8' => 'fa-solid fa-8', 'fa-solid fa-9' => 'fa-solid fa-9', 'fa-solid fa-a' => 'fa-solid fa-a', 'fa-solid fa-anchor-circle-check' => 'fa-solid fa-anchor-circle-check', 'fa-solid fa-anchor-circle-exclamation' => 'fa-solid fa-anchor-circle-exclamation', 'fa-solid fa-anchor-circle-xmark' => 'fa-solid fa-anchor-circle-xmark', 'fa-solid fa-anchor-lock' => 'fa-solid fa-anchor-lock', 'fa-solid fa-arrow-down-up-across-line' => 'fa-solid fa-arrow-down-up-across-line', 'fa-solid fa-arrow-down-up-lock' => 'fa-solid fa-arrow-down-up-lock', 'fa-solid fa-arrow-right-to-city' => 'fa-solid fa-arrow-right-to-city', 'fa-solid fa-arrow-trend-down' => 'fa-solid fa-arrow-trend-down', 'fa-solid fa-arrow-trend-up' => 'fa-solid fa-arrow-trend-up', 'fa-solid fa-arrow-up-from-bracket' => 'fa-solid fa-arrow-up-from-bracket', 'fa-solid fa-arrow-up-from-ground-water' => 'fa-solid fa-arrow-up-from-ground-water', 'fa-solid fa-arrow-up-from-water-pump' => 'fa-solid fa-arrow-up-from-water-pump', 'fa-solid fa-arrow-up-right-dots' => 'fa-solid fa-arrow-up-right-dots', 'fa-solid fa-arrows-down-to-line' => 'fa-solid fa-arrows-down-to-line', 'fa-solid fa-arrows-down-to-people' => 'fa-solid fa-arrows-down-to-people', 'fa-solid fa-arrows-left-right-to-line' =>  'fa-solid fa-arrows-left-right-to-line', 'fa-solid fa-arrows-spin' => 'fa-solid fa-arrows-spin', 'fa-solid fa-arrows-split-up-and-left' => 'fa-solid fa-arrows-split-up-and-left', 'fa-solid fa-arrows-to-circle' => 'fa-solid fa-arrows-to-circle', 'fa-solid fa-arrows-to-dot' => 'fa-solid fa-arrows-to-dot', 'fa-solid fa-arrows-to-eye' => 'fa-solid fa-arrows-to-eye', 'fa-solid fa-arrows-turn-right' => 'fa-solid fa-arrows-turn-right', 'fa-solid fa-arrows-turn-to-dots' => 'fa-solid fa-arrows-turn-to-dots', 'fa-solid fa-arrows-up-to-line' => 'fa-solid fa-arrows-up-to-line', 'fa-solid fa-austral-sign' => 'fa-solid fa-austral-sign', 'fa-solid fa-b' => 'fa-solid fa-b', 'fa-solid fa-baht-sign' =>  'fa-solid fa-baht-sign', 'fa-solid fa-bitcoin-sign' => 'fa-solid fa-bitcoin-sign', 'fa-solid fa-bolt-lightning' => 'fa-solid fa-bolt-lightning', 'fa-solid fa-book-bookmark' => 'fa-solid fa-book-bookmark', 'fa-solid fa-bore-hole' => 'fa-solid fa-bore-hole', 'fa-solid fa-bottle-droplet' => 'fa-solid fa-bottle-droplet', 'fa-solid fa-bottle-water' => 'fa-solid fa-bottle-water', 'fa-solid fa-bowl-food' => 'fa-solid fa-bowl-food', 'fa-solid fa-bowl-rice' =>  'fa-solid fa-bowl-rice', 'fa-solid fa-boxes-packing' => 'fa-solid fa-boxes-packing', 'fa-solid fa-brazilian-real-sign' => 'fa-solid fa-brazilian-real-sign', 'fa-solid fa-bridge' => 'fa-solid fa-bridge', 'fa-solid fa-bridge-circle-check' => 'fa-solid fa-bridge-circle-check', 'fa-solid fa-bridge-circle-exclamation' => 'fa-solid fa-bridge-circle-exclamation', 'fa-solid fa-bridge-circle-xmark' => 'fa-solid fa-bridge-circle-xmark', 'fa-solid fa-bridge-lock' => 'fa-solid fa-bridge-lock', 'fa-solid fa-bridge-water' => 'fa-solid fa-bridge-water', 'fa-solid fa-bucket' => 'fa-solid fa-bucket', 'fa-solid fa-bug-slash' => 'fa-solid fa-bug-slash', 'fa-solid fa-bugs' => 'fa-solid fa-bugs', 'fa-solid fa-building-circle-arrow-right' => 'fa-solid fa-building-circle-arrow-right', 'fa-solid fa-building-circle-check' =>  'fa-solid fa-building-circle-check', 'fa-solid fa-building-circle-exclamation' => 'fa-solid fa-building-circle-exclamation', 'fa-solid fa-building-circle-xmark' => 'fa-solid fa-building-circle-xmark', 'fa-solid fa-building-flag' => 'fa-solid fa-building-flag', 'fa-solid fa-building-lock' => 'fa-solid fa-building-lock', 'fa-solid fa-building-ngo' => 'fa-solid fa-building-ngo', 'fa-solid fa-building-shield' => 'fa-solid fa-building-shield', 'fa-solid fa-building-un' => 'fa-solid fa-building-un', 'fa-solid fa-building-user' => 'fa-solid fa-building-user', 'fa-solid fa-building-wheat' => 'fa-solid fa-building-wheat', 'fa-solid fa-burst' => 'fa-solid fa-burst', 'fa-solid fa-c' => 'fa-solid fa-c', 'fa-solid fa-camera-rotate' => 'fa-solid fa-camera-rotate', 'fa-solid fa-car-on' => 'fa-solid fa-car-on', 'fa-solid fa-car-tunnel' => 'fa-solid fa-car-tunnel', 'fa-solid fa-cedi-sign' => 'fa-solid fa-cedi-sign', 'fa-solid fa-cent-sign' => 'fa-solid fa-cent-sign', 'fa-solid fa-chart-column' => 'fa-solid fa-chart-column', 'fa-solid fa-chart-gantt' => 'fa-solid fa-chart-gantt', 'fa-solid fa-chart-simple' => 'fa-solid fa-chart-simple', 'fa-solid fa-child-dress' => 'fa-solid fa-child-dress', 'fa-solid fa-child-reaching' => 'fa-solid fa-child-reaching', 'fa-solid fa-child-rifle' => 'fa-solid fa-child-rifle', 'fa-solid fa-children' => 'fa-solid fa-children', 'fa-solid fa-circle-nodes' => 'fa-solid fa-circle-nodes', 'fa-solid fa-clapperboard' => 'fa-solid fa-clapperboard', 'fa-solid fa-clipboard-question' => 'fa-solid fa-clipboard-question', 'fa-solid fa-cloud-showers-water' => 'fa-solid fa-cloud-showers-water', 'fa-solid fa-clover' =>  'fa-solid fa-clover', 'fa-solid fa-code-compare' => 'fa-solid fa-code-compare', 'fa-solid fa-code-fork' => 'fa-solid fa-code-fork', 'fa-solid fa-code-pull-request' => 'fa-solid fa-code-pull-request', 'fa-solid fa-colon-sign' => 'fa-solid fa-colon-sign', 'fa-solid fa-computer' => 'fa-solid fa-computer', 'fa-solid fa-cruzeiro-sign' => 'fa-solid fa-cruzeiro-sign', 'fa-solid fa-cubes-stacked' =>  'fa-solid fa-cubes-stacked', 'fa-solid fa-d' => 'fa-solid fa-d', 'fa-solid fa-diagram-next' => 'fa-solid fa-diagram-next', 'fa-solid fa-diagram-predecessor' => 'fa-solid fa-diagram-predecessor', 'fa-solid fa-diagram-successor' => 'fa-solid fa-diagram-successor', 'fa-solid fa-display' => 'fa-solid fa-display', 'fa-solid fa-dong-sign' => 'fa-solid fa-dong-sign', 'fa-solid fa-e' => 'fa-solid fa-e', 'fa-solid fa-earth-oceania' => 'fa-solid fa-earth-oceania', 'fa-solid fa-elevator' => 'fa-solid fa-elevator', 'fa-solid fa-envelope-circle-check' => 'fa-solid fa-envelope-circle-check', 'fa-solid fa-explosion' => 'fa-solid fa-explosion', 'fa-solid fa-f' => 'fa-solid fa-f', 'fa-solid fa-ferry' => 'fa-solid fa-ferry', 'fa-solid fa-file-circle-check' => 'fa-solid fa-file-circle-check', 'fa-solid fa-file-circle-exclamation' => 'fa-solid fa-file-circle-exclamation', 'fa-solid fa-file-circle-minus' =>  'fa-solid fa-file-circle-minus', 'fa-solid fa-file-circle-plus' => 'fa-solid fa-file-circle-plus', 'fa-solid fa-file-circle-question' => 'fa-solid fa-file-circle-question', 'fa-solid fa-file-circle-xmark' => 'fa-solid fa-file-circle-xmark', 'fa-solid fa-file-shield' => 'fa-solid fa-file-shield', 'fa-solid fa-filter-circle-xmark' => 'fa-solid fa-filter-circle-xmark', 'fa-solid fa-fire-burner' => 'fa-solid fa-fire-burner', 'fa-solid fa-fish-fins' => 'fa-solid fa-fish-fins', 'fa-solid fa-flask-vial' => 'fa-solid fa-flask-vial', 'fa-solid fa-florin-sign' => 'fa-solid fa-florin-sign', 'fa-solid fa-folder-closed' => 'fa-solid fa-folder-closed', 'fa-solid fa-franc-sign' => 'fa-solid fa-franc-sign', 'fa-solid fa-g' => 'fa-solid fa-g', 'fa-solid fa-glass-water' => 'fa-solid fa-glass-water', 'fa-solid fa-glass-water-droplet' => 'fa-solid fa-glass-water-droplet', 'fa-solid fa-group-arrows-rotate' => 'fa-solid fa-group-arrows-rotate', 'fa-solid fa-guarani-sign' => 'fa-solid fa-guarani-sign', 'fa-solid fa-gun' => 'fa-solid fa-gun', 'fa-solid fa-h' => 'fa-solid fa-h', 'fa-solid fa-hand-holding-hand' => 'fa-solid fa-hand-holding-hand', 'fa-solid fa-handcuffs' => 'fa-solid fa-handcuffs', 'fa-solid fa-hands-bound' => 'fa-solid fa-hands-bound', 'fa-solid fa-hands-clapping' => 'fa-solid fa-hands-clapping', 'fa-solid fa-hands-holding-child' => 'fa-solid fa-hands-holding-child', 'fa-solid fa-hands-holding-circle' => 'fa-solid fa-hands-holding-circle', 'fa-solid fa-heart-circle-bolt' => 'fa-solid fa-heart-circle-bolt', 'fa-solid fa-heart-circle-check' => 'fa-solid fa-heart-circle-check', 'fa-solid fa-heart-circle-exclamation' => 'fa-solid fa-heart-circle-exclamation', 'fa-solid fa-heart-circle-minus' => 'fa-solid fa-heart-circle-minus', 'fa-solid fa-heart-circle-plus' => 'fa-solid fa-heart-circle-plus', 'fa-solid fa-heart-circle-xmark' => 'fa-solid fa-heart-circle-xmark', 'fa-solid fa-helicopter-symbol' => 'fa-solid fa-helicopter-symbol', 'fa-solid fa-helmet-un' => 'fa-solid fa-helmet-un', 'fa-solid fa-hill-avalanche' => 'fa-solid fa-hill-avalanche', 'fa-solid fa-hill-rockslide' =>  'fa-solid fa-hill-rockslide', 'fa-solid fa-house-chimney' => 'fa-solid fa-house-chimney', 'fa-solid fa-house-circle-check' => 'fa-solid fa-house-circle-check', 'fa-solid fa-house-circle-exclamation' => 'fa-solid fa-house-circle-exclamation', 'fa-solid fa-house-circle-xmark' => 'fa-solid fa-house-circle-xmark', 'fa-solid fa-house-crack' => 'fa-solid fa-house-crack', 'fa-solid fa-house-fire' => 'fa-solid fa-house-fire', 'fa-solid fa-house-flag' => 'fa-solid fa-house-flag', 'fa-solid fa-house-flood-water' => 'fa-solid fa-house-flood-water', 'fa-solid fa-house-flood-water-circle-arrow-right' => 'fa-solid fa-house-flood-water-circle-arrow-right', 'fa-solid fa-house-lock' => 'fa-solid fa-house-lock', 'fa-solid fa-house-medical' => 'fa-solid fa-house-medical', 'fa-solid fa-house-medical-circle-check' => 'fa-solid fa-house-medical-circle-check', 'fa-solid fa-house-medical-circle-exclamation' => 'fa-solid fa-house-medical-circle-exclamation', 'fa-solid fa-house-medical-circle-xmark' => 'fa-solid fa-house-medical-circle-xmark', 'fa-solid fa-house-medical-flag' => 'fa-solid fa-house-medical-flag', 'fa-solid fa-house-tsunami' => 'fa-solid fa-house-tsunami', 'fa-solid fa-house-user' => 'fa-solid fa-house-user', 'fa-solid fa-i' => 'fa-solid fa-i', 'fa-solid fa-indian-rupee-sign' => 'fa-solid fa-indian-rupee-sign', 'fa-solid fa-j' => 'fa-solid fa-j', 'fa-solid fa-jar' => 'fa-solid fa-jar', 'fa-solid fa-jar-wheat' => 'fa-solid fa-jar-wheat', 'fa-solid fa-jet-fighter-up' => 'fa-solid fa-jet-fighter-up', 'fa-solid fa-jug-detergent' => 'fa-solid fa-jug-detergent', 'fa-solid fa-k' => 'fa-solid fa-k', 'fa-solid fa-kip-sign' => 'fa-solid fa-kip-sign', 'fa-solid fa-kitchen-set' => 'fa-solid fa-kitchen-set', 'fa-solid fa-l' => 'fa-solid fa-l', 'fa-solid fa-land-mine-on' => 'fa-solid fa-land-mine-on', 'fa-solid fa-landmark-flag' => 'fa-solid fa-landmark-flag', 'fa-solid fa-laptop-file' => 'fa-solid fa-laptop-file', 'fa-solid fa-lari-sign' => 'fa-solid fa-lari-sign', 'fa-solid fa-lines-leaning' => 'fa-solid fa-lines-leaning', 'fa-solid fa-litecoin-sign' => 'fa-solid fa-litecoin-sign', 'fa-solid fa-location-pin-lock' => 'fa-solid fa-location-pin-lock', 'fa-solid fa-locust' => 'fa-solid fa-locust', 'fa-solid fa-m' => 'fa-solid fa-m', 'fa-solid fa-magnifying-glass-arrow-right' => 'fa-solid fa-magnifying-glass-arrow-right', 'fa-solid fa-magnifying-glass-chart' => 'fa-solid fa-magnifying-glass-chart', 'fa-solid fa-manat-sign' => 'fa-solid fa-manat-sign', 'fa-solid fa-mars-and-venus-burst' => 'fa-solid fa-mars-and-venus-burst', 'fa-solid fa-mask-face' => 'fa-solid fa-mask-face', 'fa-solid fa-mask-ventilator' => 'fa-solid fa-mask-ventilator', 'fa-solid fa-mattress-pillow' => 'fa-solid fa-mattress-pillow', 'fa-solid fa-mill-sign' => 'fa-solid fa-mill-sign', 'fa-solid fa-mobile-retro' => 'fa-solid fa-mobile-retro', 'fa-solid fa-money-bill-transfer' => 'fa-solid fa-money-bill-transfer', 'fa-solid fa-money-bill-trend-up' => 'fa-solid fa-money-bill-trend-up', 'fa-solid fa-money-bill-wheat' => 'fa-solid fa-money-bill-wheat', 'fa-solid fa-money-bills' => 'fa-solid fa-money-bills', 'fa-solid fa-mosquito' => 'fa-solid fa-mosquito', 'fa-solid fa-mosquito-net' => 'fa-solid fa-mosquito-net', 'fa-solid fa-mound' => 'fa-solid fa-mound', 'fa-solid fa-mountain-city' => 'fa-solid fa-mountain-city', 'fa-solid fa-mountain-sun' => 'fa-solid fa-mountain-sun', 'fa-solid fa-n' => 'fa-solid fa-n', 'fa-solid fa-naira-sign' => 'fa-solid fa-naira-sign', 'fa-solid fa-o' => 'fa-solid fa-o', 'fa-solid fa-oil-well' => 'fa-solid fa-oil-well', 'fa-solid fa-p' => 'fa-solid fa-p', 'fa-solid fa-panorama' => 'fa-solid fa-panorama', 'fa-solid fa-people-group' => 'fa-solid fa-people-group', 'fa-solid fa-people-line' => 'fa-solid fa-people-line', 'fa-solid fa-people-pulling' => 'fa-solid fa-people-pulling', 'fa-solid fa-people-robbery' => 'fa-solid fa-people-robbery', 'fa-solid fa-people-roof' => 'fa-solid fa-people-roof', 'fa-solid fa-person-arrow-down-to-line' => 'fa-solid fa-person-arrow-down-to-line', 'fa-solid fa-person-arrow-up-from-line' => 'fa-solid fa-person-arrow-up-from-line', 'fa-solid fa-person-breastfeeding' => 'fa-solid fa-person-breastfeeding', 'fa-solid fa-person-burst' => 'fa-solid fa-person-burst', 'fa-solid fa-person-cane' => 'fa-solid fa-person-cane', 'fa-solid fa-person-chalkboard' => 'fa-solid fa-person-chalkboard', 'fa-solid fa-person-circle-check' => 'fa-solid fa-person-circle-check', 'fa-solid fa-person-circle-exclamation' => 'fa-solid fa-person-circle-exclamation', 'fa-solid fa-person-circle-minus' => 'fa-solid fa-person-circle-minus', 'fa-solid fa-person-circle-plus' => 'fa-solid fa-person-circle-plus', 'fa-solid fa-person-circle-question' => 'fa-solid fa-person-circle-question', 'fa-solid fa-person-circle-xmark' => 'fa-solid fa-person-circle-xmark', 'fa-solid fa-person-dress-burst' => 'fa-solid fa-person-dress-burst', 'fa-solid fa-person-drowning' => 'fa-solid fa-person-drowning', 'fa-solid fa-person-falling' => 'fa-solid fa-person-falling', 'fa-solid fa-person-falling-burst' => 'fa-solid fa-person-falling-burst', 'fa-solid fa-person-half-dress' => 'fa-solid fa-person-half-dress', 'fa-solid fa-person-harassing' => 'fa-solid fa-person-harassing', 'fa-solid fa-person-military-pointing' => 'fa-solid fa-person-military-pointing', 'fa-solid fa-person-military-rifle' => 'fa-solid fa-person-military-rifle', 'fa-solid fa-person-military-to-person' => 'fa-solid fa-person-military-to-person', 'fa-solid fa-person-pregnant' => 'fa-solid fa-person-pregnant', 'fa-solid fa-person-rays' => 'fa-solid fa-person-rays', 'fa-solid fa-person-rifle' => 'fa-solid fa-person-rifle', 'fa-solid fa-person-shelter' => 'fa-solid fa-person-shelter', 'fa-solid fa-person-through-window' => 'fa-solid fa-person-through-window', 'fa-solid fa-person-walking-arrow-loop-left' => 'fa-solid fa-person-walking-arrow-loop-left', 'fa-solid fa-person-walking-arrow-right' => 'fa-solid fa-person-walking-arrow-right', 'fa-solid fa-person-walking-dashed-line-arrow-right' => 'fa-solid fa-person-walking-dashed-line-arrow-right', 'fa-solid fa-person-walking-luggage' => 'fa-solid fa-person-walking-luggage', 'fa-solid fa-peseta-sign' => 'fa-solid fa-peseta-sign', 'fa-solid fa-peso-sign' => 'fa-solid fa-peso-sign', 'fa-solid fa-plane-circle-check' => 'fa-solid fa-plane-circle-check', 'fa-solid fa-plane-circle-exclamation' => 'fa-solid fa-plane-circle-exclamation', 'fa-solid fa-plane-circle-xmark' => 'fa-solid fa-plane-circle-xmark', 'fa-solid fa-plane-lock' => 'fa-solid fa-plane-lock', 'fa-solid fa-plane-up' => 'fa-solid fa-plane-up', 'fa-solid fa-plant-wilt' => 'fa-solid fa-plant-wilt', 'fa-solid fa-plate-wheat' => 'fa-solid fa-plate-wheat', 'fa-solid fa-plug-circle-bolt' => 'fa-solid fa-plug-circle-bolt', 'fa-solid fa-plug-circle-check' => 'fa-solid fa-plug-circle-check', 'fa-solid fa-plug-circle-exclamation' => 'fa-solid fa-plug-circle-exclamation', 'fa-solid fa-plug-circle-minus' => 'fa-solid fa-plug-circle-minus', 'fa-solid fa-plug-circle-plus' => 'fa-solid fa-plug-circle-plus', 'fa-solid fa-plug-circle-xmark' => 'fa-solid fa-plug-circle-xmark', 'fa-solid fa-plus-minus' => 'fa-solid fa-plus-minus', 'fa-solid fa-q' => 'fa-solid fa-q', 'fa-solid fa-r' => 'fa-solid fa-r', 'fa-solid fa-ranking-star' => 'fa-solid fa-ranking-star', 'fa-solid fa-road-barrier' => 'fa-solid fa-road-barrier', 'fa-solid fa-road-bridge' => 'fa-solid fa-road-bridge', 'fa-solid fa-road-circle-check' => 'fa-solid fa-road-circle-check', 'fa-solid fa-road-circle-exclamation' => 'fa-solid fa-road-circle-exclamation', 'fa-solid fa-road-circle-xmark' => 'fa-solid fa-road-circle-xmark', 'fa-solid fa-road-lock' => 'fa-solid fa-road-lock', 'fa-solid fa-road-spikes' => 'fa-solid fa-road-spikes', 'fa-solid fa-rug' => 'fa-solid fa-rug', 'fa-solid fa-rupiah-sign' => 'fa-solid fa-rupiah-sign', 'fa-solid fa-s' => 'fa-solid fa-s', 'fa-solid fa-sack-xmark' => 'fa-solid fa-sack-xmark', 'fa-solid fa-sailboat' => 'fa-solid fa-sailboat', 'fa-solid fa-school-circle-check' => 'fa-solid fa-school-circle-check', 'fa-solid fa-school-circle-exclamation' => 'fa-solid fa-school-circle-exclamation', 'fa-solid fa-school-circle-xmark' => 'fa-solid fa-school-circle-xmark', 'fa-solid fa-school-flag' => 'fa-solid fa-school-flag', 'fa-solid fa-school-lock' => 'fa-solid fa-school-lock', 'fa-solid fa-section' => 'fa-solid fa-section', 'fa-solid fa-sheet-plastic' => 'fa-solid fa-sheet-plastic', 'fa-solid fa-shield-cat' => 'fa-solid fa-shield-cat', 'fa-solid fa-shield-dog' => 'fa-solid fa-shield-dog', 'fa-solid fa-shield-heart' => 'fa-solid fa-shield-heart', 'fa-solid fa-shop-lock' => 'fa-solid fa-shop-lock', 'fa-solid fa-shrimp' => 'fa-solid fa-shrimp', 'fa-solid fa-square-nfi' => 'fa-solid fa-square-nfi', 'fa-solid fa-square-person-confined' => 'fa-solid fa-square-person-confined', 'fa-solid fa-square-virus' => 'fa-solid fa-square-virus', 'fa-solid fa-staff-aesculapius' => 'fa-solid fa-staff-aesculapius', 'fa-solid fa-stairs' => 'fa-solid fa-stairs', 'fa-solid fa-sun-plant-wilt' => 'fa-solid fa-sun-plant-wilt', 'fa-solid fa-t' => 'fa-solid fa-t', 'fa-solid fa-tarp' => 'fa-solid fa-tarp', 'fa-solid fa-tarp-droplet' => 'fa-solid fa-tarp-droplet', 'fa-solid fa-tent' => 'fa-solid fa-tent', 'fa-solid fa-tent-arrow-down-to-line' => 'fa-solid fa-tent-arrow-down-to-line', 'fa-solid fa-tent-arrow-left-right' => 'fa-solid fa-tent-arrow-left-right', 'fa-solid fa-tent-arrow-turn-left' => 'fa-solid fa-tent-arrow-turn-left', 'fa-solid fa-tent-arrows-down' => 'fa-solid fa-tent-arrows-down', 'fa-solid fa-tents' => 'fa-solid fa-tents', 'fa-solid fa-timeline' => 'fa-solid fa-timeline', 'fa-solid fa-toilet-portable' => 'fa-solid fa-toilet-portable', 'fa-solid fa-toilets-portable' => 'fa-solid fa-toilets-portable', 'fa-solid fa-tower-cell' => 'fa-solid fa-tower-cell', 'fa-solid fa-tower-observation' => 'fa-solid fa-tower-observation', 'fa-solid fa-tree-city' => 'fa-solid fa-tree-city', 'fa-solid fa-trowel' => 'fa-solid fa-trowel', 'fa-solid fa-trowel-bricks' => 'fa-solid fa-trowel-bricks', 'fa-solid fa-truck-arrow-right' => 'fa-solid fa-truck-arrow-right', 'fa-solid fa-truck-droplet' => 'fa-solid fa-truck-droplet', 'fa-solid fa-truck-field' => 'fa-solid fa-truck-field', 'fa-solid fa-truck-field-un' => 'fa-solid fa-truck-field-un', 'fa-solid fa-truck-front' => 'fa-solid fa-truck-front', 'fa-solid fa-truck-plane' => 'fa-solid fa-truck-plane', 'fa-solid fa-turkish-lira-sign' => 'fa-solid fa-turkish-lira-sign', 'fa-solid fa-u' => 'fa-solid fa-u', 'fa-solid fa-users-between-lines' => 'fa-solid fa-users-between-lines', 'fa-solid fa-users-line' => 'fa-solid fa-users-line', 'fa-solid fa-users-rays' => 'fa-solid fa-users-rays', 'fa-solid fa-users-rectangle' => 'fa-solid fa-users-rectangle', 'fa-solid fa-users-viewfinder' => 'fa-solid fa-users-viewfinder', 'fa-solid fa-v' => 'fa-solid fa-v', 'fa-solid fa-vault' => 'fa-solid fa-vault', 'fa-solid fa-vial-circle-check' => 'fa-solid fa-vial-circle-check', 'fa-solid fa-vial-virus' => 'fa-solid fa-vial-virus', 'fa-solid fa-virus-covid' => 'fa-solid fa-virus-covid', 'fa-solid fa-virus-covid-slash' => 'fa-solid fa-virus-covid-slash', 'fa-solid fa-w' => 'fa-solid fa-w', 'fa-solid fa-wand-magic-sparkles' => 'fa-solid fa-wand-magic-sparkles', 'fa-solid fa-wheat-awn' => 'fa-solid fa-wheat-awn', 'fa-solid fa-wheat-awn-circle-exclamation' => 'fa-solid fa-wheat-awn-circle-exclamation', 'fa-solid fa-wheelchair-move' => 'fa-solid fa-wheelchair-move', 'fa-solid fa-worm' => 'fa-solid fa-worm', 'fa-solid fa-x' => 'fa-solid fa-x', 'fa-solid fa-xmarks-lines' => 'fa-solid fa-xmarks-lines', 'fa-solid fa-y' => 'fa-solid fa-y', 'fa-solid fa-z' => 'fa-solid fa-z', 'fa-solid fa-stapler' => 'fa-solid fa-stapler' );
        
        $hcode_fa_icons_reg = array( 'fa-regular fa-address-book' => 'fa-regular fa-address-book', 'fa-regular fa-address-card' => 'fa-regular fa-address-card', 'fa-regular fa-angry' => 'fa-regular fa-angry', 'fa-regular fa-circle-down' => 'fa-regular fa-circle-down', 'fa-regular fa-arrow-alt-circle-left' => 'fa-regular fa-arrow-alt-circle-left', 'fa-regular fa-arrow-alt-circle-right' => 'fa-regular fa-arrow-alt-circle-right', 'fa-regular fa-arrow-alt-circle-up' => 'fa-regular fa-arrow-alt-circle-up', 'fa-regular fa-bell' => 'fa-regular fa-bell', 'fa-regular fa-bell-slash' => 'fa-regular fa-bell-slash', 'fa-regular fa-bookmark' => 'fa-regular fa-bookmark', 'fa-regular fa-building' => 'fa-regular fa-building', 'fa-regular fa-calendar' => 'fa-regular fa-calendar', 'fa-regular fa-calendar-alt' => 'fa-regular fa-calendar-alt', 'fa-regular fa-calendar-check' => 'fa-regular fa-calendar-check', 'fa-regular fa-calendar-minus' => 'fa-regular fa-calendar-minus', 'fa-regular fa-calendar-plus' => 'fa-regular fa-calendar-plus', 'fa-regular fa-calendar-times' => 'fa-regular fa-calendar-times', 'fa-regular fa-caret-square-down' => 'fa-regular fa-caret-square-down', 'fa-regular fa-caret-square-left' => 'fa-regular fa-caret-square-left', 'fa-regular fa-caret-square-right' => 'fa-regular fa-caret-square-right', 'fa-regular fa-caret-square-up' => 'fa-regular fa-caret-square-up', 'fa-regular fa-chart-bar' => 'fa-regular fa-chart-bar', 'fa-regular fa-check-circle' => 'fa-regular fa-check-circle', 'fa-regular fa-check-square' => 'fa-regular fa-check-square', 'fa-regular fa-circle' => 'fa-regular fa-circle', 'fa-regular fa-clipboard' => 'fa-regular fa-clipboard', 'fa-regular fa-clock' => 'fa-regular fa-clock', 'fa-regular fa-clone' => 'fa-regular fa-clone', 'fa-regular fa-closed-captioning' => 'fa-regular fa-closed-captioning', 'fa-regular fa-comment' => 'fa-regular fa-comment', 'fa-regular fa-comment-alt' => 'fa-regular fa-comment-alt', 'fa-regular fa-comment-dots' => 'fa-regular fa-comment-dots', 'fa-regular fa-comments' => 'fa-regular fa-comments', 'fa-regular fa-compass' => 'fa-regular fa-compass', 'fa-regular fa-copy' => 'fa-regular fa-copy', 'fa-regular fa-copyright' => 'fa-regular fa-copyright', 'fa-regular fa-credit-card' => 'fa-regular fa-credit-card', 'fa-regular fa-dizzy' => 'fa-regular fa-dizzy', 'fa-regular fa-dot-circle' => 'fa-regular fa-dot-circle', 'fa-regular fa-edit' => 'fa-regular fa-edit', 'fa-regular fa-envelope' => 'fa-regular fa-envelope', 'fa-regular fa-envelope-open' => 'fa-regular fa-envelope-open', 'fa-regular fa-eye' => 'fa-regular fa-eye', 'fa-regular fa-eye-slash' => 'fa-regular fa-eye-slash', 'fa-regular fa-file' => 'fa-regular fa-file', 'fa-regular fa-file-alt' => 'fa-regular fa-file-alt', 'fa-regular fa-file-archive' => 'fa-regular fa-file-archive', 'fa-regular fa-file-audio' => 'fa-regular fa-file-audio', 'fa-regular fa-file-code' => 'fa-regular fa-file-code', 'fa-regular fa-file-excel' => 'fa-regular fa-file-excel', 'fa-regular fa-file-image' => 'fa-regular fa-file-image', 'fa-regular fa-file-pdf' => 'fa-regular fa-file-pdf', 'fa-regular fa-file-powerpoint' => 'fa-regular fa-file-powerpoint', 'fa-regular fa-file-video' => 'fa-regular fa-file-video', 'fa-regular fa-file-word' => 'fa-regular fa-file-word', 'fa-regular fa-flag' => 'fa-regular fa-flag', 'fa-regular fa-flushed' => 'fa-regular fa-flushed', 'fa-regular fa-folder' => 'fa-regular fa-folder', 'fa-regular fa-folder-open' => 'fa-regular fa-folder-open', 'fa-regular fa-frown' => 'fa-regular fa-frown', 'fa-regular fa-frown-open' => 'fa-regular fa-frown-open', 'fa-regular fa-futbol' => 'fa-regular fa-futbol', 'fa-regular fa-gem' => 'fa-regular fa-gem', 'fa-regular fa-grimace' => 'fa-regular fa-grimace', 'fa-regular fa-grin' => 'fa-regular fa-grin', 'fa-regular fa-grin-alt' => 'fa-regular fa-grin-alt', 'fa-regular fa-grin-beam' => 'fa-regular fa-grin-beam', 'fa-regular fa-grin-beam-sweat' => 'fa-regular fa-grin-beam-sweat', 'fa-regular fa-grin-hearts' => 'fa-regular fa-grin-hearts', 'fa-regular fa-grin-squint' => 'fa-regular fa-grin-squint', 'fa-regular fa-grin-squint-tears' => 'fa-regular fa-grin-squint-tears', 'fa-regular fa-grin-stars' => 'fa-regular fa-grin-stars', 'fa-regular fa-grin-tears' => 'fa-regular fa-grin-tears', 'fa-regular fa-grin-tongue' => 'fa-regular fa-grin-tongue', 'fa-regular fa-grin-tongue-squint' => 'fa-regular fa-grin-tongue-squint', 'fa-regular fa-grin-tongue-wink' => 'fa-regular fa-grin-tongue-wink', 'fa-regular fa-grin-wink' => 'fa-regular fa-grin-wink', 'fa-regular fa-hand-lizard' => 'fa-regular fa-hand-lizard', 'fa-regular fa-hand-paper' => 'fa-regular fa-hand-paper', 'fa-regular fa-hand-peace' => 'fa-regular fa-hand-peace', 'fa-regular fa-hand-point-down' => 'fa-regular fa-hand-point-down', 'fa-regular fa-hand-point-left' => 'fa-regular fa-hand-point-left', 'fa-regular fa-hand-point-right' => 'fa-regular fa-hand-point-right', 'fa-regular fa-hand-point-up' => 'fa-regular fa-hand-point-up', 'fa-regular fa-hand-pointer' => 'fa-regular fa-hand-pointer', 'fa-regular fa-hand-rock' => 'fa-regular fa-hand-rock', 'fa-regular fa-hand-scissors' => 'fa-regular fa-hand-scissors', 'fa-regular fa-hand-spock' => 'fa-regular fa-hand-spock', 'fa-regular fa-handshake' => 'fa-regular fa-handshake', 'fa-regular fa-hdd' => 'fa-regular fa-hdd', 'fa-regular fa-heart' => 'fa-regular fa-heart', 'fa-regular fa-hospital' => 'fa-regular fa-hospital', 'fa-regular fa-hourglass' => 'fa-regular fa-hourglass', 'fa-regular fa-id-badge' => 'fa-regular fa-id-badge', 'fa-regular fa-id-card' => 'fa-regular fa-id-card', 'fa-regular fa-image' => 'fa-regular fa-image', 'fa-regular fa-images' => 'fa-regular fa-images', 'fa-regular fa-keyboard' => 'fa-regular fa-keyboard', 'fa-regular fa-kiss' => 'fa-regular fa-kiss', 'fa-regular fa-kiss-beam' => 'fa-regular fa-kiss-beam', 'fa-regular fa-kiss-wink-heart' => 'fa-regular fa-kiss-wink-heart', 'fa-regular fa-laugh' => 'fa-regular fa-laugh', 'fa-regular fa-laugh-beam' => 'fa-regular fa-laugh-beam', 'fa-regular fa-laugh-squint' => 'fa-regular fa-laugh-squint', 'fa-regular fa-laugh-wink' => 'fa-regular fa-laugh-wink', 'fa-regular fa-lemon' => 'fa-regular fa-lemon', 'fa-regular fa-life-ring' => 'fa-regular fa-life-ring', 'fa-regular fa-lightbulb' => 'fa-regular fa-lightbulb', 'fa-regular fa-list-alt' => 'fa-regular fa-list-alt', 'fa-regular fa-map' => 'fa-regular fa-map', 'fa-regular fa-meh' => 'fa-regular fa-meh', 'fa-regular fa-meh-blank' => 'fa-regular fa-meh-blank', 'fa-regular fa-meh-rolling-eyes' => 'fa-regular fa-meh-rolling-eyes', 'fa-regular fa-minus-square' => 'fa-regular fa-minus-square', 'fa-regular fa-money-bill-alt' => 'fa-regular fa-money-bill-alt', 'fa-regular fa-moon' => 'fa-regular fa-moon', 'fa-regular fa-newspaper' => 'fa-regular fa-newspaper', 'fa-regular fa-object-group' => 'fa-regular fa-object-group', 'fa-regular fa-object-ungroup' => 'fa-regular fa-object-ungroup', 'fa-regular fa-paper-plane' => 'fa-regular fa-paper-plane', 'fa-regular fa-pause-circle' => 'fa-regular fa-pause-circle', 'fa-regular fa-play-circle' => 'fa-regular fa-play-circle', 'fa-regular fa-plus-square' => 'fa-regular fa-plus-square', 'fa-regular fa-question-circle' => 'fa-regular fa-question-circle', 'fa-regular fa-registered' => 'fa-regular fa-registered', 'fa-regular fa-sad-cry' => 'fa-regular fa-sad-cry', 'fa-regular fa-sad-tear' => 'fa-regular fa-sad-tear', 'fa-regular fa-save' => 'fa-regular fa-save', 'fa-regular fa-share-square' => 'fa-regular fa-share-square', 'fa-regular fa-smile' => 'fa-regular fa-smile', 'fa-regular fa-smile-beam' => 'fa-regular fa-smile-beam', 'fa-regular fa-smile-wink' => 'fa-regular fa-smile-wink', 'fa-regular fa-snowflake' => 'fa-regular fa-snowflake', 'fa-regular fa-square' => 'fa-regular fa-square', 'fa-regular fa-star' => 'fa-regular fa-star', 'fa-regular fa-star-half' => 'fa-regular fa-star-half', 'fa-regular fa-sticky-note' => 'fa-regular fa-sticky-note', 'fa-regular fa-stop-circle' => 'fa-regular fa-stop-circle', 'fa-regular fa-sun' => 'fa-regular fa-sun', 'fa-regular fa-surprise' => 'fa-regular fa-surprise', 'fa-regular fa-thumbs-down' => 'fa-regular fa-thumbs-down', 'fa-regular fa-thumbs-up' => 'fa-regular fa-thumbs-up', 'fa-regular fa-times-circle' => 'fa-regular fa-times-circle', 'fa-regular fa-tired' => 'fa-regular fa-tired', 'fa-regular fa-trash-alt' => 'fa-regular fa-trash-alt', 'fa-regular fa-user' => 'fa-regular fa-user', 'fa-regular fa-user-circle' => 'fa-regular fa-user-circle', 'fa-regular fa-window-close' => 'fa-regular fa-window-close', 'fa-regular fa-window-maximize' => 'fa-regular fa-window-maximize', 'fa-regular fa-window-minimize' => 'fa-regular fa-window-minimize', 'fa-regular fa-window-restore' => 'fa-regular fa-window-restore', 'fa-regular fa-folder-closed' => 'fa-regular fa-folder-closed' );

        $hcode_fa_icons_brand = array ( 'fa-brands fa-500px' => 'fa-brands fa-500px', 'fa-brands fa-accessible-icon' => 'fa-brands fa-accessible-icon', 'fa-brands fa-accusoft' => 'fa-brands fa-accusoft', 'fa-brands fa-adn' => 'fa-brands fa-adn', 'fa-brands fa-adversal' => 'fa-brands fa-adversal', 'fa-brands fa-affiliatetheme' => 'fa-brands fa-affiliatetheme', 'fa-brands fa-airbnb' => 'fa-brands fa-airbnb', 'fa-brands fa-algolia' => 'fa-brands fa-algolia', 'fa-brands fa-alipay' => 'fa-brands fa-alipay', 'fa-brands fa-amazon' => 'fa-brands fa-amazon', 'fa-brands fa-amazon-pay' => 'fa-brands fa-amazon-pay', 'fa-brands fa-amilia' => 'fa-brands fa-amilia', 'fa-brands fa-android' => 'fa-brands fa-android', 'fa-brands fa-angellist' => 'fa-brands fa-angellist', 'fa-brands fa-angrycreative' => 'fa-brands fa-angrycreative', 'fa-brands fa-angular' => 'fa-brands fa-angular', 'fa-brands fa-app-store' => 'fa-brands fa-app-store', 'fa-brands fa-app-store-ios' => 'fa-brands fa-app-store-ios', 'fa-brands fa-apper' => 'fa-brands fa-apper', 'fa-brands fa-apple' => 'fa-brands fa-apple', 'fa-brands fa-apple-pay' => 'fa-brands fa-apple-pay', 'fa-brands fa-artstation' => 'fa-brands fa-artstation', 'fa-brands fa-asymmetrik' => 'fa-brands fa-asymmetrik', 'fa-brands fa-atlassian' => 'fa-brands fa-atlassian', 'fa-brands fa-audible' => 'fa-brands fa-audible', 'fa-brands fa-autoprefixer' => 'fa-brands fa-autoprefixer', 'fa-brands fa-avianex' => 'fa-brands fa-avianex', 'fa-brands fa-aviato' => 'fa-brands fa-aviato', 'fa-brands fa-aws' => 'fa-brands fa-aws', 'fa-brands fa-bandcamp' => 'fa-brands fa-bandcamp', 'fa-brands fa-battle-net' => 'fa-brands fa-battle-net', 'fa-brands fa-behance' => 'fa-brands fa-behance', 'fa-brands fa-behance-square' => 'fa-brands fa-behance-square', 'fa-brands fa-bimobject' => 'fa-brands fa-bimobject', 'fa-brands fa-bitbucket' => 'fa-brands fa-bitbucket', 'fa-brands fa-bitcoin' => 'fa-brands fa-bitcoin', 'fa-brands fa-bity' => 'fa-brands fa-bity', 'fa-brands fa-black-tie' => 'fa-brands fa-black-tie', 'fa-brands fa-blackberry' => 'fa-brands fa-blackberry', 'fa-brands fa-blogger' => 'fa-brands fa-blogger', 'fa-brands fa-blogger-b' => 'fa-brands fa-blogger-b', 'fa-brands fa-bluetooth' => 'fa-brands fa-bluetooth', 'fa-brands fa-bluetooth-b' => 'fa-brands fa-bluetooth-b', 'fa-brands fa-bootstrap' => 'fa-brands fa-bootstrap', 'fa-brands fa-btc' => 'fa-brands fa-btc', 'fa-brands fa-buffer' => 'fa-brands fa-buffer', 'fa-brands fa-buromobelexperte' => 'fa-brands fa-buromobelexperte', 'fa-brands fa-buysellads' => 'fa-brands fa-buysellads', 'fa-brands fa-canadian-maple-leaf' => 'fa-brands fa-canadian-maple-leaf', 'fa-brands fa-cc-amazon-pay' => 'fa-brands fa-cc-amazon-pay', 'fa-brands fa-cc-amex' => 'fa-brands fa-cc-amex', 'fa-brands fa-cc-apple-pay' => 'fa-brands fa-cc-apple-pay', 'fa-brands fa-cc-diners-club' => 'fa-brands fa-cc-diners-club', 'fa-brands fa-cc-discover' => 'fa-brands fa-cc-discover', 'fa-brands fa-cc-jcb' => 'fa-brands fa-cc-jcb', 'fa-brands fa-cc-mastercard' => 'fa-brands fa-cc-mastercard', 'fa-brands fa-cc-paypal' => 'fa-brands fa-cc-paypal', 'fa-brands fa-cc-stripe' => 'fa-brands fa-cc-stripe', 'fa-brands fa-cc-visa' => 'fa-brands fa-cc-visa', 'fa-brands fa-centercode' => 'fa-brands fa-centercode', 'fa-brands fa-centos' => 'fa-brands fa-centos', 'fa-brands fa-chrome' => 'fa-brands fa-chrome', 'fa-brands fa-chromecast' => 'fa-brands fa-chromecast', 'fa-brands fa-cloudscale' => 'fa-brands fa-cloudscale', 'fa-brands fa-cloudsmith' => 'fa-brands fa-cloudsmith', 'fa-brands fa-cloudversify' => 'fa-brands fa-cloudversify', 'fa-brands fa-codepen' => 'fa-brands fa-codepen', 'fa-brands fa-codiepie' => 'fa-brands fa-codiepie', 'fa-brands fa-confluence' => 'fa-brands fa-confluence', 'fa-brands fa-connectdevelop' => 'fa-brands fa-connectdevelop', 'fa-brands fa-contao' => 'fa-brands fa-contao', 'fa-brands fa-cpanel' => 'fa-brands fa-cpanel', 'fa-brands fa-creative-commons' => 'fa-brands fa-creative-commons', 'fa-brands fa-creative-commons-by' => 'fa-brands fa-creative-commons-by', 'fa-brands fa-creative-commons-nc' => 'fa-brands fa-creative-commons-nc', 'fa-brands fa-creative-commons-nc-eu' => 'fa-brands fa-creative-commons-nc-eu', 'fa-brands fa-creative-commons-nc-jp' => 'fa-brands fa-creative-commons-nc-jp', 'fa-brands fa-creative-commons-nd' => 'fa-brands fa-creative-commons-nd', 'fa-brands fa-creative-commons-pd' => 'fa-brands fa-creative-commons-pd', 'fa-brands fa-creative-commons-pd-alt' => 'fa-brands fa-creative-commons-pd-alt', 'fa-brands fa-creative-commons-remix' => 'fa-brands fa-creative-commons-remix', 'fa-brands fa-creative-commons-sa' => 'fa-brands fa-creative-commons-sa', 'fa-brands fa-creative-commons-sampling' => 'fa-brands fa-creative-commons-sampling', 'fa-brands fa-creative-commons-sampling-plus' => 'fa-brands fa-creative-commons-sampling-plus', 'fa-brands fa-creative-commons-share' => 'fa-brands fa-creative-commons-share', 'fa-brands fa-creative-commons-zero' => 'fa-brands fa-creative-commons-zero', 'fa-brands fa-critical-role' => 'fa-brands fa-critical-role', 'fa-brands fa-css3' => 'fa-brands fa-css3', 'fa-brands fa-css3-alt' => 'fa-brands fa-css3-alt', 'fa-brands fa-cuttlefish' => 'fa-brands fa-cuttlefish', 'fa-brands fa-d-and-d' => 'fa-brands fa-d-and-d', 'fa-brands fa-d-and-d-beyond' => 'fa-brands fa-d-and-d-beyond', 'fa-brands fa-dashcube' => 'fa-brands fa-dashcube', 'fa-brands fa-delicious' => 'fa-brands fa-delicious', 'fa-brands fa-deploydog' => 'fa-brands fa-deploydog', 'fa-brands fa-deskpro' => 'fa-brands fa-deskpro', 'fa-brands fa-dev' => 'fa-brands fa-dev', 'fa-brands fa-deviantart' => 'fa-brands fa-deviantart', 'fa-brands fa-dhl' => 'fa-brands fa-dhl', 'fa-brands fa-diaspora' => 'fa-brands fa-diaspora', 'fa-brands fa-digg' => 'fa-brands fa-digg', 'fa-brands fa-digital-ocean' => 'fa-brands fa-digital-ocean', 'fa-brands fa-discord' => 'fa-brands fa-discord', 'fa-brands fa-discourse' => 'fa-brands fa-discourse', 'fa-brands fa-dochub' => 'fa-brands fa-dochub', 'fa-brands fa-docker' => 'fa-brands fa-docker', 'fa-brands fa-draft2digital' => 'fa-brands fa-draft2digital', 'fa-brands fa-dribbble' => 'fa-brands fa-dribbble', 'fa-brands fa-dribbble-square' => 'fa-brands fa-dribbble-square', 'fa-brands fa-dropbox' => 'fa-brands fa-dropbox', 'fa-brands fa-drupal' => 'fa-brands fa-drupal', 'fa-brands fa-dyalog' => 'fa-brands fa-dyalog', 'fa-brands fa-earlybirds' => 'fa-brands fa-earlybirds', 'fa-brands fa-ebay' => 'fa-brands fa-ebay', 'fa-brands fa-edge' => 'fa-brands fa-edge', 'fa-brands fa-elementor' => 'fa-brands fa-elementor', 'fa-brands fa-ello' => 'fa-brands fa-ello', 'fa-brands fa-ember' => 'fa-brands fa-ember', 'fa-brands fa-empire' => 'fa-brands fa-empire', 'fa-brands fa-envira' => 'fa-brands fa-envira', 'fa-brands fa-erlang' => 'fa-brands fa-erlang', 'fa-brands fa-ethereum' => 'fa-brands fa-ethereum', 'fa-brands fa-etsy' => 'fa-brands fa-etsy', 'fa-brands fa-evernote' => 'fa-brands fa-evernote', 'fa-brands fa-expeditedssl' => 'fa-brands fa-expeditedssl', 'fa-brands fa-facebook' => 'fa-brands fa-facebook', 'fa-brands fa-facebook-f' => 'fa-brands fa-facebook-f', 'fa-brands fa-facebook-messenger' => 'fa-brands fa-facebook-messenger', 'fa-brands fa-facebook-square' => 'fa-brands fa-facebook-square', 'fa-brands fa-fantasy-flight-games' => 'fa-brands fa-fantasy-flight-games', 'fa-brands fa-fedex' => 'fa-brands fa-fedex', 'fa-brands fa-fedora' => 'fa-brands fa-fedora', 'fa-brands fa-figma' => 'fa-brands fa-figma', 'fa-brands fa-firefox' => 'fa-brands fa-firefox', 'fa-brands fa-first-order' => 'fa-brands fa-first-order', 'fa-brands fa-first-order-alt' => 'fa-brands fa-first-order-alt', 'fa-brands fa-firstdraft' => 'fa-brands fa-firstdraft', 'fa-brands fa-flickr' => 'fa-brands fa-flickr', 'fa-brands fa-flipboard' => 'fa-brands fa-flipboard', 'fa-brands fa-fly' => 'fa-brands fa-fly', 'fa-brands fa-font-awesome' => 'fa-brands fa-font-awesome', 'fa-brands fa-font-awesome-alt' => 'fa-brands fa-font-awesome-alt', 'fa-brands fa-font-awesome-flag' => 'fa-brands fa-font-awesome-flag', 'fa-brands fa-fonticons' => 'fa-brands fa-fonticons', 'fa-brands fa-fonticons-fi' => 'fa-brands fa-fonticons-fi', 'fa-brands fa-fort-awesome' => 'fa-brands fa-fort-awesome', 'fa-brands fa-fort-awesome-alt' => 'fa-brands fa-fort-awesome-alt', 'fa-brands fa-forumbee' => 'fa-brands fa-forumbee', 'fa-brands fa-foursquare' => 'fa-brands fa-foursquare', 'fa-brands fa-free-code-camp' => 'fa-brands fa-free-code-camp', 'fa-brands fa-freebsd' => 'fa-brands fa-freebsd', 'fa-brands fa-fulcrum' => 'fa-brands fa-fulcrum', 'fa-brands fa-galactic-republic' => 'fa-brands fa-galactic-republic', 'fa-brands fa-galactic-senate' => 'fa-brands fa-galactic-senate', 'fa-brands fa-get-pocket' => 'fa-brands fa-get-pocket', 'fa-brands fa-gg' => 'fa-brands fa-gg', 'fa-brands fa-gg-circle' => 'fa-brands fa-gg-circle', 'fa-brands fa-git' => 'fa-brands fa-git', 'fa-brands fa-git-alt' => 'fa-brands fa-git-alt', 'fa-brands fa-git-square' => 'fa-brands fa-git-square', 'fa-brands fa-github' => 'fa-brands fa-github', 'fa-brands fa-github-alt' => 'fa-brands fa-github-alt', 'fa-brands fa-github-square' => 'fa-brands fa-github-square', 'fa-brands fa-gitkraken' => 'fa-brands fa-gitkraken', 'fa-brands fa-gitlab' => 'fa-brands fa-gitlab', 'fa-brands fa-gitter' => 'fa-brands fa-gitter', 'fa-brands fa-glide' => 'fa-brands fa-glide', 'fa-brands fa-glide-g' => 'fa-brands fa-glide-g', 'fa-brands fa-gofore' => 'fa-brands fa-gofore', 'fa-brands fa-goodreads' => 'fa-brands fa-goodreads', 'fa-brands fa-goodreads-g' => 'fa-brands fa-goodreads-g', 'fa-brands fa-google' => 'fa-brands fa-google', 'fa-brands fa-google-drive' => 'fa-brands fa-google-drive', 'fa-brands fa-google-play' => 'fa-brands fa-google-play', 'fa-brands fa-google-plus' => 'fa-brands fa-google-plus', 'fa-brands fa-google-plus-g' => 'fa-brands fa-google-plus-g', 'fa-brands fa-google-plus-square' => 'fa-brands fa-google-plus-square', 'fa-brands fa-google-wallet' => 'fa-brands fa-google-wallet', 'fa-brands fa-gratipay' => 'fa-brands fa-gratipay', 'fa-brands fa-grav' => 'fa-brands fa-grav', 'fa-brands fa-gripfire' => 'fa-brands fa-gripfire', 'fa-brands fa-grunt' => 'fa-brands fa-grunt', 'fa-brands fa-gulp' => 'fa-brands fa-gulp', 'fa-brands fa-hacker-news' => 'fa-brands fa-hacker-news', 'fa-brands fa-hacker-news-square' => 'fa-brands fa-hacker-news-square', 'fa-brands fa-hackerrank' => 'fa-brands fa-hackerrank', 'fa-brands fa-hips' => 'fa-brands fa-hips', 'fa-brands fa-hire-a-helper' => 'fa-brands fa-hire-a-helper', 'fa-brands fa-hooli' => 'fa-brands fa-hooli', 'fa-brands fa-hornbill' => 'fa-brands fa-hornbill', 'fa-brands fa-hotjar' => 'fa-brands fa-hotjar', 'fa-brands fa-houzz' => 'fa-brands fa-houzz', 'fa-brands fa-html5' => 'fa-brands fa-html5', 'fa-brands fa-hubspot' => 'fa-brands fa-hubspot', 'fa-brands fa-imdb' => 'fa-brands fa-imdb', 'fa-brands fa-instagram' => 'fa-brands fa-instagram', 'fa-brands fa-intercom' => 'fa-brands fa-intercom', 'fa-brands fa-internet-explorer' => 'fa-brands fa-internet-explorer', 'fa-brands fa-invision' => 'fa-brands fa-invision', 'fa-brands fa-ioxhost' => 'fa-brands fa-ioxhost', 'fa-brands fa-itch-io' => 'fa-brands fa-itch-io', 'fa-brands fa-itunes' => 'fa-brands fa-itunes', 'fa-brands fa-itunes-note' => 'fa-brands fa-itunes-note', 'fa-brands fa-java' => 'fa-brands fa-java', 'fa-brands fa-jedi-order' => 'fa-brands fa-jedi-order', 'fa-brands fa-jenkins' => 'fa-brands fa-jenkins', 'fa-brands fa-jira' => 'fa-brands fa-jira', 'fa-brands fa-joget' => 'fa-brands fa-joget', 'fa-brands fa-joomla' => 'fa-brands fa-joomla', 'fa-brands fa-js' => 'fa-brands fa-js', 'fa-brands fa-js-square' => 'fa-brands fa-js-square', 'fa-brands fa-jsfiddle' => 'fa-brands fa-jsfiddle', 'fa-brands fa-kaggle' => 'fa-brands fa-kaggle', 'fa-brands fa-keybase' => 'fa-brands fa-keybase', 'fa-brands fa-keycdn' => 'fa-brands fa-keycdn', 'fa-brands fa-kickstarter' => 'fa-brands fa-kickstarter', 'fa-brands fa-kickstarter-k' => 'fa-brands fa-kickstarter-k', 'fa-brands fa-korvue' => 'fa-brands fa-korvue', 'fa-brands fa-laravel' => 'fa-brands fa-laravel', 'fa-brands fa-lastfm' => 'fa-brands fa-lastfm', 'fa-brands fa-lastfm-square' => 'fa-brands fa-lastfm-square', 'fa-brands fa-leanpub' => 'fa-brands fa-leanpub', 'fa-brands fa-less' => 'fa-brands fa-less', 'fa-brands fa-line' => 'fa-brands fa-line', 'fa-brands fa-linkedin' => 'fa-brands fa-linkedin', 'fa-brands fa-linkedin-in' => 'fa-brands fa-linkedin-in', 'fa-brands fa-linode' => 'fa-brands fa-linode', 'fa-brands fa-linux' => 'fa-brands fa-linux', 'fa-brands fa-lyft' => 'fa-brands fa-lyft', 'fa-brands fa-magento' => 'fa-brands fa-magento', 'fa-brands fa-mailchimp' => 'fa-brands fa-mailchimp', 'fa-brands fa-mandalorian' => 'fa-brands fa-mandalorian', 'fa-brands fa-markdown' => 'fa-brands fa-markdown', 'fa-brands fa-mastodon' => 'fa-brands fa-mastodon', 'fa-brands fa-maxcdn' => 'fa-brands fa-maxcdn', 'fa-brands fa-medapps' => 'fa-brands fa-medapps', 'fa-brands fa-medium' => 'fa-brands fa-medium', 'fa-brands fa-medium-m' => 'fa-brands fa-medium-m', 'fa-brands fa-medrt' => 'fa-brands fa-medrt', 'fa-brands fa-meetup' => 'fa-brands fa-meetup', 'fa-brands fa-megaport' => 'fa-brands fa-megaport', 'fa-brands fa-mendeley' => 'fa-brands fa-mendeley', 'fa-brands fa-microsoft' => 'fa-brands fa-microsoft', 'fa-brands fa-mix' => 'fa-brands fa-mix', 'fa-brands fa-mixcloud' => 'fa-brands fa-mixcloud', 'fa-brands fa-mizuni' => 'fa-brands fa-mizuni', 'fa-brands fa-modx' => 'fa-brands fa-modx', 'fa-brands fa-monero' => 'fa-brands fa-monero', 'fa-brands fa-napster' => 'fa-brands fa-napster', 'fa-brands fa-neos' => 'fa-brands fa-neos', 'fa-brands fa-nimblr' => 'fa-brands fa-nimblr', 'fa-brands fa-node' => 'fa-brands fa-node', 'fa-brands fa-node-js' => 'fa-brands fa-node-js', 'fa-brands fa-npm' => 'fa-brands fa-npm', 'fa-brands fa-ns8' => 'fa-brands fa-ns8', 'fa-brands fa-nutritionix' => 'fa-brands fa-nutritionix', 'fa-brands fa-odnoklassniki' => 'fa-brands fa-odnoklassniki', 'fa-brands fa-odnoklassniki-square' => 'fa-brands fa-odnoklassniki-square', 'fa-brands fa-old-republic' => 'fa-brands fa-old-republic', 'fa-brands fa-opencart' => 'fa-brands fa-opencart', 'fa-brands fa-openid' => 'fa-brands fa-openid', 'fa-brands fa-opera' => 'fa-brands fa-opera', 'fa-brands fa-optin-monster' => 'fa-brands fa-optin-monster', 'fa-brands fa-osi' => 'fa-brands fa-osi', 'fa-brands fa-page4' => 'fa-brands fa-page4', 'fa-brands fa-pagelines' => 'fa-brands fa-pagelines', 'fa-brands fa-palfed' => 'fa-brands fa-palfed', 'fa-brands fa-patreon' => 'fa-brands fa-patreon', 'fa-brands fa-paypal' => 'fa-brands fa-paypal', 'fa-brands fa-periscope' => 'fa-brands fa-periscope', 'fa-brands fa-phabricator' => 'fa-brands fa-phabricator', 'fa-brands fa-phoenix-framework' => 'fa-brands fa-phoenix-framework', 'fa-brands fa-phoenix-squadron' => 'fa-brands fa-phoenix-squadron', 'fa-brands fa-php' => 'fa-brands fa-php', 'fa-brands fa-pied-piper' => 'fa-brands fa-pied-piper', 'fa-brands fa-pied-piper-alt' => 'fa-brands fa-pied-piper-alt', 'fa-brands fa-pied-piper-hat' => 'fa-brands fa-pied-piper-hat', 'fa-brands fa-pied-piper-pp' => 'fa-brands fa-pied-piper-pp', 'fa-brands fa-pinterest' => 'fa-brands fa-pinterest', 'fa-brands fa-pinterest-p' => 'fa-brands fa-pinterest-p', 'fa-brands fa-pinterest-square' => 'fa-brands fa-pinterest-square', 'fa-brands fa-playstation' => 'fa-brands fa-playstation', 'fa-brands fa-product-hunt' => 'fa-brands fa-product-hunt', 'fa-brands fa-pushed' => 'fa-brands fa-pushed', 'fa-brands fa-python' => 'fa-brands fa-python', 'fa-brands fa-qq' => 'fa-brands fa-qq', 'fa-brands fa-quinscape' => 'fa-brands fa-quinscape', 'fa-brands fa-quora' => 'fa-brands fa-quora', 'fa-brands fa-r-project' => 'fa-brands fa-r-project', 'fa-brands fa-raspberry-pi' => 'fa-brands fa-raspberry-pi', 'fa-brands fa-ravelry' => 'fa-brands fa-ravelry', 'fa-brands fa-react' => 'fa-brands fa-react', 'fa-brands fa-reacteurope' => 'fa-brands fa-reacteurope', 'fa-brands fa-readme' => 'fa-brands fa-readme', 'fa-brands fa-rebel' => 'fa-brands fa-rebel', 'fa-brands fa-red-river' => 'fa-brands fa-red-river', 'fa-brands fa-reddit' => 'fa-brands fa-reddit', 'fa-brands fa-reddit-alien' => 'fa-brands fa-reddit-alien', 'fa-brands fa-reddit-square' => 'fa-brands fa-reddit-square', 'fa-brands fa-redhat' => 'fa-brands fa-redhat', 'fa-brands fa-renren' => 'fa-brands fa-renren', 'fa-brands fa-replyd' => 'fa-brands fa-replyd', 'fa-brands fa-researchgate' => 'fa-brands fa-researchgate', 'fa-brands fa-resolving' => 'fa-brands fa-resolving', 'fa-brands fa-rev' => 'fa-brands fa-rev', 'fa-brands fa-rocketchat' => 'fa-brands fa-rocketchat', 'fa-brands fa-rockrms' => 'fa-brands fa-rockrms', 'fa-brands fa-safari' => 'fa-brands fa-safari', 'fa-brands fa-salesforce' => 'fa-brands fa-salesforce', 'fa-brands fa-sass' => 'fa-brands fa-sass', 'fa-brands fa-schlix' => 'fa-brands fa-schlix', 'fa-brands fa-scribd' => 'fa-brands fa-scribd', 'fa-brands fa-searchengin' => 'fa-brands fa-searchengin', 'fa-brands fa-sellcast' => 'fa-brands fa-sellcast', 'fa-brands fa-sellsy' => 'fa-brands fa-sellsy', 'fa-brands fa-servicestack' => 'fa-brands fa-servicestack', 'fa-brands fa-shirtsinbulk' => 'fa-brands fa-shirtsinbulk', 'fa-brands fa-shopware' => 'fa-brands fa-shopware', 'fa-brands fa-simplybuilt' => 'fa-brands fa-simplybuilt', 'fa-brands fa-sistrix' => 'fa-brands fa-sistrix', 'fa-brands fa-sith' => 'fa-brands fa-sith', 'fa-brands fa-sketch' => 'fa-brands fa-sketch', 'fa-brands fa-skyatlas' => 'fa-brands fa-skyatlas', 'fa-brands fa-skype' => 'fa-brands fa-skype', 'fa-brands fa-slack' => 'fa-brands fa-slack', 'fa-brands fa-slack-hash' => 'fa-brands fa-slack-hash', 'fa-brands fa-slideshare' => 'fa-brands fa-slideshare', 'fa-brands fa-snapchat' => 'fa-brands fa-snapchat', 'fa-brands fa-snapchat-ghost' => 'fa-brands fa-snapchat-ghost', 'fa-brands fa-snapchat-square' => 'fa-brands fa-snapchat-square', 'fa-brands fa-soundcloud' => 'fa-brands fa-soundcloud', 'fa-brands fa-sourcetree' => 'fa-brands fa-sourcetree', 'fa-brands fa-speakap' => 'fa-brands fa-speakap', 'fa-brands fa-speaker-deck' => 'fa-brands fa-speaker-deck', 'fa-brands fa-spotify' => 'fa-brands fa-spotify', 'fa-brands fa-squarespace' => 'fa-brands fa-squarespace', 'fa-brands fa-stack-exchange' => 'fa-brands fa-stack-exchange', 'fa-brands fa-stack-overflow' => 'fa-brands fa-stack-overflow', 'fa-brands fa-stackpath' => 'fa-brands fa-stackpath', 'fa-brands fa-staylinked' => 'fa-brands fa-staylinked', 'fa-brands fa-steam' => 'fa-brands fa-steam', 'fa-brands fa-steam-square' => 'fa-brands fa-steam-square', 'fa-brands fa-steam-symbol' => 'fa-brands fa-steam-symbol', 'fa-brands fa-sticker-mule' => 'fa-brands fa-sticker-mule', 'fa-brands fa-strava' => 'fa-brands fa-strava', 'fa-brands fa-stripe' => 'fa-brands fa-stripe', 'fa-brands fa-stripe-s' => 'fa-brands fa-stripe-s', 'fa-brands fa-studiovinari' => 'fa-brands fa-studiovinari', 'fa-brands fa-stumbleupon' => 'fa-brands fa-stumbleupon', 'fa-brands fa-stumbleupon-circle' => 'fa-brands fa-stumbleupon-circle', 'fa-brands fa-superpowers' => 'fa-brands fa-superpowers', 'fa-brands fa-supple' => 'fa-brands fa-supple', 'fa-brands fa-suse' => 'fa-brands fa-suse', 'fa-brands fa-symfony' => 'fa-brands fa-symfony', 'fa-brands fa-teamspeak' => 'fa-brands fa-teamspeak', 'fa-brands fa-telegram' => 'fa-brands fa-telegram', 'fa-brands fa-telegram-plane' => 'fa-brands fa-telegram-plane', 'fa-brands fa-tencent-weibo' => 'fa-brands fa-tencent-weibo', 'fa-brands fa-the-red-yeti' => 'fa-brands fa-the-red-yeti', 'fa-brands fa-themeco' => 'fa-brands fa-themeco', 'fa-brands fa-themeisle' => 'fa-brands fa-themeisle', 'fa-brands fa-think-peaks' => 'fa-brands fa-think-peaks', 'fa-brands fa-trade-federation' => 'fa-brands fa-trade-federation', 'fa-brands fa-trello' => 'fa-brands fa-trello', 'fa-brands fa-tumblr' => 'fa-brands fa-tumblr', 'fa-brands fa-tumblr-square' => 'fa-brands fa-tumblr-square', 'fa-brands fa-twitch' => 'fa-brands fa-twitch', 'fa-brands fa-twitter' => 'fa-brands fa-twitter', 'fa-brands fa-twitter-square' => 'fa-brands fa-twitter-square', 'fa-brands fa-typo3' => 'fa-brands fa-typo3', 'fa-brands fa-uber' => 'fa-brands fa-uber', 'fa-brands fa-ubuntu' => 'fa-brands fa-ubuntu', 'fa-brands fa-uikit' => 'fa-brands fa-uikit', 'fa-brands fa-uniregistry' => 'fa-brands fa-uniregistry', 'fa-brands fa-untappd' => 'fa-brands fa-untappd', 'fa-brands fa-ups' => 'fa-brands fa-ups', 'fa-brands fa-usb' => 'fa-brands fa-usb', 'fa-brands fa-usps' => 'fa-brands fa-usps', 'fa-brands fa-ussunnah' => 'fa-brands fa-ussunnah', 'fa-brands fa-vaadin' => 'fa-brands fa-vaadin', 'fa-brands fa-viacoin' => 'fa-brands fa-viacoin', 'fa-brands fa-viadeo' => 'fa-brands fa-viadeo', 'fa-brands fa-viadeo-square' => 'fa-brands fa-viadeo-square', 'fa-brands fa-viber' => 'fa-brands fa-viber', 'fa-brands fa-vimeo' => 'fa-brands fa-vimeo', 'fa-brands fa-vimeo-square' => 'fa-brands fa-vimeo-square', 'fa-brands fa-vimeo-v' => 'fa-brands fa-vimeo-v', 'fa-brands fa-vine' => 'fa-brands fa-vine', 'fa-brands fa-vk' => 'fa-brands fa-vk', 'fa-brands fa-vnv' => 'fa-brands fa-vnv', 'fa-brands fa-vuejs' => 'fa-brands fa-vuejs', 'fa-brands fa-waze' => 'fa-brands fa-waze', 'fa-brands fa-weebly' => 'fa-brands fa-weebly', 'fa-brands fa-weibo' => 'fa-brands fa-weibo', 'fa-brands fa-weixin' => 'fa-brands fa-weixin', 'fa-brands fa-whatsapp' => 'fa-brands fa-whatsapp', 'fa-brands fa-whatsapp-square' => 'fa-brands fa-whatsapp-square', 'fa-brands fa-whmcs' => 'fa-brands fa-whmcs', 'fa-brands fa-wikipedia-w' => 'fa-brands fa-wikipedia-w', 'fa-brands fa-windows' => 'fa-brands fa-windows', 'fa-brands fa-wix' => 'fa-brands fa-wix', 'fa-brands fa-wizards-of-the-coast' => 'fa-brands fa-wizards-of-the-coast', 'fa-brands fa-wolf-pack-battalion' => 'fa-brands fa-wolf-pack-battalion', 'fa-brands fa-wordpress' => 'fa-brands fa-wordpress', 'fa-brands fa-wordpress-simple' => 'fa-brands fa-wordpress-simple', 'fa-brands fa-wpbeginner' => 'fa-brands fa-wpbeginner', 'fa-brands fa-wpexplorer' => 'fa-brands fa-wpexplorer', 'fa-brands fa-wpforms' => 'fa-brands fa-wpforms', 'fa-brands fa-wpressr' => 'fa-brands fa-wpressr', 'fa-brands fa-xbox' => 'fa-brands fa-xbox', 'fa-brands fa-xing' => 'fa-brands fa-xing', 'fa-brands fa-xing-square' => 'fa-brands fa-xing-square', 'fa-brands fa-y-combinator' => 'fa-brands fa-y-combinator', 'fa-brands fa-yahoo' => 'fa-brands fa-yahoo', 'fa-brands fa-yammer' => 'fa-brands fa-yammer', 'fa-brands fa-yandex' => 'fa-brands fa-yandex', 'fa-brands fa-yandex-international' => 'fa-brands fa-yandex-international', 'fa-brands fa-yarn' => 'fa-brands fa-yarn', 'fa-brands fa-yelp' => 'fa-brands fa-yelp', 'fa-brands fa-yoast' => 'fa-brands fa-yoast', 'fa-brands fa-youtube' => 'fa-brands fa-youtube', 'fa-brands fa-youtube-square' => 'fa-brands fa-youtube-square', 'fa-brands fa-zhihu' => 'fa-brands fa-zhihu', 'fa-brands fa-bilibili' => 'fa-brands fa-bilibili', 'fa-brands fa-bots' => 'fa-brands fa-bots', 'fa-brands fa-cmplid' => 'fa-brands fa-cmplid', 'fa-brands fa-golang' => 'fa-brands fa-golang', 'fa-brands fa-hashnode' => 'fa-brands fa-hashnode', 'fa-brands fa-nfc-directional' => 'fa-brands fa-nfc-directional', 'fa-brands fa-nfc-symbol' => 'fa-brands fa-nfc-symbol', 'fa-brands fa-padlet' => 'fa-brands fa-padlet', 'fa-brands fa-pix' => 'fa-brands fa-pix', 'fa-brands fa-screenpal' => 'fa-brands fa-screenpal', 'fa-brands fa-sitrox' => 'fa-brands fa-sitrox', 'fa-brands fa-wirsindhandwerk' => 'fa-brands fa-wirsindhandwerk', 'fa-brands fa-space-awesome' => 'fa-brands fa-space-awesome', 'fa-brands fa-square-gitlab' => 'fa-brands fa-square-gitlab' );

        $hcode_all_icons_list = array_merge( $hcode_etline_icons, $hcode_fa_icons_solid, $hcode_fa_icons_reg, $hcode_fa_icons_brand );

        return $hcode_all_icons_list;
    }
endif;
add_filter( 'redux/hcode_theme_setting/field/font/icons', 'hcode_get_all_font_icons' );
// Remove Empty P tag

if( ! function_exists( 'hcode_remove_wpautop' ) ) {
    function hcode_remove_wpautop( $content, $force_br = true ) {
        if ( $force_br ) {
          $content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
        }
        return do_shortcode( shortcode_unautop( $content ) );
    }
}

// Post Meta
if ( ! function_exists( 'hcode_single_post_meta' ) ) :

    function hcode_single_post_meta() {

        $hcode_single_enable_author     = hcode_option( 'hcode_single_enable_author' );
        $hcode_single_enable_date       = hcode_option( 'hcode_single_enable_date' );
        $hcode_single_date_format       = hcode_option( 'hcode_single_date_format' );
        $hcode_single_enable_category   = hcode_option( 'hcode_single_enable_category' );

        $posted_by = array();
        if ( ( 'post' == get_post_type() && $hcode_single_enable_author ) || 'portfolio' == get_post_type() ) {
            if ( is_singular() || is_multi_author() ) {
                $posted_by[] = sprintf( '%1$s <span class="author vcard"><a class="url fn n" href="%2$s">%3$s</a></span>',
                    esc_html__( 'Posted by ', 'H-Code' ),
                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                    get_the_author()
                );
            }
        }
        if ( in_array( get_post_type(), array( 'post', 'attachment', 'portfolio' ) ) && $hcode_single_enable_date ) {
            $time_string = '%2$s';

            $time_string = sprintf( $time_string,
                esc_attr( get_the_date( 'c' ) ),
                get_the_date( $hcode_single_date_format ),
                esc_attr( get_the_modified_date( 'c' ) ),
                get_the_modified_date( $hcode_single_date_format )
            );

            $posted_by[] = sprintf( '<span class="published">%1$s</span><time class="updated display-none" datetime="'.esc_attr( get_the_modified_date( 'c' ) ).'">'.get_the_modified_date( $hcode_single_date_format ).'</time>',
                $time_string
            );
        }
        if ( 'post' == get_post_type() && $hcode_single_enable_category ) {
            
            $categories_list = get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'H-Code' ) );
            if ( $categories_list && hcode_categorized_blog() ) {
                $posted_by[] = sprintf( '%1$s',
                    $categories_list
                );
            }
        }

        if( !empty( $posted_by ) ) {
            echo '<div class="blog-date no-padding-top standard-post-meta">';
            echo implode(' | ', $posted_by);
            echo '</div>';
        }
    }
endif;

// single portfolio meta

if ( ! function_exists( 'hcode_single_portfolio_meta' ) ) :

    function hcode_single_portfolio_meta() {
    $output = '';
    ob_start();
    $hcode_enable_meta_author_portfolio = hcode_option('hcode_enable_meta_author_portfolio');
    $hcode_enable_meta_date_portfolio = hcode_option('hcode_enable_meta_date_portfolio');
    $hcode_portfolio_date_format = hcode_option('hcode_portfolio_date_format');
    $hcode_enable_meta_category_portfolio = hcode_option('hcode_enable_meta_category_portfolio');
        if ( 'portfolio' == get_post_type() ) {
            if ( (is_singular() || is_multi_author()) && $hcode_enable_meta_author_portfolio == 1 ) {
                printf( '%1$s <span class="author vcard"><a class="url fn n" href="%2$s">%3$s</a></span>',
                    _x( 'Created by', 'Used before post author name.', 'H-Code' ),
                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                    get_the_author()
                );
            }
        }
        if ( in_array( get_post_type(), array( 'portfolio' ) ) ) {
            $time_string = '%2$s';

            $time_string = sprintf( $time_string,
                esc_attr( get_the_date( 'c' ) ),
                get_the_date( $hcode_portfolio_date_format ),
                esc_attr( get_the_modified_date( 'c' ) ),
                get_the_modified_date( $hcode_portfolio_date_format )
            );
            if( $hcode_enable_meta_date_portfolio == 1){
                if($hcode_enable_meta_author_portfolio == 1){
                    printf( ' | <span class="published">%1$s</span><time class="updated display-none" datetime="'.esc_attr( get_the_modified_date( 'c' ) ).'">'.get_the_modified_date( $hcode_portfolio_date_format ).'</time>',
                        $time_string
                    );
                }else{
                    printf( ' <span class="published">%1$s</span><time class="updated display-none" datetime="'.esc_attr( get_the_modified_date( 'c' ) ).'">'.get_the_modified_date( $hcode_portfolio_date_format ).'</time>',
                        $time_string
                    );
                }
            }
        }

        if ( 'portfolio' == get_post_type() ) {
            $cat = get_the_terms( get_the_ID(), 'portfolio-category' );
            $item = 1;
            $cat_slug = '';
            if( !empty( $cat ) ) {
                foreach ($cat as $key => $c) {
                    if( count($cat) == $item){
                        $cat_slug .= '<a href="' . get_term_link( $c ) . '" title="' . sprintf( esc_html__( 'View all post filed under %s', 'H-Code' ), $c->name ) . '" rel="category tag">' . $c->name . '</a>';
                    }else{
                        $cat_slug .= '<a href="' . get_term_link( $c ) . '" title="' . sprintf( esc_html__( 'View all post filed under %s', 'H-Code' ), $c->name ) . '" rel="category tag">' . $c->name . '</a>, ';
                    }
                    $item++;
                }
            }
            if( $cat_slug && $hcode_enable_meta_category_portfolio == 1 ) {
                if( $hcode_enable_meta_author_portfolio == 1 || $hcode_enable_meta_date_portfolio == 1 ) {
                    echo ' | '.$cat_slug;
                } else {
                    echo sprintf( __('%s','H-Code'), $cat_slug );
                }
            }
        }
        $output = ob_get_contents();  
        ob_end_clean(); 
        return $output;
    }
endif;

// Blog Full Width Header Meta

if ( ! function_exists( 'hcode_full_width_single_post_meta' ) ) :

    function hcode_full_width_single_post_meta() {

        $hcode_single_enable_author     = hcode_option('hcode_single_enable_author');
        $hcode_single_enable_date       = hcode_option('hcode_single_enable_date');
        $hcode_single_date_format       = hcode_option('hcode_single_date_format');
        $hcode_single_enable_category   = hcode_option('hcode_single_enable_category');

        if ( 'post' == get_post_type() && $hcode_single_enable_author ) {
            if ( is_singular() || is_multi_author() ) {
                printf( '<div class="posted-by text-uppercase full-width-header-post-meta">%1$s <span class="author vcard"><a class="url fn n white-text" href="%2$s">%3$s</a></span></div>',
                    esc_html__( 'Posted by ', 'H-Code' ),
                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                    get_the_author()
                );
            }
        }
        printf('<div class="full-blog-date text-uppercase full-width-header-post-meta">');
            if( $hcode_single_enable_date ) {
                if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
                    $time_string = '%2$s';

                    $time_string = sprintf( $time_string,
                        esc_attr( get_the_date( 'c' ) ),
                        get_the_date($hcode_single_date_format)
                    );

                    printf( ' <span class="published">%s</span><time class="updated display-none" datetime="'.esc_attr( get_the_modified_date( 'c' ) ).'">'.get_the_modified_date( $hcode_single_date_format ).'</time>',
                        $time_string
                    );
                }
            }
            
            if( $hcode_single_enable_date && $hcode_single_enable_category ) {
                echo ' | ';
            }

            if( $hcode_single_enable_category ) {
                if ( 'post' == get_post_type() ) {
                    
                    $categories_list = get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'H-Code' ) );
                    if ( $categories_list && hcode_categorized_blog() ) {
                        printf( '%1$s',
                            $categories_list
                        );
                    }
                }
            }
        printf('</div>');  
        if ( is_attachment() && wp_attachment_is_image() ) {
            // Retrieve attachment metadata.
            $metadata = wp_get_attachment_metadata();

            printf( '<span class="full-size-link"><span class="screen-reader-text">%1$s </span><a href="%2$s">%3$s &times; %4$s</a></span>',
                _x( 'Full size', 'Used before full size attachment link.', 'H-Code' ),
                esc_url( wp_get_attachment_url() ),
                $metadata['width'],
                $metadata['height']
            );
        }

        if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
            echo '<span class="comments-link">';
            comments_popup_link( esc_html__( 'Leave a comment', 'H-Code' ), esc_html__( '1 Comment', 'H-Code' ), esc_html__( '% Comments', 'H-Code' ) );
            echo '</span>';
        }
    }
endif;

if ( ! function_exists( 'hcode_categorized_blog' ) ) :
    function hcode_categorized_blog() {
        if ( false === ( $all_the_cool_cats = get_transient( 'hcode_categories' ) ) ) {
            // Create an array of all the categories that are attached to posts.
            $all_the_cool_cats = get_categories( array(
                'fields'     => 'ids',
                'hide_empty' => 1,

                // We only need to know if there is more than one category.
                'number'     => 2,
            ) );

            // Count the number of categories that are attached to the posts.
            $all_the_cool_cats = count( $all_the_cool_cats );

            set_transient( 'hcode_categories', $all_the_cool_cats );
        }

        if ( $all_the_cool_cats > 1 ) {
            // This blog has more than 1 category so hcode_categorized_blog should return true.
            return true;
        } else {
            // This blog has only 1 category so hcode_categorized_blog should return false.
            return false;
        }
    }
endif;

if ( ! function_exists( 'hcode_category_transient_flusher' ) ) :
    function hcode_category_transient_flusher() {
        delete_transient( 'hcode_categories' );
    }
endif;
add_action( 'edit_category', 'hcode_category_transient_flusher' );
add_action( 'save_post',     'hcode_category_transient_flusher' );

// Get the Post Tags

if ( ! function_exists( 'hcode_single_post_meta_tag' ) ) :

    function hcode_single_post_meta_tag() {
    if ( 'post' == get_post_type() ) {

            $tags_list = get_the_tag_list( '', _x( ', ', 'Used between list items, there is a space after the comma.', 'H-Code' ) );
            if ( $tags_list ) {
                printf( '%1$s %2$s',
                    __( '<h5 class="widget-title margin-one no-margin-top">Tags</h5>', 'H-Code' ),
                    $tags_list
                );
            }
        }
    }
endif;

// To Get Portfolio Tags

if ( ! function_exists( 'hcode_single_portfolio_meta_tag' ) ) :

    function hcode_single_portfolio_meta_tag() {
    if ( 'portfolio' == get_post_type() ) {

            global $post;
            $portfolio_tag_list = get_the_term_list($post->ID, 'portfolio-tags', '<h5 class="widget-title margin-one no-margin-top">Tags</h5>', ', ', '');
            if($portfolio_tag_list):
                echo '<div class="blog-date float-left width-100 no-padding-top margin-eight no-margin-bottom">';
                echo get_the_term_list($post->ID, 'portfolio-tags', '<h5 class="widget-title margin-one no-margin-top">Tags</h5>', ', ', '');
                echo '</div>';
            endif;
        }
    }
endif;

if ( ! function_exists( 'hcode_login_logo' ) ) :
// To Change Admin Panel Logo.
    function hcode_login_logo() { 
        $admin_logo = hcode_option('hcode_header_logo');
        if( is_array( $admin_logo    ) ) {
            if( $admin_logo['url'] ) {
            ?>
            <style type="text/css">
                .login h1 a {
                    background-image: url(<?php echo esc_url( $admin_logo['url'] ) ?>  ) !important;
                    background-size: contain !important;
                    height: 48px !important;
                    width: 100% !important;
                }
            </style>
            <?php 
            }
        }
    }
endif;
add_action( 'login_enqueue_scripts', 'hcode_login_logo' );

// To Change Admin Panel Logo Url.
if ( ! function_exists( 'hcode_login_logo_url' ) ) :
    function hcode_login_logo_url() {
        return home_url( '/' );
    }
endif;
add_filter( 'login_headerurl', 'hcode_login_logo_url' );

// To Change Admin Panel Logo Title.
if ( version_compare( $GLOBALS['wp_version'], '5.2.0', '<' ) ) {
    add_filter( 'login_headertitle', 'hcode_login_logo_url_title' );
} else {
    add_filter( 'login_headertext', 'hcode_login_logo_url_title' );
}
if ( ! function_exists( 'hcode_login_logo_url_title' ) ) :
    function hcode_login_logo_url_title() {
        $text = get_bloginfo('name').' | '.get_bloginfo('description');
        return $text;
    }
endif;

// To remove deprecated notice for old functions
add_filter('deprecated_constructor_trigger_error', '__return_false');

if ( ! function_exists( 'hcode_registered_sidebars_array' ) ) :
function hcode_registered_sidebars_array() {
    global $wp_registered_sidebars;
    if( ! empty( $wp_registered_sidebars ) && is_array( $wp_registered_sidebars ) ){ 
        $sidebar_array = array();
        $sidebar_array['default'] = 'Default';
        foreach( $wp_registered_sidebars as $sidebar ){
            $sidebar_array[$sidebar['id']] = $sidebar['name'];
        }
    }
    return $sidebar_array;
}
endif;

// Check if Hcode-addons Plugin active or not.
if( !class_exists( 'Hcode_Addons_Post_Type' ) ) {
    if ( ! function_exists( 'get_simple_likes_button' ) ) {
        function get_simple_likes_button( $id ) {
            return;
        }
    }
}

// Remove VC redirection
if( class_exists( 'Vc_Manager' ) ) {
    remove_action( 'vc_activation_hook', 'vc_page_welcome_set_redirect' );
    remove_action( 'admin_init', 'vc_page_welcome_redirect' );
}

// Post excerpt
add_filter('the_content', 'hcode_trim_excerpts');
if ( ! function_exists( 'hcode_trim_excerpts' ) ) {
    function hcode_trim_excerpts($content = false) {
        global $post;

        /* To fixed Business directory plugin issue */
        if( get_post_type() == 'wpbdp_listing' ) {
            if( is_archive() ) {
                $content = str_replace("|br|", "<br>", $content );
                return $content;
            }
        }

        if( !is_singular() && !is_admin() ){
            $content = $post->post_excerpt;
            // If an excerpt is set in the Optional Excerpt box
            if( $content ) {
                $content = apply_filters('the_excerpt', $content);

            } else {
                $content = $post->post_content;
            }
        }
        $content = str_replace( "|br|", "<br>", $content );
        // Make sure to return the content
        return $content;
    }
}

if ( ! function_exists( 'hcode_enqueue_fonts_url' ) ) :

function hcode_enqueue_fonts_url( $swap = true ) {

    global $hcode_theme_settings;

    $hcode_fonts_url = '';
    $hcode_fonts = $hcode_main_font_weight = $hcode_alt_font_weight = $hcode_font_subsets = array();

    /* For Main Font Weight */
    $hcode_main_font_weight_array = ( isset( $hcode_theme_settings['main_font_weight'] ) ) ? $hcode_theme_settings['main_font_weight'] : '';
    if( !empty( $hcode_main_font_weight_array ) ) {
        foreach ($hcode_main_font_weight_array as $key => $value) {
            if( $value == 1 ){
                $hcode_main_font_weight[] = $key;
            }
        }
    }

    if( !empty( $hcode_main_font_weight ) ) {
        $hcode_main_font_weight = implode( ',', $hcode_main_font_weight );
    } else {
        $hcode_main_font_weight = '100,300,400,500,600,700,800,900';
    }

    if( isset($hcode_theme_settings['main_font']['font-family']) && $hcode_theme_settings['main_font']['font-family'] ){
        $hcode_fonts[] = $hcode_theme_settings['main_font']['font-family'].':'.$hcode_main_font_weight;
    }else{
        $hcode_fonts[] = 'Open Sans:100,300,400,500,600,700,800,900';
    }

    /* For Alt Font Weight */
    $hcode_alt_font_weight_array = ( isset( $hcode_theme_settings['alt_font_weight'] ) ) ? $hcode_theme_settings['alt_font_weight'] : '';
    if( !empty( $hcode_alt_font_weight_array ) ) {
        foreach ($hcode_alt_font_weight_array as $key => $value) {
            if( $value == 1 ){
                $hcode_alt_font_weight[] = $key;
            }
        }
    }

    if( !empty( $hcode_alt_font_weight ) ) {
        $hcode_alt_font_weight = implode( ',', $hcode_alt_font_weight );
    } else {
        $hcode_alt_font_weight = '100,300,400,500,600,700,800,900';
    }
    if( isset( $hcode_theme_settings['alt_font']['font-family'] ) && $hcode_theme_settings['alt_font']['font-family'] ){
        $hcode_fonts[] = $hcode_theme_settings['alt_font']['font-family'].':'.$hcode_alt_font_weight;
    }else{
        $hcode_fonts[] = 'Oswald:100,300,400,500,600,700,800,900';
    }

    /* For Font Subsets */
    $hcode_main_font_subsets = ( isset( $hcode_theme_settings['main_font_languages'] ) ) ? $hcode_theme_settings['main_font_languages'] : '' ;
    if( !empty( $hcode_main_font_subsets ) ) {
        foreach ($hcode_main_font_subsets as $key => $value) {
            if( $value == 1 ){
                $hcode_font_subsets[] = $key;
            }
        }
    }
    if( !empty( $hcode_font_subsets ) ) {
        $hcode_main_font_subsets = implode( ',',  $hcode_font_subsets );
    } else {
        $hcode_main_font_subsets = '';
    }
    if ( $hcode_fonts ) {
        $hcode_fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $hcode_fonts ) ),
            'subset' => urlencode( $hcode_main_font_subsets ),
        ), '//fonts.googleapis.com/css' );
    }
    if( $swap ) {
        $hcode_fonts_url = add_query_arg( array(
            'display' => 'swap',
        ), $hcode_fonts_url );
    }
    return $hcode_fonts_url;
}
endif;

if ( ! function_exists( 'hcode_font_scripts' ) ) :
    function hcode_font_scripts() {
        global $hcode_theme_settings;

        $disable_google_fonts = ( isset( $hcode_theme_settings['disable_google_fonts'] ) ) ? $hcode_theme_settings['disable_google_fonts'] : '' ;
        if( $disable_google_fonts != 1 ) {
            $hcode_performance_google_fonts_render = ( isset( $hcode_theme_settings['hcode_performance_google_fonts_render'] ) ) ? $hcode_theme_settings['hcode_performance_google_fonts_render'] : '' ;
            if( $hcode_performance_google_fonts_render != 1 ) {
                wp_enqueue_style( 'hcode-fonts', hcode_enqueue_fonts_url(), array(), null );
            }
        }
    }
endif;
add_action( 'wp_enqueue_scripts', 'hcode_font_scripts' );

add_action( 'wp_footer', 'hcode_load_font_faster_render', 99 );
if( ! function_exists( 'hcode_load_font_faster_render' ) ) :
    function hcode_load_font_faster_render(){
        global $hcode_theme_settings;

        $hcode_performance_google_fonts_render = ( isset( $hcode_theme_settings['hcode_performance_google_fonts_render'] ) ) ? $hcode_theme_settings['hcode_performance_google_fonts_render'] : '' ;
        if( $hcode_performance_google_fonts_render == 1 ) {
            $disable_google_fonts = ( isset( $hcode_theme_settings['disable_google_fonts'] ) ) ? $hcode_theme_settings['disable_google_fonts'] : '' ;
            if( $disable_google_fonts != 1 ) {
                $hcode_enqueue_fonts_url = hcode_enqueue_fonts_url( false );
                if( $hcode_enqueue_fonts_url ) {
                    ?>
<link rel="dns-prefetch" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.googleapis.com/" crossorigin="anonymous">
<link rel="preload" href="<?php echo esc_url( $hcode_enqueue_fonts_url ) ?>" as="font" crossorigin="anonymous">
<script type="text/javascript">
!function(e,n,t){"use strict";var o="<?php echo esc_url( $hcode_enqueue_fonts_url ) ?>",r="__3perf_googleFonts_a1ce4";function c(e){(n.head||n.body).appendChild(e)}function a(){var e=n.createElement("link");e.href=o,e.rel="stylesheet",c(e)}function f(e){if(!n.getElementById(r)){var t=n.createElement("style");t.id=r,c(t)}n.getElementById(r).innerHTML=e}e.FontFace&&e.FontFace.prototype.hasOwnProperty("display")?(t[r]&&f(t[r]),fetch(o).then(function(e){return e.text()}).then(function(e){return e.replace(/@font-face {/g,"@font-face{font-display:swap;")}).then(function(e){return t[r]=e}).then(f).catch(a)):a()}(window,document,localStorage);
</script>
                <?php
                }
            }
        }
    }
endif;
/* End Google Fonts Render Faster */


if ( ! function_exists( 'hcode_check_enable_mini_header' ) ) :
    function hcode_check_enable_mini_header() {

        $hcode_enable_mini_header           = hcode_option( 'hcode_enable_mini_header' );
        $hcode_enable_mini_header_sidebar   = hcode_option( 'hcode_enable_mini_header_sidebar' );

        if( $hcode_enable_mini_header == 1 && !empty( $hcode_enable_mini_header_sidebar ) && is_active_sidebar( $hcode_enable_mini_header_sidebar ) ) {
            return true;
        }

        return false;
    }
endif;

if ( ! function_exists( 'hcode_extract_shortcode_contents' ) ) :
    /**
     * Extract text contents from all shortcodes for usage in excerpts
     *
     * @return string The shortcode contents
     **/
    function hcode_extract_shortcode_contents( $m ) {
        global $shortcode_tags;

        // Setup the array of all registered shortcodes
        $shortcodes = array_keys( $shortcode_tags );
        $no_space_shortcodes = array( 'dropcap' );
        $omitted_shortcodes  = array( 'slide' );

        // Extract contents from all shortcodes recursively
        if ( in_array( $m[2], $shortcodes ) && ! in_array( $m[2], $omitted_shortcodes ) ) {
            $pattern = get_shortcode_regex();
            // Add space the excerpt by shortcode, except for those who should stick together, like dropcap
            $space = ' ' ;
            if ( in_array( $m[2], $no_space_shortcodes ) ) {
                $space = '' ;
            }
            $content = preg_replace_callback( "/$pattern/s", 'hcode_extract_shortcode_contents', rtrim( $m[5] ) . $space );
            return $content;
        }

        // allow [[foo]] syntax for escaping a tag
        if ( $m[1] == '[' && $m[6] == ']' ) {
            return substr( $m[0], 1, -1 );
        }

       return $m[1] . $m[6];
    }
endif;

if ( ! function_exists( 'hcode_theme_active_licence' ) ) :
    function hcode_theme_active_licence( $value ='no' ) {
        $hcode_option_name = 'hcode_theme_active' ;
        if ( get_option( $hcode_option_name ) !== false ) {
            update_option( $hcode_option_name, $value );
        } else {
            $deprecated = null;
            $autoload = 'no';
            add_option( $hcode_option_name, $value, $deprecated, $autoload );
        }
    }
endif;

if ( ! function_exists( 'hcode_is_theme_licence_active' ) ) :
    function hcode_is_theme_licence_active() {
        $hcode_theme_active = get_option( 'hcode_theme_active' );
        if( $hcode_theme_active == 'yes' || defined('ENVATO_HOSTED_SITE') ){
            return true;
        } else {
            return false;
        }
    }
endif;

if ( ! function_exists( 'hcode_theme_activate' ) ) :
    function hcode_theme_activate() {
        global $pagenow;
        if( !hcode_is_theme_licence_active() ){
            if( is_admin() && 'themes.php' == $pagenow && isset( $_GET[ 'activated' ] ) ) {
                wp_redirect( admin_url( 'themes.php?page=hcode-licence-activation' ) );
                exit;
            }
        }

    }
endif;
add_action( 'after_setup_theme', 'hcode_theme_activate', 11 );

if ( ! function_exists( 'hcode_get_host' ) ) :
    function hcode_get_host() {
        $hcode_api_host = 'http://api.themezaa.com';
        return $hcode_api_host;
    }
endif;

if ( ! function_exists( 'hcode_random_string' ) ) :
    function hcode_random_string( $length = 20 ) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $len = strlen( $characters );
        $str = '';
        for ( $i = 0; $i < $length; $i ++ ) {
            $str .= $characters[ rand( 0, $len - 1 ) ];
        }

        return $str;
    }
endif;

if ( ! function_exists( 'hcode_generate_theme_licence_activation_url' ) ) :
    function hcode_generate_theme_licence_activation_url() {
            
        $hcode_licence_api = hcode_get_host();

        $hcode_token = sha1( current_time( 'timestamp' ) . '|' . hcode_random_string(20) );
        $hcode_home_url = esc_url( home_url( '/' ) );

        $hcode_redirect = admin_url( 'themes.php?page=hcode-licence-activation' );
                    
        if ( false === ( $hcode_token == get_transient( 'hcode_licence_token' ) ) ) {
            set_transient( 'hcode_licence_token', $hcode_token, HOUR_IN_SECONDS );
        }
        $hcode_get_transient = get_transient( 'hcode_licence_token' );

        return sprintf( '%s?token=%s&url=%s&redirect=%s&itemid=%s', $hcode_licence_api.'/activate-license/', $hcode_get_transient, $hcode_home_url, $hcode_redirect, '14561695' );
    }
endif;

if ( ! function_exists( 'hcode_theme_licence_notice' ) ) :
    function hcode_theme_licence_notice() {
        
        if( !empty( $_COOKIE['hcode_hide_activation_message'] ) || hcode_is_theme_licence_active() ) {
            return;
        }

        if( isset( $_GET['response'] ) ) {
            if( $_GET['response'] == 'true' ) {
                return;
            }
        }

        $class = 'notice notice-success hcode-license-activation-message is-dismissible';
        $message = esc_html__( 'Please activate your H-Code WordPress theme license to unlock H-Code premium features.', 'H-Code' );

        printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) ); 
    }
endif;
add_action( 'admin_notices', 'hcode_theme_licence_notice' );

if ( ! function_exists( 'hcode_add_default_cursor' ) ) :
    function hcode_add_default_cursor() {
        
        $hcode_custom_css = '';
        $hcode_options = get_option( 'hcode_theme_setting' );

        $hcode_show_default_cursor_image =  (isset($hcode_options['hcode_show_default_cursor_image']) && !empty($hcode_options['hcode_show_default_cursor_image'])) ? $hcode_options['hcode_show_default_cursor_image'] : '';

        if( $hcode_show_default_cursor_image != 1 ) {
            $hcode_custom_css .= "figure:hover img, figure:hover figcaption, .popup-gallery img, .lightbox-gallery img, .image-popup-no-margins img, .image-popup-vertical-fit img, .zoom-gallery img { cursor: pointer !important }";
            $hcode_custom_css .= ".mfp-zoom-out-cur, .mfp-zoom-out-cur .mfp-image-holder .mfp-close, .mfp-image-holder, .mfp-iframe-holder, .mfp-close-btn-in, .mfp-content, .mfp-container, .mfp-auto-cursor .mfp-content { cursor: pointer !important }";
        } else {
            /* For Open Cursor */
            $hcode_default_open_cursor_image = (isset($hcode_options['hcode_default_open_cursor_image']) && !empty($hcode_options['hcode_default_open_cursor_image'])) ? $hcode_options['hcode_default_open_cursor_image'] : '';
            if( isset( $hcode_default_open_cursor_image['url'] ) && !empty( $hcode_default_open_cursor_image['url'] ) ){
                $hcode_custom_css .= "figure:hover img, figure:hover figcaption,.popup-gallery img, .lightbox-gallery img, .image-popup-no-margins img, .image-popup-vertical-fit img, .zoom-gallery img { cursor: url('".esc_url($hcode_default_open_cursor_image['url'])."'), pointer !important }";
            }

            /* For Close Cursor */
            $hcode_default_close_cursor_image = (isset($hcode_options['hcode_default_close_cursor_image']) && !empty($hcode_options['hcode_default_close_cursor_image'])) ? $hcode_options['hcode_default_close_cursor_image'] : '';
            if( isset( $hcode_default_close_cursor_image['url'] ) && !empty( $hcode_default_close_cursor_image['url'] ) ){
                $hcode_custom_css .= ".mfp-zoom-out-cur, .mfp-zoom-out-cur .mfp-image-holder .mfp-close, .mfp-image-holder, .mfp-iframe-holder, .mfp-close-btn-in, .mfp-content, .mfp-container { cursor: url('".esc_url($hcode_default_close_cursor_image['url'])."'), pointer !important }";
            }
        }

        wp_add_inline_style( 'hcode-magnific-popup-style', $hcode_custom_css );
    }
endif;
add_action( 'wp_enqueue_scripts', 'hcode_add_default_cursor', 999 );

add_filter( 'body_class', 'hcode_add_body_class' );
if ( ! function_exists( 'hcode_add_body_class' ) ) :
    function hcode_add_body_class( $classes ) {

        $hcode_options = get_option( 'hcode_theme_setting' );

        $hcode_popup_on_click_close =  (isset($hcode_options['hcode_popup_on_click_close']) && !empty($hcode_options['hcode_popup_on_click_close'])) ? $hcode_options['hcode_popup_on_click_close'] : '';
        if( $hcode_popup_on_click_close != 1 ) {
            $classes[] = 'hcode-custom-popup-close';
        }           

        if( ( isset( $hcode_options['enable_lightbox_title'] ) && $hcode_options['enable_lightbox_title'] == 1 ) || ( isset( $hcode_options['enable_lightbox_caption'] ) && $hcode_options['enable_lightbox_caption'] == 1 ) ){
            $classes[] = 'hcode-custom-lightbox-title';
        }
        $classes[] = 'hcode-menu-custom-color';
        return $classes;
    }
endif;

if ( ! function_exists( 'hcode_admin_favicon' ) ) :
    function hcode_admin_favicon() {
        
        global $hcode_theme_settings;

        $enable_theme_favicon = ( isset( $hcode_theme_settings[ 'enable_theme_favicon' ] ) ) ? $hcode_theme_settings[ 'enable_theme_favicon' ] : 1;
        $hcode_favicon_meta_tags = array();
        if( $enable_theme_favicon ) {
            if( hcode_option( 'default_favicon' ) ) {
                $default_favicon = hcode_option_url( 'default_favicon' );
                $hcode_favicon_meta_tags[] = sprintf( '<link rel="shortcut icon" href="%s" />', esc_url( $default_favicon ) );
            }
            if( hcode_option( 'apple_iPhone_favicon' ) ) {
                $apple_iPhone_favicon = hcode_option_url( 'apple_iPhone_favicon' );
                $hcode_favicon_meta_tags[] = sprintf( '<link rel="apple-touch-icon" href="%s" />', esc_url( $apple_iPhone_favicon ) );
            }
            if( hcode_option( 'apple_iPad_favicon' ) ) {
                $apple_iPad_favicon = hcode_option_url( 'apple_iPad_favicon' );
                $hcode_favicon_meta_tags[] = sprintf( '<link rel="apple-touch-icon" sizes="72x72" href="%s" />', esc_url( $apple_iPad_favicon ) );
            }
            if( hcode_option( 'apple_iPhone_retina_favicon' ) ) {
                $apple_iPhone_retina_favicon = hcode_option_url( 'apple_iPhone_retina_favicon' );
                $hcode_favicon_meta_tags[] = sprintf( '<link rel="apple-touch-icon" sizes="114x114" href="%s" />', esc_url( $apple_iPhone_retina_favicon ) );
            }
            if( hcode_option( 'apple_iPad_retina_favicon' ) ) {
                $apple_iPad_retina_favicon = hcode_option_url( 'apple_iPad_retina_favicon' );
                $hcode_favicon_meta_tags[] = sprintf( '<link rel="apple-touch-icon" sizes="149x149" href="%s" />', esc_url( $apple_iPad_retina_favicon ) );
            }

            if( count( $hcode_favicon_meta_tags ) >= 1 ) {
                foreach ( $hcode_favicon_meta_tags as $hcode_favicon_meta_tag ) {
                    echo "$hcode_favicon_meta_tag\n";
                }
            }
        }
    }
endif;    
add_action( 'admin_head', 'hcode_admin_favicon', 99999 );
add_action( 'wp_head', 'hcode_admin_favicon', 99999 );

if ( ! function_exists( 'hcode_space_before_head' ) ) :
    function hcode_space_before_head() {
        
        if ( is_singular() && pings_open() ) {
            printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
        }

        if( hcode_option( 'general_css_code' ) ) { ?>
            <style>
                <?php echo hcode_option( 'general_css_code' ); ?>
            </style>
        <?php }
    
        if( hcode_option( 'tracking_code' ) ) {
            echo hcode_option( 'tracking_code' );
        }

        if( hcode_option( 'space_before_head' ) ) {
            echo hcode_option( 'space_before_head' );
        }
    }
endif;    
add_action( 'wp_head', 'hcode_space_before_head', 99999 );

if ( ! function_exists( 'hcode_space_before_body' ) ) :
    function hcode_space_before_body() {
        if( hcode_option( 'space_before_body' ) ):
            echo hcode_option( 'space_before_body' );
        endif;
    }
endif;    
add_action( 'wp_footer', 'hcode_space_before_body', 99999 );

if ( ! function_exists( 'hcode_get_header_layout' ) ) :
    function hcode_get_header_layout( $type = 'title' ) {

        if( $type == 'preview' ) {

            return array(
                            "headertype1" => get_template_directory_uri()."/assets/images/header1.jpg",
                            "headertype2" => get_template_directory_uri()."/assets/images/header2.jpg",
                            "headertype3" => get_template_directory_uri()."/assets/images/header3.jpg",
                            "headertype4" => get_template_directory_uri()."/assets/images/header4.jpg",
                            "headertype5" => get_template_directory_uri()."/assets/images/header5.jpg",
                            "headertype6" => get_template_directory_uri()."/assets/images/header6.jpg",
                            "headertype7" => get_template_directory_uri()."/assets/images/header7.jpg",
                            "headertype8" => get_template_directory_uri()."/assets/images/header6.jpg",
                            "headertype9" => get_template_directory_uri()."/assets/images/header9.jpg",
                            "headertype10"=> get_template_directory_uri()."/assets/images/header10.jpg",
                            "headertype11"=> get_template_directory_uri()."/assets/images/header11.jpg",
                        );
        } else if( $type == 'meta_fields' ) {

            return array(  
                            'default'     => esc_html__('Default', 'H-Code'),
                            'headertype1' => esc_html__('Light Header', 'H-Code'),
                            'headertype2' => esc_html__('Dark Header', 'H-Code'),
                            'headertype3' => esc_html__('Dark Transparent Header', 'H-Code'),
                            'headertype4' => esc_html__('Light Transparent Header', 'H-Code'),
                            'headertype5' => esc_html__('Static Sticky Header', 'H-Code'),
                            'headertype6' => esc_html__('White Sticky Header', 'H-Code'),
                            'headertype7' => esc_html__('Gray Header', 'H-Code'),
                            'headertype8' => esc_html__('Non Sticky Header', 'H-Code'),
                            'headertype9' => esc_html__('Hamburger Header 1', 'H-Code'),
                            'headertype10'=> esc_html__('Hamburger Header 2', 'H-Code'),
                            'headertype11'=> esc_html__('Hamburger Header 3', 'H-Code'),
                        );
        } else {

            return array(  
                            'imgtitle1'   => esc_html__('Light Header', 'H-Code'),
                            'imgtitle2'   => esc_html__('Dark Header', 'H-Code'),
                            'imgtitle3'   => esc_html__('Dark Transparent Header', 'H-Code'),
                            'imgtitle4'   => esc_html__('Light Transparent Header', 'H-Code'),
                            'imgtitle5'   => esc_html__('Static Sticky Header', 'H-Code'),
                            'imgtitle6'   => esc_html__('White Sticky Header', 'H-Code'),
                            'imgtitle7'   => esc_html__('Gray Header', 'H-Code'),
                            'imgtitle8'   => esc_html__('Non Sticky Header', 'H-Code'),
                            'imgtitle9'   => esc_html__('Hamburger Header 1', 'H-Code'),
                            'imgtitle10'  => esc_html__('Hamburger Header 2', 'H-Code'),
                            'imgtitle11'  => esc_html__('Hamburger Header 3', 'H-Code'),
                        );
        }
    }
endif;

if( ! function_exists( 'hcode_get_intermediate_image_sizes' ) ) :
    function hcode_get_intermediate_image_sizes() {
        global $wp_version;
        $image_sizes = array( 'full', 'thumbnail', 'medium', 'medium_large', 'large' ); // Standard sizes
        if( $wp_version >= '4.7.0' ){
            $_wp_additional_image_sizes = wp_get_additional_image_sizes();
            if ( ! empty( $_wp_additional_image_sizes ) ) {
                $image_sizes = array_merge( $image_sizes, array_keys( $_wp_additional_image_sizes ) );
            }
            return apply_filters( 'intermediate_image_sizes', $image_sizes );
        } else {
            return $image_sizes;
        }
    }
endif;

if( ! function_exists( 'hcode_get_image_sizes' ) ) :
    function hcode_get_image_sizes() {
        global $_wp_additional_image_sizes;

        $sizes = array();

        foreach ( get_intermediate_image_sizes() as $_size ) {
            if ( in_array( $_size, array('full', 'thumbnail', 'medium', 'medium_large', 'large') ) ) {
                $sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
                $sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
                $sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
            } elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
                $sizes[ $_size ] = array(
                    'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
                    'height' => $_wp_additional_image_sizes[ $_size ]['height'],
                    'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
                );
            }
        }
        return $sizes;
    }
endif;

if( ! function_exists( 'hcode_get_image_size' ) ) :
        function hcode_get_image_size( $size ) {
            $sizes = hcode_get_image_sizes();

            if ( isset( $sizes[ $size ] ) ) {
                return $sizes[ $size ];
            }

            return false;
        }
    endif;

if( ! function_exists( 'hcode_get_thumbnail_image_sizes' ) ) :
    function hcode_get_thumbnail_image_sizes() {

        $thumbnail_image_sizes = array();

        // Hackily add in the data link parameter.
        $hcode_srcset = hcode_get_intermediate_image_sizes();

        if(!empty($hcode_srcset)) {
            foreach ( $hcode_srcset as $value => $label ){
                
                if( 'full' === $label ) {
                    $data = esc_html__( 'Original Full Size', 'H-Code' );
                } else {
                    $hcode_srcset_image_data = hcode_get_image_size( $label );
                    $width = ( $hcode_srcset_image_data['width'] == 0 ) ? esc_html( 'Auto', 'H-Code' ) : $hcode_srcset_image_data['width'].'px';
                    $height = ( $hcode_srcset_image_data['height'] == 0 ) ? esc_html( 'Auto', 'H-Code' ) : $hcode_srcset_image_data['height'].'px';

                    $data = ucwords( str_replace( '_', ' ', str_replace( '-', ' ', esc_attr( $label ) ) ) ).' ('.esc_attr( $width ).' X '.esc_attr( $height ).')';
                }

                $thumbnail_image_sizes[$data] = $label;
            }
        }

        return $thumbnail_image_sizes;
    }
endif;

if ( ! function_exists( 'hcode_hide_feature_image' ) ) :
    function hcode_hide_feature_image( $classes ) {

        if( is_single() ) {

            $hcode_options = get_option( 'hcode_theme_setting' );
            $hcode_disable_feature_image = ( isset( $hcode_options[ 'hcode_disable_feature_image' ] ) ) ? $hcode_options[ 'hcode_disable_feature_image' ] : '';

            if( $hcode_disable_feature_image != 1 ){
                $classes[] = 'hide-post-feature-image';
            }
        }
        
        return $classes;
    }
endif;
add_filter( 'post_class', 'hcode_hide_feature_image' );

add_filter( 'the_privacy_policy_link', 'hcode_privacy_policy_link' );

if ( ! function_exists( 'hcode_privacy_policy_link' ) ) :
    function hcode_privacy_policy_link( $link ) {
        $link = str_replace( 'privacy-policy-link', 'privacy-policy-link light-gray-text2 vertical-align-middle', $link );
        return $link;
    }
endif;


/* Body BG image */
add_action( 'wp_head', 'hcode_background_image_callback' );

if ( ! function_exists( 'hcode_background_image_callback' ) ) :
    function hcode_background_image_callback() {
        global $hcode_theme_settings, $post;

        $image_flag = true;
        $hcode_body_image = '';
        if( is_page() || is_single() || is_singular( 'portfolio' ) ) {
            $single_bg_image = get_post_meta( $post->ID, 'hcode_bg_image_single', true );
            if( esc_url( $single_bg_image ) ) {
                $hcode_body_image = $single_bg_image;
                $image_flag = false;
            }
        } 
        if( $image_flag ) {
            if( isset( $hcode_theme_settings['hcode_general_bg_image'] ) && $hcode_theme_settings['hcode_general_bg_image'] != ''){
                $hcodeimage = $hcode_theme_settings['hcode_general_bg_image'];
                $general_image =$hcodeimage['url'];
                
                if( esc_url( $general_image ) ) {
                    $hcode_body_image = $general_image;
                }
            }
        }
        
        if( $hcode_body_image ) {
        ?>
        <style type="text/css" id="hcode-background-image-css">body {background-image: url(<?php echo esc_url( $hcode_body_image ); ?>) !important;background-repeat: no-repeat !important;background-position: 50% 50% !important;-webkit-background-size: cover !important;-moz-background-size: cover !important;-o-background-size: cover !important;background-size: cover !important;background-attachment: fixed !important;}</style>
        <?php
        }
    }
endif;

//load button setting css other css 
if( ! function_exists( 'hcode_addons_generate_custom_css' ) ) {
    function hcode_addons_generate_custom_css() {
        global $hcode_featured_array, $style_array,$responsive_style;

        $output_css = '';
        if( !empty($hcode_featured_array)) {
            ob_start();
                echo '<style id="hcode-addon-custom-css" type="text/css">';
                    foreach ($hcode_featured_array as $key => $value) {
                        echo esc_attr( $value );
                    }    
                echo '</style>';
            $output_css = ob_get_contents();
            ob_end_clean();

            // 1. Remove comments.
            // 2. Remove whitespace.
            // 3. Remove starting whitespace.
            $output_css = preg_replace( '#/\*.*?\*/#s', '', $output_css );
            $output_css = preg_replace( '/\s*([{}|:;,])\s+/', '$1', $output_css );
            $output_css = preg_replace( '/\s\s+(.*)/', '$1', $output_css );

            ?>
                <script type="text/javascript"> (function($) { $('head').append('<?php print $output_css; ?>'); })(jQuery); </script>
            <?php   
        }

    }
}
add_action( 'wp_footer', 'hcode_addons_generate_custom_css', 998 );

/* Disable VC auto-update */
if( ! function_exists( 'hcode_vc_disable_update' ) ) {
    function hcode_vc_disable_update() {
        if( function_exists( 'vc_license' ) && function_exists( 'vc_updater' ) && ! vc_license()->isActivated() ) {
            remove_filter( 'upgrader_pre_download', array( vc_updater(), 'preUpgradeFilter' ), 10 );
            remove_filter( 'pre_set_site_transient_update_plugins', array( vc_updater()->updateManager(), 'check_update' ) );
        }
    }
}
add_action( 'admin_init', 'hcode_vc_disable_update', 9 );

/* Custom Header Image */
if( ! function_exists( 'hcode_custom_header_image' ) ) {
    function hcode_custom_header_image() {
        
        $header_image = get_header_image();

        if ( ! empty( $header_image ) ) {
            $hcode_header_image_css = ".navbar { background-image: url( ".esc_url( $header_image )." ) !important; background-repeat: no-repeat !important; background-position: 50% 50% !important; -webkit-background-size: cover !important; -moz-background-size: cover !important; -o-background-size: cover !important; background-size: cover !important; }";
            wp_add_inline_style( 'hcode-responsive-style', $hcode_header_image_css );
        }
    }
}
add_action( 'wp_enqueue_scripts', 'hcode_custom_header_image', 100 );

if( ! function_exists( 'hcode_redux_footer_credit_text' ) ) {
    function hcode_redux_footer_credit_text( $args ) {
        if ( empty( $args['footer_credit'] ) ) {

            $url = 'https://hcode.themezaa.com';
            $footer_text = sprintf(
                /* translators: 1: Redux, 2: Link to plugin review */
                __( 'Options panel for %1$s', 'H-Code' ),
                '<a href="' . $url . '" target="_blank">' . __( 'H-Code', 'H-Code' ) . '</a> v' . HCODE_THEME_VERSION
            );

            $args['footer_credit'] = '<span id="footer-thankyou">' . $footer_text . '</span>';
        }
        return $args;
    }
}

add_filter( 'hcode_footer_credit_text', 'hcode_redux_footer_credit_text' );
