<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */
defined( 'ABSPATH' ) || exit;

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$page_title    = apply_filters( 'woocommerce_my_account_my_address_title', esc_html__( 'My Addresses', 'H-Code' ) );
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __( 'Billing address', 'H-Code' ),
			'shipping' => __( 'Shipping address', 'H-Code' ),
		),
		$customer_id
	);
} else {
	$page_title    = apply_filters( 'woocommerce_my_account_my_address_title', esc_html__( 'My Address', 'H-Code' ) );
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __( 'Billing address', 'H-Code' ),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>
<div class="col-md-12 margin-bottom-10px">
	<h2 class="black-text font-weight-600 text-uppercase title-small"><?php echo esc_html($page_title); ?></h2>

	<p class="myaccount_address">
		<?php echo apply_filters( 'woocommerce_my_account_my_address_description', esc_html__( 'The following addresses will be used on the checkout page by default.', 'H-Code' ) ); ?>
	</p>
</div>
<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) echo '<div class="col2-set addresses">'; ?>

<?php foreach ( $get_addresses as $name => $address_title ) : ?>
	<?php
		$address = wc_get_account_formatted_address( $name );
		$col     = $col * -1;
		$oldcol  = $oldcol * -1;
	?>

	<div class="u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> woocommerce-Address address col-sm-6 col-xs-12">		
		<div class="woocommerce-Address-title title">
			<h3 class="black-text font-weight-600 text-uppercase text-large margin-bottom-10px"><?php echo esc_html($address_title); ?></h3>
			<a href="<?php echo wc_get_endpoint_url( 'edit-address', $name ); ?>" class="edit"><?php echo $address ? esc_html__( 'Edit', 'H-Code' ) : esc_html__( 'Add', 'H-Code' ); ?></a>
		</div>
		<address>
			<?php
				echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'H-Code' );

				/**
				 * Used to output content after core address fields.
				 *
				 * @param string $name Address type.
				 * @since 8.7.0
				 */
				do_action( 'woocommerce_my_account_after_my_address', $name );
			?>
		</address>
	</div>

<?php endforeach; ?>

<?php
if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	echo '</div>';
}

